<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
?>
<div class="skin-06 <?php echo esc_attr($item_class); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>"
     data-time="<?php echo esc_attr($time); ?>"  data-single-time="<?php echo esc_attr($single_time);?>">
    <div class="fat-event-item-inner">
        <a href="<?php echo esc_url($event['link_detail']) ?>"
           data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
           target="<?php echo esc_attr($event['link_open_type']); ?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
           data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
            <div class="fat-event-thumb has-hover-effect">
                <img src="<?php echo ($layout === 'masonry' ? FAT_Event_Utils::get_thumbnail_image_masonry($event['id'], $width, $height):  FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height) ); ?>"
                     width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
            </div>
        </a>
        <div class="fat-event-thumb-overlay"></div>
        <div class="fat-event-start">
                <span class="event-day">
                    <?php echo esc_attr($event['start_date']->format('d')); ?>
                </span>
            <span class="event-month">
                    <?php echo date_i18n($date_format,$event['start_date']->format('U')); ?>
                </span>
        </div>

        <div class="fat-event-meta">
            <div class="fat-event-title">
                <a href="<?php echo esc_url($event['link_detail']) ?>"
                   data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
                   data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                   target="<?php echo esc_attr($event['link_open_type']); ?>"><?php echo get_the_title($event['id']); ?></a>
            </div>
            <div class="fat-event-booking-info">
                <?php  if(isset($event['fees_type']) && $event['fees_type']=='ticket_class' && isset($event['ticket_class']) && is_array($event['ticket_class'])):
                    ?>

                <?php else: ?>
                <?php endif;?>

                <?php
                $fees = isset($event['fees']) && $event['fees'] ? $event['fees'] : '';
                if(isset($event['fees_type']) && $event['fees_type']=='ticket_class' && isset($event['ticket_class']) && is_array($event['ticket_class'])){
                    $fees = $event['ticket_class']['fees'][0];
                }
                if ($fees): ?>
                    <span title="<?php echo esc_attr__('Ticket price','fat-event');?>"><i class="fa fa-ticket"></i><?php echo ($fees > 0 ? $currency_symbol.$fees : esc_html__('Free','fat-event'));?></span>
                <?php endif; ?>
                <?php if(isset($event['seats'])): ?>
                    <span title="<?php echo esc_attr__('Total seats','fat-event');?>"><i class="fa fa-user"></i><?php echo ($event['seats'] > 0 ? $event['seats'] : esc_html__('Unlimited','fat-event'));?></span>
                    <?php if($event['seats'] > 0):
                        $num_of_book = 0;
                        $seat_available = 0;
                        $seats = 0;

                        if(isset($event['fees_type']) && $event['fees_type']=='ticket_class' && isset($event['ticket_class']) && is_array($event['ticket_class'])){
                            $num_of_book_key = 'num_of_book_'.$event['start_date']->format('U').'_'.$event['end_date']->format('U').'_';
                            for ($i = 0; $i < count($event['ticket_class']['seats']); $i++) {
                                $seats += $event['ticket_class']['seats'][$i] ? $event['ticket_class']['seats'][$i] : 0;
                                $num_of_book += get_post_meta($event['id'], $num_of_book_key .'_'.$event['ticket_class']['class_id'][$i], true);
                            }
                        }else{
                            $num_of_book_key = 'num_of_book_'.$event['start_date']->format('U').'_'.$event['end_date']->format('U');
                            $num_of_book = get_post_meta($event['id'], $num_of_book_key, true);
                            $num_of_book = $num_of_book ? $num_of_book : 0;
                            $seats = isset($event['seats'])  && $event['seats'] ? $event['seats'] : 0;
                        }
                        $seat_available = $seats > $num_of_book ? ($event['seats'] - $num_of_book) : 0;
                        ?>
                    <span title="<?php echo esc_attr__('Seats available','fat-event');?>"><i class="fa fa-user-o"></i><?php echo esc_html($seat_available);?></span>
                    <?php endif;?>
                <?php endif;?>
            </div>
        </div>
    </div>
</div>