<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
?>
<div class="skin-03 <?php echo esc_attr($item_class); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>"
     data-time="<?php echo esc_attr($time); ?>"
     data-single-time="<?php echo esc_attr($single_time); ?>">
    <div class="fat-event-item-inner transition-30">
        <div class="fat-event-thumb">
            <img src="<?php echo ($layout === 'masonry' ? FAT_Event_Utils::get_thumbnail_image_masonry($event['id'], $width, $height):  FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height) ); ?>"
                 width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
            <div class="fat-event-thumb-overlay"></div>

            <div class="fat-event-info">
                <div class="fat-event-title fat-mg-bottom-5">
                    <i class="fa fa-bell"></i>
                    <?php echo get_the_title($event['id']); ?>
                </div>

                <div class="fat-event-meta fat-mg-bottom-5">
                    <div class="fat-event-meta-time">
                        <i class="fa fa-clock-o"></i>
                        <?php if ($event['all_day_event'] === '1'): ?>
                            <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                        <?php else: ?>
                            <span><?php echo esc_attr($event['start_date']->format($time_format)); ?></span>
                        <?php endif; ?>
                        <span class="text-upper"> - <?php echo date_i18n($date_format, $event['start_date']->format('U')); ?></span>
                    </div>
                </div>

                <?php
                if ($event['location'] && $event['location'] !== '' && $event['location'] !== 'hide'): ?>
                    <div class="fat-event-location">
                        <i class="fa fa-map-marker"></i>
                        <?php echo FAT_Event_Utils::get_location_title($event['location'], ', '); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="fat-event-footer transition-30">
            <a class="fat-event-bt transition-30" href="<?php echo esc_url($event['link_detail']) ?>"
               title="<?php echo get_the_title($event['id']); ?>"
               data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
               target="<?php echo esc_attr($event['link_open_type']); ?>"
               data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
               data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
                <?php echo esc_html__('View Detail', 'fat-event'); ?>
            </a>
        </div>
    </div>
</div>