<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
?>
<div class="skin-02 <?php echo esc_attr($item_class); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>"
     data-time="<?php echo esc_attr($time); ?>"
     data-single-time="<?php echo esc_attr($single_time); ?>">
    <div class="fat-event-item-inner b-radius-5">
        <div class="fat-event-thumb has-hover-effect">
            <img src="<?php echo(($layout === 'masonry') ? FAT_Event_Utils::get_thumbnail_image_masonry($event['id'], $width, $height) : FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height)); ?>"
                 width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
            <div class="fat-event-hover transition-30">
                <div class="fat-event-hover-inner">
                    <a href="<?php echo esc_url($event['link_detail']) ?>"
                       data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
                       target="<?php echo esc_attr($event['link_open_type']); ?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
                       data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
                        <i class="spl-icon-link icons"></i>
                    </a>

                    <?php if ($event['media_type'] === 'image'): ?>
                        <a class="fat-event-view-gallery" href="javascript:"
                           data-event-id="<?php echo esc_attr($event['id']); ?>"
                           title="<?php esc_html_e('View event gallery', 'fat-event'); ?>">
                            <i class="spl-icon-magnifier icons"></i>
                        </a>
                    <?php endif; ?>
                    <?php if ($event['media_type'] === 'video'): ?>
                        <a class="fat-event-view-video" data-video="<?php echo esc_url($event['link_video']); ?>"
                           title="<?php esc_html_e('View event video', 'fat-event'); ?>"
                           data-title="<?php echo get_the_title($event['id']); ?>" href="javascript:">
                            <i class="spl-icon-control-play icons"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="fat-event-info">
            <div class="fat-event-start">
                <span class="event-month">
                    <?php echo date_i18n('F', $event['start_date']->format('U')); ?>
                </span>
                <span class="event-day">
                    <?php echo esc_attr($event['start_date']->format('d')); ?>
                    <?php if ($shortcode_config['hide_event_end_time'] !== '1' && $event['end_date']->diff($event['start_date'])->d > 0 && $event['end_date']->diff($event['start_date'])->m == 0): ?>
                        - <?php echo esc_attr($event['end_date']->format('d')); ?>
                    <?php endif; ?>
                </span>
                <?php if ($event['end_date']->diff($event['start_date'])->m > 0): ?>
                    <span class="event-month">
                    <?php echo date_i18n('F', $event['end_date']->format('U')); ?>
                </span>
                    <span class="event-day">
                    <?php echo esc_attr($event['end_date']->format('d')); ?>
                </span>
                <?php endif; ?>
            </div>
            <div class="fat-event-meta">
                <div class="fat-event-title">
                    <a href="<?php echo esc_url($event['link_detail']) ?>"
                       data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
                       target="<?php echo esc_attr($event['link_open_type']); ?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
                       data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>">
                        <?php echo get_the_title($event['id']); ?>
                    </a>
                </div>

                <div class="fat-event-meta-time">
                    <?php if ($event['all_day_event'] === '1'): ?>
                        <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                    <?php else: ?>
                        <span><?php echo $event['start_date']->format($time_format); ?>
                            <?php if ($shortcode_config['hide_event_end_time'] !== '1') {
                                echo ' - ' . $event['end_date']->format($time_format);
                            }; ?>
                        </span>
                    <?php endif; ?>
                </div>

                <?php
                if ($event['location'] && $event['location'] !== '' && $event['location'] !== 'hide'): ?>
                    <div class="fat-event-location">
                        <?php echo FAT_Event_Utils::get_location_title($event['location'], ', '); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>