<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
?>
<div class="metro-skin-01 <?php echo esc_attr($item_class); ?>" data-event-id="<?php echo esc_attr($event['id']); ?>"
 data-time="<?php echo esc_attr($time);?>"  data-single-time="<?php echo esc_attr($single_time);?>" >
    <div class="fat-event-item-inner">

        <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
           target="<?php echo esc_attr($event['link_open_type']); ?>">
            <div class="fat-event-thumb has-hover-effect">
                <img src="<?php echo FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height); ?>"
                     width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
                <div class="fat-event-thumb-overlay">
                </div>
            </div>
        </a>
        <div class="fat-event-info">
            <div class="fat-event-meta">
                <?php if(isset($layout) && $layout=='metro-03'):
                    $terms = wp_get_post_terms($event['id'], array(FAT_EVENT_CATEGORY_TAXONOMY));
                    $cat = '';
                    foreach ($terms as $term) {
                        if (isset($term->taxonomy) && $term->taxonomy === FAT_EVENT_CATEGORY_TAXONOMY) {
                            $cat .= $term->name . ', ';
                        }
                    }
                    $cat = rtrim($cat, ', ');
                    ?>
                    <div class="fat-event-cat" style="text-transform: uppercase">
                        <?php echo esc_html($cat);?>
                    </div>
                <?php endif; ?>
                <div class="fat-event-title fat-mg-bottom-5">
                    <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                       target="<?php echo esc_attr($event['link_open_type']); ?>"><?php echo get_the_title($event['id']); ?></a>
                </div>

                <?php if ($event['hide_event_time'] !== '1'): ?>
                    <div class="fat-event-meta-time">
                        <span><?php esc_html_e($time); ?></span>
                    </div>
                <?php endif; ?>

                <?php
                if ($event['location'] && $event['location']!=='' && $event['location']!=='hide' ): ?>
                    <div class="fat-event-location">
                        <?php echo FAT_Event_Utils::get_location_title($event['location'], ' , '); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>