<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
$bd_color = get_post_meta($event['id'], 'fat-mb-event-color', true);
$bd_color = isset($bd_color['color']) && $bd_color['color'] ? $bd_color['color'] : '#2171c6';
$width = isset($shortcode_config['bg_image_width']) && $shortcode_config['bg_image_width'] ? $shortcode_config['bg_image_width'] : 200;
$height = isset($shortcode_config['bg_image_height']) && $shortcode_config['bg_image_height'] ? $shortcode_config['bg_image_height'] : 200;
?>
<div class="list-skin-02 fat-event-item has-infinite <?php echo 'event-' . $event['id']; ?>" data-event-id="<?php echo esc_attr($event['id']); ?>"
     data-single-time="<?php echo esc_attr($single_time);?>" data-time="<?php echo esc_attr($time);?>">
    <div class="fat-event-item-inner" style="border-right: solid 3px <?php echo esc_attr($bd_color); ?>">
        <div class="fat-event-thumb">
            <a href="<?php echo esc_url($event['link_detail']) ?>" class="text-upper" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
               data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
               target="<?php echo esc_attr($event['link_open_type']); ?>">
                <img src="<?php echo FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height); ?>"
                     width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>">
            </a>
        </div>

        <div class="fat-event-title">
            <a href="<?php echo esc_url($event['link_detail']) ?>" class="text-upper" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
               data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
               target="<?php echo esc_attr($event['link_open_type']); ?>">
                <i class="fa fa-bell"></i>
                <?php echo get_the_title($event['id']); ?></a>

            <div class="fat-event-meta-time">
                <i class="fa fa-clock-o"></i>
                <?php if ($event['all_day_event'] === '1' || $event['all_day_event']) { ?>
                    <span class="fe-time"><?php esc_attr_e('All day', 'fat-event'); ?>  -  </span>
                    <span class="fe-date"><?php echo date_i18n($date_format, $event['start_date']); ?> </span>
                <?php } elseif (date_diff($event['start_date'], $event['end_date'])->d == 0) { ?>
                    <span class="fe-time"><?php echo esc_attr($event['start_date']->format($time_format)); ?>
                        <?php echo ($shortcode_config['hide_event_end_time'] !== '1' ? ' - '.esc_html($event['end_date']->format($time_format)) : '' ); ?>
                    </span>
                    <span class="fe-date"> <?php echo trim($time_format)!='' ? date_i18n(str_replace($time_format,'',$date_format),$event['start_date']->format('U')) : date_i18n($date_format,$event['start_date']->format('U'));?> </span>
                <?php } else {
                    $date_time = strpos($date_format, $time_format) === FALSE ? $date_format.' '.$time_format : $date_format;
                    ?>
                    <span class="fe-date">
                        <?php echo date_i18n($date_format, $event['start_date']->format('U')). ' ' .$event['start_date']->format($time_format); ?>
                        <?php echo  ($shortcode_config['hide_event_end_time'] !== '1' ?  ' - ' .date_i18n($date_format, $event['end_date']->format('U')) . ' '. $event['end_date']->format($time_format) : '' ) ; ?>
                    </span>
                <?php } ?>
            </div>

            <?php
            if ($event['location'] && $event['location']!=='' && $event['location']!=='add_new' && $event['location']!=='hide'): ?>
                <span class="fat-event-location">
                    <i class="fa fa-map-marker"></i>
                    <?php echo FAT_Event_Utils::get_location_title($event['location'], ' , '); ?>
                            </span>
            <?php endif; ?>
        </div>
    </div>
</div>