<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/12/2018
 * Time: 2:44 PM
 */
$background = isset($shortcode_config['background']) && $shortcode_config['background'] == 'image';
$image = '';
if ($background) {
    $width = isset($shortcode_config['bg_image_width']) && $shortcode_config['bg_image_width'] ? $shortcode_config['bg_image_width'] : 200;
    $height = isset($shortcode_config['bg_image_height']) && $shortcode_config['bg_image_height'] ? $shortcode_config['bg_image_height'] : 200;
    $image = FAT_Event_Utils::get_thumbnail_image($event['id'], $width, $height);
}
$item_date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : '';
?>
<div class="list-skin-01 fat-event-item has-infinite fat-mg-bottom-15 <?php echo 'event-' . $event['id']; ?>"
     data-event-id="<?php echo esc_attr($event['id']); ?>" data-time="<?php echo esc_attr($time); ?>"
     data-single-time="<?php echo esc_attr($single_time); ?>">
    <div class="fat-event-item-inner">
        <?php if ($image): ?>
        <div class="fat-event-start has-background" style="background-image: url(<?php echo esc_url($image); ?>);">
            <div class="fat-event-bg-overlay"></div>
            <?php else: ?>
            <div class="fat-event-start">
                <?php endif; ?>
                <div class="fat-event-entry">
                    <?php if ($item_date_format) {
                        echo '<span class="custom-date-format">' . date_i18n($item_date_format, $event['start_date']->format('U')) . '<span>';
                    } else { ?>
                        <span class="event-month">
                        <?php echo date_i18n('l', $event['start_date']->format('U')); ?>
                    </span>
                        <span class="event-day">
                        <?php echo esc_attr($event['start_date']->format('d')); ?>
                    </span>
                        <span class="event-month">
                        <?php echo date_i18n('M', $event['start_date']->format('U')); ?>
                </span>
                    <?php } ?>

                </div>
            </div>

            <div class="fat-event-title">
                <a href="<?php echo esc_url($event['link_detail']) ?>"
                   data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
                   data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
                   data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                   target="<?php echo esc_attr($event['link_open_type']); ?>">
                    <i class="fa fa-bell"></i>
                    <?php echo get_the_title($event['id']); ?></a>

                <div class="fat-event-meta-time">
                    <i class="fa fa-clock-o"></i>
                    <?php
                    if ($event['all_day_event'] === '1' || $event['all_day_event']) { ?>
                        <span><?php esc_attr_e('All day', 'fat-event'); ?></span>
                    <?php } elseif (date_diff($event['start_date'], $event['end_date'])->d == 0) { ?>
                        <span><?php echo esc_html($event['start_date']->format($time_format)); ?>
                            <?php echo($shortcode_config['hide_event_end_time'] !== '1' ? ' - ' . esc_html($event['end_date']->format($time_format)) : ''); ?> </span>
                    <?php } else {
                        $date_time = strpos($date_format, $time_format) === FALSE ? $date_format . ' ' . $time_format : $date_format;
                        ?>
                        <span><?php echo date_i18n($date_format, $event['start_date']->format('U')) . ' ' . $event['start_date']->format($time_format); ?>
                            <?php echo($shortcode_config['hide_event_end_time'] !== '1' ? ' - ' . date_i18n($date_format, $event['end_date']->format('U')) . ' ' . $event['end_date']->format($time_format) : ''); ?> </span>
                    <?php } ?>
                </div>
                <?php
                if ($event['location'] && $event['location'] !== '' && $event['location'] !== 'add_new' && $event['location'] !== 'hide'): ?>
                    <span class="fat-event-location">
                    <i class="fa fa-map-marker"></i>
                    <?php echo FAT_Event_Utils::get_location_title($event['location'], ' , '); ?>
                            </span>
                <?php endif; ?>
            </div>

            <?php if (isset($event['fees']) && $event['fees'] > 0): ?>
                <div class="fat-event-fees">
                    <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?><?php echo number_format($event['fees'], $decimal, '.', $separator); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                    <div class="fat-event-fees-label">
                        <?php esc_html_e('A Ticket', 'fat-event'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="fat-event-action-groups transition-30">
                <a href="<?php echo esc_url($event['link_detail']) ?>"
                   data-open-type="<?php echo esc_attr($event['open_detail_type']); ?>"
                   data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>"
                   data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                   target="<?php echo esc_attr($event['link_open_type']); ?>"><?php echo esc_html__('View Detail', 'fat-event'); ?></a>
            </div>
        </div>
    </div>