<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/20/2018
 * Time: 2:39 PM
 */
$color = get_post_meta($event['id'], 'fat-mb-event-color', true);
$color = isset($color['color']) ? $color['color'] : 'inherit';
$bg =  get_post_meta($event['id'], 'fat-mb-event-bg-image', true);
$bg = isset($bg['bg_image']) ? $bg['bg_image'] : '';
$cd_color = 'inherit';
if($color!=='inherit' && $bg===''){
    $cd_color = FAT_Event_Utils::color_luminance($color,-0.2);
}
if($bg!==''){
    $bg = 'background-image:url('.wp_get_attachment_image_url($bg, 'full').');';
}
?>
<div class="cd-skin-01 <?php echo esc_attr($item_class); ?>" style="background-color: <?php echo esc_attr($color);?>; <?php echo esc_attr($bg);?>"  data-event-id="<?php echo esc_attr($event['id']); ?>" data-time="<?php echo esc_attr($time);?>">
    <div class="fat-event-item-inner">
        <?php if($bg!==''): ?>
            <div class="fat-event-thumb-overlay"></div>
        <?php endif; ?>
        <div class="fat-event-col-left">
            <div class="fat-event-left-inner">
                <div class="fat-event-title">
                    <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
                       data-event-id="<?php echo esc_attr($event['id']);?>"
                       data-time="<?php echo esc_attr($time_detail);?>" data-single-time="<?php echo esc_attr($single_time);?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                       title="<?php echo get_the_title($event['id']);?>" target="<?php echo esc_attr($event['link_open_type']);?>">
                        <?php echo get_the_title($event['id']); ?>
                    </a>
                </div>
                <div class="fat-event-excerpt">
                    <?php
                    $excerpt = get_the_excerpt($event['id']);
                    $excerpt = wp_trim_words($excerpt, 22);
                    echo wp_kses_post($excerpt);?>
                </div>
                <div class="fat-event-meta">
                    <?php echo  date_i18n($date_format, $event['start_date']->format('U')); ?>
                    <?php
                    if ($event['location'] && $event['location']!=='' && $event['location']!=='hide'):
                        echo esc_html__('in ', 'fat-event') . FAT_Event_Utils::get_location_title($event['location'], ' , ');
                    endif; ?>
                </div>
                <div class="fat-event-footer">
                    <a class="fat-event-bt transition-30" href="<?php echo esc_url($event['link_detail']) ?>"
                       data-event-id="<?php echo esc_attr($event['id']);?>"
                       data-time="<?php echo esc_attr($time_detail);?>" data-single-time="<?php echo esc_attr($single_time);?>"
                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                       data-open-type="<?php echo esc_attr($event['open_detail_type']);?>" title="<?php echo get_the_title($event['id']);?>" target="<?php echo esc_attr($event['link_open_type']);?>">
                        <?php echo esc_html__('View Detail','fat-event');?> <i class="fa fa-long-arrow-right transition-30"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="fat-event-col-right">
            <div class="fat-event-cd text-right">
                <div class="fat-event-cd-inner"
                     data-start="<?php echo esc_attr($event['start_date']->format('Y/m/d H:i:s')); ?>">
                    <div class="fat-event-cd-info" style="background-color: <?php echo esc_attr($cd_color);?>">
                        <h4 class="fat-event-cd-day">00</h4>
                        <h5><?php esc_html_e('Days', 'fat-event'); ?></h5>
                    </div>

                    <div class="fat-event-cd-info" style="background-color: <?php echo esc_attr($cd_color);?>">
                        <h4 class="fat-event-cd-hour">00</h4>
                        <h5><?php esc_html_e('Hours', 'fat-event'); ?></h5>
                    </div>

                    <div class="fat-event-cd-info" style="background-color: <?php echo esc_attr($cd_color);?>">
                        <h4 class="fat-event-cd-minute">00</h4>
                        <h5><?php esc_html_e('Minutes', 'fat-event'); ?></h5>
                    </div>

                    <div class="fat-event-cd-info" style="background-color: <?php echo esc_attr($cd_color);?>">
                        <h4 class="fat-event-cd-second">00</h4>
                        <h5><?php esc_html_e('Seconds', 'fat-event'); ?></h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>