<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 7/3/2018
 * Time: 3:33 PM
 */

$hide_col_right = (!isset($organizer->name) || $organizer->name === '') && ($fees <= 0 || $event_start_date < $now) &&
    (!is_array($hourly_schedule) || count($hourly_schedule['from']) == 0 || $hourly_schedule['from'][0] === '') && $latitude === ''
    && (isset($fat_event_setting['enable_social']) && $fat_event_setting['enable_social'] === '');
$decimal = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal'] ? $fat_event_setting['currency_decimal'] : 0;
$separator = isset($fat_event_setting['currency_separator']) ? $fat_event_setting['currency_separator'] : ',';
$disable_single_crop = isset($fat_event_setting['disable_single_crop'][0]) && $fat_event_setting['disable_single_crop'][0]=='1';
$width = isset($single_image_size['single_image_width']) && $single_image_size['single_image_width'] >= 0 ? $single_image_size['single_image_width'] : 1170;
$height = isset($single_image_size['single_image_height']) && $single_image_size['single_image_height'] >= 0 ? $single_image_size['single_image_height'] : 500;

$amenities_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/amenities.php';
$amenities_theme_path = get_stylesheet_directory() . '/templates/fat-event/single/part/amenities.php';
if(is_readable($amenities_theme_path)){
    $amenities_path = $amenities_theme_path;
}
$allow_html = array(
    'span' => array('class' => array())
);
?>
<div class="fat-event-single single-03 fat-event-container hide-col-right">
    <div class="fat-container">
        <div class="fat-row">
            <div class="fat-col-md-8 fat-col-left">
                <div class="fat-event-thumb">
                    <?php
                    if (has_post_thumbnail($id)):
                        $attachment_id = get_post_thumbnail_id($id);
                        if (!$disable_single_crop && function_exists('fat_event_matthewruddy_image_resize_id') && $width > 0 && $height > 0) {
                            $thumb = fat_event_matthewruddy_image_resize_id($attachment_id, $width, $height);
                            $thumb = is_array($thumb) && isset($thumb['url']) ? $thumb['url'] : wp_get_attachment_url($attachment_id);
                        } else {
                            $thumb = wp_get_attachment_url($attachment_id);
                        }
                        ?>
                        <img src="<?php echo esc_url($thumb); ?>" width="<?php echo ($disable_single_crop ? "100%": $width); ?>" height="<?php echo ($disable_single_crop ? "auto": $height); ?>">
                    <?php endif; ?>
                    <div class="fat-event-popup-info">
                        <div class="fat-event-popup-title">
                            <?php the_title(); ?>
                        </div>
                        <?php if ($time): ?>
                            <div class="fat-event-popup-time">
                                <i class="fa fa-clock-o"></i> <?php echo wp_kses_post($time); ?>
                            </div>
                        <?php endif; ?>

                        <?php foreach ($list_location as $loc) { ?>
                            <div class="fat-event-popup-location">
                                <i class="fa fa-map-marker"></i> <?php echo wp_kses($loc['location'], $allow_html); ?>
                                <?php if (isset($loc['latitude']) && $loc['latitude']): ?>
                                    <a href="<?php echo 'https://www.google.com/maps/dir/?api=1&destination=' . $loc['latitude']; ?>"
                                       target="_blank"><i
                                                class="fa fa-location-arrow"></i><?php esc_html_e('Get directions', 'fat-event'); ?>
                                    </a>
                                <?php endif;?>
                            </div>
                        <?php } ?>

                    </div>
                </div>

                <div class="fat-event-single-content fat-mg-top-30">
                    <?php
                    if (is_readable($amenities_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='top_content') {
                        do_action('fat_event_begin_single_amenities');
                        include_once $amenities_path;
                        do_action('fat_event_end_single_amenities');
                    }
                    ?>
                    <?php
                    do_action('fat_event_begin_single_content', $id);
                    if ( did_action( 'elementor/loaded' ) ) {
                        the_content();
                    }else{
                        $content = get_the_content();
                        $content = wpautop($content, true);
                        echo do_shortcode($content);
                    }
                    do_action('fat_event_end_single_content', $id);
                    ?>
                    <?php if (isset($event_detail['link_more_info']) && $event_detail['link_more_info']): ?>
                        <div class="fat-event-more-detail">
                            <a href="<?php echo esc_url($event_detail['link_more_info']); ?>"><?php echo(isset($event_detail['label_more_info']) && $event_detail['label_more_info'] ? $event_detail['label_more_info'] : esc_html__('More info', 'fat-event')); ?> </a>
                        </div>
                    <?php endif; ?>

                    <?php
                    if (is_readable($amenities_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='bottom_content') {
                        do_action('fat_event_begin_single_amenities', $id);
                        include_once $amenities_path;
                        do_action('fat_event_end_single_amenities', $id);
                    }
                    ?>
                </div>

            </div>
        </div>
    </div>
</div>