<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 7/3/2018
 * Time: 3:33 PM
 */

$hide_col_right = (!isset($organizer->name) || $organizer->name === '') && ($fees <= 0 || $event_start_date < $now) &&
    (!is_array($hourly_schedule) || count($hourly_schedule['from']) == 0 || $hourly_schedule['from'][0] === '') && $latitude === ''
    && (isset($fat_event_setting['enable_social']) && $fat_event_setting['enable_social'] === '');
$width = isset($single_image_size['single_image_width']) && $single_image_size['single_image_width'] >= 0 ? $single_image_size['single_image_width'] : 1170;
$height = isset($single_image_size['single_image_height']) && $single_image_size['single_image_height'] >= 0 ? $single_image_size['single_image_height'] : 500;
$decimal = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal'] ? $fat_event_setting['currency_decimal'] : 0;
$separator = isset($fat_event_setting['currency_separator']) ? $fat_event_setting['currency_separator'] : ',';
$disable_single_crop = isset($fat_event_setting['disable_single_crop'][0]) && $fat_event_setting['disable_single_crop'][0]=='1';

$amenities_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/amenities.php';
$amenities_theme_path = get_stylesheet_directory() . '/templates/fat-event/single/part/amenities.php';
if(is_readable($amenities_theme_path)){
    $amenities_path = $amenities_theme_path;
}

$ticket_detail_label =  isset($fat_event_setting['ticket_detail_label']) && $fat_event_setting['ticket_detail_label'] ? $fat_event_setting['ticket_detail_label'] : esc_html__('Ticket Detail','fat-event');
$fees_label =  isset($fat_event_setting['fees_label']) && $fat_event_setting['fees_label'] ? $fat_event_setting['fees_label'] : esc_html__('Fees','fat-event');
$seats_label =  isset($fat_event_setting['seats_label']) && $fat_event_setting['seats_label'] ? $fat_event_setting['seats_label'] : esc_html__('Seats','fat-event');
$seats_available_label =  isset($fat_event_setting['seats_available_label']) && $fat_event_setting['seats_available_label'] ? $fat_event_setting['seats_available_label'] : esc_html__('Seats available','fat-event');
$book_now_label =  isset($fat_event_setting['booking_button_label']) && $fat_event_setting['booking_button_label'] ? $fat_event_setting['booking_button_label'] : esc_html__('Book Now','fat-event');
$allow_html = array(
        'span' => array('class' => array())
);
?>
<div class="fat-event-single single-01 fat-event-container <?php echo($hide_col_right ? 'hide-col-right' : ''); ?>">
    <div class="fat-container">
        <div class="fat-row">
            <div class="fat-col-md-12">
                <div class="fat-event-thumb">
                    <?php
                    if (has_post_thumbnail($id)):
                        $attachment_id = get_post_thumbnail_id($id);
                        if (!$disable_single_crop && function_exists('fat_event_matthewruddy_image_resize_id') && $width > 0 && $height > 0) {
                            $thumb = fat_event_matthewruddy_image_resize_id($attachment_id, $width, $height);
                            $thumb = is_array($thumb) && isset($thumb['url']) ? $thumb['url'] : wp_get_attachment_url($attachment_id);
                        } else {
                            $thumb = wp_get_attachment_url($attachment_id);
                        }
                        ?>
                        <img src="<?php echo esc_url($thumb); ?>" width="<?php echo ($disable_single_crop ? "100%": $width); ?>" height="<?php echo ($disable_single_crop ? "auto": $width); ?>">
                    <?php endif; ?>
                    <div class="fat-event-popup-info">
                        <div class="fat-event-popup-title">
                            <?php the_title(); ?>
                        </div>
                        <?php if ($time): ?>
                            <div class="fat-event-popup-time">
                                <i class="fa fa-clock-o"></i> <?php echo wp_kses_post($time); ?>
                            </div>
                        <?php endif; ?>
                        <?php foreach ($list_location as $loc) { ?>
                            <div class="fat-event-popup-location">
                                <i class="fa fa-map-marker"></i> <?php echo wp_kses($loc['location'], $allow_html); ?>
                                <?php if (isset($loc['latitude']) && $loc['latitude']): ?>
                                    <a href="<?php echo 'https://www.google.com/maps/dir/?api=1&destination=' . $loc['latitude']; ?>"
                                    target="_blank"><i
                                            class="fa fa-location-arrow"></i><?php esc_html_e('Get directions', 'fat-event'); ?>
                                    </a>
                                <?php endif;?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="fat-col-md-8 fat-col-left fat-mg-top-60">
                <div class="fat-event-single-content">
                    <?php
                    if (is_readable($amenities_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='top_content') {
                        do_action('fat_event_begin_single_amenities', $id);
                        include_once $amenities_path;
                        do_action('fat_event_end_single_amenities', $id);
                    }
                    ?>
                    <?php
                    do_action('fat_event_begin_single_content', $id);
                    if (did_action('elementor/loaded')) {
                        the_content();
                    } else {
                        $content = get_the_content();
                        $content = wpautop($content, true);
                        echo do_shortcode($content);
                    }
                    do_action('fat_event_end_single_content', $id);
                    ?>
                    <?php if (isset($event_detail['link_more_info']) && $event_detail['link_more_info']): ?>
                        <div class="fat-event-more-detail">
                            <a href="<?php echo esc_url($event_detail['link_more_info']); ?>"><?php echo(isset($event_detail['label_more_info']) && $event_detail['label_more_info'] ? $event_detail['label_more_info'] : esc_html__('More info', 'fat-event')); ?> </a>
                        </div>
                    <?php endif; ?>
                    <?php
                    if (is_readable($amenities_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='bottom_content') {
                        do_action('fat_event_begin_single_amenities', $id);
                        include_once $amenities_path;
                        do_action('fat_event_end_single_amenities', $id);
                    }
                    ?>

                </div>
            </div>
            <div class="fat-col-md-4 fat-col-right fat-mg-top-60">
                <div class="fat-event-meta-wrap">
                    <?php
                    if (isset($organizers) && is_array($organizers) && count($organizers) > 0): ?>
                        <h4 class="fat-event-meta-title organizer-meta"><?php esc_html_e('Organizer', 'fat-event'); ?></h4>
                        <?php foreach ($organizers as $org) { ?>
                            <div class="fat-event-organizer">
                                <?php if ($org['thumb']): ?>
                                    <span class="organizer-thumb">
                                             <img src="<?php echo esc_url($org['thumb']); ?>" width="100" height="100">
                                        </span>
                                <?php endif; ?>
                                <ul class="organizer-info">
                                    <li><?php echo esc_html($org['name']); ?></li>
                                    <?php if($org['description']) : ?>
                                        <li><?php echo esc_html($org['description']);?></li>
                                    <?php endif; ?>
                                    <?php if ($org['telephone']): ?>
                                        <li>
                                            <i class="fa fa-phone"></i><a
                                                    href="tel:<?php echo esc_attr($org['telephone']); ?>"> <?php echo esc_html($org['telephone']); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ($org['email']): ?>
                                        <li>
                                            <i class="fa fa-envelope"></i><a
                                                    href="mailto:<?php echo esc_attr($org['email']); ?>"> <?php echo esc_html($org['email']); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ($org['website']): ?>
                                        <li>
                                            <i class="fa fa-desktop"></i><a
                                                    href="<?php echo esc_url($org['website']); ?>"> <?php echo esc_html($org['website']); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ($org['facebook'] || $org['twitter'] || $org['linkedin']) : ?>
                                        <li class="organizer-social">
                                            <?php if ($org['facebook']): ?>
                                                <span><a href="<?php echo esc_url($org['facebook']); ?>"
                                                         target="_blank"> <i
                                                                class="fa fa-facebook"></i></a></span>
                                            <?php endif; ?>
                                            <?php if ($org['twitter']): ?>
                                                <span><a href="<?php echo esc_url($org['twitter']); ?>"
                                                         target="_blank"> <i
                                                                class="fa fa-twitter"></i></a></span>
                                            <?php endif; ?>
                                            <?php if ($org['linkedin']): ?>
                                                <span><a href="<?php echo esc_url($org['linkedin']); ?>"
                                                         target="_blank"> <i
                                                                class="fa fa-linkedin"></i></a></span>
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>

                            </div>
                        <?php } ?>
                    <?php endif; ?>

                    <?php
                    $other_organizer = isset($event_detail['other_organizer']) ? $event_detail['other_organizer'] : '';
                    $organizer = $organizer_detail = $organizer_thumb = '';
                    if (is_array($other_organizer)): ?>
                        <h4 class="fat-event-meta-title other-organizer-meta"><?php esc_html_e('Other Organizer(s)', 'fat-event'); ?></h4>
                        <?php foreach ($other_organizer as $or) {
                            $organizer = get_term_by('id', $or, FAT_EVENT_ORGANIZER_TAXONOMY);
                            $organizer_detail = get_term_meta($or, 'fat-mb-organizer-detail', true);
                            $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                            if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                                $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                                $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                            }
                            ?>
                            <div class="fat-event-organizer fat-event-other-organizer fat-mg-bottom-15">
                                <?php if ($organizer_thumb): ?>
                                    <span class="organizer-thumb">
                                     <?php if (isset($organizer_detail['website']) && $organizer_detail['website']): ?>
                                         <a href="<?php echo esc_url($organizer_detail['website']); ?>"><img
                                                     src="<?php echo esc_url($organizer_thumb); ?>"
                                                     width="100" height="100"></a>
                                     <?php else: ?>
                                         <img src="<?php echo esc_url($organizer_thumb); ?>"
                                              width="100" height="100">
                                     <?php endif; ?>
                                </span>
                                <?php endif; ?>
                                <ul class="organizer-info">
                                    <li><?php echo isset($organizer->name) ? $organizer->name : ''; ?></li>
                                    <?php if (isset($organizer_detail['telephone']) && $organizer_detail['telephone']): ?>
                                        <li>
                                            <i class="fa fa-phone"></i> <?php echo esc_html($organizer_detail['telephone']); ?>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (isset($organizer_detail['email']) && $organizer_detail['email']): ?>
                                        <li>
                                            <i class="fa fa-envelope"></i><a
                                                    href="mailto:<?php echo esc_attr($organizer_detail['email']); ?>"> <?php echo esc_html($organizer_detail['email']); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (isset($organizer_detail['website']) && $organizer_detail['website']): ?>
                                        <li>
                                            <i class="fa fa-desktop"></i><a
                                                    href="<?php echo esc_url($organizer_detail['website']); ?>"> <?php echo esc_html($organizer_detail['website']); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ((isset($organizer_detail['facebook']) && $organizer_detail['facebook'])
                                        || (isset($organizer_detail['twitter']) && $organizer_detail['twitter'])
                                        || (isset($organizer_detail['linkedin']) && $organizer_detail['linkedin'])
                                    ) : ?>
                                        <li class="organizer-social">
                                            <?php if ($organizer_detail['facebook']): ?>
                                                <span><a href="<?php echo esc_url($organizer_detail['facebook']); ?>"
                                                         target="_blank"> <i class="fa fa-facebook"></i></a></span>
                                            <?php endif; ?>
                                            <?php if ($organizer_detail['twitter']): ?>
                                                <span><a href="<?php echo esc_url($organizer_detail['twitter']); ?>"
                                                         target="_blank"> <i class="fa fa-twitter"></i></a></span>
                                            <?php endif; ?>
                                            <?php if ($organizer_detail['linkedin']): ?>
                                                <span><a href="<?php echo esc_url($organizer_detail['linkedin']); ?>"
                                                         target="_blank"> <i class="fa fa-linkedin"></i></a></span>
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>

                            </div>
                        <?php } ?>
                    <?php endif ?>

                    <?php
                    if (isset($schedule)): ?>
                        <h4 class="fat-event-meta-title schedule-meta"><?php esc_html_e('Schedule', 'fat-event'); ?></h4>
                        <ul class="fat-event-hourly-schedule">
                            <?php foreach ($schedule as $sc) { ?>
                                <li>
                                    <i class="fa fa-clock-o"></i> <?php echo sprintf('<span class="schedule-hour">%s - %s</span> : %s', $sc['from'], $sc['to'], $sc['title']); ?>
                                    <?php if (isset($sc['description']) && $sc['description']): ?>
                                        <p class="fat-event-schedule-desc"><?php echo esc_html($sc['description']); ?></p>
                                    <?php endif; ?>

                                    <?php if (isset($sc['location']) && $sc['location']): ?>
                                        <p class="fat-event-schedule-location"><i
                                                    class="fa fa-map-marker"></i>
                                            <?php if (isset($sc['latitude']) && $sc['latitude']): ?>
                                                <a href="<?php echo 'https://www.google.com/maps/dir/?api=1&destination=' . $sc['latitude']; ?>"
                                                   target="_blank"><?php echo esc_html($sc['location']); ?>
                                                </a>
                                            <?php else: ?>
                                                <?php echo esc_html($sc['location']); ?>
                                            <?php endif;?>

                                        </p>
                                    <?php endif; ?>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php endif; ?>

                    <?php
                        $amenities_sidebar_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/amenities-sidebar.php';
                        $amenities_sidebar_theme_path = get_stylesheet_directory() . '/templates/fat-event/single/part/amenities-sidebar.php';
                        if (is_readable($amenities_sidebar_theme_path)) {
                            $amenities_sidebar_path = $amenities_sidebar_theme_path;
                        }
                        if(is_readable($amenities_sidebar_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='sidebar'){
                            include_once $amenities_sidebar_path;
                        }
                    ?>

                    <?php
                    //&& $event_start_date > $now
                    if ($enable_booking == 1 ): ?>
                        <h4 class="fat-event-meta-title ticket-detail-meta"><?php echo esc_html($ticket_detail_label); ?></h4>
                        <ul class="fat-event-popup-fees">
                            <li>
                                <?php if (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'package' && is_array($fees_package)): ?>
                                    <?php esc_html_e('Fees package:', 'fat-event'); ?>
                                    <ul class="fat-event-fees-package">
                                        <?php foreach ($fees_package as $package) { ?>
                                            <li>
                                                <?php echo esc_html($package['quantity']) . esc_html__(' Ticket', 'fat-event'); ?>
                                                -
                                                <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                                <?php echo esc_html($package['fees']); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                <?php elseif (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'ticket_class' && is_array($ticket_class)): ?>
                                    <?php esc_html_e('Ticket classification:', 'fat-event'); ?>
                                    <ul class="fat-event-fees-package">
                                        <?php foreach ($ticket_class as $class) { ?>
                                            <li>
                                                <?php echo esc_html($class['class']); ?>
                                                -
                                                <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                                <?php echo esc_html($class['fees']); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                                &nbsp;
                                                <?php if ($class['seat'] != '' && $class['seat'] != '0'): ?>
                                                    <?php echo esc_html($seats_label)  ?>
                                                    <?php echo esc_html($class['seat']); ?>
                                                    <?php if (isset($class['seat_available']) && $class['seat_available'] !== ''): ?>
                                                        <div data-ticket-id="<?php echo esc_attr($class['class_id']); ?>"
                                                             data-seats="<?php echo esc_attr($class['seat_available']); ?>"
                                                             class="fat-event-seats-available"><?php echo esc_html__('Available: ', 'fat-event'); ?>
                                                            <span><?php echo esc_html($class['seat_available']); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                            </li>
                                        <?php } ?>
                                    </ul>
                                <?php else: ?>
                                    <span class="price">
                                    <?php echo esc_html($fees_label); ?>
                                    <strong>
                                        <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?><?php echo number_format($fees, $decimal, '.', $separator); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                    </strong> &nbsp;
                                        </span>
                                <?php endif; ?>

                                <!-- seat for fix price and fees package -->
                                <?php if (isset($event_detail['fees_type']) && $event_detail['fees_type'] != 'ticket_class' && $seats != '' && $seats != '0'): ?>
                                    <span class="seat">
                                    <?php echo esc_html($seats_label) ?>
                                    <strong><?php echo $seats; ?></strong>
                                        </span>
                                    <?php if ($enable_seat_available && isset($num_of_book) && $num_of_book !== ''): ?>
                                        <div data-seats="<?php echo esc_attr($seats); ?>"
                                             class="fat-event-seats-available"><?php echo esc_html($seats_available_label) . '<strong> ' . ($seats > $num_of_book ? ($seats - $num_of_book) : 0) . '</strong>'; ?></div>
                                    <?php endif; ?>
                                <?php endif; ?>

                            </li>
                            <li>
                                <?php
                                $json_location = json_encode($list_location);
                                $list_amenities = is_array($list_amenities) ? json_encode(array_values($list_amenities)) : '';
                                if($seats > $num_of_book || $seats==0 || $event_detail['fees_type'] == 'ticket_class' || $event_detail['fees_type'] == 'package' ){
                                ?>
                                    <a class="fat-event-register"
                                       data-payment="<?php echo esc_attr($event_detail['payment']); ?>"
                                       data-start="<?php echo esc_attr($event_start_date->format('U')); ?>"
                                       data-end="<?php echo esc_attr($event_end_date->format('U')); ?>"
                                       data-fees-type="<?php echo isset($event_detail['fees_type']) ? $event_detail['fees_type'] : 'fixed'; ?>"
                                       data-fees-package='<?php echo json_encode($fees_package); ?>'
                                       data-ticket-class='<?php echo json_encode($ticket_class); ?>'
                                       data-fees="<?php echo esc_attr($fees); ?>" data-id="<?php echo get_the_ID(); ?>"
                                       href="<?php echo $event_detail['payment'] == 'external_link' ? $event_detail['external_link_booking'] : 'javascript:;'; ?>"
                                       data-amenities="<?php echo esc_attr($list_amenities); ?>"
                                       data-location="<?php echo esc_attr($json_location); ?>"
                                    >
                                        <?php echo esc_html($book_now_label); ?> <i class="fa fa-long-arrow-right"></i>
                                    </a>
                                <?php }
                                if($seats <= $num_of_book && $seats != 0 && $event_detail['fees_type'] == 'fixed' && !$enable_woocommerce){?>
                                    <div><?php echo esc_html__('Fully booked','fat-event');?></div>
                                <?php } ?>

                                <?php if ($enable_woocommerce) {
                                    include_once(untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/price-variable.php');
                                }?>

                                <?php $second_link = $event_detail['payment'] == 'external_link' ? $event_detail['second_external_link_booking'] : '';
                                if($second_link): ?>
                                    <div>
                                        <a class="fat-event-register" href="<?php echo esc_url($second_link);?>" data-payment="<?php echo esc_attr($event_detail['payment']); ?>">
                                            <?php echo esc_html__('or Book Here', 'fat-event');?>
                                            <i class="fa fa-long-arrow-right"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </li>
                        </ul>
                    <?php endif; ?>

                    <h4 class="fat-event-meta-title export-meta"><?php esc_html_e('Export', 'fat-event'); ?></h4>
                    <div class="fat-event-export">
                        <a target="_blank"
                           href="<?php echo home_url('/') . '?action=fat_event_export_ical&id=' . get_the_ID() . '&s_date=' . $event_start_date->format('U') . '&e_date=' . $event_end_date->format('U'); ?>"
                           class="fat-event-export-ical"><i
                                    class="fa fa-calendar"></i><?php echo esc_html__('Ical', 'fat-event'); ?></a>
                        <a target="_blank" href="<?php echo esc_url($export_gg_link);?>" class="fat-event-export-google-calendar">
                            <i class="fa fa-calendar-plus-o"></i>
                            <?php echo esc_html__('Google Calendar','fat-event'); ?></a>
                    </div>

                    <?php
                    if (is_array($latitudes) && count($latitudes) > 0 && $latitudes[0]): ?>
                        <h4 class="fat-event-meta-title location-meta"><?php esc_html_e('Location', 'fat-event'); ?></h4>
                        <div class="fat-event-location" data-latitude="<?php echo implode(';', $latitudes); ?>"
                             data-access-token="<?php echo esc_attr($fat_event_setting['mapbox_access_token']);?>"
                             data-lazy-load="<?php echo isset($fat_event_setting['disable_google_API'][0])  ? $fat_event_setting['disable_google_API'][0]: 0 ;?>" >
                            <?php if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'): ?>
                                <div class="fat-mapbox" id="fat_single_mapbox"></div>
                            <?php else: ?>
                                <div class="fat-google-map"></div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <?php
                    if (isset($fat_event_setting['enable_social'][0]) && $fat_event_setting['enable_social'][0] === '1'): ?>
                        <h4 class="fat-event-meta-title share-meta"><?php esc_html_e('Share our event', 'fat-event'); ?></h4>
                        <div class="fat-event-share"
                             data-link="<?php echo $event_detail['link_detail'] ? $event_detail['link_detail'] : get_permalink(); ?>"
                             data-title="<?php $title = get_the_title();
                             echo html_entity_decode($title); ?>"
                             data-thumb="<?php echo isset($thumb) ? $thumb : ''; ?>">
                            <?php if (isset($fat_event_setting['enable_facebook'][0]) && $fat_event_setting['enable_facebook'][0] === '1'): ?>
                                <a data-social="facebook" class="fat-event-share-facebook transition-30"
                                   href="javascript:"><i
                                            class="fa fa-facebook"></i></a>
                            <?php endif; ?>
                            <?php if (isset($fat_event_setting['enable_twitter'][0]) && $fat_event_setting['enable_twitter'][0] === '1'): ?>
                                <a data-social="twitter" class="fat-event-share-twitter transition-30"
                                   href="javascript:"><i
                                            class="fa fa-twitter"></i></a>
                            <?php endif; ?>
                            <?php if (isset($fat_event_setting['enable_google_plus'][0]) && $fat_event_setting['enable_google_plus'][0] === '1'): ?>
                                <a data-social="google" class="fat-event-share-google-plus transition-30"
                                   href="javascript:"><i
                                            class="fa fa-google-plus"></i></a>
                            <?php endif; ?>
                            <?php if (isset($fat_event_setting['enable_email'][0]) && $fat_event_setting['enable_email'][0] === '1'):
                                $location = '';
                                foreach ($list_location as $loc){
                                    $location.= $location=='' ? $loc['location'] : ('. '. $loc['location']);
                                }
                                ?>
                                <a class="fat-event-share-mail transition-30"
                                   href="mailto:?subject=<?php echo get_the_title(); ?>&body=Time: <?php echo esc_attr($time); ?> %0ALocation: <?php echo esc_attr($location); ?> %0AOrganizer: <?php echo(isset($organizer->name) ? esc_attr($organizer->name) : ''); ?> %0A<?php get_the_excerpt(); ?>%0A<?php echo $event_detail['link_detail'] ? $event_detail['link_detail'] : get_permalink(); ?>"><i
                                            class="fa fa-envelope-o"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>