<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 4/23/2020
 * Time: 8:49 AM
 */
$is_ticket_class = (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'ticket_class' && is_array($ticket_class));
?>
<div class="fat-event-price-variable" data-fees-type="<?php echo esc_attr($event_detail['fees_type']); ?>">
    <?php if ($is_ticket_class): ?>
        <div class="ticket-class-wrap">
            <label><?php echo esc_html__('Select ticket', 'fat-event'); ?></label>
            <select name="ticket_class" id="ticket_class">
                <?php
                $seat_available = 0;
                foreach ($ticket_class as $class) {
                    $seat_available = $class['seat'] != '' && $class['seat'] != '0' && isset($class['seat_available']) ? intval($class['seat_available']) : 20;
                    ?>
                    <option value="<?php echo esc_attr($class['class_id']); ?>"
                            data-class="<?php echo esc_attr($class['class']);?>"
                            data-seat="<?php echo esc_attr($seat_available); ?>">
                        <?php echo esc_html($class['class']); ?>
                        -
                        <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                        <?php echo esc_html($class['fees']); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                        &nbsp;
                    </option>
                <?php } ?>
            </select>
        </div>
        <div class="ticket-number-wrap">
            <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
            <select name="ticket_number" id="ticket_number">
            </select>
        </div>
    <?php elseif(isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'package' && is_array($fees_package)): ?>
        <div class="ticket-number-wrap">
            <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
            <?php
            $seats = $seats ?  $seats : 20; // for unlimit seat
            $seats = $seats >=20 ? 20 : $seats;?>
            <select name="ticket_number" id="ticket_number" data-seat="<?php echo esc_attr($seats);?>">
                <?php
                foreach ($fees_package as $package) { ?>
                    <option value="<?php echo esc_attr($package['quantity']);?>"  data-seat="<?php echo esc_attr($seats); ?>">
                        <?php echo esc_html($package['quantity']);?>
                    </option>
                <?php } ?>
            </select>
        </div>
    <?php else:  ?>
        <div class="ticket-number-wrap">
            <label><?php esc_html_e('Number of ticket', 'fat-event'); ?></label>
            <?php
            $seats = $seats ?  $seats : 20; // for unlimit seat
            $seats = $seats >=20 ? 20 : $seats;?>
            <select name="ticket_number" id="ticket_number" data-seat="<?php echo esc_attr($seats);?>">
                <?php
                for($i=1; $i<= $seats; $i++) { ?>
                    <option value="<?php echo esc_attr($i);?>"  data-seat="<?php echo esc_attr($seats); ?>">
                        <?php echo esc_html($i);?>
                    </option>
                <?php } ?>
            </select>
        </div>
    <?php endif;?>
    <a href="javascript:" class="fat-bt-submit-to-WC"><?php echo esc_html__('Submit', 'fat-event'); ?></a>
</div>
