<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 7/29/2018
 * Time: 10:48 AM
 */
$fat_event_setting = get_option('fat_event_setting');
$current_user_id = get_current_user_id();
if ($current_user_id == 0) {
    global $wp;
    $register_url = home_url($wp->request);
    $login_url= wp_login_url($register_url);
    $register_url = wp_registration_url();
    $register_notice_message = stripslashes($fat_event_setting['register_notice_message']);
    $register_notice_message = str_replace('[login_link]',$login_url, $register_notice_message);
    $register_notice_message = str_replace('[register_link]',$register_url, $register_notice_message);
    echo $register_notice_message;
    return;
}

$args = array(
    'include' => ''
);

$utils = new FAT_Event_Utils();

if ($current_user_id && isset($fat_event_setting['allow_select_location']) && $fat_event_setting['allow_select_location'] == 'owner') {
    $term_owner = get_user_meta($current_user_id, 'location_term_owner', true);
    if (is_array($term_owner) && count($term_owner) > 0) {
        $args['include'] = $term_owner;
        $location = $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY, $args);
    }else{
        $location = array();
    }
}else{
    $location = $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY);
}

$location = array(
        'hide' => esc_html__('Hide location', 'fat-event'),
        'add_new' => esc_html__('Add new location', 'fat-event'),
    ) + $location;


$args = array(
    'include' => ''
);
if ($current_user_id && isset($fat_event_setting['allow_select_organizer']) && $fat_event_setting['allow_select_organizer'] == 'owner') {
    $term_owner = get_user_meta($current_user_id, 'organizer_term_owner', true);
    if (is_array($term_owner)  && count($term_owner) > 0) {
        $args['include'] = $term_owner;
        $other_organizer = $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY, $args);
    }else{
        $other_organizer = array();
    }
}else{
    $other_organizer = $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY);
}

$main_organizer = array(
        'hide' => esc_html__('Hide organizer', 'fat-event'),
        'add_new' => esc_html__('Add new organizer', 'fat-event'),
    ) + $other_organizer;

$terms = get_terms(array(
    'taxonomy' => FAT_EVENT_CATEGORY_TAXONOMY
));
$cats = array();
foreach ($terms as $term) {
    $cats[$term->term_id] = $term->name;
}

$gateways = array();

if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'both') {
    $gateways['both'] = esc_html__('Offline, Paypal and Stripe', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'offline_paypal') {
    $gateways['offline_paypal'] = esc_html__('Offline and Paypal', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'offline_stripe') {
    $gateways['offline_stripe'] = esc_html__('Offline and Stripe', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'paypal_stripe') {
    $gateways['offline_stripe'] = esc_html__('Paypal and Stripe', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'myPOS') {
    $gateways['myPOS'] = esc_html__('myPOS', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] == 'offline' || $fat_event_setting['payment_method'] == 'both'
        || $fat_event_setting['payment_method'] == 'offline_paypal' || $fat_event_setting['payment_method'] == 'offline_stripe')) {
    $gateways['offline'] = esc_html__('Payment offline', 'fat-event');
}
if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] === 'both' || $fat_event_setting['payment_method'] === 'paypal'
        || $fat_event_setting['payment_method'] === 'paypal_stripe' || $fat_event_setting['payment_method'] === 'offline_paypal')) {
    $gateways['paypal'] = esc_html__('Payment by Paypal', 'fat-event');
}

if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] === 'both' || $fat_event_setting['payment_method'] === 'stripe'
        || $fat_event_setting['payment_method'] === 'paypal_stripe' || $fat_event_setting['payment_method'] === 'offline_stripe')) {
    $gateways['stripe'] = esc_html__('Payment by Stripe', 'fat-event');
}

$gateways['external_link'] = esc_html__('External link', 'fat-event');

$fields = array(
    array(
        'label' => esc_html__('Categories', 'fat-event'),
        'id' => 'categories',
        'type' => 'select',
        'multiple' => true,
        'std' => '',
        'options' => $cats,
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Tags', 'fat-event'),
        'id' => 'tags',
        'type' => 'text',
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'description' => esc_html__('Separate tags with commas', 'fat-event')
    ),
    array(
        'label' => esc_html__('Start Date', 'fat-event'),
        'id' => 'start_date',
        'type' => 'datetime',
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'description' => esc_html__('Format: Year/Month/Day Hour:Minute', 'fat-event')
    ),
    array(
        'label' => esc_html__('End Date', 'fat-event'),
        'id' => 'end_date',
        'type' => 'datetime',
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'description' => esc_html__('Format: Year/Month/Day Hour:Minute', 'fat-event')
    ),
    array(
        'label' => esc_html__('All Day Event', 'fat-event'),
        'id' => 'all_day_event',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'std' => '',
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Hide Event Time', 'fat-event'),
        'id' => 'hide_event_time',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'std' => '',
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Hide Event End Time', 'fat-event'),
        'id' => 'hide_event_end_time',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'std' => '',
        'col_width' => 'fat-cmb-col-12'
    ),

    /** Repeating */
    array(
        'label' => esc_html__('Event Repeating', 'fat-event'),
        'id' => 'event_repeating',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'col_width' => 'fat-cmb-col-12',
        'value' => ''
    ),
    array(
        'label' => esc_html__('Repeat', 'fat-event'),
        'id' => 'repeat',
        'type' => 'select',
        'multiple' => false,
        'options' => array(
            'daily' => esc_html__('Daily', 'fat-event'),
            'monthly' => esc_html__('Monthly', 'fat-event'),
            'weekly' => esc_html__('Weekly', 'fat-event'),
            'yearly' => esc_html__('Yearly', 'fat-event'),
            'custom' => esc_html__('Custom days', 'fat-event')
        ),
        'std' => 'daily',
        'depend_field' => array(
            'field' => 'event_repeating',
            'value' => '1',
            'compare' => '='
        ),
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Repeat interval', 'fat-event'),
        'id' => 'daily_interval',
        'type' => 'number',
        'min' => 0,
        'max' => 100,
        'step' => 1,
        'std' => '1',
        'depend_field' => array(
            'field' => 'repeat',
            'value' => 'daily',
            'compare' => '='
        ),
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Repeat event display', 'fat-event'),
        'id' => 'repeat_event_display',
        'type' => 'number',
        'min' => 0,
        'max' => 100,
        'step' => 1,
        'std' => '1',
        'depend_field' => array(
            'field' => 'repeat',
            'value' => 'daily',
            'compare' => '='
        ),
        'col_width' => 'fat-cmb-col-12'
    ),
    array(
        'label' => esc_html__('Custom days', 'fat-event'),
        'id' => 'custom_days',
        'type' => 'repeat',
        'fields' => array(
            array(
                'label' => esc_html__('Repeat on', 'fat-event'),
                'id' => 'repeat_on_date',
                'type' => 'datetime',
                'std' => '',
                'time_picker' => 1
            ),
        ),
        'depend_field' => array(
            'field' => 'repeat',
            'value' => 'custom',
            'compare' => '='
        ),
    ),

    /** Multiple location */
    array(
        'label' => esc_html__('Multiple location', 'fat-event'),
        'id' => 'multiple_location',
        'type' => 'select',
        'multiple' => false,
        'options' => array(
            'no' => esc_html__('No. The event takes place at one location', 'fat-event'),
            'yes' => esc_html__('Yes. Events taking place in many locations', 'fat-event'),
        ),
        'std' => 'no',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'multiple-location-field',
        'description' => esc_html__('If choices Yes. Please select locations and organizer in \'Hourly Schedule\' section', 'fat-event')
    ),
    /** Hour schedule */
    array(
        'label' => esc_html__('Hourly Schedule', 'fat-event'),
        'id' => 'section_schedule',
        'type' => 'section',
        'css_class' => 'hour-schedule-field'
    ),
    array(
        'id' => 'schedule',
        'type' => 'repeat',
        'fields' => array(
            array(
                'label' => esc_html__('From', 'fat-event'),
                'id' => 'from',
                'type' => 'text',
                'std' => '',
                'description' => esc_html__('Ex: 8:30', 'fat-event')
            ),
            array(
                'label' => esc_html__('To', 'fat-event'),
                'id' => 'to',
                'type' => 'text',
                'std' => '',
                'description' => esc_html__('Ex: 9:30', 'fat-event')
            ),
            array(
                'label' => esc_html__('Title', 'fat-event'),
                'id' => 'title',
                'type' => 'text',
                'std' => '',
            ),
            array(
                'label' => esc_html__('Description', 'fat-event'),
                'id' => 'description',
                'type' => 'text',
                'std' => ''
            ),
            array(
                'label' => esc_html__('Choose location', 'fat-event'),
                'id' => 'location',
                'type' => 'select',
                'multiple' => false,
                'options' => $location,
                'std' => '',
                'col_width' => 'fat-cmb-col-6',
                'depend_field' => array(
                    'field' => 'multiple_location',
                    'value' => 'yes',
                    'compare' => '='
                ),
            ),
            array(
                'label' => esc_html__('Organizer', 'fat-event'),
                'id' => 'organizer',
                'type' => 'select',
                'multiple' => false,
                'options' => $main_organizer,
                'std' => 'hide',
                'col_width' => 'fat-cmb-col-6',
                'css_class' => '',
                'depend_field' => array(
                    'field' => 'multiple_location',
                    'value' => 'yes',
                    'compare' => '='
                ),
            )
        ),
        'css_class' => 'hour-schedule-field'
    ),

    /** Location & Organizer */
    array(
        'label' => esc_html__('Event location & organizer', 'fat-event'),
        'id' => 'section_location',
        'type' => 'section',
        'depend_field' => array(
            'field' => 'multiple_location',
            'value' => 'yes',
            'compare' => '!='
        ),
        'css_class' => 'section-location-field'
    ),
    array(
        'label' => esc_html__('Choose location', 'fat-event'),
        'id' => 'location',
        'type' => 'select',
        'multiple' => false,
        'options' => $location,
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'depend_field' => array(
            'field' => 'multiple_location',
            'value' => 'yes',
            'compare' => '!='
        ),
        'css_class' => 'single-location-field'
    ),
    array(
        'label' => esc_html__('Main organizer', 'fat-event'),
        'id' => 'main_organizer',
        'type' => 'select',
        'multiple' => false,
        'options' => $main_organizer,
        'std' => 'hide',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'clear-both',
        'depend_field' => array(
            'field' => 'multiple_location',
            'value' => 'yes',
            'compare' => '!='
        ),
        'css_class' => 'single-organizer-field'
    ),
    array(
        'label' => esc_html__('Other organizer', 'fat-event'),
        'id' => 'other_organizer',
        'type' => 'select',
        'multiple' => true,
        'options' => $other_organizer,
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'clear-both',
        'depend_field' => array(
            'field' => 'multiple_location',
            'value' => 'yes',
            'compare' => '!='
        ),
        'css_class' => 'other-organizer-field'
    ),

    /** Links */
    array(
        'label' => esc_html__('Links', 'fat-event'),
        'id' => 'section_link',
        'type' => 'section',
        'css_class' => 'link-field'
    ),
    array(
        'label' => esc_html__('Link to detail', 'fat-event'),
        'id' => 'link_detail',
        'type' => 'text',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'link-field link-detail'
    ),
    array(
        'label' => esc_html__('Link more info', 'fat-event'),
        'id' => 'link_more_info',
        'type' => 'text',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'link-field link-more-info'
    ),
    array(
        'label' => esc_html__('More info label', 'fat-event'),
        'id' => 'label_more_info',
        'type' => 'text',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'link-field link-more-info'
    ),
    array(
        'label' => esc_html__('Open type', 'fat-event'),
        'id' => 'link_open_type',
        'type' => 'select',
        'multiple' => false,
        'options' => array(
            '_target' => esc_html__('Current Window', 'fat-event'),
            '_blank' => esc_html__('New Window', 'fat-event'),
        ),
        'std' => '_target',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'link-field link-open-type'
    ),

    /** Booking */
    array(
        'label' => esc_html__('Booking', 'fat-event'),
        'id' => 'section_booking',
        'type' => 'section',
        'css_class' => 'booking-field'
    ),
    array(
        'label' => esc_html__('Enable booking', 'fat-event'),
        'id' => 'enable_booking',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'booking-field'
    ),
    array(
        'label' => esc_html__('Fees type', 'fat-event'),
        'id' => 'fees_type',
        'type' => 'select',
        'multiple' => false,
        'options' => array(
            'fixed' => esc_html__('Fixed fees', 'fat-event'),
            'package' => esc_html__('Fees base on quantity (Ex: 1 ticket : 10$, 2 ticket : 15$, 3 ticket: 22$, .. )', 'fat-event'),
            'ticket_class' => esc_html__('Ticket classification (Ex: Economy class - 10$, Premium class -> 30$, ..)', 'fat-event'),
        ),
        'std' => 'fixed',
        'col_width' => 'fat-cmb-col-12',
        'css_class' => 'full-width',
        'depend_field' => array(
            'field' => 'enable_booking',
            'value' => '1',
            'compare' => '='
        ),
        'css_class' => 'booking-field fee-type'
    ),
    array(
        'label' => esc_html__('Fees', 'fat-event'),
        'id' => 'fees',
        'type' => 'number',
        'min' => 0,
        'max' => 10000000,
        'step' => 0.1,
        'std' => 0,
        'col_width' => 'fat-cmb-col-12',
        'description' => esc_html__('Set empty or 0 if event is free', 'fat-event'),
        'depend_field' => array(
            'field' => 'fees_type',
            'value' => 'fixed',
            'compare' => '='
        ),
        'css_class' => 'booking-field fee'
    ),
    array(
        'id' => 'fees_package',
        'type' => 'repeat',
        'add_field_label' => esc_html__('Add package', 'fat-event'),
        'fields' => array(
            array(
                'label' => esc_html__('Quantity', 'fat-event'),
                'id' => 'quantity',
                'type' => 'number',
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'std' => 1
            ),
            array(
                'label' => esc_html__('Fees', 'fat-event'),
                'id' => 'fees',
                'type' => 'number',
                'min' => 0,
                'max' => 10000000,
                'step' => 0.1,
                'std' => 0,
            ),
        ),
        'depend_field' => array(
            'field' => 'fees_type',
            'value' => 'package',
            'compare' => '='
        ),
        'css_class' => 'booking-field fee-package'
    ),
    array(
        'id' => 'ticket_class',
        'type' => 'repeat',
        'add_field_label' => esc_html__('Add class', 'fat-event'),
        'fields' => array(

            array(
                'label' => esc_html__('Class', 'fat-event'),
                'id' => 'class',
                'type' => 'text',
                'std' => '',
                'col_width' => 'fat-cmb-col-4',
                'description' => esc_html__('Ticket class name', 'fat-event')
            ),
            array(
                'label' => esc_html__('Seats available', 'fat-event'),
                'id' => 'seats',
                'type' => 'number',
                'min' => 1,
                'max' => 10000,
                'step' => 1,
                'std' => 1,
                'col_width' => 'fat-cmb-col-4',
                'description' => esc_html__('Seat of this ticket class. Set empty or 0 to unlimited', 'fat-event')
            ),
            array(
                'label' => esc_html__('Fees', 'fat-event'),
                'id' => 'fees',
                'type' => 'number',
                'min' => 0,
                'max' => 10000000,
                'step' => 0.1,
                'std' => 0,
                'col_width' => 'fat-cmb-col-4',
                'description' => esc_html__('Fees of this ticket class', 'fat-event')
            ),
            array(
                'id' => 'class_id',
                'type' => 'hidden',
                'guid' => 1,
                'std' => uniqid()
            ),
        ),
        'depend_field' => array(
            'field' => 'fees_type',
            'value' => 'ticket_class',
            'compare' => '='
        ),
        'css_class' => 'booking-field fee-ticket'
    ),
    array(
        'label' => esc_html__('Seats', 'fat-event'),
        'id' => 'seats',
        'type' => 'number',
        'min' => 0,
        'max' => 10000,
        'step' => 1,
        'std' => 0,
        'col_width' => 'fat-cmb-col-12',
        'description' => esc_html__('Set empty or 0 to remove limit seat'),
        'depend_field' => array(
            'field' => 'fees_type',
            'value' => 'ticket_class',
            'compare' => '!='
        ),
        'css_class' => 'booking-field seats'
    ),
    array(
        'label' => esc_html__('Enable seat available', 'fat-event'),
        'id' => 'enable_seat_available',
        'type' => 'check',
        'options' => array(
            '1' => esc_html__('Yes', 'fat-event')
        ),
        'std' => '',
        'col_width' => 'fat-cmb-col-12',
        'depend_field' => array(
            'field' => 'fees_type',
            'value' => 'ticket_class',
            'compare' => '!='
        ),
        'css_class' => 'booking-field seat-available'
    ),
    array(
        'label' => esc_html__('Payment', 'fat-event'),
        'id' => 'payment',
        'type' => 'select',
        'multiple' => false,
        'options' => $gateways,
        'std' => 'offline',
        'col_width' => 'fat-cmb-col-12',
        'depend_field' => array(
            'field' => 'enable_booking',
            'value' => '1',
            'compare' => '='
        ),
        'css_class' => 'booking-field payment'
    ),
    array(
        'label' => esc_html__('External link booking', 'fat-event'),
        'id' => 'external_link_booking',
        'type' => 'text',
        'col_width' => 'fat-cmb-col-12',
        'depend_field' => array(
            'field' => 'payment',
            'value' => 'external_link',
            'compare' => '='
        ),
        'description' => esc_html__('Please input external link booking. The website will be redirect to this link when user click register button', 'fat-event'),
        'css_class' => 'booking-field external-link'
    ),


    /** Color */
    array(
        'label' => esc_html__('Color', 'fat-event'),
        'id' => 'section_color',
        'type' => 'section',
        'css_class' => 'color-field'
    ),
    array(
        'label' => esc_html__('Choose color', 'fat-event'),
        'id' => 'color',
        'type' => 'color',
        'std' => '#a3b745',
        'is_frontend' => true,
        'css_class' => 'color-field'
    ),

    /** Background */
    array(
        'label' => esc_html__('Feature & Background Image', 'fat-event'),
        'id' => 'section_bg',
        'type' => 'section',
    ),
    array(
        'label' => esc_html__('Feature image', 'fat-event'),
        'id' => 'feature_image',
        'type' => 'single_image'
    ),
    array(
        'label' => esc_html__('Background image', 'fat-event'),
        'id' => 'bg_images',
        'type' => 'single_image',
        'css_class' => 'background-field'
    ),

    /** Media  */
    array(
        'label' => esc_html__('Media', 'fat-event'),
        'id' => 'section_media',
        'type' => 'section',
        'css_class' => 'media-field'
    ),
    array(
        'label' => esc_html__('Media type', 'fat-event'),
        'id' => 'media_type',
        'type' => 'radio',
        'options' => array(
            'none' => esc_html__('None', 'fat-event'),
            'image' => esc_html__('Image', 'fat-event'),
            'video' => 'Video'
        ),
        'col_width' => 'fat-cmb-col-12',
        'std' => 'none',
        'css_class' => 'media-field'
    ),
    array(
        'label' => esc_html__('Choose images', 'fat-event'),
        'id' => 'images',
        'type' => 'images',
        'depend_field' => array(
            'field' => 'media_type',
            'value' => 'image',
            'compare' => '='
        ),
        'css_class' => 'media-field'
    ),
    array(
        'label' => esc_html__('Link video', 'fat-event'),
        'id' => 'link_video',
        'type' => 'text',
        'col_width' => 'fat-cmb-col-12',
        'depend_field' => array(
            'field' => 'media_type',
            'value' => 'video',
            'compare' => '='
        ),
        'css_class' => 'media-field'
    ),
);

$fields = apply_filters('fat_event_register_field',$fields);

$amenities = isset($fat_event_setting['amenities']) ? $fat_event_setting['amenities'] : '';
if (is_array($amenities) && isset($amenities['amenities_name'])) {
    $field_id = '';
    $fields[] = array(
        'label' => esc_html__('Amenities', 'fat-event'),
        'id' => 'section_amenities',
        'type' => 'section',
    );
    foreach ($amenities['amenities_name'] as $a) {
        $field_id = strtolower($a);
        $field_id = str_replace(' ', '_', $field_id);
        $fields[] = array(
            'label' => '',
            'id' => $field_id,
            'type' => 'check',
            'options' => array(
                $a => $a
            ),
            'std' => '',
            'col_width' => 'fat-cmb-col-6',
            'css_class' => 'amenities-field'
        );
    }
}
$container_class = 'fat-event-register-container';
$container_class .= isset($atts['hide_multi_location']) && $atts['hide_multi_location'] == '1' ? ' hide-multi-location' : '';
$container_class .= isset($atts['hide_hour_schedule']) && $atts['hide_hour_schedule'] == '1' ? ' hide-hour-schedule' : '';
$container_class .= isset($atts['hide_link']) && $atts['hide_link'] == '1' ? ' hide-link' : '';
$container_class .= isset($atts['hide_link_open_type']) && $atts['hide_link_open_type'] == '1' ? ' hide-link-open-type' : '';
$container_class .= isset($atts['hide_booking']) && $atts['hide_booking'] == '1' ? ' hide-booking' : '';
$container_class .= isset($atts['hide_color']) && $atts['hide_color'] == '1' ? ' hide-color' : '';
$container_class .= isset($atts['hide_background']) && $atts['hide_background'] == '1' ? ' hide-background' : '';

?>
<div class="<?php echo esc_attr($container_class); ?>" id="fat_event_register_container" data-spinner="atom">
    <div class="fat-cmb-container fat-cmb-fields">
        <div class="fat-cmb-row">
            <div class="fat-cmb-col-12  fat-cmb-text-wrap">
                <label for="title"><?php echo esc_html__('Event Name'); ?></label>
                <div class="fat-cmb-field">
                    <input type="text" name="title" value="" id="title" data-field-id="title" data-std="">
                </div>
            </div>
        </div>
    </div>
    <?php
    wp_editor('', 'event_content');
    do_action('add_page_meta_boxes', uniqid(), $fields);
    ?>
    <div class="fat-event-register-button-group">
        <a href="javascript:" class="button fat-event-register-submit"><?php esc_html_e('Submit', 'fat-event'); ?></a>
        <a href="javascript:" class="button fat-event-register-cancel"><?php esc_html_e('Cancel', 'fat-event'); ?></a>
    </div>
</div>
