<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/14/2018
 * Time: 4:10 PM
 */
$item_per_page = isset($shortcode_config['item_per_page']) && $shortcode_config['item_per_page'] ? $shortcode_config['item_per_page'] : 12;
$current_page = isset($shortcode_config['current_page']) && $shortcode_config['current_page'] ? $shortcode_config['current_page'] : 1;

$has_paging = false;
if ($item_per_page && $item_per_page > 0 && ($item_per_page < $total_found || $total_found == 0 || $total_found ==='')) {
    $max_num_pages = floor($total_found / $item_per_page) + ($total_found % $item_per_page > 0 ? 1 : 0);
    if ($max_num_pages > 1) {
        $has_paging = true;
    }
}
if (!$has_paging) {
    return;
}

global $wp_query, $wp_rewrite;
$paged = get_query_var('paged') ? intval(get_query_var('paged')) : $current_page;
$pagenum_link = html_entity_decode(get_pagenum_link());
$query_args = array();
$url_parts = explode('?', $pagenum_link);

if (isset($url_parts[1])) {
    wp_parse_str($url_parts[1], $query_args);
}

$pagenum_link = esc_url(remove_query_arg(array_keys($query_args), $pagenum_link));
$pagenum_link = trailingslashit($pagenum_link) . '%_%';

$format = $wp_rewrite->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit($wp_rewrite->pagination_base . '/%#%', 'paged') : '?paged=%#%';
?>

<div class="fat-paging-navigation-wrap text-center"  data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']);?>">
    <div class="paging-navigation clearfix" >
        <?php echo paginate_links(array(
            'base'               => $pagenum_link,
            'format'             => $format,
            'total'              => $max_num_pages,
            'current'            => $paged,
            'mid_size'           => 1,
            'prev_text'          => '<span ><i class="fa fa-angle-left"></i></span>',
            'next_text'          => '<span ><i class="fa fa-angle-right"></i></span>',
            'before_page_number' => '<span >',
            'after_page_number'  => '</span>'
        )); ?>
    </div>
</div>