<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/26/2018
 * Time: 10:14 AM
 */

$total_found = 0;
$now = current_time('mysql',0);
$now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
$ts = strtotime($now->format('M') . ' ' . $now->format('Y'));
$start_of_month = date('m-01-Y 00:00:00', $ts);
$end_of_month = date('m-t-Y 12:59:59', $ts);

$fat_event_setting = get_option('fat_event_setting');
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
$start_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $start_of_month);
$end_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $end_of_month);

$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
$date_format = $date_format != '' ? $date_format : ' ';

$shortcode_config['limit'] = '';
$shortcode_config['pagination'] = 'none';
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$data_events = array();
$bg_color = '';
$index = 0;
$single_time = '';

$day_off = array();
$is_day_off = 0;
$start_date = '';
$end_date = '';
$event_title = '';
foreach ($events as $event) {
    $is_day_off = 0;
    $bg_color = FAT_Event_Utils::get_seat_color($event['id'], $event['start_date'], $event['end_date']);
    $day_off = get_post_meta($event['id'],'fat-mb-event-detail', true);
    $day_off = isset($day_off['day_off']) ? $day_off['day_off'] : array();
    if(isset($day_off['dof']) && is_array($day_off['dof'])){
        $start_date = $event['start_date']->format('Y-m-d');
        $end_date = $event['end_date']->format('Y-m-d');
        foreach($day_off['dof'] as $dof){
            $dof = explode(';',$dof);
            if(count($dof)==2 && ( ($dof[0] <= $start_date && $start_date <= $dof[1]) || ($dof[0] <= $end_date && $end_date <= $dof[1]) ) ){
                $is_day_off = 1;
                break;
            }
        }
    }
    if ($event['all_day_event'] === '1') {
        $single_time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
    }else{
        $all_day_event = isset($event['all_day_event'][0]) ? $event['all_day_event'][0] : '';
        if (isset($event['hide_event_end_time'][0]) && $event['hide_event_end_time'][0] == '1') {
            $single_time = $event['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
        } else {
            if ($all_day_event && date_diff($event['start_date'], $event['end_date'])->d == 0) {
                $single_time = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($single_time_format);
            } else {
                if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                    $single_time = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                } else {
                    $single_time = $event['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $event['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $event['end_date']->format('U'));
                }
            }
        }
    }
    $event_title  = $is_day_off ? esc_html__('Unfortunately this event is canceled','fat-event') : get_the_title($event['id']);
    $data_events[] = array(
        'id' => $event['id'],
        'title' => $event_title,
        'start' => $event['all_day_event'] ? $event['start_date']->format('Y-m-d') : $event['start_date']->format('c'), //format to display on timeable js library
        'start_date' => $event['start_date']->format('U'),
        'end_date' => $event['end_date']->format('U'),
        'color' => $bg_color,
        'open_type' => isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window',
        'time' => $single_time,
        'url' => 'javascript:;',
        'is_day_off' => $is_day_off
    );

    if (!$event['all_day_event']) {
        $data_events[$index]['end'] = $event['end_date']->format('c');
    }
    if ($event['open_detail_type'] === 'single_window'  || $event['open_detail_type'] =='current_window') {
        $data_events[$index]['url'] = esc_url($event['link_detail']);
    }
    if($is_day_off){
        $data_events[$index]['url']='#';
    }
    $index++;
}

$data_events = json_encode($data_events);
?>
<div class="fat-event-container event-timetable" data-sc-id="<?php echo esc_attr($id); ?>"
     data-sc-organizer="<?php echo(isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo(isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']); ?>"
     data-events="<?php echo esc_attr($data_events); ?>"
     data-default-date="<?php echo $now->format('Y-m-d'); ?>"
     data-locale="<?php echo(isset($shortcode_config['locale']) ? $shortcode_config['locale'] : 'en'); ?>"
     data-view="<?php echo(isset($shortcode_config['timetable_view']) && $shortcode_config['timetable_view'] ? $shortcode_config['timetable_view'] : 'month'); ?>"
     data-list-day="<?php echo(isset($shortcode_config['list_day_label']) && $shortcode_config['list_day_label'] ? $shortcode_config['list_day_label'] : ''); ?>"
     data-list-week="<?php echo(isset($shortcode_config['list_week_label']) && $shortcode_config['list_week_label'] ? $shortcode_config['list_week_label'] : ''); ?>"
     data-list-month="<?php echo(isset($shortcode_config['list_month_label']) && $shortcode_config['list_month_label'] ? $shortcode_config['list_month_label'] : ''); ?>"
     data-single-time-format= <?php echo esc_attr($single_time_format); ?>
>
</div>