<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 8/28/2019
 * Time: 10:37 AM
 */
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$shortcode_search = get_post_meta($id, 'fat-mb-shortcode-search', true);
$width = isset($shortcode_config['image_width']) ? $shortcode_config['image_width'] : 375;
$height = isset($shortcode_config['image_height']) ? $shortcode_config['image_height'] : 275;
$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';
$time_format = $time_format!='' ? $time_format : ' ';
$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
$date_format = $date_format !='' ? $date_format : ' ';
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';

$fat_event_setting = get_option('fat_event_setting');
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$separator = isset($fat_event_setting['currency_separator']) ? $fat_event_setting['currency_separator'] : ',';
$decimal = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal'] ? $fat_event_setting['currency_decimal'] : 0;
?>
<div class="fat-event-container <?php echo(isset($shortcode_config['enable_animation'][0]) ? $shortcode_config['enable_animation'][0] : ''); ?>"
     data-layout="<?php echo esc_attr($layout); ?>"
     data-sc-id="<?php echo esc_attr($id); ?>"
     data-sc-organizer="<?php echo(isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo(isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-animation="fadeInUp"
     data-animation-duration="200"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']); ?>"
>
    <?php
    if (isset($shortcode_search['enable_search'][0]) && $shortcode_search['enable_search'][0] === '1') {
        $filter_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/filters/' . $shortcode_search['search_style'] . '.php';
        include $filter_path;
    }
    ?>
    <div class="fat-event-sc table-layout">
        <?php if (count($events) == 0): ?>
            <div class="fat-event-item no-upcoming-event"><?php echo esc_html__('No upcoming event', 'fat-event'); ?></div>
        <?php else:
            $skin_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/skins/' . (isset($shortcode_config['skin']) && $shortcode_config['skin'] ? $shortcode_config['skin'] : 'skin-01') . '.php';
            $item_class = $time = $single_time = '';
            $locale = get_locale();
            if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                $locale .= '.utf8';
            }
            setlocale(LC_TIME, $locale);
            ?>
        <table>
            <thead>
                <tr>
                    <th><?php echo esc_html__('Event','fat-event');?></th>
                    <th><?php echo esc_html__('Location','fat-event');?></th>
                    <th><?php echo esc_html__('Start date','fat-event');?></th>
                    <th><?php echo esc_html__('End date','fat-event');?></th>
                    <th><?php echo esc_html__('Fees','fat-event');?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <?php
            $location = '';
            $time = '';
            $single_time = '';
            foreach ($events as $event) {
                $event_detail = get_post_meta($event['id'], 'fat-mb-event-detail', true);
                $location = FAT_Event_Utils::get_location_title($event_detail['location'], ', ');
                if ($event['all_day_event'] === '1') {
                    $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
                    $single_time = $time;
                } else {
                    $time = $event['start_date']->format($time_format) . ' - ' . $event['end_date']->format($time_format) . ', ' . date_i18n($date_format, $event['start_date']->format('U'));

                    $all_day_event = isset($event['all_day_event'][0]) ? $event['all_day_event'][0] : '';
                    if (isset($event['hide_event_end_time'][0]) && $event['hide_event_end_time'][0] == '1') {
                        $single_time = $event['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                    } else {
                        if ($all_day_event && date_diff($event['start_date'], $event['end_date'])->d == 0) {
                            $single_time = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($single_time_format);
                        } else {
                            if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                                $single_time = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                            } else {
                                $single_time = $event['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $event['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $event['end_date']->format('U'));
                            }
                        }
                    }
                }

                ?>
                <tr>
                    <td class="fat-event-title" data-col-title="<?php echo esc_attr('Event','fat-event');?>">
                        <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
                           target="<?php echo esc_attr($event['link_open_type']);?>" data-event-id="<?php echo esc_attr($event['id']);?>"
                           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                           data-time="<?php echo esc_attr($time); ?>"  data-single-time="<?php echo esc_attr($single_time);?>">
                            <?php echo esc_html($event['title']);?>
                        </a>
                    </td>
                    <td data-col-title="<?php echo esc_attr('Location','fat-event');?>"><?php echo esc_html($location);?></td>
                    <td data-col-title="<?php echo esc_attr('Start date','fat-event');?>">
                        <?php echo esc_attr($event['start_date']->format($time_format)); ?> -
                        <?php echo date_i18n($date_format,$event['start_date']->format('U'));?>
                    </td>
                    <td data-col-title="<?php echo esc_attr('End date','fat-event');?>">
                        <?php echo esc_attr($event['end_date']->format($time_format)); ?> -
                        <?php echo date_i18n($date_format,$event['end_date']->format('U'));?>
                    </td>
                    <td data-col-title="<?php echo esc_attr('Fees','fat-event');?>">
                        <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?><?php echo number_format($event['fees'], $decimal, '.', $separator); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                    </td>
                    <td>
                        <a href="<?php echo esc_url($event['link_detail']) ?>" data-open-type="<?php echo esc_attr($event['open_detail_type']);?>"
                           target="<?php echo esc_attr($event['link_open_type']);?>" data-event-id="<?php echo esc_attr($event['id']);?>"
                           data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                           data-time="<?php echo esc_attr($time); ?>"  data-single-time="<?php echo esc_attr($single_time);?>">
                            <?php echo esc_html__('View Detail', 'fat-event');?>
                        </a>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
     <?php endif; ?>
    </div>
</div>
