<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 11:12 AM
 */

$shortcode_config['pagination'] = 'none';
$total_found = 0;
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$shortcode_search = get_post_meta($id, 'fat-mb-shortcode-search', true);
$width = isset($shortcode_config['image_width']) ? $shortcode_config['image_width'] : 375;
$height = isset($shortcode_config['image_height']) ? $shortcode_config['image_height'] : 275;
$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';
$time_format = $time_format!='' ? $time_format : ' ';
$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
$date_format = $date_format!='' ? $date_format : ' ';

$fat_event_setting = get_option('fat_event_setting');
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$seat_available = $num_of_book = 0;

$slider_desktop_medium_width = isset($shortcode['slider_desktop_medium_width']) ? $shortcode['slider_desktop_medium_width'] : 1200;
$slider_desktop_small_width = isset($shortcode['slider_desktop_small_width']) ? $shortcode['slider_desktop_small_width'] : 980;
$slider_tablet_width = isset($shortcode['slider_tablet_width']) ? $shortcode['slider_tablet_width'] : 768;
$slider_tablet_small_width = isset($shortcode['slider_tablet_small_width']) ? $shortcode['slider_tablet_small_width'] : 480;
$slider_mobile_width = isset($shortcode['slider_mobile_width']) ? $shortcode['slider_mobile_width'] : 320;
$slider_show_dot = isset($shortcode['slider_show_dot']) && $shortcode['slider_show_dot'] == 'true';
$slider_show_nav_text = isset($shortcode['slider_show_nav_text']) && $shortcode['slider_show_nav_text'] == 'true';
$slider_rtl = isset($shortcode['slider_rtl']) && $shortcode['slider_rtl'] == 'true';
$slider_desktop_large_width = $slider_desktop_medium_width + 100;
$gutter = isset($shortcode_config['slide_gutter']) ? $shortcode_config['slide_gutter'] : 0;

$owl_options = array(
    "responsive" => array(
        $slider_desktop_large_width => array(
            "items" => isset($shortcode_config['slider_desktop_large_column']) ? $shortcode_config['slider_desktop_large_column'] : 4
        ),
        1200 => array(
            "items" => isset($shortcode_config['slider_desktop_medium_column']) ? $shortcode_config['slider_desktop_medium_column'] : 4
        ),
        980 => array(
            "items" => isset($shortcode_config['slider_desktop_small_column']) ? $shortcode_config['slider_desktop_small_column'] : 4
        ),
        768 => array(
            "items" => isset($shortcode_config['slider_tablet_column']) ? $shortcode_config['slider_tablet_column'] : 3
        ),
        480 => array(
            "items" => isset($shortcode_config['slider_tablet_small_column']) ? $shortcode_config['slider_tablet_small_column'] : 2
        ),
        320 => array(
            "items" => isset($shortcode_config['slider_mobile_column']) ? $shortcode_config['slider_mobile_column'] : 1
        )
    ),
    "margin" => intval($gutter),
    "dots" => isset($shortcode_config['slider_show_dot'][0]) && $shortcode_config['slider_show_dot'][0] === '1',
    "nav" => isset($shortcode_config['slider_show_nav_text'][0]) && $shortcode_config['slider_show_nav_text'][0] === '1',
    "autoHeight" => 'true',
    "autoplay" => isset($shortcode_config['slider_auto_play']) && $shortcode_config['slider_auto_play'] == 'true',
    "autoplayTimeout" => 2000,
    "rtl" => isset($shortcode_config['slider_rtl']) && $shortcode_config['slider_rtl'] == 'true'
);
$owl_options = json_encode($owl_options);

?>
<div class="fat-event-container <?php echo(isset($shortcode_config['enable_animation'][0]) ? $shortcode_config['enable_animation'][0] : ''); ?>"
     data-layout="<?php echo esc_attr($layout); ?>"
     data-sc-id="<?php echo esc_attr($id); ?>"
     data-sc-organizer="<?php echo(isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo(isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-animation="fadeInUp"
     data-animation-duration="200"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']); ?>"
>
    <?php
    if (isset($shortcode_search['enable_search'][0]) && $shortcode_search['enable_search'][0] === '1') {
        $filter_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/filters/' . $shortcode_search['search_style'] . '.php';
        include $filter_path;
    }
    ?>
    <div class="fat-event-sc event-slide owl-carousel item-<?php echo esc_attr($shortcode_config['skin']); ?>"
         data-owl-options="<?php echo esc_attr($owl_options); ?>">
        <?php if (count($events) == 0): ?>
            <div class="fat-event-item no-upcoming-event"><?php echo esc_html__('No upcoming event', 'fat-event'); ?></div>
        <?php else:
            $skin_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/skins/' . (isset($shortcode_config['skin']) && $shortcode_config['skin'] ? $shortcode_config['skin'] : 'skin-01') . '.php';
            $item_class = $time = $single_time = '';
            $locale = get_locale();
            if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                $locale .= '.utf8';
            }
            setlocale(LC_TIME, $locale);
            $theme_path = get_stylesheet_directory() . '/templates/fat-event/skins/' . $shortcode_config['skin'] . '.php';
            if (file_exists($theme_path)) {
                $skin_path = $theme_path;
            }
            foreach ($events as $event) {
                $item_class = 'fat-event-item has-infinite';
                $item_class .= ' event-' . $event['id'];
                if ($event['all_day_event'] === '1') {
                    $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
                    $single_time = $time;
                } else {
                    $time = $event['start_date']->format($time_format) . ' - ' . $event['end_date']->format($time_format) . ', ' . date_i18n($date_format, $event['start_date']->format('U'));

                    $all_day_event = isset($event['all_day_event'][0]) ? $event['all_day_event'][0] : '';
                    if (isset($event['hide_event_end_time'][0]) && $event['hide_event_end_time'][0] == '1') {
                        $single_time = $event['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                    } else {
                        if ($all_day_event && date_diff($event['start_date'], $event['end_date'])->d == 0) {
                            $single_time = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($single_time_format);
                        } else {
                            if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                                $single_time = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                            } else {
                                $single_time = $event['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $event['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $event['end_date']->format('U'));
                            }
                        }
                    }


                }
                include $skin_path;
            };
        endif; ?>
    </div>
</div>