<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 8/27/2018
 * Time: 9:18 AM
 */

$shortcode_config['limit'] = '';
$shortcode_config['pagination'] = 'none';
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$event_map = array();
$location = $name = '';
$fat_event_setting = get_option('fat_event_setting');
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';
$time_format = $time_format!='' ? $time_format : ' ';
$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
$date_format = $date_format !='' ? $date_format : ' ';

foreach ($events as $e) {
    if (isset($e['location']) && $e['location']) {
        if (key_exists($e['location'], $event_map)) {
            $event_map[$e['location']]['events'][] = $e;
        } else {
            $location = get_term_by('id', $e['location'], FAT_EVENT_LOCATION_TAXONOMY);
            if (isset($location->name)) {
                $name = $location->name;
                $location = get_term_meta($e['location'], 'fat-mb-location-detail', true);
                $event_map[$e['location']] = array(
                    'map' => $location['map'],
                    'name' => $name,
                    'address' => $location['address'],
                    'events' => array($e)
                );
            }
        }
    }
}

?>
<div class="fat-event-google-map-container fat-event-sc">
    <div class="fat-event-google-map"
         style="height: <?php echo(isset($shortcode_config['map_height']) && $shortcode_config['map_height'] ? $shortcode_config['map_height'] : 500); ?>px"
         data-zoom="<?php echo(isset($shortcode_config['map_zoom']) && $shortcode_config['map_zoom'] ? $shortcode_config['map_zoom'] : 10); ?>"
         data-map-type="<?php echo(isset($shortcode_config['map_color_schema']) && $shortcode_config['map_color_schema'] ? $shortcode_config['map_color_schema'] : 'default'); ?>"
         data-marker-color="<?php echo(isset($shortcode_config['marker_color']) && $shortcode_config['marker_color'] ? $shortcode_config['marker_color'] : '#4d94ff'); ?>"
         data-enable-marker-info="<?php echo(isset($shortcode_config['enable_marker_info'][0]) && $shortcode_config['enable_marker_info'][0] ? $shortcode_config['enable_marker_info'][0] : '0'); ?>"
    >

    </div>
    <input type="text" placeholder="<?php echo esc_html__('Enter location to find event','fat-event');?>" name="map_search" class="search-box">
    <div class="fat-event-google-map-marker">
        <?php
        $time = $single_time = '';
        foreach ($event_map as $em) {
            ?>
            <div class="lk-google-map-marker-info" data-latitude="<?php echo esc_attr($em['map']); ?>"
                 data-events="<?php echo esc_attr(count($em['events'])); ?>">
                <div class="fat-event-location">
                    <?php echo esc_attr(count($em['events'])) . (count($em['events']) > 1 ? esc_html__(' events at ','fat-event') : esc_html__(' event at ','fat-event')) . $em['name'].' '.$em['address'] ; ?>
                </div>
                <ul class="fat-event-list">
                    <?php foreach ($em['events'] as $e) {
                        if ($e['all_day_event'] === '1') {
                            $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $e['start_date']->format('U'));
                            $single_time = $time;
                        } else {
                            $time = $e['start_date']->format($time_format) . ' - ' . $e['end_date']->format($time_format) . ', ' . date_i18n($date_format, $e['start_date']->format('U'));
                            $all_day_event = isset($e['all_day_event'][0]) ? $e['all_day_event'][0] : '';
                            if (isset($e['hide_event_end_time'][0]) && $e['hide_event_end_time'][0] == '1') {
                                $single_time = $e['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $e['start_date']->format('U'));
                            } else {
                                if ($all_day_event && date_diff($e['start_date'], $e['end_date'])->d == 0) {
                                    $single_time = esc_html__('All day - ', 'fat-event') . $e['start_date']->format($single_time_format);
                                } else {
                                    if (date_diff($e['start_date'], $e['end_date'])->d == 0) {
                                        $single_time = $e['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $e['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $e['start_date']->format('U'));
                                    } else {
                                        $single_time = $e['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $e['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $e['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $e['end_date']->format('U'));
                                    }
                                }
                            }
                        }
                        ?>
                        <li>
                            <span class="fat-event-title">
                                 <a href="<?php echo esc_url($e['link_detail']) ?>"
                                    data-event-id="<?php echo esc_attr($e['id']);?>"
                                    data-time="<?php echo esc_attr($time);?>" data-single-time="<?php echo esc_attr($single_time);?>"
                                    data-open-type="<?php echo esc_attr($e['open_detail_type']); ?>"
                                    data-s="<?php echo esc_attr($e['start_date']->format('U')); ?>"
                                    data-e="<?php echo esc_attr($e['end_date']->format('U')); ?>"
                                    target="<?php echo esc_attr($e['link_open_type']); ?>">
                                <?php echo $e['title']; ?>
                                 </a>
                            </span>
                            <?php if ($e['all_day_event'] === '1') { ?>
                                <span class="fat-event-time"><?php esc_attr_e('All day', 'fat-event'); ?>
                                    - <?php echo esc_attr($e['start_date']->format($e['date_format'])); ?> </span>
                            <?php } elseif (date_diff($e['start_date'], $e['end_date'])->d == 0) { ?>
                                <span class="fat-event-time"><?php echo esc_attr($e['start_date']->format('H:i')); ?>
                                    - <?php echo esc_html($e['end_date']->format($time_format)); ?> <?php echo date_i18n($date_format,$e['start_date']->format('U')); ?> </span>
                            <?php }else{?>
                                <span class="fat-event-time"><?php echo date_i18n($date_format,$e['start_date']->format('U')). ' '.$e['start_date']->format($time_format); ?>
                                    - <?php echo date_i18n($date_format,$e['end_date']->format('U')) . ' ' .$e['end_date']->format($time_format); ?> </span>
                            <?php }; ?>
                        </li>
                    <?php }; ?>
                </ul>
            </div>
        <?php }; ?>
    </div>
</div>

