<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 11:12 AM
 */

$column = isset($shortcode_config['column']) && $shortcode_config['column'] && $shortcode_config['column'] > 0 ? $shortcode_config['column'] : 3;
$total_found = 0;
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$shortcode_search = get_post_meta($id, 'fat-mb-shortcode-search', true);
$width = isset($shortcode_config['image_width']) ? $shortcode_config['image_width'] : 375;
$height = isset($shortcode_config['image_height']) ? $shortcode_config['image_height'] : 275;
$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';
$time_format = $time_format!='' ? $time_format : ' ';
$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');
$date_format = $date_format !='' ? $date_format : ' ';

$fat_event_setting = get_option('fat_event_setting');
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$seat_available = $num_of_book = 0;
$hide_single_end_time = isset($fat_event_setting['hide_event_end_time'][0]) ? $fat_event_setting['hide_event_end_time'][0] : 0;

?>
<div class="fat-event-container <?php echo(isset($shortcode_config['enable_animation'][0]) ? $shortcode_config['enable_animation'][0] : ''); ?>"
     data-layout="<?php echo esc_attr($layout); ?>"
     data-sc-id="<?php echo esc_attr($id); ?>"
     data-sc-organizer="<?php echo(isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo(isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-animation="fadeInUp"
     data-animation-duration="200"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']); ?>"
>
    <?php
    if (isset($shortcode_search['enable_search'][0]) && $shortcode_search['enable_search'][0] === '1') {
        $filter_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/filters/' . $shortcode_search['search_style'] . '.php';
        include $filter_path;
    }
    ?>
    <div class="fat-event-sc event-masonry <?php echo(isset($shortcode_config['gutter']) && $shortcode_config['gutter'] ? $shortcode_config['gutter'] : 'fat-padding-10'); ?>"
         data-event-col="<?php echo esc_attr(12 / $column); ?>">
        <?php if (count($events) == 0): ?>
            <div class="fat-event-item no-upcoming-event"><?php echo esc_html__('No upcoming event', 'fat-event'); ?></div>
        <?php else:
            $skin_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/skins/' . (isset($shortcode_config['skin']) && $shortcode_config['skin'] ? $shortcode_config['skin'] : 'skin-01') . '.php';
            $item_class = $time = $single_time = '';
            $locale = get_locale();
            if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                $locale .= '.utf8';
            }
            setlocale(LC_TIME, $locale);
            $theme_path = get_stylesheet_directory() . '/templates/fat-event/skins/' . $shortcode_config['skin'] . '.php';
            if (file_exists($theme_path)) {
                $skin_path = $theme_path;
            }
            foreach ($events as $event) {
                $item_class = 'fat-event-item has-infinite fat-col-sm-6 fat-col-xs-12 fat-col-md-' . (12 / $column);
                $item_class .= ' event-' . $event['id'];
                if ($event['all_day_event'] === '1') {
                    $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
                    $single_time = $time;
                } else {
                    $time = $event['start_date']->format($time_format) . ' - ' . $event['end_date']->format($time_format) . ', ' . date_i18n($date_format, $event['start_date']->format('U'));
                    $all_day_event = isset($event['all_day_event'][0]) ? $event['all_day_event'][0] : '';
                    if ($hide_single_end_time == '1') {
                        $single_time = $event['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                    } else {
                        if ($all_day_event && date_diff($event['start_date'], $event['end_date'])->d == 0) {
                            $single_time = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($single_time_format);
                        } else {
                            if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                                $single_time = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
                            } else {
                                $single_time = $event['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $event['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $event['end_date']->format('U'));
                            }
                        }
                    }
                }
                include $skin_path;
            };
        endif; ?>
    </div>
    <?php
    if (isset($shortcode_config['pagination']) && $shortcode_config['pagination'] !== 'none') {
        include untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/pagings/' . $shortcode_config['pagination'] . '.php';
    }
    ?>
</div>