<?php


$fat_event_setting = get_option('fat_event_setting');
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$time_format = isset($fat_event_setting['single_time_format']) && $fat_event_setting['single_time_format'] ? $fat_event_setting['single_time_format'] : 'H:i';
$date_time_order = isset($fat_event_setting['single_date_time_order']) && $fat_event_setting['single_date_time_order'] ? $fat_event_setting['single_date_time_order'] : 'time-date';
$custom_css = isset($fat_event_setting['single_custom_css']) && $fat_event_setting['single_custom_css'] ? $fat_event_setting['single_custom_css'] : '';
$show_google_map = !isset($fat_event_setting['show_google_map']) || (isset($fat_event_setting['show_google_map'][0]) && $fat_event_setting['show_google_map'][0] == '1');
$enable_woocommerce =  isset($fat_event_setting['enable_woocommerce']) ? $fat_event_setting['enable_woocommerce'] : 0;
if ($custom_css) {
    echo sprintf('<style type="text/css">%s</style>', $custom_css);
}

$tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl_popup_booking.php';
if (file_exists($tmpl_path)) {
    include_once $tmpl_path;
}

$hide_end_time = isset($fat_event_setting['hide_event_end_time'][0]) ? $fat_event_setting['hide_event_end_time'][0] : 0;

$id = isset($atts['id']) ? $atts['id'] : 0;
$event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
$single_image_size = get_post_meta($id, 'fat-mb-event-single-image-size', true);
$opt_date_format = get_post_meta($id, 'opt_date_format', true);

if (isset($_REQUEST['sd']) && $_REQUEST['sd']) {
    $event_start_date = DateTime::createFromFormat('U', $_REQUEST['sd']);
} else {
    $event_start_date = get_post_meta($id, 'start_date', true);
    $event_start_date = $event_start_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date) : '';
}
if (isset($_REQUEST['ed']) && $_REQUEST['ed']) {
    $event_end_date = DateTime::createFromFormat('U', $_REQUEST['ed']);
} else {
    $event_end_date = get_post_meta($id, 'end_date', true);
    $event_end_date = $event_end_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date) : '';
}
$all_day_event = isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '';
$date_format = get_option('date_format');

$multiple_location = isset($event_detail['multiple_location']) ? $event_detail['multiple_location'] : 'no';

$organizers = array();
$list_location = array();
$latitude = '';
$latitudes = array();
$map_source = isset($fat_event_setting['map_source']) ? $fat_event_setting['map_source'] : 'google';

if ($show_google_map && $multiple_location != 'yes') {
    $latitude = get_term_meta($event_detail['location'], 'fat-mb-location-detail', true);
    $latitudes[] = isset($latitude['map']) ? $latitude['map'] : '';
}
if ($multiple_location != 'yes') {
    $organizer = isset($event_detail['main_organizer']) ? get_term_by('id', $event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
    $organizer_detail = get_term_meta($event_detail['main_organizer'], 'fat-mb-organizer-detail', true);
    $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
    if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
        $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
        $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
    }

    if(isset($organizer->name)){
        $organizers[] = array(
            'name' => $organizer->name,
            'description' => $organizer->description,
            'thumb' => $organizer_thumb,
            'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
            'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
            'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
            'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
            'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
            'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone'] : ''
        );
    }
    $list_location[] = array(
        'id' => $event_detail['location'],
        'location' => FAT_Event_Utils::get_location_title($event_detail['location'], ', '),
        'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : ''
    );
}
$hourly_schedule = isset($event_detail['schedule']) ? $event_detail['schedule'] : '';
if (is_array($hourly_schedule) && is_countable($hourly_schedule['from']) && count($hourly_schedule['from']) > 0 && $hourly_schedule['from'][0]) {
    for ($i = 0; $i < count($hourly_schedule['from']); $i++) {
        if ($multiple_location == 'yes') {
            if ($show_google_map) {
                $location = isset($hourly_schedule['location'][$i]) ? FAT_Event_Utils::get_location_title($hourly_schedule['location'][$i], ', ') : '';
                $latitude = get_term_meta($hourly_schedule['location'][$i], 'fat-mb-location-detail', true);
                $latitudes[] = isset($latitude['map']) ? $latitude['map'] : '';
            }
            if (isset($hourly_schedule['organizer'][$i]) && $hourly_schedule['organizer'][$i] && $hourly_schedule['organizer'][$i] != 'hide') {
                $organizer = isset($hourly_schedule['organizer'][$i]) ? get_term_by('id', $hourly_schedule['organizer'][$i], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                $organizer_detail = get_term_meta($hourly_schedule['organizer'][$i], 'fat-mb-organizer-detail', true);
                $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                    $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                    $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                }
                $organizers[] = array(
                    'name' => $organizer->name,
                    'description' => $organizer->description,
                    'thumb' => $organizer_thumb,
                    'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
                    'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
                    'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
                    'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
                    'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
                    'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone'] : ''
                );
            }
            $list_location[] = array(
                'id' => $hourly_schedule['location'][$i],
                'location' => $location,
                'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : ''
            );
        }
        $schedule[] = array(
            'from' => isset($hourly_schedule['from'][$i]) ? $hourly_schedule['from'][$i] : '',
            'to' => isset($hourly_schedule['to'][$i]) ? $hourly_schedule['to'][$i] : '',
            'title' => isset($hourly_schedule['title'][$i]) ? $hourly_schedule['title'][$i] : '',
            'description' => isset($hourly_schedule['description'][$i]) ? $hourly_schedule['description'][$i] : '',
            'location' => isset($location) ? $location : '',
            'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : '',
            'organizer' => isset($organizer->name) ? $organizer->name : ''
        );
    }
}
$now = current_time('mysql',0);
$now = DateTime::createFromFormat('Y-m-d H:i:s', $now);

$enable_booking = isset($event_detail['enable_booking'][0]) && $event_detail['enable_booking'][0] === '1' ? 1 : 0;
$disable_booking_before = isset($event_detail['disable_booking_before']) && $event_detail['disable_booking_before'] ? $event_detail['disable_booking_before'] : 0;
$allow_booking_after_event_started = isset($event_detail['allow_booking_after_event_started']) && $event_detail['allow_booking_after_event_started'] ? $event_detail['allow_booking_after_event_started'] : 0;

$fees = isset($event_detail['fees']) && $event_detail['fees'] && is_numeric($event_detail['fees']) ? $event_detail['fees'] : 0;
$seats = isset($event_detail['seats'])  ? $event_detail['seats'] : 0;
$num_of_book = 0;
$enable_seat_available = 0;

if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime) {
    $num_of_book_key = 'num_of_book_' . $event_start_date->format('U') . '_' . $event_end_date->format('U');
    if($enable_booking){
        $enable_booking = (FAT_Event_Utils::diff_hours($now, $event_start_date) > $disable_booking_before);
        $enable_booking = $disable_booking_before ==0 && $allow_booking_after_event_started > 0 ?  (FAT_Event_Utils::diff_hours($event_start_date, $now) <= $allow_booking_after_event_started) : $enable_booking;
    }

} else {
    $num_of_book_key = 'num_of_book_';
}

$enable_seat_available = isset($event_detail['enable_seat_available'][0]) && $event_detail['enable_seat_available'][0] === '1';
if (isset($_REQUEST['sd']) && isset($_REQUEST['ed']) && $_REQUEST['ed'] && $_REQUEST['sd']) {
    $num_of_book_key = 'num_of_book_' . $_REQUEST['sd'] . '_' . $_REQUEST['ed'];
}
$num_of_book = get_post_meta($id, $num_of_book_key, true);
$num_of_book = $num_of_book && $num_of_book != NULL ? $num_of_book : 0;

$event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
$repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
$repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
$time = '';

if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime && $hide_end_time == '1') {
    $time = $event_start_date->format($time_format) . ' - <span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>';
}
if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime && $hide_end_time!= '1') {
    if ($all_day_event && date_diff($event_start_date, $event_end_date)->d == 0) {
        $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event_start_date->format('U'));
    } else {
        if($date_time_order=='time-date'){
            if (date_diff($event_start_date, $event_end_date)->d == 0) {
                $time = $event_start_date->format($time_format) . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format) . ' - <span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>';
            } else {
                $time = $event_start_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>' . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_end_date->format('U')) . '</span>';
            }
        }else{
            if (date_diff($event_start_date, $event_end_date)->d == 0) {
                $time ='<span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span> - '. $event_start_date->format($time_format) . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format);
            } else {
                $time = date_i18n($date_format, $event_start_date->format('U')) . '</span>' . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_end_date->format('U')) . '</span> '. $event_start_date->format($time_format . ' ') . '<span>' ;
            }
        }

    }
}

?>
<div class="fat-event-single fat-event-detail-page-title fat-event-container">
    <div class="fat-event-thumb">
        <?php
        if (has_post_thumbnail($id)):
            $attachment_id = get_post_thumbnail_id($id);
            if (!$disable_single_crop && function_exists('fat_event_matthewruddy_image_resize_id') && $width > 0 && $height > 0) {
                $thumb = fat_event_matthewruddy_image_resize_id($attachment_id, $width, $height);
                $thumb = is_array($thumb) && isset($thumb['url']) ? $thumb['url'] : wp_get_attachment_url($attachment_id);
            } else {
                $thumb = wp_get_attachment_url($attachment_id);
            }
            ?>
            <img src="<?php echo esc_url($thumb); ?>" width="<?php echo ($disable_single_crop ? "100%": $width); ?>" height="<?php echo ($disable_single_crop ? "auto": $width); ?>">
        <?php endif; ?>
        <div class="fat-event-popup-info">
            <div class="fat-event-popup-title">
                <?php the_title(); ?>
            </div>
            <?php if ($time): ?>
                <div class="fat-event-popup-time">
                    <i class="fa fa-clock-o"></i> <?php echo wp_kses_post($time); ?>
                </div>
            <?php endif; ?>
            <?php foreach ($list_location as $loc) { ?>
                <div class="fat-event-popup-location">
                    <i class="fa fa-map-marker"></i> <?php echo wp_kses($loc['location'], $allow_html); ?>
                    <?php if (isset($loc['latitude']) && $loc['latitude']): ?>
                        <a href="<?php echo 'https://www.google.com/maps/dir/?api=1&destination=' . $loc['latitude']; ?>"
                           target="_blank"><i
                                class="fa fa-location-arrow"></i><?php esc_html_e('Get directions', 'fat-event'); ?>
                        </a>
                    <?php endif;?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
