<?php
$fat_event_setting = get_option('fat_event_setting');
$currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
$currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
$currency_symbol = $currency_symbol ? $currency_symbol : $currency;
$time_format = isset($fat_event_setting['single_time_format']) && $fat_event_setting['single_time_format'] ? $fat_event_setting['single_time_format'] : 'H:i';
$date_time_order = isset($fat_event_setting['single_date_time_order']) && $fat_event_setting['single_date_time_order'] ? $fat_event_setting['single_date_time_order'] : 'time-date';
$custom_css = isset($fat_event_setting['single_custom_css']) && $fat_event_setting['single_custom_css'] ? $fat_event_setting['single_custom_css'] : '';
$show_google_map = !isset($fat_event_setting['show_google_map']) || (isset($fat_event_setting['show_google_map'][0]) && $fat_event_setting['show_google_map'][0] == '1');
$enable_woocommerce =  isset($fat_event_setting['enable_woocommerce']) ? $fat_event_setting['enable_woocommerce'] : 0;
if ($custom_css) {
    echo sprintf('<style type="text/css">%s</style>', $custom_css);
}

$tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl_popup_booking.php';
if (file_exists($tmpl_path)) {
    include_once $tmpl_path;
}

$hide_end_time = isset($fat_event_setting['hide_event_end_time'][0]) ? $fat_event_setting['hide_event_end_time'][0] : 0;

$id = isset($atts['id']) ? $atts['id'] : 0;
$event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
$single_image_size = get_post_meta($id, 'fat-mb-event-single-image-size', true);
$opt_date_format = get_post_meta($id, 'opt_date_format', true);

if (isset($_REQUEST['sd']) && $_REQUEST['sd']) {
    $event_start_date = DateTime::createFromFormat('U', $_REQUEST['sd']);
} else {
    $event_start_date = get_post_meta($id, 'start_date', true);
    $event_start_date = $event_start_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date) : '';
}
if (isset($_REQUEST['ed']) && $_REQUEST['ed']) {
    $event_end_date = DateTime::createFromFormat('U', $_REQUEST['ed']);
} else {
    $event_end_date = get_post_meta($id, 'end_date', true);
    $event_end_date = $event_end_date ? DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date) : '';
}
$all_day_event = isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '';
$date_format = get_option('date_format');

$multiple_location = isset($event_detail['multiple_location']) ? $event_detail['multiple_location'] : 'no';

$organizers = array();
$list_location = array();
$latitude = '';
$latitudes = array();
$map_source = isset($fat_event_setting['map_source']) ? $fat_event_setting['map_source'] : 'google';

if ($show_google_map && $multiple_location != 'yes') {
    $latitude = get_term_meta($event_detail['location'], 'fat-mb-location-detail', true);
    $latitudes[] = isset($latitude['map']) ? $latitude['map'] : '';
}
if ($multiple_location != 'yes') {
    $organizer = isset($event_detail['main_organizer']) ? get_term_by('id', $event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
    $organizer_detail = get_term_meta($event_detail['main_organizer'], 'fat-mb-organizer-detail', true);
    $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
    if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
        $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
        $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
    }

    if(isset($organizer->name)){
        $organizers[] = array(
            'name' => $organizer->name,
            'description' => $organizer->description,
            'thumb' => $organizer_thumb,
            'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
            'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
            'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
            'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
            'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
            'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone'] : ''
        );
    }
    $list_location[] = array(
        'id' => $event_detail['location'],
        'location' => FAT_Event_Utils::get_location_title($event_detail['location'], ', '),
        'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : ''
    );
}
$hourly_schedule = isset($event_detail['schedule']) ? $event_detail['schedule'] : '';
if (is_array($hourly_schedule) && is_countable($hourly_schedule['from']) && count($hourly_schedule['from']) > 0 && $hourly_schedule['from'][0]) {
    for ($i = 0; $i < count($hourly_schedule['from']); $i++) {
        if ($multiple_location == 'yes') {
            if ($show_google_map) {
                $location = isset($hourly_schedule['location'][$i]) ? FAT_Event_Utils::get_location_title($hourly_schedule['location'][$i], ', ') : '';
                $latitude = get_term_meta($hourly_schedule['location'][$i], 'fat-mb-location-detail', true);
                $latitudes[] = isset($latitude['map']) ? $latitude['map'] : '';
            }
            if (isset($hourly_schedule['organizer'][$i]) && $hourly_schedule['organizer'][$i] && $hourly_schedule['organizer'][$i] != 'hide') {
                $organizer = isset($hourly_schedule['organizer'][$i]) ? get_term_by('id', $hourly_schedule['organizer'][$i], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                $organizer_detail = get_term_meta($hourly_schedule['organizer'][$i], 'fat-mb-organizer-detail', true);
                $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                    $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                    $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                }
                $organizers[] = array(
                    'name' => $organizer->name,
                    'description' => $organizer->description,
                    'thumb' => $organizer_thumb,
                    'email' => isset($organizer_detail['email']) ? $organizer_detail['email'] : '',
                    'website' => isset($organizer_detail['website']) ? $organizer_detail['website'] : '',
                    'facebook' => isset($organizer_detail['facebook']) ? $organizer_detail['facebook'] : '',
                    'twitter' => isset($organizer_detail['twitter']) ? $organizer_detail['twitter'] : '',
                    'linkedin' => isset($organizer_detail['linkedin']) ? $organizer_detail['linkedin'] : '',
                    'telephone' => isset($organizer_detail['telephone']) ? $organizer_detail['telephone'] : ''
                );
            }
            $list_location[] = array(
                'id' => $hourly_schedule['location'][$i],
                'location' => $location,
                'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : ''
            );
        }
        $schedule[] = array(
            'from' => isset($hourly_schedule['from'][$i]) ? $hourly_schedule['from'][$i] : '',
            'to' => isset($hourly_schedule['to'][$i]) ? $hourly_schedule['to'][$i] : '',
            'title' => isset($hourly_schedule['title'][$i]) ? $hourly_schedule['title'][$i] : '',
            'description' => isset($hourly_schedule['description'][$i]) ? $hourly_schedule['description'][$i] : '',
            'location' => isset($location) ? $location : '',
            'latitude' => isset($latitude['map']) && $map_source == 'google' ? $latitude['map'] : '',
            'organizer' => isset($organizer->name) ? $organizer->name : ''
        );
    }
}
$now = current_time('mysql',0);
$now = DateTime::createFromFormat('Y-m-d H:i:s', $now);

$enable_booking = isset($event_detail['enable_booking'][0]) && $event_detail['enable_booking'][0] === '1' ? 1 : 0;
$disable_booking_before = isset($event_detail['disable_booking_before']) && $event_detail['disable_booking_before'] ? $event_detail['disable_booking_before'] : 0;
$allow_booking_after_event_started = isset($event_detail['allow_booking_after_event_started']) && $event_detail['allow_booking_after_event_started'] ? $event_detail['allow_booking_after_event_started'] : 0;

$fees = isset($event_detail['fees']) && $event_detail['fees'] && is_numeric($event_detail['fees']) ? $event_detail['fees'] : 0;
$seats = isset($event_detail['seats'])  ? $event_detail['seats'] : 0;
$num_of_book = 0;
$enable_seat_available = 0;

if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime) {
    $num_of_book_key = 'num_of_book_' . $event_start_date->format('U') . '_' . $event_end_date->format('U');
    if($enable_booking){
        $enable_booking = (FAT_Event_Utils::diff_hours($now, $event_start_date) > $disable_booking_before);
        $enable_booking = $disable_booking_before ==0 && $allow_booking_after_event_started > 0 ?  (FAT_Event_Utils::diff_hours($event_start_date, $now) <= $allow_booking_after_event_started) : $enable_booking;
    }

} else {
    $num_of_book_key = 'num_of_book_';
}

$enable_seat_available = isset($event_detail['enable_seat_available'][0]) && $event_detail['enable_seat_available'][0] === '1';
if (isset($_REQUEST['sd']) && isset($_REQUEST['ed']) && $_REQUEST['ed'] && $_REQUEST['sd']) {
    $num_of_book_key = 'num_of_book_' . $_REQUEST['sd'] . '_' . $_REQUEST['ed'];
}
$num_of_book = get_post_meta($id, $num_of_book_key, true);
$num_of_book = $num_of_book && $num_of_book != NULL ? $num_of_book : 0;

$event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
$repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
$repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
$time = '';

if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime && $hide_end_time == '1') {
    $time = $event_start_date->format($time_format) . ' - <span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>';
}
if ($event_start_date instanceof DateTime && $event_end_date instanceof DateTime && $hide_end_time!= '1') {
    if ($all_day_event && date_diff($event_start_date, $event_end_date)->d == 0) {
        $time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event_start_date->format('U'));
    } else {
        if($date_time_order=='time-date'){
            if (date_diff($event_start_date, $event_end_date)->d == 0) {
                $time = $event_start_date->format($time_format) . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format) . ' - <span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>';
            } else {
                $time = $event_start_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span>' . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_end_date->format('U')) . '</span>';
            }
        }else{
            if (date_diff($event_start_date, $event_end_date)->d == 0) {
                $time ='<span>' . date_i18n($date_format, $event_start_date->format('U')) . '</span> - '. $event_start_date->format($time_format) . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format);
            } else {
                $time = date_i18n($date_format, $event_start_date->format('U')) . '</span>' . esc_html__(' to ', 'fat-event') . $event_end_date->format($time_format . ' ') . '<span>' . date_i18n($date_format, $event_end_date->format('U')) . '</span> '. $event_start_date->format($time_format . ' ') . '<span>' ;
            }
        }

    }
}

$fees_package = $ticket_class = array();
if (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'package') {
    if (isset($event_detail['fees_package']) && is_array($event_detail['fees_package'])) {
        for ($i = 0; $i < count($event_detail['fees_package']['quantity']); $i++) {
            $fees_package[] = array(
                'quantity' => $event_detail['fees_package']['quantity'][$i],
                'fees' => $event_detail['fees_package']['fees'][$i]
            );
        }
    }
}
if (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'ticket_class') {
    if (isset($event_detail['ticket_class']) && is_array($event_detail['ticket_class'])) {
        $nob_key = $nob = '';
        for ($i = 0; $i < count($event_detail['ticket_class']['seats']); $i++) {
            $nob_key = $num_of_book_key . '_' . $event_detail['ticket_class']['class_id'][$i];
            $nob_key = get_post_meta($id, $nob_key, true);
            $nob = $nob_key && is_numeric($nob_key) ? $nob_key : 0;
            $ticket_class[] = array(
                'class_id' => $event_detail['ticket_class']['class_id'][$i],
                'class' => $event_detail['ticket_class']['class'][$i],
                'seat' => $event_detail['ticket_class']['seats'][$i],
                'fees' => $event_detail['ticket_class']['fees'][$i],
                'number_of_book' => $nob,
                'seat_available' => is_numeric($event_detail['ticket_class']['seats'][$i]) &&  ($event_detail['ticket_class']['seats'][$i] - $nob) > 0 ? $event_detail['ticket_class']['seats'][$i] - $nob : 0,
                'seat_label' => esc_html__('Seat available', 'fat-event')
            );
        }
    }
}
//Amenities
$amenities = get_post_meta($id, 'fat-mb-event-single-amenities', true);
$list_amenities = array();
$amenities_setting = isset($fat_event_setting['amenities']) ? $fat_event_setting['amenities']: array();
$amenities_heading = isset($fat_event_setting['amenities_heading']) ? $fat_event_setting['amenities_heading'] : '';
$amenities_key = '';
if (is_array($amenities)) {
    foreach ($amenities as $key => $value) {
        if ($value) {
            for ($i = 0; $i < count($amenities_setting['amenities_name']); $i++) {
                $amenities_key = strtolower($amenities_setting['amenities_name'][$i]);
                $amenities_key = str_replace(' ', '_', $amenities_key);
                $amenities_key = str_replace(',','',$amenities_key);
                $amenities_key = str_replace(';','',$amenities_key);
                $amenities_key = str_replace('.','',$amenities_key);
                $amenities_key = str_replace('#','',$amenities_key);
                if ($amenities_key == $key) {
                    $list_amenities[$key] = array(
                        'name' => $value[0],
                        'icon' => $amenities_setting['amenities_icon'][$i]
                    );
                }
            }
        }
    }
}

$export_gg_link = 'http://www.google.com/calendar/render?action=TEMPLATE';
$export_gg_link .= '&text=' . get_the_title();
if($event_start_date instanceof DateTime && $event_end_date  instanceof DateTime){
    $export_gg_link .= '&dates=' . $event_start_date->format('Ymd').'T'.$event_start_date->format('His') . '/' . $event_end_date->format('Ymd').'T'.$event_end_date->format('His');
}
$export_detail = '';
if(isset($organizers) && is_countable($organizers)){
    foreach ($organizers as $org){
        $export_detail.= esc_html__('Organizer: ','fat-event').$org['name'].' '. esc_html__('Telephone: ','fat-event').$org['telephone'].' '. esc_html__('Email: ','fat-event').$org['email'].'</br>';
    }
    $export_gg_link .= '&details='. esc_html($export_detail);
}
if(is_countable($list_location) && count($list_location)>0 && isset($list_location[0]['location'])){
    $export_gg_link .= '&location=' . $list_location[0]['location'];
}
$export_gg_link .= '&trp=false&sprop=&sprop=name:';

?>
<div class="fat-event-single fat-event-container event-detail-page-sidebar">
    <div class="fat-event-meta-wrap">
        <?php
        if (isset($organizers) && is_array($organizers) && count($organizers) > 0): ?>
            <h4 class="fat-event-meta-title organizer-meta"><?php esc_html_e('Organizer', 'fat-event'); ?></h4>
            <?php foreach ($organizers as $org) { ?>
                <div class="fat-event-organizer">
                    <?php if ($org['thumb']): ?>
                        <span class="organizer-thumb">
                                             <img src="<?php echo esc_url($org['thumb']); ?>" width="100" height="100">
                                        </span>
                    <?php endif; ?>
                    <ul class="organizer-info">
                        <li><?php echo esc_html($org['name']); ?></li>
                        <?php if($org['description']) : ?>
                            <li><?php echo esc_html($org['description']);?></li>
                        <?php endif; ?>
                        <?php if ($org['telephone']): ?>
                            <li>
                                <i class="fa fa-phone"></i><a
                                    href="tel:<?php echo esc_attr($org['telephone']); ?>"> <?php echo esc_html($org['telephone']); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if ($org['email']): ?>
                            <li>
                                <i class="fa fa-envelope"></i><a
                                    href="mailto:<?php echo esc_attr($org['email']); ?>"> <?php echo esc_html($org['email']); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if ($org['website']): ?>
                            <li>
                                <i class="fa fa-desktop"></i><a
                                    href="<?php echo esc_url($org['website']); ?>"> <?php echo esc_html($org['website']); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if ($org['facebook'] || $org['twitter'] || $org['linkedin']) : ?>
                            <li class="organizer-social">
                                <?php if ($org['facebook']): ?>
                                    <span><a href="<?php echo esc_url($org['facebook']); ?>"
                                             target="_blank"> <i
                                                class="fa fa-facebook"></i></a></span>
                                <?php endif; ?>
                                <?php if ($org['twitter']): ?>
                                    <span><a href="<?php echo esc_url($org['twitter']); ?>"
                                             target="_blank"> <i
                                                class="fa fa-twitter"></i></a></span>
                                <?php endif; ?>
                                <?php if ($org['linkedin']): ?>
                                    <span><a href="<?php echo esc_url($org['linkedin']); ?>"
                                             target="_blank"> <i
                                                class="fa fa-linkedin"></i></a></span>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    </ul>

                </div>
            <?php } ?>
        <?php endif; ?>

        <?php
        $other_organizer = isset($event_detail['other_organizer']) ? $event_detail['other_organizer'] : '';
        $organizer = $organizer_detail = $organizer_thumb = '';
        if (is_array($other_organizer)): ?>
            <h4 class="fat-event-meta-title other-organizer-meta"><?php esc_html_e('Other Organizer(s)', 'fat-event'); ?></h4>
            <?php foreach ($other_organizer as $or) {
                $organizer = get_term_by('id', $or, FAT_EVENT_ORGANIZER_TAXONOMY);
                $organizer_detail = get_term_meta($or, 'fat-mb-organizer-detail', true);
                $organizer_thumb = isset($organizer_detail['thumbnail']) ? $organizer_detail['thumbnail'] : '';
                if ($organizer_thumb > 0 && function_exists('fat_event_matthewruddy_image_resize_id')) {
                    $organizer_thumb = fat_event_matthewruddy_image_resize_id($organizer_thumb, 80, 80);
                    $organizer_thumb = is_array($organizer_thumb) && isset($organizer_thumb['url']) ? $organizer_thumb['url'] : wp_get_attachment_url($organizer_thumb);
                }
                ?>
                <div class="fat-event-organizer fat-event-other-organizer fat-mg-bottom-15">
                    <?php if ($organizer_thumb): ?>
                        <span class="organizer-thumb">
                                     <?php if (isset($organizer_detail['website']) && $organizer_detail['website']): ?>
                                         <a href="<?php echo esc_url($organizer_detail['website']); ?>"><img
                                                 src="<?php echo esc_url($organizer_thumb); ?>"
                                                 width="100" height="100"></a>
                                     <?php else: ?>
                                         <img src="<?php echo esc_url($organizer_thumb); ?>"
                                              width="100" height="100">
                                     <?php endif; ?>
                                </span>
                    <?php endif; ?>
                    <ul class="organizer-info">
                        <li><?php echo isset($organizer->name) ? $organizer->name : ''; ?></li>
                        <?php if (isset($organizer_detail['telephone']) && $organizer_detail['telephone']): ?>
                            <li>
                                <i class="fa fa-phone"></i> <?php echo esc_html($organizer_detail['telephone']); ?>
                            </li>
                        <?php endif; ?>
                        <?php if (isset($organizer_detail['email']) && $organizer_detail['email']): ?>
                            <li>
                                <i class="fa fa-envelope"></i><a
                                    href="mailto:<?php echo esc_attr($organizer_detail['email']); ?>"> <?php echo esc_html($organizer_detail['email']); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (isset($organizer_detail['website']) && $organizer_detail['website']): ?>
                            <li>
                                <i class="fa fa-desktop"></i><a
                                    href="<?php echo esc_url($organizer_detail['website']); ?>"> <?php echo esc_html($organizer_detail['website']); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if ((isset($organizer_detail['facebook']) && $organizer_detail['facebook'])
                            || (isset($organizer_detail['twitter']) && $organizer_detail['twitter'])
                            || (isset($organizer_detail['linkedin']) && $organizer_detail['linkedin'])
                        ) : ?>
                            <li class="organizer-social">
                                <?php if ($organizer_detail['facebook']): ?>
                                    <span><a href="<?php echo esc_url($organizer_detail['facebook']); ?>"
                                             target="_blank"> <i class="fa fa-facebook"></i></a></span>
                                <?php endif; ?>
                                <?php if ($organizer_detail['twitter']): ?>
                                    <span><a href="<?php echo esc_url($organizer_detail['twitter']); ?>"
                                             target="_blank"> <i class="fa fa-twitter"></i></a></span>
                                <?php endif; ?>
                                <?php if ($organizer_detail['linkedin']): ?>
                                    <span><a href="<?php echo esc_url($organizer_detail['linkedin']); ?>"
                                             target="_blank"> <i class="fa fa-linkedin"></i></a></span>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    </ul>

                </div>
            <?php } ?>
        <?php endif ?>

        <?php
        if (isset($schedule)): ?>
            <h4 class="fat-event-meta-title schedule-meta"><?php esc_html_e('Schedule', 'fat-event'); ?></h4>
            <ul class="fat-event-hourly-schedule">
                <?php foreach ($schedule as $sc) { ?>
                    <li>
                        <i class="fa fa-clock-o"></i> <?php echo sprintf('<span class="schedule-hour">%s - %s</span> : %s', $sc['from'], $sc['to'], $sc['title']); ?>
                        <?php if (isset($sc['description']) && $sc['description']): ?>
                            <p class="fat-event-schedule-desc"><?php echo esc_html($sc['description']); ?></p>
                        <?php endif; ?>

                        <?php if (isset($sc['location']) && $sc['location']): ?>
                            <p class="fat-event-schedule-location"><i
                                    class="fa fa-map-marker"></i>
                                <?php if (isset($sc['latitude']) && $sc['latitude']): ?>
                                    <a href="<?php echo 'https://www.google.com/maps/dir/?api=1&destination=' . $sc['latitude']; ?>"
                                       target="_blank"><?php echo esc_html($sc['location']); ?>
                                    </a>
                                <?php else: ?>
                                    <?php echo esc_html($sc['location']); ?>
                                <?php endif;?>

                            </p>
                        <?php endif; ?>
                    </li>
                <?php } ?>
            </ul>
        <?php endif; ?>

        <?php
        $amenities_sidebar_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/amenities-sidebar.php';
        $amenities_sidebar_theme_path = get_stylesheet_directory() . '/templates/fat-event/single/part/amenities-sidebar.php';
        if (is_readable($amenities_sidebar_theme_path)) {
            $amenities_sidebar_path = $amenities_sidebar_theme_path;
        }
        if(is_readable($amenities_sidebar_path) && isset($fat_event_setting['amenities_position']) && $fat_event_setting['amenities_position']=='sidebar'){
            include_once $amenities_sidebar_path;
        }
        ?>

        <?php
        //&& $event_start_date > $now
        if ($enable_booking == 1 ): ?>
            <h4 class="fat-event-meta-title ticket-detail-meta"><?php echo esc_html($ticket_detail_label); ?></h4>
            <ul class="fat-event-popup-fees">
                <li>
                    <?php if (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'package' && is_array($fees_package)): ?>
                        <?php esc_html_e('Fees package:', 'fat-event'); ?>
                        <ul class="fat-event-fees-package">
                            <?php foreach ($fees_package as $package) { ?>
                                <li>
                                    <?php echo esc_html($package['quantity']) . esc_html__(' Ticket', 'fat-event'); ?>
                                    -
                                    <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                    <?php echo esc_html($package['fees']); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php elseif (isset($event_detail['fees_type']) && $event_detail['fees_type'] == 'ticket_class' && is_array($ticket_class)): ?>
                        <?php esc_html_e('Ticket classification:', 'fat-event'); ?>
                        <ul class="fat-event-fees-package">
                            <?php foreach ($ticket_class as $class) { ?>
                                <li>
                                    <?php echo esc_html($class['class']); ?>
                                    -
                                    <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?>
                                    <?php echo esc_html($class['fees']); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                    &nbsp;
                                    <?php if ($class['seat'] != '' && $class['seat'] != '0'): ?>
                                        <?php echo esc_html($seats_label)  ?>
                                        <?php echo esc_html($class['seat']); ?>
                                        <?php if (isset($class['seat_available']) && $class['seat_available'] !== ''): ?>
                                            <div data-ticket-id="<?php echo esc_attr($class['class_id']); ?>"
                                                 data-seats="<?php echo esc_attr($class['seat_available']); ?>"
                                                 class="fat-event-seats-available"><?php echo esc_html__('Available: ', 'fat-event'); ?>
                                                <span><?php echo esc_html($class['seat_available']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                </li>
                            <?php } ?>
                        </ul>
                    <?php else: ?>
                        <span class="price">
                                    <?php echo esc_html($fees_label); ?>
                                    <strong>
                                        <?php echo(isset($fat_event_setting['symbol_position']) && $fat_event_setting['symbol_position'] === 'prefix' ? $currency_symbol : ''); ?><?php echo number_format($fees, $decimal, '.', $separator); ?><?php echo(!isset($fat_event_setting['symbol_position']) || $fat_event_setting['symbol_position'] === 'suffix' ? $currency_symbol : ''); ?>
                                    </strong> &nbsp;
                                        </span>
                    <?php endif; ?>

                    <!-- seat for fix price and fees package -->
                    <?php if (isset($event_detail['fees_type']) && $event_detail['fees_type'] != 'ticket_class' && $seats != '' && $seats != '0'): ?>
                        <span class="seat">
                                    <?php echo esc_html($seats_label) ?>
                                    <strong><?php echo $seats; ?></strong>
                                        </span>
                        <?php if ($enable_seat_available && isset($num_of_book) && $num_of_book !== ''): ?>
                            <div data-seats="<?php echo esc_attr($seats); ?>"
                                 class="fat-event-seats-available"><?php echo esc_html($seats_available_label) . '<strong> ' . ($seats > $num_of_book ? ($seats - $num_of_book) : 0) . '</strong>'; ?></div>
                        <?php endif; ?>
                    <?php endif; ?>

                </li>
                <li>
                    <?php
                    $json_location = json_encode($list_location);
                    $list_amenities = is_array($list_amenities) ? json_encode(array_values($list_amenities)) : '';
                    if($seats > $num_of_book || $seats==0 || $event_detail['fees_type'] == 'ticket_class' || $event_detail['fees_type'] == 'package' ){
                        ?>
                        <a class="fat-event-register"
                           data-payment="<?php echo esc_attr($event_detail['payment']); ?>"
                           data-start="<?php echo esc_attr($event_start_date->format('U')); ?>"
                           data-end="<?php echo esc_attr($event_end_date->format('U')); ?>"
                           data-fees-type="<?php echo isset($event_detail['fees_type']) ? $event_detail['fees_type'] : 'fixed'; ?>"
                           data-fees-package='<?php echo json_encode($fees_package); ?>'
                           data-ticket-class='<?php echo json_encode($ticket_class); ?>'
                           data-fees="<?php echo esc_attr($fees); ?>" data-id="<?php echo get_the_ID(); ?>"
                           href="<?php echo $event_detail['payment'] == 'external_link' ? $event_detail['external_link_booking'] : 'javascript:;'; ?>"
                           data-amenities="<?php echo esc_attr($list_amenities); ?>"
                           data-location="<?php echo esc_attr($json_location); ?>"
                        >
                            <?php echo esc_html($book_now_label); ?> <i class="fa fa-long-arrow-right"></i>
                        </a>
                    <?php }
                    if($seats <= $num_of_book && $seats != 0 && $event_detail['fees_type'] == 'fixed' && !$enable_woocommerce){?>
                        <div><?php echo esc_html__('Fully booked','fat-event');?></div>
                    <?php } ?>

                    <?php if ($enable_woocommerce) {
                        include_once(untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/part/price-variable.php');
                    }?>

                    <?php $second_link = $event_detail['payment'] == 'external_link' ? $event_detail['second_external_link_booking'] : '';
                    if($second_link): ?>
                        <div>
                            <a class="fat-event-register" href="<?php echo esc_url($second_link);?>" data-payment="<?php echo esc_attr($event_detail['payment']); ?>">
                                <?php echo esc_html__('or Book Here', 'fat-event');?>
                                <i class="fa fa-long-arrow-right"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </li>
            </ul>
        <?php endif; ?>

        <h4 class="fat-event-meta-title export-meta"><?php esc_html_e('Export', 'fat-event'); ?></h4>
        <div class="fat-event-export">
            <a target="_blank"
               href="<?php echo home_url('/') . '?action=fat_event_export_ical&id=' . get_the_ID() . '&s_date=' . $event_start_date->format('U') . '&e_date=' . $event_end_date->format('U'); ?>"
               class="fat-event-export-ical"><i
                    class="fa fa-calendar"></i><?php echo esc_html__('Ical', 'fat-event'); ?></a>
            <a target="_blank" href="<?php echo esc_url($export_gg_link);?>" class="fat-event-export-google-calendar">
                <i class="fa fa-calendar-plus-o"></i>
                <?php echo esc_html__('Google Calendar','fat-event'); ?></a>
        </div>

        <?php
        if (is_array($latitudes) && count($latitudes) > 0 && $latitudes[0]): ?>
            <h4 class="fat-event-meta-title location-meta"><?php esc_html_e('Location', 'fat-event'); ?></h4>
            <div class="fat-event-location" data-latitude="<?php echo implode(';', $latitudes); ?>"
                 data-access-token="<?php echo esc_attr($fat_event_setting['mapbox_access_token']);?>"
                 data-lazy-load="<?php echo isset($fat_event_setting['disable_google_API'][0])  ? $fat_event_setting['disable_google_API'][0]: 0 ;?>" >
                <?php if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'): ?>
                    <div class="fat-mapbox" id="fat_single_mapbox"></div>
                <?php else: ?>
                    <div class="fat-google-map"></div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php
        if (isset($fat_event_setting['enable_social'][0]) && $fat_event_setting['enable_social'][0] === '1'): ?>
            <h4 class="fat-event-meta-title share-meta"><?php esc_html_e('Share our event', 'fat-event'); ?></h4>
            <div class="fat-event-share"
                 data-link="<?php echo $event_detail['link_detail'] ? $event_detail['link_detail'] : get_permalink(); ?>"
                 data-title="<?php $title = get_the_title();
                 echo html_entity_decode($title); ?>"
                 data-thumb="<?php echo isset($thumb) ? $thumb : ''; ?>">
                <?php if (isset($fat_event_setting['enable_facebook'][0]) && $fat_event_setting['enable_facebook'][0] === '1'): ?>
                    <a data-social="facebook" class="fat-event-share-facebook transition-30"
                       href="javascript:"><i
                            class="fa fa-facebook"></i></a>
                <?php endif; ?>
                <?php if (isset($fat_event_setting['enable_twitter'][0]) && $fat_event_setting['enable_twitter'][0] === '1'): ?>
                    <a data-social="twitter" class="fat-event-share-twitter transition-30"
                       href="javascript:"><i
                            class="fa fa-twitter"></i></a>
                <?php endif; ?>
                <?php if (isset($fat_event_setting['enable_google_plus'][0]) && $fat_event_setting['enable_google_plus'][0] === '1'): ?>
                    <a data-social="google" class="fat-event-share-google-plus transition-30"
                       href="javascript:"><i
                            class="fa fa-google-plus"></i></a>
                <?php endif; ?>
                <?php if (isset($fat_event_setting['enable_email'][0]) && $fat_event_setting['enable_email'][0] === '1'):
                    $location = '';
                    foreach ($list_location as $loc){
                        $location.= $location=='' ? $loc['location'] : ('. '. $loc['location']);
                    }
                    ?>
                    <a class="fat-event-share-mail transition-30"
                       href="mailto:?subject=<?php echo get_the_title(); ?>&body=Time: <?php echo esc_attr($time); ?> %0ALocation: <?php echo esc_attr($location); ?> %0AOrganizer: <?php echo(isset($organizer->name) ? esc_attr($organizer->name) : ''); ?> %0A<?php get_the_excerpt(); ?>%0A<?php echo $event_detail['link_detail'] ? $event_detail['link_detail'] : get_permalink(); ?>"><i
                            class="fa fa-envelope-o"></i></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
