<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 8/31/2018
 * Time: 9:18 AM
 */
$event_dates = array();
$post_id = $atts['id'];
$event_detail = get_post_meta($post_id, 'fat-mb-event-detail', true);
$opt_date_format = get_post_meta($post_id, 'opt_date_format', true);

$now = new DateTime();
$event_start_date = get_post_meta($post_id, 'start_date', true);
$event_start_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date);
$event_end_date = get_post_meta($post_id, 'end_date', true);
$event_end_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date);
$event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
$repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
$repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
$is_show_up = false;

if(isset($atts['repeat_number']) && $atts['repeat_number']>=0){
    $repeat_number = $atts['repeat_number'];
}else{
    $repeat_number = isset($event_detail['repeat_event_display']) && $event_detail['repeat_event_display'] ? $event_detail['repeat_event_display'] : 0;
}

if (($event_end_date instanceof DateTime) && ($event_start_date instanceof DateTime)) {

    //convert link to detail
    if(isset($event_detail['link_detail_type'])){
        if($event_detail['link_detail_type']==='post' && $event_detail['link_detail_post']){
            $event_detail['link_detail'] = get_permalink($event_detail['link_detail_post']);
        }
        if($event_detail['link_detail_type']==='page' && $event_detail['link_detail_page']){
            $event_detail['link_detail'] = get_permalink($event_detail['link_detail_page']);
        }
    }

    if ($now <= $event_start_date  || ($now >= $event_start_date && $now <= $event_end_date)) {
        $is_show_up = true;
    }

    $is_show_up = apply_filters('fat_event_show_up', $is_show_up, $event_detail, $event_start_date, $event_end_date, $now);

    if ($is_show_up) {
        $event_dates[] = array(
            'start_date' => (clone $event_start_date),
            'end_date' => (clone $event_end_date),
            'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
        );
    }

    if ($repeat === 'custom') {
        $custom_days = $event_detail['custom_days'];
        $hours_start = $event_start_date->format('H');
        $minutes_start = $event_start_date->format('i');

        if (count($custom_days) > 0) {
            for ($i = 0; $i < count($custom_days['repeat_on_date']); $i++) {
                $repeat_on_date = $custom_days['repeat_on_date'][$i];
                if ($repeat_on_date) {
                    $repeat_on_date = DateTime::createFromFormat($opt_date_format, $repeat_on_date);
                    if (!($repeat_on_date instanceof DateTime)) {
                        break;
                    }
                    $repeat_on_date->setTime(0, 0, 0);

                    if ($repeat_on_date >= $now) {
                        $date_diff = $event_start_date->diff($event_end_date);
                        $event_start_date = $repeat_on_date->setTime($hours_start, $minutes_start, 0);

                        $event_end_date = (clone $event_start_date)->modify('+' . $date_diff->y . ' year');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->m . ' month');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->d . ' day');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->h . ' hours');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->i . ' minutes');

                        if ($event_detail['link_detail']) {
                            $link_detail = $event_detail['link_detail'];
                        } else {
                            $link_detail = get_permalink($post_id);
                            $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                        }
                        $event_dates[] = array(
                            'start_date' => $event_start_date,
                            'end_date' => $event_end_date,
                            'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                        );
                    }
                }
            }
        }
    }

    if ($repeat === 'daily') {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff += $event_start_date->diff($now)->h > 0 ? 1 : 0;
        $date_diff = ceil($date_diff / $repeat_interval);
        $event_start_date = $event_start_date->modify('+' . ($repeat_interval * $date_diff) . ' day');
        $event_end_date = $event_end_date->modify('+' . ($repeat_interval * $date_diff) . ' day');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+' . $repeat_interval . ' day');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+' . $repeat_interval . ' day');
            if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
                if ($event_detail['link_detail']) {
                    $link_detail = $event_detail['link_detail'];
                } else {
                    $link_detail = get_permalink($post_id);
                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                }
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                );
            }
        }
    }
    if ($repeat === 'weekly') {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff = floor($date_diff / 7) + ($date_diff % 7 > 0 ? 1 : 0);
        $event_start_date = $event_start_date->modify('+' . (7 * $date_diff) . ' day');
        $event_end_date = $event_end_date->modify('+' . (7 * $date_diff) . ' day');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+7 day');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+7 day');
            if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
                if ($event_detail['link_detail']) {
                    $link_detail = $event_detail['link_detail'];
                } else {
                    $link_detail = get_permalink($post_id);
                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                }
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                );
            }
        }
    }
    if ($repeat === 'monthly') {
        $date_diff = date_diff($event_start_date, $now)->m;
        $date_diff += date_diff($event_start_date, $now)->d > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+' . $date_diff . ' month');
        $event_end_date = $event_end_date->modify('+' . $date_diff . ' month');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+1 month');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+1 month');
            if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
                if ($event_detail['link_detail']) {
                    $link_detail = $event_detail['link_detail'];
                } else {
                    $link_detail = get_permalink($post_id);
                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                }
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                );
            }
        }
    }
    if ($repeat === 'yearly') {
        $date_diff = date_diff($event_start_date, $now)->y;
        $date_diff += date_diff($event_start_date, $now)->y == 0 && date_diff($event_start_date, $now)->d > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+' . $date_diff . ' year');
        $event_end_date = $event_end_date->modify('+' . $date_diff . ' year');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+1 year');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+1 year');
            if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
                if ($event_detail['link_detail']) {
                    $link_detail = $event_detail['link_detail'];
                } else {
                    $link_detail = get_permalink($post_id);
                    $link_detail = add_query_arg(array('sd' => $event_start_date->format('U'), 'ed' => $event_end_date->format('U')), $link_detail);
                }
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                    'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
                );
            }
        }
    }
}
$date_format = get_option('date_format');
$time_format = get_option('time_format');
?>
<div class="fat-event-container">
    <div class="fat-event-sc event-dates">
        <ul class="fat-event-dates">
            <?php foreach ($event_dates as $event) { ?>
                <li>
                    <a href="<?php echo esc_url($link_detail);?>">
                        <?php
                        if($event['all_day_event'] === '1'){
                            echo esc_html__('All day - ','fat-event'). date_i18n($date_format,$event['start_date']->format('U'));
                        }else{
                            echo $event['start_date']->format($time_format).' - '. date_i18n($date_format, $event['start_date']->format('U'));
                        }
                        ?>
                    </a>
                </li>
            <?php } ?>
        </ul>
    </div>
</div>