<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 8/31/2018
 * Time: 9:18 AM
 */
$event_dates = array();
$sc_date = isset($atts['date']) && $atts['date'] ? DateTime::createFromFormat('m/d/Y', $atts['date']) : '';
$post_id = $atts['id'];
$event_detail = get_post_meta($post_id, 'fat-mb-event-detail', true);
$opt_date_format = get_post_meta($post_id, 'opt_date_format', true);

$now = new DateTime();
$event_start_date = get_post_meta($post_id, 'start_date', true);
$event_start_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date);
$event_end_date = get_post_meta($post_id, 'end_date', true);
$event_end_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date);
$event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
$repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
$repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
$is_show_up = false;
$repeat_number = 100;

if (($event_end_date instanceof DateTime) && ($event_start_date instanceof DateTime)) {

    if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
        $is_show_up = true;
    }

    $is_show_up = apply_filters('fat_event_show_up', $is_show_up, $event_detail, $event_start_date, $event_end_date, $now);
    if ($is_show_up && ($sc_date instanceof DateTime)) {
        $is_show_up = $event_start_date->diff($sc_date)->days == 0;
    }

    if ($is_show_up) {
        $event_dates[] = array(
            'start_date' => $event_start_date,
            'end_date' => $event_end_date,
            'payment' => $event_detail['payment']
        );
    }

    if ($repeat === 'custom' && count($event_dates) == 0) {
        $custom_days = $event_detail['custom_days'];
        $hours_start = $event_start_date->format('H');
        $minutes_start = $event_start_date->format('i');

        if (count($custom_days) > 0) {
            for ($i = 0; $i < count($custom_days['repeat_on_date']); $i++) {
                $repeat_on_date = $custom_days['repeat_on_date'][$i];
                if ($repeat_on_date) {
                    $repeat_on_date = DateTime::createFromFormat($opt_date_format, $repeat_on_date);
                    if (!($repeat_on_date instanceof DateTime)) {
                        break;
                    }
                    $repeat_on_date->setTime(0, 0, 0);

                    if ($repeat_on_date >= $now) {
                        $date_diff = $event_start_date->diff($event_end_date);
                        $event_start_date = $repeat_on_date->setTime($hours_start, $minutes_start, 0);

                        $event_end_date = (clone $event_start_date)->modify('+' . $date_diff->y . ' year');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->m . ' month');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->d . ' day');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->h . ' hours');
                        $event_end_date = $event_end_date->modify('+' . $date_diff->i . ' minutes');

                        if ($sc_date === '' || ($event_start_date->diff($sc_date)->days == 0)) {

                            $event_dates[] = array(
                                'start_date' => $event_start_date,
                                'end_date' => $event_end_date,
                            );
                            break;
                        }
                    }
                }
            }
        }
    }

    if ($repeat === 'daily' && count($event_dates) == 0) {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff += $event_start_date->diff($now)->h > 0 ? 1 : 0;
        $date_diff = ceil($date_diff / $repeat_interval);
        $event_start_date = $event_start_date->modify('+' . ($repeat_interval * $date_diff) . ' day');
        $event_end_date = $event_end_date->modify('+' . ($repeat_interval * $date_diff) . ' day');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+' . $repeat_interval . ' day');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+' . $repeat_interval . ' day');
            if (($sc_date === '' && ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date))) ||
                ($sc_date instanceof DateTime && ($event_start_date->diff($sc_date)->days == 0))) {
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                );
                var_dump($event_start_date);
                echo('</br>');
                var_dump($event_end_date);
                break;
            }
        }
    }
    if ($repeat === 'weekly' && count($event_dates) == 0) {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff = floor($date_diff / 7) + ($date_diff % 7 > 0 ? 1 : 0);
        $event_start_date = $event_start_date->modify('+' . (7 * $date_diff) . ' day');
        $event_end_date = $event_end_date->modify('+' . (7 * $date_diff) . ' day');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+7 day');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+7 day');
            if (($sc_date === '' && ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date))) ||
                ($sc_date instanceof DateTime && ($event_start_date->diff($sc_date)->days == 0))) {
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                );
                break;
            }
        }
    }
    if ($repeat === 'monthly' && count($event_dates) == 0) {
        $date_diff = date_diff($event_start_date, $now)->m;
        $date_diff += date_diff($event_start_date, $now)->d > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+' . $date_diff . ' month');
        $event_end_date = $event_end_date->modify('+' . $date_diff . ' month');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+1 month');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+1 month');
            if (($sc_date === '' && ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date))) ||
                ($sc_date instanceof DateTime && ($event_start_date->diff($sc_date)->days == 0))) {
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                );
                break;
            }
        }
    }
    if ($repeat === 'yearly' && count($event_dates) == 0) {
        $date_diff = date_diff($event_start_date, $now)->y;
        $date_diff += date_diff($event_start_date, $now)->y == 0 && date_diff($event_start_date, $now)->d > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+' . $date_diff . ' year');
        $event_end_date = $event_end_date->modify('+' . $date_diff . ' year');

        for ($i = 0; $i < $repeat_number; $i++) {
            $event_start_date = $i == 0 ? $event_start_date : $event_start_date->modify('+1 year');
            $event_end_date = $i == 0 ? $event_end_date : $event_end_date->modify('+1 year');
            if (($sc_date === '' && ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date))) ||
                ($sc_date instanceof DateTime && ($event_start_date->diff($sc_date)->days == 0))) {
                $event_dates[] = array(
                    'start_date' => (clone $event_start_date),
                    'end_date' => (clone $event_end_date),
                );
                break;
            }
        }
    }
}

wp_enqueue_style('font-awesome', FAT_EVENT_PLUGIN_URL . '/assets/fonts/fonts-awesome/css/font-awesome.min.css', array(), '4.7.0');
wp_enqueue_style('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/style.css', array(), FAT_EVENT_PLUGIN_VERSION);
wp_enqueue_style('fat-spinner', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/spinner.css', array(), false);

$dist = (defined('FAT_CORE_SCRIP_DEBUG') && FAT_CORE_SCRIP_DEBUG) ? '' : 'dist/';
wp_enqueue_script('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/fat-event.js', array('jquery', 'wp-util'), FAT_EVENT_PLUGIN_VERSION, false);
wp_localize_script('fat-event', 'fat_event_ajax',
    array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'fully_booked' => esc_html__('Fully booked','fat-event')
    )
);

$tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl_popup_booking.php';
if (file_exists($tmpl_path)) {
    include_once $tmpl_path;
}

?>
<div class="fat-event-container">
    <div class="fat-event-sc event-booking">
        <a class="fat-event-register"
           data-payment="<?php echo esc_attr($event_detail['payment']); ?>"
           data-start="<?php echo esc_attr($event_start_date->format('U')); ?>"
           data-end="<?php echo esc_attr($event_end_date->format('U')); ?>"
           data-fees="<?php echo esc_attr($event_detail['fees']); ?>" data-id="<?php echo esc_attr($post_id); ?>"
           href="<?php echo $event_detail['payment'] == 'external_link' ? $event_detail['external_link_booking'] : 'javascript:;'; ?>"
        >
            <?php esc_html_e('Book Now', 'fat-event'); ?> <i class="fa fa-long-arrow-right"></i>
        </a>
    </div>
</div>