<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 11:12 AM
 */

$event_id =  isset($shortcode_config['event_id']) && $shortcode_config['event_id'] ? $shortcode_config['event_id'] : 0;
if($event_id <= 0){
    return;
}

$event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
$opt_date_format = get_post_meta($event_id, 'opt_date_format', true);

$start_date = isset($shortcode_config['start_date']) && $shortcode_config['start_date'] ? $shortcode_config['start_date'] : '';
$date_format = isset($shortcode_config['date_format']) && $shortcode_config['date_format'] ? $shortcode_config['date_format'] : get_option('date_format');
$now = new DateTime($start_date);
$event_start_date = get_post_meta($event_id, 'start_date', true);
$event_start_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date);
$event_end_date = get_post_meta($event_id, 'end_date', true);
$event_end_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date);
$event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
$repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
$repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
$sc_open_detail = isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window';

$is_show_up = false;
if ($now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)) {
    $is_show_up = true;
} else {
    if ($repeat === 'custom') {
        $custom_days = $event_detail['custom_days'];
        if (count($custom_days) > 0) {
            for ($i = 0; $i < count($custom_days); $i++) {
                $repeat_on_date = $custom_days['repeat_on_date'][$i];
                if ($repeat_on_date) {
                    $repeat_on_date = DateTime::createFromFormat($opt_date_format, $repeat_on_date);
                    if ($repeat_on_date >= $now) {
                        $is_show_up = true;
                        break;
                    }
                }
            }
        }
    }
    if ($repeat === 'daily') {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff += $event_start_date->diff($now)->h > 0 ? 1 : 0;
        $date_diff = ceil($date_diff / $repeat_interval);
        $event_start_date = $event_start_date->modify('+' . ($repeat_interval * $date_diff) . ' day');
        $event_end_date = $event_end_date->modify('+' . ($repeat_interval * $date_diff)  . ' day');
        $is_show_up = $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date);
    }
    if ($repeat === 'weekly') {
        $date_diff = $event_start_date->diff($now)->days;
        $date_diff = floor($date_diff / 7) + ($date_diff % 7 > 0 ? 1 : 0);

        $event_start_date = $event_start_date->modify('+' . $date_diff . ' day');
        $event_end_date = $event_end_date->modify('+' . $date_diff  . ' day');
        $is_show_up = $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date);
    }
    if ($repeat === 'monthly') {
        $date_diff = date_diff($event_start_date,$now)->m;
        $date_diff += isset(date_diff($event_start_date,$now)->weekday) && date_diff($event_start_date,$now)->weekday > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+'. $date_diff .' month');
        $event_end_date = $event_end_date->modify('+'. $date_diff .' month');
        $is_show_up = $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date);
    }
    if ($repeat === 'yearly') {
        $date_diff = isset(date_diff($event_start_date,$now)->y) ? date_diff($event_start_date,$now)->y : 0;
        $date_diff += date_diff($event_start_date,$now)->y == 0 && date_diff($event_start_date,$now)->m > 0 ? 1 : 0;

        $event_start_date = $event_start_date->modify('+'. $date_diff .' year');
        $event_end_date = $event_end_date->modify('+'. $date_diff .' year');
        $is_show_up = $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date);
    }
}
$event = array();
if (!$is_show_up) {
    return;
}else{
    $event = array(
        'id' => $event_id,
        'title' => get_the_title($event_id),
        'start_date' => $event_start_date,
        'end_date' => $event_end_date,
        'location' => $event_detail['location'],
        'media_type' => $event_detail['media_type'],
        'link_video' =>  $event_detail['link_video'],
        'link_detail' => $event_detail['link_detail'] ?  $event_detail['link_detail'] : get_permalink($event_id),
        'link_open_type' => $event_detail['link_open_type'],
        'open_detail_type' => $sc_open_detail,
        'all_day_event' => isset($event_detail['all_day_event'][0]) ? $event_detail['all_day_event'][0] : '',
        'hide_event_time' => isset($event_detail['hide_event_time'][0]) ? $event_detail['hide_event_time'][0] : '',
        'hide_event_end_time' => isset($event_detail['hide_event_end_time'][0]) ? $event_detail['hide_event_end_time'][0] : '',
        'date_format' => $date_format,
    );
}

$column = isset($shortcode_config['column']) && $shortcode_config['column'] && $shortcode_config['column'] > 0 ? $shortcode_config['column'] : 3;
$total_found = 0;
$width = isset($shortcode_config['image_width']) ? $shortcode_config['image_width'] : 375;
$height = isset($shortcode_config['image_height']) ? $shortcode_config['image_height'] : 275;
$now = new DateTime();
$color = $bg = $cd_color = $style = $time = '';

$time = date_i18n('Y/m/d',$event['start_date']->format('U')). $event['start_date']->format(' H:i:s');

if ($event['all_day_event'] === '1') {
    $time_detail = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
    $single_time = esc_html__('All day - ', 'fat-event') . date_i18n($date_format, $event['start_date']->format('U'));
} else {
    $time_detail = $event['start_date']->format($time_format) . ' - ' . $event['end_date']->format($time_format) . ', ' . date_i18n($date_format, $event['start_date']->format('U'));

    $all_day_event = isset($event['all_day_event'][0]) ? $event['all_day_event'][0] : '';
    if (isset($event['hide_event_end_time'][0]) && $event['hide_event_end_time'][0] == '1') {
        $single_time = $event['start_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
    } else {
        if ($all_day_event && date_diff($event['start_date'], $event['end_date'])->d == 0) {
            $single_time = esc_html__('All day - ', 'fat-event') . $event['start_date']->format($single_time_format);
        } else {
            if (date_diff($event['start_date'], $event['end_date'])->d == 0) {
                $single_time = $event['start_date']->format($single_time_format) . esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format) . ' - ' . date_i18n($date_format, $event['start_date']->format('U'));
            } else {
                $single_time = $event['start_date']->format($single_time_format . ' ') . date_i18n($date_format, $event['start_date']->format('U')) .  esc_html__(' to ', 'fat-event') . $event['end_date']->format($single_time_format . ' ') .  date_i18n($date_format, $event['end_date']->format('U'));
            }
        }
    }
}
?>
<div class="fat-event-container" data-layout="<?php echo esc_attr($layout);?>" data-sc-id="<?php echo esc_attr($id);?>" data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']);?>" >
    <div class="fat-event-sc event-countdown">
        <?php
        $skin_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/skins/'.(isset($shortcode_config['countdown_skin']) && $shortcode_config['countdown_skin'] ? $shortcode_config['countdown_skin'] : 'cd-skin-01').'.php';
        $item_class = '';
        $item_class = 'fat-event-item';
        $item_class .= ' event-' . $event['id'];
        $theme_path = get_template_directory().'/templates/fat-event/skins/'.$shortcode_config['countdown_skin'].'.php';
        if(file_exists($theme_path)){
            $skin_path = $theme_path;
        }
        include $skin_path;
        ?>
    </div>
</div>