<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 11:12 AM
 */

$shortcode_config['pagination'] = 'none';
$total_found = 0;
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$shortcode_search = get_post_meta($id, 'fat-mb-shortcode-search', true);
$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';

$width = isset($shortcode_config['image_width']) ? $shortcode_config['image_width'] : 375;
$height = isset($shortcode_config['image_height']) ? $shortcode_config['image_height'] : 275;

$fat_event_setting = get_option('fat_event_setting');
$single_time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';
?>
<div class="fat-event-container" data-layout="<?php echo esc_attr($layout); ?>"
     data-sc-id="<?php echo esc_attr($id); ?>"
     data-sc-organizer="<?php echo (isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo (isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']); ?>">
    <?php
    if (isset($shortcode_search['enable_search'][0]) && $shortcode_search['enable_search'][0] === '1') {
        $filter_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/filters/' . $shortcode_search['search_style'] . '.php';
        include $filter_path;
    }
    ?>
    <div class="fat-event-sc event-conference">
        <?php
        $conferences = array();
        $time = '';
        foreach ($events as $event) {
            if ($event['start_date']->format('dmY') == $event['end_date']->format('dmY')) {
                $conferences[$event['start_date']->format('dmY')][] = $event;
            }
        };
        foreach ($conferences as $confer) { ?>
            <div class="fat-event-item">
                <div class="fat-event-date">
                    <span class="fat-event-weekday">
                        <?php echo strftime('%A',$confer[0]['start_date']->getTimestamp());?>
                    </span>
                    <span class="fat-event-fullday">
                         <?php echo esc_html($confer[0]['start_date']->format('d/m')); ?>
                    </span>
                </div>
                <ul class="fat-event-confer-detail">
                    <?php foreach ($confer as $event) {
                        if($event['all_day_event']){
                            if(date_diff($event['start_date'],$event['end_date'])->d == 0){
                                $time = esc_html__('All day - ','fat-event').$event['start_date']->format($event['date_format']);
                                $single_time = $time;
                            }
                        }else{
                            if(date_diff($event['start_date'],$event['end_date'])->d == 0){
                                $time = $event['start_date']->format($time_format). esc_html__(' to ','fat-event'). $event['end_date']->format($time_format).' - '. date_i18n($event['date_format'],$event['start_date']->format('U')) ;
                                $single_time = $event['start_date']->format($single_time_format). esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format).' - '. date_i18n($event['date_format'],$event['start_date']->format('U'));
                            }else{
                                $time = $event['start_date']->format($time_format.' '). $event['start_date']->format($event['date_format']) . esc_html__(' to ','fat-event'). $event['end_date']->format($time_format.' '). date_i18n($event['date_format'],$event['end_date']->format('U'));
                                $single_time = $event['start_date']->format($single_time_format.' '). $event['start_date']->format($event['date_format']) . esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format.' '). date_i18n($event['date_format'],$event['end_date']->format('U'));
                            }
                        }
                        ?>
                        <li>
                            <div class="fat-event-time-ranger">
                                <?php echo $event['start_date']->format('H:i') . '-' . $event['end_date']->format('H:i'); ?>
                            </div>
                            <div class="fat-event-content">
                                <span class="fat-event-title">
                                    <a href="<?php echo esc_url($event['link_detail']) ?>" target="<?php echo esc_attr($event['link_open_type']);?>"
                                       data-event-id="<?php echo esc_attr($event['id']); ?>" data-time="<?php echo esc_attr($time);?>"
                                       data-single-time="<?php echo esc_attr($single_time);?>"
                                       data-s="<?php echo esc_attr($event['start_date']->format('U')); ?>" data-e="<?php echo esc_attr($event['end_date']->format('U')); ?>"
                                       data-open-type="<?php echo esc_attr($event['open_detail_type']);?>" target="<?php echo esc_attr($event['link_open_type']);?>" >
                                        <?php echo get_the_title($event['id']); ?>
                                    </a>
                                </span>
                                <?php if ($event['location'] && $event['location'] !== 'hide' && $event['location'] !== 'add_new') : ?>
                                    <span class="fat-event-location">
                                    <i class="fa fa-map-marker"></i>
                                        <?php echo get_term_by('id', $event['location'], FAT_EVENT_LOCATION_TAXONOMY)->name ?>
                                </span>
                                <?php endif; ?>
                                <?php if ($event['main_organizer'] && $event['main_organizer'] !== 'hide' && $event['main_organizer'] !== 'add_new') : ?>
                                    <span class="fat-event-organizer">
                                    <i class="fa fa-user"></i>
                                        <?php echo get_term_by('id', $event['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY)->name ?>
                                </span>
                                <?php endif; ?>
                            </div>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        <?php } ?>
    </div>
</div>