<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/30/2018
 * Time: 2:25 PM
 */
$total_found = 0;
$now = current_time('mysql',0);
$now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
$ts = strtotime($now->format('M'). ' '.$now->format('Y'));
$start_of_month =  date('m-01-Y 00:00:00', $ts);
$end_of_month= date('m-t-Y 12:59:59', $ts);

$start_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $start_of_month);
$end_of_month = DateTime::createFromFormat('m-d-Y H:i:s', $end_of_month);

//$time_format = isset($shortcode_config['time_format']) ? $shortcode_config['time_format'] : 'H:i';
$date_format = isset($shortcode_config['date_format']) ? $shortcode_config['date_format'] : get_option('date_format');

$shortcode_config['limit'] = '';
$shortcode_config['pagination'] = 'none';
$events = FAT_Event_Utils::get_events($shortcode_config, $total_found);
$data_events = array();
$bg_color = '';
$index = 0;

$fat_event_setting = get_option('fat_event_setting');
$single_time_format = $time_format = isset($fat_event_setting['single_time_format']) ? $fat_event_setting['single_time_format'] : 'H:i';

foreach ($events as $event) {
    $bg_color = get_post_meta($event['id'], 'fat-mb-event-color', true);
    $bg_color = isset($bg_color['color']) && $bg_color['color'] ? $bg_color['color'] : '#3a87ad';
    $data_events[] = array(
        'id' => $event['id'],
        'eventName' => get_the_title($event['id']),
        'date' => $event['all_day_event'] ? $event['start_date']->format('Y-m-d 00:00') : $event['start_date']->format('Y-m-d H:i'),
        'day' => $event['start_date']->format('j'),
        'month' => $event['start_date']->format('n'),
        'year' => $event['start_date']->format('Y'),
        'color' => $bg_color,
        'link_detail' => $event['link_detail'],
        'data_start' => $event['start_date']->format('U'),
        'data_end' => $event['end_date']->format('U'),
        'open_type' => isset($shortcode_config['open_detail_type']) && $shortcode_config['open_detail_type'] ? $shortcode_config['open_detail_type'] : 'single_window'
    );
    if(!$event['all_day_event']){
        $data_events[$index]['end'] =  $event['end_date']->format('c');
    }
    if($event['all_day_event']){
        if(date_diff($event['start_date'],$event['end_date'])->d == 0){
            $data_events[$index]['time'] = esc_html__('All day - ','fat-event'). date_i18n($date_format,$event['start_date']->format('U'));
            $data_events[$index]['single_time'] = $data_events[$index]['time'];
        }
    }else{
        if(date_diff($event['start_date'],$event['end_date'])->d == 0){
            $data_events[$index]['time'] = $event['start_date']->format($time_format). esc_html__(' to ','fat-event'). $event['end_date']->format($time_format).' - '. date_i18n($date_format,$event['start_date']->format('U'));
            $data_events[$index]['single_time'] = $event['start_date']->format($single_time_format). esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format).' - '. date_i18n($date_format,$event['start_date']->format('U'));
        }else{
            $data_events[$index]['time'] = $event['start_date']->format($time_format.' '). date_i18n($date_format, $event['start_date']->format('U')) . esc_html__(' to ','fat-event'). $event['end_date']->format($time_format. ' '). date_i18n($date_format,$event['end_date']->format('U'));
            $data_events[$index]['single_time'] = $event['start_date']->format($single_time_format.' '). date_i18n($date_format, $event['start_date']->format('U')) . esc_html__(' to ','fat-event'). $event['end_date']->format($single_time_format. ' '). date_i18n($date_format,$event['end_date']->format('U'));
        }
    }

    $index++;
}
$data_events = json_encode($data_events);
?>
<div id="<?php echo uniqid('fat-event-');?>" class="<?php echo esc_attr($shortcode_config['calendar_color_skin']);?> fat-event-sc calendar-widget"
     data-sc-id ="<?php echo esc_attr($id);?>"
     data-sc-organizer="<?php echo (isset($atts['filter_organizer']) && $atts['filter_organizer'] ? $atts['filter_organizer'] : ''); ?>"
     data-sc-cat="<?php echo (isset($atts['filter_cat']) && $atts['filter_cat'] ? $atts['filter_cat'] : ''); ?>"
     data-spinner="<?php echo esc_attr($shortcode_config['loading_spinner']);?>"
     data-events="<?php echo esc_attr($data_events); ?>"
     data-current="<?php echo esc_attr($now->format('U'));?>"
     data-month="<?php echo (isset($shortcode_config['calendar_default_month']) ? $shortcode_config['calendar_default_month'] : -1); ?>"
>
</div>