<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/13/2018
 * Time: 8:58 AM
 */
$terms = '';
$locale = get_locale();
$locale = explode('_',$locale)[0];
?>
<div class="fat-event-filter-container">
    <?php if (isset($shortcode_search['enable_search_name'][0]) && $shortcode_search['enable_search_name'][0] === '1'): ?>
        <input type="text" id="fat-event-filter-name"
               placeholder="<?php echo esc_attr__('Input event name or ID', 'fat-event'); ?>">
    <?php endif ?>

    <?php if (isset($shortcode_search['enable_search_start_date'][0]) && $shortcode_search['enable_search_start_date'][0] === '1'): ?>
        <span class="fat-event-date-filter-wrap">
            <i class="fa fa-calendar"></i>
            <input type="text" class="fat-event-date" data-locale="<?php echo esc_attr($locale);?>" autocomplete="off" id="fat-event-date" />
        </span>

    <?php endif ?>

    <?php if (isset($shortcode_search['enable_search_tag'][0]) && $shortcode_search['enable_search_tag'][0] === '1') : ?>
        <input type="text" id="fat-event-filter-tag" placeholder="<?php echo esc_attr__('Input tag', 'fat-event'); ?>">
    <?php endif ?>

    <?php if (isset($shortcode_search['enable_search_category'][0]) && $shortcode_search['enable_search_category'][0] === '1'):
        $include_term = isset($shortcode_config['categories']) && $shortcode_config['categories'] ? $shortcode_config['categories'] : array();
        ?>
        <span class="fat-event-cat-filter-wrap">
              <i class="fa fa-bars"></i>
            <?php wp_dropdown_categories(array(
            'taxonomy' => FAT_EVENT_CATEGORY_TAXONOMY,
            'include' => $include_term,
            'hierarchical' => 1,
            'id' => 'fat-event-filter-category',
            'show_option_all' => esc_html__('All categories', 'fat-event')
        )); ?>
     </span>
    <?php endif ?>

    <?php if (isset($shortcode_search['enable_search_location'][0]) && $shortcode_search['enable_search_location'][0] === '1'):
        $include_term = isset($shortcode_config['locations']) && $shortcode_config['locations'] ? $shortcode_config['locations'] : array();
        $terms = get_terms(array(
            'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
            'include' => $include_term
        ));
        ?>
        <span class="fat-event-location-filter-wrap">
            <i class="fa fa-map-marker" aria-hidden="true"></i>
            <select name="fat-event-filter-location" id="fat-event-filter-location">
                <option value="0" selected><?php esc_html_e('All locations', 'fat-event'); ?></option>
                <?php foreach ($terms as $term) { ?>
                    <option value="<?php echo esc_attr($term->term_id); ?>"><?php echo esc_html($term->name); ?></option>
                <?php } ?>
            </select>
        </span>
    <?php endif; ?>

    <?php if (isset($shortcode_search['enable_search_organizer'][0]) && $shortcode_search['enable_search_organizer'][0] === '1'):
        $include_term = isset($shortcode_config['organizers']) && $shortcode_config['organizers'] ? $shortcode_config['organizers'] : array();
        $terms = get_terms(array(
            'taxonomy' => FAT_EVENT_ORGANIZER_TAXONOMY,
            'include' => $include_term
        ));
        ?>
        <select name="fat-event-filter-organizer" id="fat-event-filter-organizer">
            <option value="0"><?php esc_html_e('All organizers', 'fat-event'); ?></option>
            <?php foreach ($terms as $term) { ?>
                <option value="<?php echo esc_attr($term->term_id); ?>"><?php echo esc_html($term->name); ?></option>
            <?php } ?>
        </select>
    <?php endif; ?>
</div>


