<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 9/3/2019
 * Time: 10:15 AM
 */
class fat_cmb_mapbox
{
    public $metabox_id;
    public $id;
    public $label;
    public $location = ''; //ex: 51.514294,-0.161696
    public $col_width = 'fat-cmb-col-12';
    public $description = '';
    public $depend_field = null;
    public $css_class = '';
    public $term_id = 0; //current term_id apply for taxonomy metabox
    public $api_key = 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';

    public function __construct($api_key)
    {
        $this->api_key = isset($api_key) && $api_key ? $api_key : $this->api_key;
        $this->enqueue_script();
    }

    private function enqueue_script(){
        wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
        wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
        wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
        wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);

        wp_enqueue_script('fat-cmb-mapbox', FAT_CMB_ASSET_JS_URL . 'mapbox.js', array('mapbox-gl','mapbox-gl-geocoder'), '1.0.0', true);
    }

    public function render()
    {
        global $fat_cmb_post_meta;
        if($this->term_id==0){
            $post_meta = isset($fat_cmb_post_meta[$this->metabox_id][0]) ? unserialize($fat_cmb_post_meta[$this->metabox_id][0]) : '';
        }else{
            $post_meta = $fat_cmb_post_meta;
        }
        $latitude = isset($post_meta[$this->id]) ? $post_meta[$this->id] : $this->location;
        $loc = explode(',',$this->location);
        if(isset($post_meta[$this->id])){
            $loc = explode(',',$post_meta[$this->id]);
        }
        $location_x = isset($loc[0]) ? $loc[0]: '';
        $location_y = isset($loc[1]) ? $loc[1]: '';

        $data_depend_field = isset($this->depend_field['field']) ? sprintf(' data-depend-field="%s" ', $this->depend_field['field']) : '';
        $data_depend_field .= isset($this->depend_field['value']) ? sprintf(' data-depend-value="%s" ', $this->depend_field['value']) : '';
        $data_depend_field .= isset($this->depend_field['compare']) ? sprintf(' data-depend-compare="%s" ', $this->depend_field['compare']) : '';

        $field_id = $this->id;
        $field_name = $this->id;
        ?>
        <div
            class="<?php echo esc_attr($this->col_width) ?> <?php echo esc_attr($this->css_class) ?> fat-cmb-mapbox-wrap" <?php echo sprintf('%s', $data_depend_field); ?> >
            <label for="<?php echo esc_attr($this->id) ?>"><?php echo esc_attr($this->label) ?></label>
            <div class="fat-cmb-field">
                <input type="text" name="<?php echo esc_attr($field_name) ?>" value="<?php echo esc_attr($latitude);?>"
                       id="<?php echo esc_attr($field_id) ?>"
                       data-field-id="<?php echo esc_attr($this->id) ?>"
                       data-std="<?php echo esc_attr($this->location); ?>"
                       class="fat-mapbox-location"

                />
                <?php if (isset($this->description) && $this->description != ''): ?>
                    <span class="fat-cmb-description"><?php echo esc_html($this->description); ?> </span>
                <?php endif; ?>
                <div class="fat-mapbox" id="fat_mapbox_<?php echo esc_attr($field_id) ?>"
                     data-latitude-x="<?php echo esc_attr($location_x); ?>"
                     data-latitude-y="<?php echo esc_attr($location_y); ?>"
                     data-access-token="<?php echo esc_attr($this->api_key);?>"
                     data-map-type="roadmap"
                     data-zoom="15"
                >
                </div>
            </div>
        </div>
    <?php }
}