<?php

/**
 * Created by PhpStorm.
 * User: Roninwp
 * Date: 10/15/2016
 * Time: 10:03 PM
 */
class fat_cmb_google_map
{

    public $metabox_id;
    public $id;
    public $label;
    public $location = ''; //ex: 51.514294,-0.161696
    public $col_width = 'fat-cmb-col-12';
    public $description = '';
    public $depend_field = null;
    public $css_class = '';
    public $term_id = 0; //current term_id apply for taxonomy metabox
    public $api_key = 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';

    public function __construct($api_key)
    {
        $this->api_key = isset($api_key) && $api_key ? $api_key : $this->api_key;
        $this->enqueue_script();
    }

    private function enqueue_script(){
        $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&libraries=places&callback=fat_google_map_init',$this->api_key);
        wp_enqueue_script('fat-cmb-google-map', FAT_CMB_ASSET_JS_URL . 'google-map.js', array(), '1.0.0', true);
        wp_enqueue_script('fat-google-map-api', $map_api, array('fat-cmb-google-map'), false, true);
    }

    public function render()
    {
        global $fat_cmb_post_meta;
        if($this->term_id==0){
            $post_meta = isset($fat_cmb_post_meta[$this->metabox_id][0]) ? unserialize($fat_cmb_post_meta[$this->metabox_id][0]) : '';
        }else{
            $post_meta = $fat_cmb_post_meta;
        }
        $latitude = isset($post_meta[$this->id]) ? $post_meta[$this->id] : $this->location;
        $loc = explode(',',$this->location);
        if(isset($post_meta[$this->id])){
            $loc = explode(',',$post_meta[$this->id]);
        }
        $location_x = isset($loc[0]) ? $loc[0]: '';
        $location_y = isset($loc[1]) ? $loc[1]: '';

        $data_depend_field = isset($this->depend_field['field']) ? sprintf(' data-depend-field="%s" ', $this->depend_field['field']) : '';
        $data_depend_field .= isset($this->depend_field['value']) ? sprintf(' data-depend-value="%s" ', $this->depend_field['value']) : '';
        $data_depend_field .= isset($this->depend_field['compare']) ? sprintf(' data-depend-compare="%s" ', $this->depend_field['compare']) : '';

        $field_id = $this->id;
        $field_name = $this->id;
        ?>
        <div
            class="<?php echo esc_attr($this->col_width) ?> <?php echo esc_attr($this->css_class) ?> fat-cmb-google-map-wrap" <?php echo sprintf('%s', $data_depend_field); ?> >
            <label for="<?php echo esc_attr($this->id) ?>"><?php echo esc_attr($this->label) ?></label>
            <div class="fat-cmb-field">
                <input type="text" name="<?php echo esc_attr($field_name) ?>" value="<?php echo esc_attr($latitude);?>"
                       id="<?php echo esc_attr($field_id) ?>"
                       data-field-id="<?php echo esc_attr($this->id) ?>"
                       data-std="<?php echo esc_attr($this->location); ?>"
                       class="fat-google-map-location"

                />
                <?php if (isset($this->description) && $this->description != ''): ?>
                    <span class="fat-cmb-description"><?php echo esc_html($this->description); ?> </span>
                <?php endif; ?>
                <input type="text" name="<?php echo esc_attr($field_name.'_search') ?> " class="search-box">
                <div class="fat-google-map"
                     data-latitude-x="<?php echo esc_attr($location_x); ?>"
                     data-latitude-y="<?php echo esc_attr($location_y); ?>"
                     data-map-type="roadmap"
                     data-zoom="15"
                >
                </div>
            </div>
        </div>
    <?php }
}
