<?php
/**
 * Created by PhpStorm.
 * User: Roninwp
 * Date: 10/15/2016
 * Time: 10:03 PM
 */
class fat_cmb_dateranger
{

    public $repeat_id;
    public $repeat_value;
    public $repeat_index;
    public $metabox_id;
    public $id;
    public $label;
    public $std = '';
    public $col_width = 'fat-cmb-col-6';
    public $description = '';
    public $tooltip = '';
    public $depend_field = null;
    public $date_format = '';
    public $start_init = '';
    public $end_init = '';
    public $locale = '';
    public $css_class = '';
    public $term_id = 0; //current term_id apply for taxonomy metabox

    public function __construct()
    {
        $this->enqueue_script();
    }

    private function enqueue_script(){
        wp_enqueue_style('date-ranger', FAT_CMB_ASSET_JS_URL . 'date-ranger/daterangepicker.css', array(), '3.0.3');
        wp_enqueue_script('date-ranger-moment', FAT_CMB_ASSET_JS_URL . 'date-ranger/moment.min.js', array(), '3.0.3', true);
        wp_enqueue_script('date-ranger', FAT_CMB_ASSET_JS_URL . 'date-ranger/daterangepicker.js', array(), '3.0.3', true);
        wp_enqueue_script('fat-cmb-date-ranger', FAT_CMB_ASSET_JS_URL . 'date-ranger.js', array(), '1.0.0', true);
    }

    public function render()
    {

        global $fat_cmb_post_meta;
        if($this->term_id==0){
            $post_meta = isset($fat_cmb_post_meta[$this->metabox_id][0]) ? unserialize($fat_cmb_post_meta[$this->metabox_id][0]) : '';
        }else{
            $post_meta = $fat_cmb_post_meta;
        }
        if(isset($this->repeat_id)){
            $text = isset($this->repeat_value) ? $this->repeat_value : $this->std;
        }else{
            $text = isset($post_meta[$this->id]) ? $post_meta[$this->id] : $this->std;
        }

        $data_depend_field = isset($this->depend_field['field']) ? sprintf(' data-depend-field="%s" ',$this->depend_field['field']) : '';
        $data_depend_field .= isset($this->depend_field['value']) ? sprintf(' data-depend-value="%s" ', $this->depend_field['value']) : '';
        $data_depend_field .= isset($this->depend_field['compare']) ? sprintf(' data-depend-compare="%s" ', $this->depend_field['compare']) : '';

        $field_id = isset($this->repeat_id) ? sprintf('%s_%s', $this->repeat_id, $this->id) : $this->id;
        $field_name = isset($this->repeat_id) ? sprintf('%s_%s[%s]', $this->repeat_id, $this->id, $this->repeat_index) : $this->id;

        $text = apply_filters('fat_cmd_field_value',$text, $this->id, $fat_cmb_post_meta);
        if($text){
            $date = explode(';',$text);
            if(is_array($date) && count($date) == 2){
                $this->start_init = \DateTime::createFromFormat('Y-m-d',$date[0]);
                $this->start_init = date_i18n($this->date_format,$this->start_init->format('U'));
                $this->end_init = \DateTime::createFromFormat('Y-m-d',$date[1]);
                $this->end_init = date_i18n($this->date_format,$this->end_init->format('U'));
            }
        }
        ?>
        <div
            class="<?php echo esc_attr($this->col_width) ?> <?php echo esc_attr($this->css_class) ?> fat-cmb-date-ranger-wrap" <?php echo sprintf('%s', $data_depend_field); ?> >
            <label for="<?php echo esc_attr($this->id) ?>"><?php echo esc_attr($this->label) ?>
                <?php if($this->tooltip): ?>
                    <span class="fat-cmb-tooltip" title="<?php echo esc_html($this->tooltip);?>"></span>
                <?php endif; ?>
            </label>
            <div class="fat-cmb-field">
                <input type="hidden" name="<?php echo esc_attr($field_name) ?>"
                       data-field-id="<?php echo esc_attr($this->id) ?>"
                       id="<?php echo esc_attr($field_id) ?>" value="<?php echo esc_attr($text);?>">
                <input class="fat-cmb-date-ranger" autocomplete="off" type="text" name="<?php echo esc_attr('dr_'.$field_name) ?>"

                       data-field-id="<?php echo esc_attr('dr_'.$this->id) ?>"
                       data-start-init="<?php echo esc_attr($this->start_init);?>" data-end-init="<?php echo esc_attr($this->end_init);?>"
                       data-locale="<?php echo esc_attr($this->locale); ?>"
                       data-std="<?php echo esc_attr($this->std); ?>"
                       data-date-format = "<?php echo esc_attr($this->date_format);?>"
                />
                <?php if (isset($this->description) && $this->description != ''): ?>
                    <span class="fat-cmb-description"><?php echo esc_html($this->description); ?> </span>
                <?php endif; ?>
            </div>
        </div>
    <?php }
}