<?php

/**
 * Created by PhpStorm.
 * User: roninwp
 * Date: 3/1/2017
 * Time: 2:09 PM
 */
class fat_cmb_color
{

    public $repeat_id;
    public $repeat_value;
    public $repeat_index;
    public $metabox_id;
    public $id;
    public $label;
    public $std = '';
    public $col_width = 'fat-cmb-col-6';
    public $description = '';
    public $depend_field = null;
    public $css_class = '';
    public $is_frontend= false;
    public $term_id = 0; //current term_id apply for taxonomy metabox

    public function __construct($is_frontend)
    {
        $this->is_frontend = isset($is_frontend) ? $is_frontend : false;
        $this->enqueue_script();
    }

    private function enqueue_script()
    {
        wp_enqueue_style( 'wp-color-picker' );
        if(!$this->is_frontend) {
            wp_enqueue_script('wp-color-picker');
        }else{
            wp_enqueue_script(
                'iris',
                admin_url( 'js/iris.min.js' ),
                array(
                    'jquery-ui-draggable',
                    'jquery-ui-slider',
                    'jquery-touch-punch'
                ),
                false,
                1
            );
            wp_enqueue_script(
                'wp-color-picker',
                FAT_CMB_ASSET_JS_URL . 'color-picker/color-picker.js',
                array('iris'),
                false,
                1
            );
            $colorpicker_l10n = array(
                'clear' => __( 'Clear' ),
                'defaultString' => __( 'Default' ),
                'pick' => __( 'Select Color' ),
                'current' => __( 'Current Color' ),
            );
            wp_localize_script(
                'wp-color-picker',
                'wpColorPickerL10n',
                $colorpicker_l10n
            );
        }

        wp_enqueue_script('wp-color-picker-alpha', FAT_CMB_ASSET_JS_URL . 'color-picker/wp-color-picker-alpha.js', array('wp-color-picker'), '2.1.2', true);
        wp_enqueue_script('fat-cmb-color', FAT_CMB_ASSET_JS_URL . 'color.js', array('wp-color-picker'), '1.0.0', true);
    }


    public function render()
    {
        global $fat_cmb_post_meta;
        global $cronus_theme_options;
        $theme_options = get_option($cronus_theme_options);
        $pre_colors = array();
        if (isset($theme_options['primary_color'])) {
            $pre_colors[] = array(
                'color' => $theme_options['primary_color'],
                'title' => esc_html__('Primary color','cronus')
            );
            $pre_colors[] = array(
                    'color' => $this->color_luminance($theme_options['primary_color'], 0.2),
                'title' => esc_html__('Lighten 20% of primary color','cronus')
            );
            $pre_colors[] = array(
                'color' => $this->color_luminance($theme_options['primary_color'], -0.2),
                'title' => esc_html__('Darken 20% of primary color','cronus')
            );
        }
        if (isset($theme_options['second_color'])) {
            $pre_colors[] = array(
                'color' => $theme_options['second_color'],
                'title' => esc_html__('Second color','cronus')
            );
            $pre_colors[] = array(
                'color' => $this->color_luminance($theme_options['second_color'], 0.2),
                'title' => esc_html__('Lighten 20% of second color','cronus')
            );
            $pre_colors[] = array(
                'color' => $this->color_luminance($theme_options['second_color'], -0.1),
                'title' => esc_html__('Darken 10% of second color','cronus')
            );

        }
        if($this->term_id==0){
            $post_meta = isset($fat_cmb_post_meta[$this->metabox_id][0]) ? unserialize($fat_cmb_post_meta[$this->metabox_id][0]) : '';
        }else{
            $post_meta = $fat_cmb_post_meta;
        }
        if (isset($this->repeat_id)) {
            $color = isset($this->repeat_value) ? $this->repeat_value : $this->std;
        } else {
            $color = isset($post_meta[$this->id]) ? $post_meta[$this->id] : $this->std;
        }

        $data_depend_field = isset($this->depend_field['field']) ? sprintf(' data-depend-field="%s" ', $this->depend_field['field']) : '';
        $data_depend_field .= isset($this->depend_field['value']) ? sprintf(' data-depend-value="%s" ', $this->depend_field['value']) : '';
        $data_depend_field .= isset($this->depend_field['compare']) ? sprintf(' data-depend-compare="%s" ', $this->depend_field['compare']) : '';

        $field_id = isset($this->repeat_id) ? sprintf('%s_%s', $this->repeat_id, $this->id) : $this->id;
        $field_name = isset($this->repeat_id) ? sprintf('%s_%s[%s]', $this->repeat_id, $this->id, $this->repeat_index) : $this->id;
        ?>
        <div class="<?php echo esc_attr($this->col_width) ?> <?php echo esc_attr($this->css_class) ?> fat-cmb-color-wrap" <?php echo sprintf('%s', $data_depend_field); ?>>
            <label for="<?php echo esc_attr($field_id) ?>"><?php echo esc_attr($this->label) ?></label>
            <div class="fat-cmb-field">
                <input type="text" name="<?php echo esc_attr($field_name) ?>" id="<?php echo esc_attr($field_id) ?>"
                       data-field-id="<?php echo esc_attr($this->id) ?>"
                       data-alpha="true"
                       value="<?php echo esc_attr($color) ?>"
                       data-std="<?php echo esc_attr($this->std); ?>"
                       class="fat-cmb-color-picker"/>
                <span class="input-group-addon"><i></i></span>
                <div class="fat-cmb-color-predefined">
                    <?php if (is_array($pre_colors) && count($pre_colors) > 0):
                        foreach ($pre_colors as $pre_color) {
                            ?>
                            <a href="javascript:" title="<?php echo esc_attr($pre_color['title']); ?>" data-color="<?php echo esc_attr($pre_color['color']); ?>"
                               style="background-color: <?php echo esc_attr($pre_color['color']); ?>"></a>
                        <?php }
                    endif; ?>
                </div>
                <?php if (isset($this->description) && $this->description != ''): ?>
                    <span class="fat-cmb-description"><?php echo esc_html($this->description); ?> asdsad</span>
                <?php endif; ?>
            </div>
        </div>
    <?php }

    /**
     * Lightens/darkens a given colour (hex format), returning the altered colour in hex format.7
     * @param str $hex Colour as hexadecimal (with or without hash);
     * @percent float $percent Decimal ( 0.2 = lighten by 20%(), -0.4 = darken by 40%() )
     * @return str Lightened/Darkend colour as hexadecimal (with hash);
     */
    private function color_luminance($hex, $percent)
    {

        // validate hex string

        $hex = preg_replace('/[^0-9a-f]/i', '', $hex);
        $new_hex = '#';

        if (strlen($hex) < 6) {
            $hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
        }

        // convert to decimal and change luminosity
        for ($i = 0; $i < 3; $i++) {
            $dec = hexdec(substr($hex, $i * 2, 2));
            $dec = min(max(0, $dec + $dec * $percent), 255);
            $new_hex .= str_pad(dechex($dec), 2, 0, STR_PAD_LEFT);
        }

        return $new_hex;
    }
}