<?php
/*
Plugin Name: FAT Custom MetaBox
Plugin URI:   http://roninwp.com/plugins/
Description: FAT CMB is a custom metabox for wordpress
Version:     1.0
Author:      Roninwp
Author URI:  http://roninwp.com/plugins/
Domain Path: /languages
Text Domain: inc
*/

if (!defined('ABSPATH')) die('-1');

defined('FAT_CMB_DIR_PATH') or define('FAT_CMB_DIR_PATH', plugin_dir_path(__FILE__));

defined('FAT_CMB_URL') or define('FAT_CMB_URL', plugins_url() . '/fat-event/libs/fat-cmb/');

defined('FAT_CMB_ASSET_JS_URL') or define('FAT_CMB_ASSET_JS_URL', trailingslashit(FAT_CMB_URL . 'assets/js'));

defined('FAT_CMB_ASSET_CSS_URL') or define('FAT_CMB_ASSET_CSS_URL', trailingslashit(FAT_CMB_URL . 'assets/css'));

if (!class_exists('FAT_Cmb')) {

    class FAT_Cmb
    {
        protected $page_options;

        /**
         * Metabox Defaults
         * @var   array
         * @since 1.0.1
         */
        //public $meta_boxes = array();

        function __construct()
        {
            $hook_name = sprintf('%s_%s_%s','add','meta','boxes');
            add_action($hook_name, array($this, 'callback_add_metabox'));
            add_action('add_page_meta_boxes', array($this,'callback_add_page_metabox'), 10, 2);
            add_action('save_post', array($this, 'fat_cmb_meta_box_save'));
            spl_autoload_extensions(".php");
            spl_autoload_register(array($this, 'fat_cmb_autload_class'));
            if (is_admin()) {
                add_action('admin_menu', array($this, 'callback_option_pages'));
                $this->add_taxonomy_meta_box();
            }
        }

        function fat_cmb_autload_class($class_name)
        {
            $class_path = FAT_CMB_DIR_PATH . "fields/{$class_name}.php";
            if (strrpos($class_name, 'fat_cmb') == 0 && file_exists($class_path)) {
                include_once($class_path);
            }
        }

        function callback_add_metabox()
        {
            add_action('admin_enqueue_scripts', array($this, 'enqueue_style'), 0);

            $meta_boxes = apply_filters('fat_cmb_register_metabox', array());
            if (count($meta_boxes) > 0) {
                foreach ($meta_boxes as $meta_box) {
                    if (isset($meta_box['id']) && isset($meta_box['pages'])) {
                        $meta_box['context'] = isset($meta_box['context']) ? $meta_box['context'] : 'advanced';
                        $meta_box['priority'] = isset($meta_box['priority']) ? $meta_box['priority'] : 'default';
                        $tabs = isset($meta_box['tabs']) ? $meta_box['tabs'] : array();
                        add_meta_box(
                            $meta_box['id'],
                            $meta_box['title'],
                            array($this, 'fat_cmb_meta_box_callback'),
                            $meta_box['pages'],
                            $meta_box['context'],
                            $meta_box['priority'],
                            array($meta_box['id'], $meta_box['fields'], $tabs)
                        );
                    }
                }
            }
        }

        function callback_option_pages()
        {
            global $fat_menu_slug;
            add_filter('admin_body_class', array($this, 'fat_cmb_add_body_class'));
            add_action('admin_enqueue_scripts', array($this, 'option_page_enqueue'), 0);

            $options = apply_filters('fat_cmb_register_option_page', array());

            foreach ($options as $option) {
                if (isset($option['menu_type']) && isset($option['menu_slug']) && $option['menu_slug'] != '') {
                    $page_title = isset($option['page_title']) ? $option['page_title'] : '';
                    $menu_title = isset($option['menu_title']) ? $option['menu_title'] : '';
                    $capability = isset($option['capability']) ? $option['capability'] : '';
                    $menu_slug = isset($option['menu_slug']) ? $option['menu_slug'] : '';
                    $icon_url = isset($option['icon_url']) ? $option['icon_url'] : '';
                    $position = isset($option['position']) ? $option['position'] : null;
                    $page_id = isset($option['page_id']) ? $option['page_id'] : '';
                    $parent_slug = isset($option['parent_slug']) ? $option['parent_slug'] : '';
                    $fields = isset($option['fields']) ? $option['fields'] : array();

                    if ($option['menu_type'] === 'menu' && !isset($fat_menu_slug[$menu_slug]) ) {
                        $add_page = sprintf('%s_%s_page','add','menu');
                        $this->page_options[$menu_slug] = $option;
                        $add_page($page_title, $menu_title, $capability, $menu_slug, array($this, 'initPageOptions'), $icon_url, $position);
                        $fat_menu_slug[$menu_slug] = $menu_slug;
                    }
                    if ($option['menu_type'] === 'sub-menu' && !isset($fat_menu_slug[$menu_slug]) ) {
                        $add_page = sprintf('%s_%s_page','add','submenu');
                        $this->page_options[$menu_slug] = $option;
                        $fat_menu_slug[$menu_slug] = $menu_slug;
                        $add_page($parent_slug, $page_title, $menu_title, $capability, $menu_slug, array($this, 'initPageOptions'));
                    }
                }
            }
        }

        function callback_add_page_metabox($page_id, $fields){
            $meta_box_id = $page_id;
            add_action('admin_enqueue_scripts', array($this, 'enqueue_style'), 0);
            wp_enqueue_script('fat-cmb', FAT_CMB_ASSET_JS_URL . 'fat-cmb.js', array(), '1.0.0', true);
            wp_enqueue_script('fat-cmb-utils', FAT_CMB_ASSET_JS_URL . 'fat-cmb-utils.js', array(), '1.0.0', true);
            echo '<link rel = "stylesheet" type = "text/css" href = "'.FAT_CMB_ASSET_CSS_URL . 'fat-cmb.css'.'" />';
            $template = FAT_CMB_DIR_PATH . 'templates/init-field.php';
            if (file_exists($template)) {
                include $template;
            }
        }

        function fat_cmb_add_body_class($classes)
        {
            $screen =  get_current_screen();
            if(isset($screen->id) && $screen->id=='fat-event_page_fat-event-setting'){
                return $classes . ' fat-cmb-page-options';
            }else{
                return $classes;
            }
        }

        function initPageOptions()
        {
            $template = FAT_CMB_DIR_PATH . 'templates/option-page.php';
            if (file_exists($template)) {
                include $template;
            } else {
                echo '<div>Cannot find option page template</div>';
            }
        }

        function fat_cmb_meta_box_callback($post, $callback_args)
        {
            if (count($callback_args['args']) <= 0) {
                return;
            }

            wp_enqueue_script('fat-cmb', FAT_CMB_ASSET_JS_URL . 'fat-cmb.js', array(), '1.0.0', true);

            // We'll use this nonce field later on when saving.
            wp_nonce_field('my_meta_box_nonce', 'meta_box_nonce');
            $fat_field_type = null;
            $meta_box_id = $callback_args['args'][0];
            $fields = $callback_args['args'][1];
            $tabs = isset($callback_args['args'][2]) ? $callback_args['args'][2] : array();

            global $post, $fat_cmb_post_meta, $fat_cmb_post_id, $fat_cmb_post_type;
            $fat_cmb_post_id = $post->ID;
            $fat_cmb_post_type = get_post_type($fat_cmb_post_id);
            $fat_cmb_post_meta = get_post_custom($fat_cmb_post_id);

            ?>
            <div class="fat-cmb-form-container">
                <div class="fat-cmb-option-page-container">
                    <?php if (is_array($tabs) && count($tabs) > 0) :
                        $tab_icon = $tab_title = $tab_id_active = '';
                        $tab_type = isset($tabs['tab_type']) ? $tabs['tab_type'] : 'horizontal';
                        $tab_class = 'fat-cmb-tab-settings-nav fat-tab-' . $tab_type;
                        ?>

                        <ul class="<?php echo esc_attr($tab_class); ?>">
                            <?php foreach ($tabs as $tab) {
                                $tab_icon = isset($tab['icon']) ? $tab['icon'] : '';
                                $tab_title = isset($tab['title']) ? $tab['title'] : 'Tab title';
                                $tab_id_active = $tab_id_active === '' && $tab['id'] ? $tab['id'] : $tab_id_active;

                                ?>
                                <li class="<?php echo($tab_id_active === $tab['id'] ? 'active' : ''); ?>">
                                    <a href="javascript:"
                                       data-tab="<?php echo esc_attr($tab['id']); ?>">
                                        <i class="<?php echo esc_attr($tab_icon); ?>"></i>
                                        <span><?php echo esc_html($tab_title); ?></span>
                                    </a>
                                </li>
                            <?php }; ?>
                        </ul>

                    <?php endif;
                    $template = FAT_CMB_DIR_PATH . 'templates/init-field.php';
                    if (is_array($tabs) && count($tabs) > 0) {
                        $tab_fields = $fields;
                        foreach ($tabs as $tab) {
                            $fields = array();
                            foreach ($tab_fields as $field) {
                                if (isset($field['tab_id']) && $field['tab_id'] == $tab['id']) {
                                    $fields[] = $field;
                                }
                            }
                            ?>
                            <div class="fat-tab-setting <?php echo($tab_id_active === $tab['id'] ? 'active' : ''); ?>"
                                 id="<?php echo esc_attr($tab['id']); ?>">
                                <?php include $template; ?>
                            </div>
                        <?php }
                    } else {
                        include $template;
                    }

                    ?>
                </div>
            </div>
            <?php
        }

        function fat_cmb_meta_box_save($post_id)
        {
            // Bail if we're doing an auto save
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

            // if our nonce isn't there, or we can't verify it, bail
            if (!isset($_POST['meta_box_nonce']) || !wp_verify_nonce($_POST['meta_box_nonce'], 'my_meta_box_nonce')) return;

            // if our current user can't edit this post, bail
            if (!current_user_can('edit_posts')) return;

            // now we can actually save the data
            $allowed = array(
                'a' => array( // on allow a tags
                    'title' => array(),
                    'ref' => array(),
                    'href' => array() // and those anchors can only have href attribute
                ),
                'em' => array(),
                'strong' => array(),
                'br' => array(),
                'i'      => array(),
                'strike' => array(),
                'iframe' => array(
                    'width' => array(),
                    'height' => array(),
                    'style' => array(),
                    'src' => array(),
                    'frameborder' => array(),
                    'longdesc' => array(),
                    'name' => array(),
                    'scrolling' => array(),
                    'align' => array(),
                    'allowfullscreen' => array()
                )
            );

            // Make sure your data is set before trying to save it
            $meta_boxes = apply_filters('fat_cmb_register_metabox', array());
            $repeat_field_id = $instagram_access_token = $instagram_user_id = $flickr_api_key = $flickr_user_id = '';
            $post_type = get_post_type($post_id);
            foreach ($meta_boxes as $meta_box) {
                $fat_cmb_section_value = $repeat_fields = array();
                if (isset($meta_box['pages']) && is_array($meta_box['pages']) && in_array($post_type, $meta_box['pages'])) {
                    foreach ($meta_box['fields'] as $field) {
                        switch ($field['type']) {
                            case 'repeat':
                                $repeat_fields = $field['fields'];
                                foreach ($repeat_fields as $repeat_field) {
                                    $repeat_field_id = $field['id'] . '_' . $repeat_field['id'];
                                    if (isset($_POST[$repeat_field_id])) {
                                        $fat_cmb_section_value[$field['id']][$repeat_field['id']] = $_POST[$repeat_field_id];
                                    }
                                }
                                break;
                            case 'instagram':
                                $instagram_access_token = isset($_POST[$field['id']]['access_token']) ? $_POST[$field['id']]['access_token'] : '';
                                $instagram_user_id = isset($_POST[$field['id']]['user_id']) ? $_POST[$field['id']]['user_id'] : '';
                                $fat_cmb_section_value[$field['id']] = $_POST[$field['id']];
                                break;
                            case 'flickr':
                                $flickr_api_key = isset($_POST[$field['id']]['api_key']) ? $_POST[$field['id']]['api_key'] : '';
                                $flickr_user_id = isset($_POST[$field['id']]['user_id']) ? $_POST[$field['id']]['user_id'] : '';
                                $fat_cmb_section_value[$field['id']] = $_POST[$field['id']];
                                break;
                            default:
                                $field_value = isset($_POST[$field['id']]) ? $_POST[$field['id']] : '';
                                if ($field['type'] !== 'check' && $field['type'] !== 'ace' &&  $field['type']!='select' && $field['type'] !== 'radio') {
                                    $fat_cmb_section_value[$field['id']] = wp_kses  ($field_value, $allowed);
                                } else {
                                    $fat_cmb_section_value[$field['id']] = $field_value;
                                }
                                break;
                        }
                    }
                    if ($instagram_access_token) {
                        $option_key = sprintf('%s_%s_instagram', $post_type, $meta_box['id']);
                        update_option($option_key, array(
                            'access_token' => $instagram_access_token,
                            'user_id'      => $instagram_user_id
                        ));
                    }
                    if ($flickr_api_key) {
                        $option_key = sprintf('%s_%s_flickr', $post_type, $meta_box['id']);
                        update_option($option_key, array(
                            'api_key' => $flickr_api_key,
                            'user_id' => $flickr_user_id
                        ));
                    }
                    update_post_meta($post_id, $meta_box['id'], $fat_cmb_section_value);
                }
            }
        }

        function enqueue_style()
        {
            wp_enqueue_style('fat-cmb-style', FAT_CMB_ASSET_CSS_URL . 'fat-cmb.css', array(), true);
        }

        function option_page_enqueue()
        {
            wp_enqueue_style('font-awesome', FAT_CMB_ASSET_CSS_URL.'/font-awesome/css/font-awesome.min.css', array(), '4.7.0');
            wp_enqueue_style('fat-cmb-dialog-popup', FAT_CMB_ASSET_CSS_URL . 'dialog-popup.css', array(), true);
            wp_enqueue_style('fat-cmb-option-page', FAT_CMB_ASSET_CSS_URL . 'option-page.css', array(), true);
            wp_enqueue_style('fat-cmb-style', FAT_CMB_ASSET_CSS_URL . 'fat-cmb.css', array(), true);

            wp_enqueue_script('fat-cmb-utils', FAT_CMB_ASSET_JS_URL . 'fat-cmb-utils.js', array('jquery'), '1.0.0', true);
            wp_enqueue_script('fat-cmb', FAT_CMB_ASSET_JS_URL . 'fat-cmb.js', array('jquery'), '1.0.0', true);
            wp_enqueue_script('fat-cmb-option-page', FAT_CMB_ASSET_JS_URL . 'option-page.js', array('jquery'), '1.0.0', true);
        }

        function add_taxonomy_meta_box(){
            $taxonomy_meta_boxes = apply_filters('fat_cmb_register_taxonomy_metabox', array());
            if(count($taxonomy_meta_boxes)>0){
                foreach ($taxonomy_meta_boxes as $meta_box) {
                    if (isset($meta_box['id']) && isset($meta_box['taxonomy'])) {
                        add_action($meta_box['taxonomy'].'_add_form_fields', function() use ($meta_box){ $this->fat_cmd_taxonomy_meta_box_callback($meta_box);}, 10,1);
                        add_action($meta_box['taxonomy'].'_edit_form_fields', array($this,'fat_cmd_edit_taxonomy_meta_box_callback'), 10,1);

                        add_action('created_'.$meta_box['taxonomy'], array($this,'save_taxonomy_metadata'), 10,1);
                        add_action('edited_'.$meta_box['taxonomy'], array($this,'save_taxonomy_metadata'), 10, 1);
                    }
                }
            }
        }

        function fat_cmd_taxonomy_meta_box_callback($meta_box){
            global $fat_taxonomy_init;
            if(isset($fat_taxonomy_init[$meta_box['id']])){
                return;
            }
            wp_enqueue_script('fat-cmb', FAT_CMB_ASSET_JS_URL . 'fat-cmb.js', array(), '1.0.0', true);

            // We'll use this nonce field later on when saving.
            wp_nonce_field('my_meta_box_nonce', 'meta_box_nonce');
            $fat_field_type = null;
            $meta_box_id = $meta_box['id'];
            $fields = $meta_box['fields'];
            $fat_taxonomy_init[$meta_box_id] = $meta_box_id;

            $template = FAT_CMB_DIR_PATH . 'templates/init-field.php';
            if (file_exists($template)) {
                include $template;
            }
        }

        function fat_cmd_edit_taxonomy_meta_box_callback($term){
            global $fat_cmb_post_meta, $fat_taxonomy_init;

            $taxonomy_meta_boxes = apply_filters('fat_cmb_register_taxonomy_metabox', array());
            foreach ($taxonomy_meta_boxes as $meta_box) {
                if (isset($meta_box['taxonomy']) && $meta_box['taxonomy']=== $term->taxonomy) {
                    if(!isset($fat_taxonomy_init[$meta_box['id']])){
                        $meta_box_id = $meta_box['id'];
                        $fields = $meta_box['fields'];
                        $term_id = $term->term_id;
                        $fat_cmb_post_meta = get_term_meta($term_id, $meta_box_id, true );
                        $template = FAT_CMB_DIR_PATH . 'templates/init-field.php';
                        if (file_exists($template)) {
                            include $template;
                        }
                        $fat_taxonomy_init[$meta_box_id] = $meta_box_id;
                    }
                }
            }
        }

        function save_taxonomy_metadata($term_id){
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

            $allowed = array(
                'a' => array( // on allow a tags
                    'title' => array(),
                    'ref' => array(),
                    'href' => array() // and those anchors can only have href attribute
                ),
                'em' => array(),
                'strong' => array(),
                'br' => array(),
                'i'      => array(),
                'strike' => array(),
                'iframe' => array(
                    'width' => array(),
                    'height' => array(),
                    'style' => array(),
                    'src' => array(),
                    'frameborder' => array(),
                    'longdesc' => array(),
                    'name' => array(),
                    'scrolling' => array(),
                    'align' => array(),
                    'allowfullscreen' => array()
                )
            );

            $taxonomy_meta_boxes = apply_filters('fat_cmb_register_taxonomy_metabox', array());
            foreach ($taxonomy_meta_boxes as $meta_box) {
                $fat_cmb_section_value = $repeat_fields = array();
                if (isset($meta_box['taxonomy'])) {
                    foreach ($meta_box['fields'] as $field) {
                        switch ($field['type']) {
                            case 'repeat':
                                $repeat_fields = $field['fields'];
                                foreach ($repeat_fields as $repeat_field) {
                                    $repeat_field_id = $field['id'] . '_' . $repeat_field['id'];
                                    if (isset($_POST[$repeat_field_id])) {
                                        $fat_cmb_section_value[$field['id']][$repeat_field['id']] = $_POST[$repeat_field_id];
                                    }
                                }

                                break;
                            default:
                                $field_value = isset($_POST[$field['id']]) ? $_POST[$field['id']] : '';
                                if ($field['type'] !== 'check' && $field['type'] !== 'ace') {
                                    $fat_cmb_section_value[$field['id']] = wp_kses  ($field_value, $allowed);
                                } else {
                                    $fat_cmb_section_value[$field['id']] = $field_value;
                                }
                                break;
                        }
                    }
                    if(count($fat_cmb_section_value)>0){
                        update_term_meta($term_id, $meta_box['id'], $fat_cmb_section_value);
                    }
                }
            }
        }
    }

    if (!function_exists('fat_cmb_load')) {
        function fat_cmb_load()
        {
            new FAT_Cmb();
        }

        add_action('wp_loaded', 'fat_cmb_load');
    }
}