/**
 * Created by roninwp on 3/3/2017.
 */
jQuery(function ($) {
    'use strict';

    function Fat_cmb_repeat_add_field() {
        $('.fat-cmb-repeat-wrap').each(function () {
            var $this = $(this);
            $('a.fat-cmb-repeat-add', $this).off('click').on('click', function () {
                FatCmbUtil.showLoading('Add new field');
                setTimeout(function () {
                    $('select.fat-cmb-select', $this).each(function () {
                        if ($(this)[0].selectize) {
                            var value = $(this).val();
                            $(this)[0].selectize.destroy();
                            $(this).val(value);
                        }
                    });

                    if (typeof Fat_Cmb_Google_Font != 'undefined') {
                        Fat_Cmb_Google_Font.fat_cmb_google_font_destroy_selectize_clone($this);
                    }

                    var $field_group = $('.fat-cmb-repeat-field-group:last', $this).clone(true),
                        $total_group = $('.fat-cmb-repeat-field-group', $this).length,
                        $input_color;

                    if ($('.fat-cmb-date-ranger-wrap', $field_group).length > 0) {
                        $field_group = $field_group.clone(false);
                    }

                    Fat_cmb_repeat_reset_field($field_group);
                    Fat_cmb_re_index_field_group($field_group, $total_group);

                    $('.fat-cmb-color-wrap', $field_group).each(function () {
                        $input_color = $('.fat-cmb-color-picker', this).clone();
                        $('.fat-cmb-field', this).empty();
                        $('.fat-cmb-field', this).append($input_color);
                        $($input_color).wpColorPicker();
                    });

                    if($('.fat-cmb-date-ranger', $field_group).length){
                        if ($.isFunction($.fn.daterangepicker)) {
                            var field = $('.fat-cmb-date-ranger', $field_group),
                                field_container = field.closest('.fat-cmb-field'),
                                locale = typeof field.attr('data-locale') != 'undefined' && field.attr('data-locale') != '' ? field.attr('data-locale') : '',
                                start_date = field.attr('data-start-init'),
                                end_date = field.attr('data-end-init'),
                                date_format = field.attr('data-date-format');

                            date_format = date_format.replace('M', 'MMM');
                            date_format = date_format.replace('F', 'MMMM');
                            date_format = date_format.replace('m', 'MM');
                            date_format = date_format.replace('n', 'M');
                            date_format = date_format.replace('jS', 'DD');
                            date_format = date_format.replace('j', 'D');
                            date_format = date_format.replace('d', 'DD');
                            date_format = date_format.replace('s', 'Mo');
                            date_format = date_format.replace('Y', 'YYYY');

                            var options = {
                                autoUpdateInput: true,
                                autoApply: true,
                                locale: {
                                    format: date_format,
                                    /*  applyLabel: FatSbMain.data.apply_title,
                                      cancelLabel: FatSbMain.data.cancel_title,
                                      fromLabel: FatSbMain.data.from_title,
                                      toLabel: FatSbMain.data.to_title,
                                      daysOfWeek: FatSbMain.data.day_of_week,
                                      monthNames: FatSbMain.data.month_name*/
                                }
                            };
                            if (locale != '') {
                                moment.locale(locale);
                            }
                            if (typeof start_date != 'undefined' && start_date != '') {
                                options.startDate = start_date;
                            }
                            if (typeof end_date != 'undefined' && end_date != '') {
                                options.endDate = end_date;
                            }
                            field.daterangepicker(options);

                            field.daterangepicker(options, function (start, end, label) {
                                $('input[type="hidden"]',field_container).val(start.format('YYYY-MM-DD')+ ';' + end.format('YYYY-MM-DD'));
                                field.attr('data-start', start.format('YYYY-MM-DD'));
                                field.attr('data-end', end.format('YYYY-MM-DD'));
                            });
                        }
                    }


                    $field_group.insertBefore($('.fat-cmb-repeat-button-group', $this));

                    $('select.fat-cmb-select', $this).selectize({
                        plugins: ['remove_button', 'drag_drop'],
                        searchField: 'text',
                        delimiter: ',',
                        persist: false
                    });

                    if ($.isFunction($.fn.fat_datetimepicker)) {
                        $('input.fat-cmb-datetime-picker', '.fat-cmb-date-wrap').each(function () {
                            var $self = $(this),
                                $date_picker = $self.attr('data-date-picker'),
                                $time_picker = $self.attr('data-time-picker'),
                                $locale = $self.attr('data-locale'),
                                $date_format = $self.attr('data-date-format');

                            $date_picker = typeof $date_picker != 'undefined' && $date_picker == '1';
                            $time_picker = typeof $time_picker != 'undefined' && $time_picker == '1';
                            $date_format = $time_picker ? $date_format + ' H:i' : $date_format;
                            $self.fat_datetimepicker('destroy');
                            $self.fat_datetimepicker({
                                datepicker: $date_picker,
                                timepicker: $time_picker,
                                format: $date_format
                            });
                            $.datetimepicker.setLocale($locale);
                        });
                    }

                    $('.fat-cmb-select', $this).css('opacity', 1);

                    if (typeof Fat_Cmb_Google_Font != 'undefined') {
                        Fat_Cmb_Google_Font.fat_cmb_google_font_init_selectize_clone($this);
                    }

                    $(document).trigger('refresh_depend_field');

                    Fat_cmb_repeat_remove();

                    FatCmbUtil.closeLoading(0);
                }, 100);
            });
        })
    }

    function Fat_cmb_repeat_remove() {
        $('.fat-cmb-repeat-wrap').each(function () {
            var $this = $(this);
            $('a.fat-cmb-repeat-remove', $this).off('click').on('click', function () {
                var $groups = $('.fat-cmb-repeat-field-group', $this).length,
                    $field_group = $(this).closest('.fat-cmb-repeat-field-group'),
                    $repeat_wrap = $(this).closest('.fat-cmb-repeat-wrap');

                if($.isFunction($.confirm)){
                    var confirm_title = typeof($repeat_wrap.attr('data-confirm-title') !='undefined') ? $repeat_wrap.attr('data-confirm-title') :  'Confirm delete !';
                    var confirm_message = typeof($repeat_wrap.attr('data-confirm-message') !='undefined') ? $repeat_wrap.attr('data-confirm-message') :  'Please confirm delete item !';
                    $.confirm({
                        title: confirm_title,
                        content: confirm_message,
                        buttons: {
                            confirm: function () {
                                if ($groups > 1) {
                                    $field_group.remove();
                                } else {
                                    Fat_cmb_repeat_reset_field($field_group);
                                }
                                Fat_cmb_repeat_re_index($repeat_wrap);
                            },
                            cancel: function () {
                            },
                        }
                    });
                }else{
                    if ($groups > 1) {
                        $field_group.remove();
                    } else {
                        Fat_cmb_repeat_reset_field($field_group);
                    }
                    Fat_cmb_repeat_re_index($repeat_wrap);
                }
            });

            $('a.fat-cmb-repeat-remove-all', $this).off('click').on('click', function () {
                $('.fat-cmb-repeat-field-group:not(:first-child)', $this).remove();
                Fat_cmb_repeat_reset_field($('.fat-cmb-repeat-field-group', $this));
            });
        })
    }

    function Fat_cmb_repeat_reset_field($field_group) {
        $('input[type="text"], input[type="number"],input[type="hidden"]', $field_group).each(function () {
            if ($(this).attr('data-guid') == 1) {
                var guid = Fat_cmb_guid();
                $(this).attr('data-std', guid);
                $(this).val(guid);
            } else {
                var $std = $(this).attr('data-std');
                console.log($std);
                $std = typeof $std != 'undefined' ? $std : '';
                $(this).val($std);
            }
        });
        $('input[type="checkbox"], input[type="radio"]', $field_group).each(function () {
            var $std = $(this).attr('data-std');
            $std = typeof $std != 'undefined' ? $std : '0';
            if ($std == '1') {
                $(this).attr('checked', 'checked');
            } else {
                $(this).removeAttr('checked');
            }
        });

        //remove for single image
        $('.fat-image-thumb', $field_group).remove();

    }

    function Fat_cmb_repeat_re_index($repeat_wrap) {
        var $index = 0;
        $('.fat-cmb-repeat-field-group', $repeat_wrap).each(function () {
            var pattern = /\[\d+\]/ig;
            $('select, input[type="radio"], input[type="checkbox"], input.fat-cmb-datetime-picker', this).each(function () {
                var $name = $(this).attr('name');
                if (typeof $name != 'undefined') {
                    $name = $name.replace(pattern, '[' + $index + ']');
                    $(this).attr('name', $name);
                }
            });
            $index++;
        })
    }

    function Fat_cmb_re_index_field_group($field_group, $index) {
        var pattern = /\[\d+\]/ig;
        $('select, textarea, input[type="text"], input[type="radio"], input[type="checkbox"], input[type="hidden"], input[type="number"]', $field_group).each(function () {
            var $name = $(this).attr('name');
            if (typeof $name != 'undefined') {
                $name = $name.replace(pattern, '[' + $index + ']');
                $(this).attr('name', $name);
            }
        });
    }

    function Fat_cmb_repeat_register_event() {
        Fat_cmb_repeat_add_field();
        Fat_cmb_repeat_remove();
    }

    function Fat_cmb_guid() {
        function s4() {
            return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
        }

        return s4() + s4() + s4();
    }

    $(document).ready(function () {
        Fat_cmb_repeat_register_event();
    });
});