'use strict';
jQuery(function ($) {
    $(document).ready(function () {
        $('.fat-cmb-mapbox-wrap').each(function(){
            var container = $(this);
            if(typeof mapboxgl !='undefined'){
                var elm_map = $('.fat-mapbox',container),
                    access_token = elm_map.attr('data-access-token'),
                    latitude_x = elm_map.attr('data-latitude-x'),
                    latitude_y = elm_map.attr('data-latitude-y'),
                    zoom = elm_map.attr('data-zoom');

                latitude_x = typeof latitude_x!='undefined' && latitude_x!='' ? latitude_x : -79.4512;
                latitude_y = typeof latitude_y!='undefined' && latitude_y!='' ? latitude_y : 43.6568;

                mapboxgl.accessToken = access_token;
                var map = new mapboxgl.Map({
                    container: elm_map.attr('id'),
                    style: 'mapbox://styles/mapbox/streets-v11',
                    center: [latitude_x, latitude_y],
                    zoom: zoom
                });

                var marker = new mapboxgl.Marker({
                    draggable: true
                }).setLngLat([latitude_x, latitude_y]).addTo(map);

                marker.on('dragend', function(){
                    var lngLat = marker.getLngLat();
                    $('input.fat-mapbox-location',container).val(lngLat.lng+',' + lngLat.lat);
                });

                var geocoder = new MapboxGeocoder({
                    accessToken: mapboxgl.accessToken,
                    mapboxgl: mapboxgl,
                    marker: false
                });

                map.addControl(geocoder);
                map.on('load', function() {
                    geocoder.on('result', function(ev) {
                        var coordinates = ev.result.geometry.coordinates;
                        if(coordinates.length ==2){
                            var marker = new mapboxgl.Marker({
                                draggable: true
                            }).setLngLat([coordinates[0], coordinates[1]]).addTo(map);

                            marker.on('dragend', function(){
                                var lngLat = marker.getLngLat();
                                $('input.fat-mapbox-location',container).val(lngLat.lng+',' + lngLat.lat);
                            });

                            $('input.fat-mapbox-location',container).val(coordinates[0] +',' + coordinates[1]);
                        }
                    });
                   /* geocoder.options.marker.on('dragend', function(){
                        var lngLat = marker.getLngLat();
                        console.log(lngLat);
                        $('input.fat-mapbox-location',container).val(lngLat.lng+',' + lngLat.lat);
                    });*/
                });

                /*map.on('click', function (e) {
                    //clear current marker
                    if (map_markers!==null) {
                        for (var i = map_markers.length - 1; i >= 0; i--) {
                            map_markers[i].remove();
                        }
                    }
                    var marker = new mapboxgl.Marker({
                        draggable: true
                    }).setLngLat([e.lngLat.lng, e.lngLat.lat]).addTo(map);

                    map_markers.push(marker);
                });*/
            }
        });
    });
});