"use strict";
function fat_google_map_init(){
    jQuery('.fat-cmb-google-map-wrap').each(function(){
        var map_wrap = jQuery(this),
            map = jQuery('.fat-google-map',map_wrap),
            latitude_X = map.attr('data-latitude-x'),
            latitude_Y = map.attr('data-latitude-y'),
            map_type = map.attr('data-map-type'),
            zoom = 15,
            search = jQuery('input.search-box', map_wrap),
            input_location = jQuery('.fat-google-map-location',map_wrap);

        var mapCenter = new google.maps.LatLng(
            latitude_X =='' ? 51.491676 : latitude_X,
            latitude_Y=='' ? -0.167660 : latitude_Y
        );

        var google_map = new google.maps.Map(map[0], {
            center: mapCenter,
            zoom: zoom,
            mapTypeId: map_type
        });

        google.maps.event.addDomListener(window, "resize", function() {
            var center = google_map.getCenter();
            google.maps.event.trigger(map, "resize");
            google_map.setCenter(center);
        });

        if(latitude_X!='' && latitude_Y!=''){
            var map_marker = new google.maps.Marker({
                position: new google.maps.LatLng(latitude_X, latitude_Y),
                draggable:true,
                animation: google.maps.Animation.DROP
            });
            map_marker.setMap(google_map);

            google.maps.event.addListener(map_marker, 'dragend', function(map_marker){
                var latLng = map_marker.latLng;
                input_location.val(latLng.lat() + ',' + latLng.lng());
            });
        }

        search = search[0];
        var searchBox = new google.maps.places.SearchBox(search);
        google_map.controls[google.maps.ControlPosition.TOP_LEFT].push(search);

        // Bias the SearchBox results towards current map's viewport.
        google_map.addListener('bounds_changed', function() {
            searchBox.setBounds(google_map.getBounds());
        });

        var markers = [];

        // Listen for the event fired when the user selects a prediction and retrieve
        // more details for that place.
        searchBox.addListener('places_changed', function() {
            var places = searchBox.getPlaces();

            if (places.length == 0) {
                return;
            }

            // Clear out the old markers.
            markers.forEach(function(marker) {
                marker.setMap(null);
            });
            markers = [];

            // For each place, get the icon, name and location.
            var bounds = new google.maps.LatLngBounds();
            places.forEach(function(place) {
                if (!place.geometry) {
                    console.log("Returned place contains no geometry");
                    return;
                }
                var icon = {
                    size: new google.maps.Size(71, 71),
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(17, 34),
                    scaledSize: new google.maps.Size(25, 25)
                };

                // Create a marker for each place.
                var new_marker = new google.maps.Marker({
                    map: google_map,
                    icon: icon,
                    title: place.name,
                    draggable:true,
                    animation: google.maps.Animation.DROP,
                    position: place.geometry.location
                });
                markers.push(new_marker);

                google.maps.event.addListener(new_marker, 'dragend', function(new_marker){
                    var latLng = new_marker.latLng;
                    input_location.val(latLng.lat() + ',' + latLng.lng());
                });

                if (place.geometry.viewport) {
                    // Only geocodes have viewport.
                    bounds.union(place.geometry.viewport);
                } else {
                    bounds.extend(place.geometry.location);
                }
                input_location.val(place.geometry.location.lat() + ',' + place.geometry.location.lng());
            });

            google_map.fitBounds(bounds);
        });

    })
}