jQuery(function ($) {
    'use strict';
    $(document).ready(function () {
        if ($.isFunction($.fn.fat_datetimepicker)) {
            $('input.fat-cmb-datetime-picker', '.fat-cmb-date-wrap').each(function () {
                var $self = $(this),
                    $date_picker = $self.attr('data-date-picker'),
                    $time_picker = $self.attr('data-time-picker'),
                    $locale = $self.attr('data-locale'),
                    $date_format = $self.attr('data-date-format');

                $date_picker = typeof $date_picker != 'undefined' && $date_picker == '1';
                $time_picker = typeof $time_picker != 'undefined' && $time_picker == '1';
                if($.isFunction($.fn.datetimepicker)){
                    $self.datetimepicker('destroy');
                }
                if($time_picker){
                    $self.fat_datetimepicker({
                        datepicker: $date_picker,
                        timepicker: $time_picker,
                        formatDate: $date_format,
                        formatTime: 'H:i'
                    });
                }else{
                    $self.fat_datetimepicker({
                        datepicker: $date_picker,
                        timepicker: false,
                        format: $date_format,
                    });
                }
                $.datetimepicker.setLocale($locale);
            });
        }else{
            console.log('datetimepicker not exitst');
        }
    });
});
