jQuery(function ($) {
    'use strict';
    $(document).ready(function () {
        if ($.isFunction($.fn.daterangepicker)) {
            $('input.fat-cmb-date-ranger', '.fat-cmb-date-ranger-wrap').each(function () {
                var self = $(this),
                    field_container = self.closest('.fat-cmb-field'),
                    locale = typeof self.attr('data-locale') != 'undefined' && self.attr('data-locale') != '' ? self.attr('data-locale') : '',
                    start_date = self.attr('data-start-init'),
                    end_date = self.attr('data-end-init'),
                    date_format = self.attr('data-date-format');

                date_format = date_format.replace('M', 'MMM');
                date_format = date_format.replace('F', 'MMMM');
                date_format = date_format.replace('m', 'MM');
                date_format = date_format.replace('n', 'M');
                date_format = date_format.replace('jS', 'DD');
                date_format = date_format.replace('j', 'D');
                date_format = date_format.replace('d', 'DD');
                date_format = date_format.replace('s', 'Mo');
                date_format = date_format.replace('Y', 'YYYY');

                var options = {
                    autoUpdateInput: true,
                    autoApply: true,
                    locale: {
                        format: date_format,
                        /*  applyLabel: FatSbMain.data.apply_title,
                          cancelLabel: FatSbMain.data.cancel_title,
                          fromLabel: FatSbMain.data.from_title,
                          toLabel: FatSbMain.data.to_title,
                          daysOfWeek: FatSbMain.data.day_of_week,
                          monthNames: FatSbMain.data.month_name*/
                    }
                };

                if (locale != '') {
                    moment.locale(locale);
                }
                if (typeof start_date != 'undefined' && start_date != '') {
                    options.startDate = start_date;
                }
                if (typeof end_date != 'undefined' && end_date != '') {
                    options.endDate = end_date;
                }

                self.daterangepicker(options, function (start, end, label) {
                    $('input[type="hidden"]',field_container).val(start.format('YYYY-MM-DD')+ ';' + end.format('YYYY-MM-DD'));
                    self.attr('data-start', start.format('YYYY-MM-DD'));
                    self.attr('data-end', end.format('YYYY-MM-DD'));
                });
                if(typeof start_date=='undefined' || start_date=='' || typeof end_date=='undefined' || end_date==''){
                    self.val('');
                }

            });
        } else {
            console.log('date ranger not exitst');
        }
    });
});