<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 11/22/2018
 * Time: 8:55 AM
 */
if (!defined('ABSPATH')) die('-1');
if (!class_exists('FAT_Event_WC_Integrated')) {
    class FAT_Event_WC_Integrated
    {
        private static $instance = NULL;

        function __construct()
        {

        }

        function init()
        {
            //add product if not exists
            if (is_admin()) {
                add_filter('parse_query', array($this, 'hide_product_event_in_query'));
                add_action('delete_post', array($this, 'delete_product'));
                add_filter('wp_count_posts', array($this,'wp_count_posts'), 10, 3);
            }

            add_action('woocommerce_after_cart_item_name', array($this, 'wc_cart_item_name'), 100, 2);


            /** override check is product purchaseable */
            add_filter('woocommerce_is_purchasable', array($this,'wc_is_purchasable'), 100, 2);

            //set maximum for quantity in cart page
            add_filter('woocommerce_cart_item_quantity', array($this, 'woocommerce_cart_item_quantity'), 100, 3);

            //add hidden field for start, end date, ticket class for checkout page
            add_filter('woocommerce_checkout_cart_item_quantity', array($this, 'woocommerce_checkout_cart_item_quantity'), 100, 3);

            add_action('woocommerce_checkout_update_order_meta', array($this, 'woocommerce_checkout_update_order_meta'), 100, 2);

            add_filter('woocommerce_cart_item_name', array($this, 'woocommerce_cart_item_name'), 100, 3);

            add_action('woocommerce_display_item_meta', array($this, 'woocommerce_display_item_meta'), 100, 3);

            add_filter('woocommerce_hidden_order_itemmeta', array($this, 'woocommerce_hidden_order_itemmeta'));

            /** Update boat price in cart and checkout page */
            add_action('woocommerce_before_calculate_totals', array($this, 'wc_before_calculate_totals'), 200, 1);

            /** fix subtotal and total for fees type is package */
            add_filter('woocommerce_cart_product_subtotal', array($this, 'woocommerce_cart_product_subtotal'), 100, 4);

            add_action('woocommerce_checkout_order_processed', array($this, 'woocommerce_checkout_order_processed'), 100, 3);

            add_action('woocommerce_thankyou', array($this, 'woocommerce_send_mail_notification'), 100, 1);

            add_filter('woocommerce_payment_complete', array($this,'woocommerce_send_mail_notification', 100, 1));

            add_action('woocommerce_product_query', array($this, 'custom_pre_get_posts_query'), 90, 1);

            add_filter('woocommerce_coupon_get_apply_quantity', array($this,'woocommerce_coupon_get_apply_quantity'),100, 4);
        }

        function wc_is_purchasable($is_purchasable, $product){
            if(!$is_purchasable){
                global $wpdb;
                $event_id = get_post_meta($product->get_id(),'_event_id', true);
                $is_purchasable = $event_id ? 1 : 0;
            }
            return $is_purchasable;
        }

        function get_terms_args_exclude($args, $taxonomies)
        {
            if (is_shop()) {
                global $wpdb;
                $sql = "SELECT term_id FROM {$wpdb->prefix}terms WHERE slug=%s";
                $sql = $wpdb->prepare($sql, 'fat-event');
                $cat = $wpdb->get_results($sql);
                if (count($cat) > 0 && isset($cat[0]->term_id)) {
                    $args['exclude'] = $cat[0]->term_id;
                }
            }
            return $args;
        }

        function custom_pre_get_posts_query($q)
        {
            if (is_shop()) {
                $tax_query = (array)$q->get('tax_query');
                $tax_query[] = array(
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => array('fat-event'),
                    'operator' => 'NOT IN'
                );
                $q->set('tax_query', $tax_query);
            }
        }

        function delete_product($post_id)
        {
            $post_type = get_post_type($post_id);
            if ($post_type === FAT_EVENT_POST_TYPE) {
                $products = get_posts(array(
                    'post_type' => 'product',
                    'meta_key' => '_event_id',
                    'meta_value' => $post_id
                ));
                if (is_array($products) && count($products) > 0) {
                    wp_delete_post($products[0]->ID);
                }
            }
        }

        function wc_before_calculate_totals($cart_obj)
        {
            $event_id = 0;
            $fees_type = '';
            $price = 0;
            $product_id = 0;
            foreach ($cart_obj->get_cart() as $cart_item) {
                if ($cart_item['product_id']) {
                    $event_id = get_post_meta($cart_item['product_id'], '_event_id', true);
                    if($event_id){
                        $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                        $fees_type = isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed';
                        $price = isset($event_detail['fees']) && $fees_type == 'fixed' && $event_detail['fees'] ? $event_detail['fees'] : 0;
                        $quantity = isset($cart_item['quantity']) && $cart_item['quantity'] ? $cart_item['quantity'] : 1;

                        if ($fees_type == 'ticket_class' && isset($cart_item['class_id'])) {
                            $ticket_class = isset($event_detail['ticket_class']) && $event_detail['ticket_class'] ? $event_detail['ticket_class'] : array();
                            for ($i = 0; $i < count($ticket_class['class']); $i++) {
                                if ($ticket_class['class_id'][$i] == $cart_item['class_id']) {
                                    $price = $ticket_class['fees'][$i];
                                }
                            }
                        }

                        if ($fees_type == 'package') {
                            $fees_package = isset($event_detail['fees_package']) ? $event_detail['fees_package'] : array();
                            $default_price = 0;
                            $price = 0;
                            for ($i = 0; $i < count($fees_package['quantity']); $i++) {
                                if ($fees_package['quantity'][$i] == '1') {
                                    $default_price = $fees_package['fees'][$i];
                                }
                                if ($fees_package['quantity'][$i] == $quantity) {
                                    $price = $fees_package['fees'][$i];
                                }
                            }
                            $price = $price ? $price : $default_price;
                        }
                        $cart_item['data']->set_price($price);
                    }
                }
            }
        }

        function woocommerce_coupon_get_apply_quantity($apply_quantity, $item, $coupon, $wc_discounts){
            if($item->object['fees_type']){
                $apply_quantity = 1;
            }
            return $apply_quantity;
        }

        function woocommerce_cart_product_subtotal($product_subtotal, $product, $quantity, $wc_cart)
        {
            $product_id = $product->get_id();
            if($product_id){
                $event_id = get_post_meta($product_id, '_event_id', true);
                if($event_id){
                    $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                    $fees_type = isset($event_detail['fees_type']) && $event_detail['fees_type'] ? $event_detail['fees_type'] : 'fixed';
                    if ($fees_type == 'package') {
                        $fees_package = isset($event_detail['fees_package']) ? $event_detail['fees_package'] : array();
                        $default_price = 0;
                        for ($i = 0; $i < count($fees_package['quantity']); $i++) {
                            if ($fees_package['quantity'][$i] == '1') {
                                $default_price = $fees_package['fees'][$i];
                            }
                            if ($fees_package['quantity'][$i] == $quantity) {
                                $wc_cart->set_subtotal($fees_package['fees'][$i]);

                                $discount = $wc_cart->get_discount_total();
                                $total = floatval($fees_package['fees'][$i]) - $discount;
                                $wc_cart->set_total($total);
                                return wc_price($fees_package['fees'][$i]);
                            }
                        }
                        $product_subtotal = $default_price * $quantity;
                    }
                }
            }
            return $product_subtotal;
        }

        function woocommerce_cart_item_quantity($product_quantity, $cart_item_key, $cart_item)
        {
            if (isset($cart_item['number_ticket'])) {
                $_product = wc_get_product($cart_item['product_id']);
                $product_quantity = woocommerce_quantity_input(array(
                    'input_name' => "cart[{$cart_item_key}][qty]",
                    'input_value' => $cart_item['quantity'],
                    'max_value' => $cart_item['number_ticket'],
                    'min_value' => 1,
                    'product_name' => $_product->get_name(),
                ), $_product, false);
            }
            return $product_quantity;
        }

        function woocommerce_checkout_update_order_meta($order_id, $data)
        {
            $order = wc_get_order($order_id);
            $items = $order->get_items();
            $product_id = $order_item_id = 0;
            foreach ($items as $item) {
                $order_item_id = $item->get_id();
                $product_id = wc_get_order_item_meta($order_item_id, '_product_id', true);
                $item_meta = $this->get_cart_item_meta($product_id);

                if (isset($item_meta['start_date'])) {
                    wc_update_order_item_meta($order_item_id, 'start_date', $item_meta['start_date']);
                }
                if (isset($item_meta['s_date'])) {
                    wc_update_order_item_meta($order_item_id, 's_date', $item_meta['s_date']);
                }
                if (isset($item_meta['end_date'])) {
                    wc_update_order_item_meta($order_item_id, 'end_date', $item_meta['end_date']);
                }
                if (isset($item_meta['e_date'])) {
                    wc_update_order_item_meta($order_item_id, 'e_date', $item_meta['e_date']);
                }
                if (isset($item_meta['class_id'])) {
                    wc_update_order_item_meta($order_item_id, 'class_id', $item_meta['class_id']);
                }
                if (isset($item_meta['class_name'])) {
                    wc_update_order_item_meta($order_item_id, 'class_name', $item_meta['class_name']);
                }
            }
        }

        function wc_cart_item_name($cart_item, $cart_item_key)
        {
            if (isset($cart_item['start_date']) && isset($cart_item['s_date'])) {
                echo '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('Start date: ', 'fat-event') . '</span>' . $cart_item['start_date'] .
                    '<input type="hidden" name="start_date' . $cart_item['product_id'] . '" id="start_date' . $cart_item['product_id'] . '" value="' . $cart_item['start_date'] . '">' .
                    '<input type="hidden" name="s_date' . $cart_item['product_id'] . '" id="s_date' . $cart_item['product_id'] . '" value="' . $cart_item['s_date'] . '">' .
                    '</div>';
            }
            if (isset($cart_item['end_date']) && isset($cart_item['e_date'])) {
                echo '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('End date: ', 'fat-event') . '</span>' . $cart_item['end_date'] .
                    '<input type="hidden" name="end_date' . $cart_item['product_id'] . '" id="end_date' . $cart_item['product_id'] . '" value="' . $cart_item['end_date'] . '">' .
                    '<input type="hidden" name="e_date' . $cart_item['product_id'] . '" id="e_date' . $cart_item['product_id'] . '" value="' . $cart_item['e_date'] . '">' .
                    '</div>';
            }

            if (isset($cart_item['class_id']) && $cart_item['class_id'] && isset($cart_item['class_name']) && $cart_item['class_name']) {
                echo '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('Ticket class: ', 'fat-event') . '</span>' . $cart_item['class_name'] .
                    '<input type="hidden" name="class_id' . $cart_item['product_id'] . '" id="class_id' . $cart_item['product_id'] . '" value="' . $cart_item['class_id'] . '">' .
                    '<input type="hidden" name="class_name' . $cart_item['product_id'] . '" id="class_name' . $cart_item['product_id'] . '" value="' . $cart_item['class_name'] . '">' .
                    '</div>';
            }
        }

        function woocommerce_checkout_cart_item_quantity($quantity, $cart_item, $cart_item_key)
        {
            if (isset($cart_item['start_date']) && isset($cart_item['s_date'])) {
                $quantity .= '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('Start date: ', 'fat-event') . '</span>' . $cart_item['start_date'] .
                    '<input type="hidden" name="start_date' . $cart_item['product_id'] . '" id="start_date' . $cart_item['product_id'] . '" value="' . $cart_item['start_date'] . '">' .
                    '<input type="hidden" name="s_date' . $cart_item['product_id'] . '" id="s_date' . $cart_item['product_id'] . '" value="' . $cart_item['s_date'] . '">' .
                    '</div>';
            }
            if (isset($cart_item['end_date']) && isset($cart_item['e_date'])) {
                $quantity .= '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('End date: ', 'fat-event') . '</span>' . $cart_item['end_date'] .
                    '<input type="hidden" name="end_date' . $cart_item['product_id'] . '" id="end_date' . $cart_item['product_id'] . '" value="' . $cart_item['end_date'] . '">' .
                    '<input type="hidden" name="e_date' . $cart_item['product_id'] . '" id="e_date' . $cart_item['product_id'] . '" value="' . $cart_item['e_date'] . '">' .
                    '</div>';
            }
            if (isset($cart_item['class_id']) && $cart_item['class_id'] && isset($cart_item['class_name']) && $cart_item['class_name']) {
                $quantity .= '<div class="product-event-meta" style="font-size: 0.8em; color: #7d7d7d;line-height: 1.3em"><span style="font-weight: 600">' .
                    esc_html__('Ticket class: ', 'fat-event') . '</span>' . $cart_item['class_name'] .
                    '<input type="hidden" name="class_id' . $cart_item['product_id'] . '" id="class_id' . $cart_item['product_id'] . '" value="' . $cart_item['class_id'] . '">' .
                    '<input type="hidden" name="class_name' . $cart_item['product_id'] . '" id="class_name' . $cart_item['product_id'] . '" value="' . $cart_item['class_name'] . '">' .
                    '</div>';
            }

            return $quantity;
        }

        function woocommerce_cart_item_name($permalink, $cart_item, $cart_item_key)
        {
            if (isset($cart_item['product_id']) && isset($cart_item['s_date'])) {
                $product = wc_get_product($cart_item['product_id']);
                $event_id = get_post_meta($cart_item['product_id'], '_event_id', true);
                if ($event_id) {
                    $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                    if ($event_detail['link_detail']) {
                        $permalink = $event_detail['link_detail'];
                    } else {
                        $permalink = get_permalink($event_id);
                        $permalink = add_query_arg(array('sd' => $cart_item['s_date'], 'ed' => $cart_item['e_date']), $permalink);
                    }
                    $permalink = sprintf('<a href="%s">%s</a>', esc_url($permalink), $product->get_name());
                }
            }
            return $permalink;
        }

        function woocommerce_display_item_meta($html, $item, $args)
        {
            $is_event_order = 0;
            foreach ($item->get_formatted_meta_data() as $meta_id => $meta) {
                if ($meta->display_key == 'start_date') {
                    $is_event_order = 1;
                    break;
                }
            }
            if ($is_event_order) {
                $strings = array();
                $html = '';
                $args = wp_parse_args($args, array(
                    'before' => '<ul class="wc-item-meta"><li>',
                    'after' => '</li></ul>',
                    'separator' => '</li><li>',
                    'echo' => true,
                    'autop' => false,
                    'label_before' => '<strong class="wc-item-meta-label">',
                    'label_after' => ':</strong> ',
                ));
                foreach ($item->get_formatted_meta_data() as $meta_id => $meta) {
                    if ($meta->display_key !== 's_date' && $meta->display_key !== 'e_date') {
                        $value = $args['autop'] ? wp_kses_post($meta->display_value) : wp_kses_post(make_clickable(trim($meta->display_value)));
                        if ($meta->display_key == 'start_date') {
                            $strings[] = $args['label_before'] . esc_html__('Start Date', 'fat-event') . $args['label_after'] . $value;
                        }
                        if ($meta->display_key == 'end_date') {
                            $strings[] = $args['label_before'] . esc_html__('End Date', 'fat-event') . $args['label_after'] . $value;
                        }
                        if ($meta->display_key == 'class_name') {
                            $strings[] = $args['label_before'] . esc_html__('Ticket class', 'fat-event') . $args['label_after'] . $value;
                        }
                    }
                }

                if ($strings) {
                    $html = $args['before'] . implode($args['separator'], $strings) . $args['after'];
                }
            }
            return $html;
        }

        function woocommerce_hidden_order_itemmeta($item_meta)
        {
            $item_meta[] = 's_date';
            $item_meta[] = 'e_date';
            return $item_meta;
        }

        function woocommerce_checkout_order_processed($order_id, $posted_data, $order)
        {
            global $wpdb;
            $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_value=%d";
            $sql = $wpdb->prepare($sql, $order_id);
            $post_meta = $wpdb->get_results($sql);
            if(is_countable($post_meta) && count($post_meta)>0){
                error_log($order_id. ' has been added for another reservation');
                return;
            }

            $items = $order->get_items();
            $firstName = $order->get_billing_first_name();
            $lastName = $order->get_billing_last_name();
            $address = $order->get_billing_address_1();
            $address = $address == '' ? $order->get_billing_address_2() : $address;
            $email = $order->get_billing_email();
            $phone = $order->get_billing_phone();
            $company = $order->get_billing_company();
            $country = $order->get_billing_country();
            $event_id = $product_id = $booking_id = $quantity = $fees = $num_book = 0;
            $event = $post = $product = null;
            $confirm_attention = uniqid();
            $start_date = $end_date = $booking_id = 0;
            $order_detail = $currency_symbol = '';
            $currency_symbol = $order->get_currency();
            $currency_symbol = get_woocommerce_currency_symbol($currency_symbol);
            $ticket_class_name = $ticket_class_id = $fees_type = '';
            $seats = 0;

            $date_format = get_option('date_format');
            $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;

            $coupons = 0;
            if (count($order->get_used_coupons()) > 0) {
                foreach ($order->get_used_coupons() as $code) {
                    $coupon_post_obj = get_page_by_title($code, OBJECT, 'shop_coupon');
                    $coupon_id = $coupon_post_obj->ID;
                    $coupons_obj = new WC_Coupon($coupon_id);
                    $coupons += $coupons_obj->get_amount();
                }
            }

            foreach ($items as $item_id => $item) {
                $product_id = $item->get_product_id();
                $product = wc_get_product($product_id);
                $fees = $product->get_price();
                $quantity = $item->get_quantity();

                $event_id = get_post_meta($product_id, '_event_id', true);
                if ($event_id) {
                    $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                    $start_date = wc_get_order_item_meta($item_id, 's_date', true);
                    $end_date = wc_get_order_item_meta($item_id, 'e_date', true);
                    $ticket_class_name = wc_get_order_item_meta($item_id, 'class_name', true);
                    $ticket_class_id = wc_get_order_item_meta($item_id, 'class_id', true);
                    $fees_type = isset($event_detail['fees']) && $event_detail['fees'] ? $event_detail['fees'] : 'fixed';

                    $num_book = 0;
                    $num_of_book_key = 'num_of_book_';
                    if ($start_date != '' && $end_date != '') {
                        $num_of_book_key .= $start_date . '_' . $end_date;
                        $num_book = get_post_meta($event_id, $num_of_book_key, true);
                        $num_book = isset($num_book) && $num_book ? $num_book : 0;
                    }

                    if ($event_detail['fees_type'] == 'ticket_class') {
                        $is_exists_fees = false;
                        error_log(serialize($event_detail['ticket_class']));
                        error_log('item_id:'.$item_id);
                        error_log('start_date:'.$start_date);
                        error_log('ticket_class_name:'.$ticket_class_name);
                        error_log('ticket class id:'.$ticket_class_id);
                        if (isset($event_detail['ticket_class']) && is_array($event_detail['ticket_class'])) {
                            for ($i = 0; $i < count($event_detail['ticket_class']['class']); $i++) {
                                if ($event_detail['ticket_class']['class_id'][$i] == $ticket_class_id) {
                                    $fees = $event_detail['ticket_class']['fees'][$i];
                                    $is_exists_fees = true;
                                    $seats = isset($event_detail['ticket_class']['seats'][$i]) && $event_detail['ticket_class']['seats'][$i] ? $event_detail['ticket_class']['seats'][$i] : 0;
                                    $num_of_book_key .= '_' . $ticket_class_id;
                                    break;
                                }
                            }
                        }
                        if (!$is_exists_fees) {
                            $error = esc_html__('The fees package don\'t exists', 'fat-event');
                            throw new Exception($error);
                            return;
                        }


                        $num_book = get_post_meta($event_id, $num_of_book_key, true);
                        $num_book = isset($num_book) && $num_book ? $num_book : 0;

                        if ($seats > 0 && $quantity > ($seats - $num_book)) {
                            $error = esc_html__('The number of tickets is greater than the number of seats available', 'fat-event');
                            throw new Exception($error);
                            return;
                        }
                    }


                    $start_date = $start_date ? DateTime::createFromFormat('U', $start_date) : 0;
                    $end_date = $end_date ? DateTime::createFromFormat('U', $end_date) : 0;
                    if (!$start_date || !$end_date) {
                        return;
                    }

                    $event = get_post($event_id);
                    $post = array(
                        'post_title' => esc_html__('Booking ', 'fat-event') . $event->post_title,
                        'post_status' => 'publish',
                        'post_type' => FAT_EVENT_BOOKING_POST_TYPE
                    );
                    $booking_id = wp_insert_post($post);
                    if ($booking_id > 0) {
                        add_post_meta($booking_id, 'fat-mb-event-booking-detail', array(
                            'event_id' => $event_id,
                            'event_start_date' => $start_date ? $start_date->format($date_format) : '',
                            'event_end_date' => $end_date ? $end_date->format($date_format) : '',
                            'first_name' => $firstName,
                            'last_name' => $lastName,
                            'email' => $email,
                            'phone' => $phone,
                            'address' => $address,
                            'gender' => '',
                            'department' => '',
                            'company' => $company,
                            'country' => $country,
                            'quantity' => $quantity,
                            'price' => $fees,
                            'coupon' => $coupons,
                            'total_price' => $order->get_total(),
                            'payment_type' => 'wocommerce',
                            'payment_title' => $order->get_payment_method(),
                            'note' => '',
                            'process_status' => 'no_process'
                        ));

                        $num_book += $quantity;
                        update_post_meta($event_id, $num_of_book_key, $num_book);
                        add_post_meta($booking_id, 'start_date', $start_date);
                        add_post_meta($booking_id, 'end_date', $end_date);
                        add_post_meta($booking_id, 'email', $email);
                        add_post_meta($booking_id, 'event_id', $event_id);
                        add_post_meta($booking_id, 'order_id', $order_id);
                        add_post_meta($booking_id, 'payment_type', 'woocommerce');
                        add_post_meta($booking_id, 'process_status', 'no_process');
                        add_post_meta($booking_id, 'attention_code', $confirm_attention);
                        add_post_meta($booking_id, 'attention_status', 0);
                        add_post_meta($booking_id, 'ticket_class', $ticket_class_name);
                        add_post_meta($booking_id, 'ticket_class_id', $ticket_class_id);

                        // for compare
                        add_post_meta($booking_id, 'start_date_string', $start_date->format('Y-m-d H:i:s'));
                        add_post_meta($booking_id, 'end_date_string', $end_date->format('Y-m-d H:i:s'));
                    }
                }
            }
        }

        function woocommerce_send_mail_notification($order_id)
        {
            $fat_event_setting = get_option('fat_event_setting');
            if (isset($fat_event_setting['enable_email_notification']) && $fat_event_setting['enable_email_notification'] == '1') {
                $order = wc_get_order($order_id);
                $items = $order->get_items();
                $firstName = $order->get_billing_first_name();
                $lastName = $order->get_billing_last_name();
                $address = $order->get_billing_address_1();
                $address = $address == '' ? $order->get_billing_address_2() : $address;
                $email = $order->get_billing_email();
                $phone = $order->get_billing_phone();
                $company = $order->get_billing_company();
                $country = $order->get_billing_country();
                $event_id = $product_id = $booking_id = $quantity = $fees = $num_book = 0;
                $event = $post = $product = null;

                $start_date = $end_date = $booking_id = 0;
                $order_detail = $currency_symbol = '';
                $currency_symbol = $order->get_currency();
                $currency_symbol = get_woocommerce_currency_symbol($currency_symbol);


                $date_format = get_option('date_format');
                $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;

                ob_start();
                include_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail-start.php';
                $order_detail = ob_get_contents();
                ob_end_clean();

                $coupons = 0;
                if (count($order->get_used_coupons()) > 0) {
                    foreach ($order->get_used_coupons() as $code) {
                        $coupon_post_obj = get_page_by_title($code, OBJECT, 'shop_coupon');
                        if (isset($coupon_post_obj->ID)) {
                            $coupon_id = $coupon_post_obj->ID;
                            $coupons_obj = new WC_Coupon($coupon_id);
                            $coupons += $coupons_obj->get_amount();
                        }
                    }
                }

                foreach ($items as $item_id => $item) {
                    $product_id = $item->get_product_id();
                    $product = wc_get_product($product_id);
                    $fees = $product->get_price();

                    $event_id = get_post_meta($product_id, '_event_id', true);
                    $start_date = wc_get_order_item_meta($item_id, 's_date', true);
                    $end_date = wc_get_order_item_meta($item_id, 'e_date', true);

                    $quantity = $item->get_quantity();

                    if ($event_id) {
                        $start_date = $start_date ? DateTime::createFromFormat('U', $start_date) : 0;
                        $end_date = $end_date ? DateTime::createFromFormat('U', $end_date) : 0;

                        $event = get_post($event_id);

                        ob_start();
                        include untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail-item.php';
                        $order_detail .= ob_get_contents();
                        ob_end_clean();

                        ob_start();
                        include_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/order/order-detail-end.php';
                        $order_detail .= ob_get_contents();
                        ob_end_clean();

                        global $wpdb;
                        $posts = $wpdb->get_results("SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'order_id' AND  meta_value = {$order_id} LIMIT 1");

                        $booking_id = isset($posts[0]) && isset($posts[0]->post_id) ? $posts[0]->post_id : 0;
                        $confirm_attention = get_post_meta($booking_id, 'attention_code', true);
                        error_log('woocommerce_send_mail_notification booking id: '. $booking_id);
                        if ($booking_id > 0) {
                            $has_send = get_post_meta($booking_id, 'has_send', true);
                            error_log('woocommerce_send_mail_notification has send: '. $has_send);
                            if (isset($has_send) && $has_send) {
                                return;
                            }
                            $start_date = $start_date ? $start_date->format($date_format) : '';
                            $end_date = $end_date ? $end_date->format($date_format) : '';

                            $email_subject = isset($fat_event_setting['email_subject']) ? $fat_event_setting['email_subject'] : '';
                            $email_content = isset($fat_event_setting['email_content']) ? $fat_event_setting['email_content'] : '';
                            $cc = isset($fat_event_setting['cc_email']) ? $fat_event_setting['cc_email'] : '';
                            $bcc = isset($fat_event_setting['bcc_email']) ? $fat_event_setting['bcc_email'] : '';
                            $recipients = array(
                                $email => ($firstName . ' ' . $lastName)
                            );

                            $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                            $location_id = isset($event_detail['location']) && $event_detail['location'] ? $event_detail['location'] : 0;
                            $location = '';
                            $location_address = '';
                            if ($location_id) {
                                $location = get_term_by('id', $location_id, FAT_EVENT_LOCATION_TAXONOMY);
                                $location = $location->name;
                                $location_meta = get_term_meta($location_id, 'fat-mb-location-detail', true);
                                $location_address = isset($location_meta['address']) ? $location_meta['address'] : '';
                            }

                            FAT_Event_Utils::send_mail_notification($recipients, $cc, $bcc, $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id, $confirm_attention, $order_detail);

                            //send email to admin and organizer
                            $admin_email = isset($fat_event_setting['admin_email']) ? $fat_event_setting['admin_email'] : '';
                            $admin_name = isset($fat_event_setting['admin_name']) ? $fat_event_setting['admin_name'] : '';
                            $recipients = array(
                                $admin_email => $admin_name
                            );
                            $notifier_to_organizer = isset($fat_event_setting['notifier_to_organizer']) ? $fat_event_setting['notifier_to_organizer'] : '';
                            if ($notifier_to_organizer == '1') {
                                $event_detail = get_post_meta($event_id, 'fat-mb-event-detail', true);
                                $multiple_location = isset($event_detail['multiple_location']) ? $event_detail['multiple_location'] : 'no';
                                if ($multiple_location != 'yes') {
                                    $organizer = isset($event_detail['main_organizer']) ? get_term_by('id', $event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                                    $organizer_detail = get_term_meta($event_detail['main_organizer'], 'fat-mb-organizer-detail', true);
                                    if (isset($organizer_detail['email']) && $organizer_detail['email']) {
                                        $recipients[$organizer_detail['email']] = isset($organizer->name) ? $organizer->name : '';
                                    }
                                }
                            }
                            if ($admin_email != '') {
                                $email_subject = isset($fat_event_setting['admin_email_subject']) ? $fat_event_setting['admin_email_subject'] : '';
                                $email_content = isset($fat_event_setting['admin_email_content']) ? $fat_event_setting['admin_email_content'] : '';
                                FAT_Event_Utils::send_mail_notification($recipients, '', '', $email_subject, $email_content, $firstName, $lastName, $event, $start_date, $end_date, $location, $location_address, $booking_id, $confirm_attention, $order_detail);
                            }

                            update_post_meta($booking_id, 'has_send', 1);
                        }

                    }
                }
            }
        }

        function hide_product_event_in_query($query){
            global $wpdb;
            $type = isset($_GET['post_type']) ? $_GET['post_type'] : '';
            $post_status =  isset($_GET['post_status']) ? $_GET['post_status'] : '';
            if($type=='product' && $post_status!='trash'){
                $qv = &$query->query_vars;
                $sql= "SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key=%s";
                $sql = $wpdb->prepare($sql,'_event_id');
                $product_event = $wpdb->get_results($sql);
                $p_ids = array();
                foreach($product_event as $p){
                    $p_ids[] = $p->post_id;
                }
                $query->set('post__not_in',$p_ids);
            }
        }

        public function wp_count_posts($counts, $type, $perm ){
            global $wpdb;
            if($type==='product'){
                $sql= "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE meta_key=%s";
                $sql = $wpdb->prepare($sql,'_event_id');
                $product_event = $wpdb->get_results($sql);
                $event_ids = array();
                foreach($product_event as $p){
                    $event_ids[] = $p->meta_value;
                }
                $event_ids = implode(',',$event_ids);

                $sql= "SELECT ID FROM {$wpdb->prefix}posts WHERE ID IN ({$event_ids}) AND post_type=%s AND post_status=%s";
                $sql = $wpdb->prepare($sql,FAT_EVENT_POST_TYPE,'publish');
                $events = $wpdb->get_results($sql);

                $counts->draft = $counts->draft - count($events);
                $counts->draft = $counts->draft >=0 ? $counts->draft: 0;
            }
            return $counts;
        }

        function get_cart_item_meta($product_id)
        {
            $cart_data = WC()->session->get('cart');
            foreach ($cart_data as $key => $value) {
                if (isset($value['product_id']) && $value['product_id'] == $product_id) {
                    return $value;
                }
            }
            return;
        }

        public static function instance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

    }
}

if (!function_exists('fat_event_init_wc_integrated')) {
    function fat_event_init_wc_integrated()
    {
        if (class_exists('WooCommerce')) {
            $FAT_Event_WC = FAT_Event_WC_Integrated::instance();
            $FAT_Event_WC->init();
        }
    }

    add_action('init', 'fat_event_init_wc_integrated');
}