<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 9:37 AM
 */
if (!defined('ABSPATH')) die('-1');
if (!class_exists('FAT_Event_Shortcode')) {
    class FAT_Event_Shortcode
    {
        function __construct()
        {
            add_shortcode('fat_event', array($this, 'event_shortcode'));
            add_shortcode('fat_event_detail_page_title', array($this, 'event_detail_page_title_shortcode'));
            add_shortcode('fat_event_detail_page_sidebar', array($this, 'event_detail_page_sidebar_shortcode'));
            add_shortcode('fat_event_dates', array($this, 'event_dates_shortcode'));
            add_shortcode('fat_event_booking', array($this, 'event_booking_shortcode'));
            add_shortcode('fat_event_register', array($this, 'event_register_shortcode'));
            add_action('init', array($this, 'register_page_builder_shortcode'), 7);
            $this->includes();
        }

        function register_page_builder_shortcode()
        {
            $args = array(
                'posts_per_page' => -1,
                'post_type' => FAT_EVENT_SHORTCODE_POST_TYPE,
                'post_status' => 'publish');
            $shortcodes = array();
            $post_array = get_posts($args);
            foreach ($post_array as $post) : setup_postdata($post);
                $shortcodes[$post->post_title] = $post->ID;
            endforeach;
            wp_reset_postdata();

            if (function_exists('vc_map')) {
                vc_map(array(
                    'name' => 'FAT Event',
                    'base' => 'fat_event',
                    'icon' => 'dashicons dashicons-calendar-alt',
                    'category' => esc_html__('FAT Shortcode', 'fat-event'),
                    'description' => esc_html__('A event calendar for your site', 'fat-event'),
                    'params' => array(
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Choose event shortcode', 'fat-event'),
                            'param_name' => 'id',
                            'admin_label' => true,
                            'value' => $shortcodes
                        ),
                    )
                ));

                vc_map(array(
                    'name' => 'FAT Event Register',
                    'base' => 'fat_event_register',
                    'icon' => 'dashicons dashicons-calendar-alt',
                    'category' => esc_html__('FAT Shortcode', 'fat-event'),
                    'description' => esc_html__('Show up register event form on frontend', 'fat-event'),
                    'params' => array()
                ));
            }
        }

        function event_shortcode($atts)
        {
            if (!isset($atts['id']) || $atts['id'] == 0) {
                return;
            }
            $atts = array('id' => $atts['id']);

            global $fat_event_custom_css;

            $id = $atts['id'];
            $shortcode_config = get_post_meta($id, 'fat-mb-event-shortcode-config', true);
            if(!is_array($shortcode_config)){
                return;
            }
            $shortcode_config['hide_event_end_time'] = isset($shortcode_config['hide_event_end_time']) && isset($shortcode_config['hide_event_end_time'][0]) ? $shortcode_config['hide_event_end_time'][0] : 0;
            $layout = isset($shortcode_config['layout']) && $shortcode_config['layout'] ? $shortcode_config['layout'] : 'grid';
            $sc_disable_modernizr = isset($shortcode_config['disable_modernizr']) && $shortcode_config['disable_modernizr'] ? $shortcode_config['disable_modernizr'] : 'inherit';
            if (isset($atts['filter_organizer']) && $atts['filter_organizer']) {
                $shortcode_config['organizers'] = explode(',', $atts['filter_organizer']);
            }
            if (isset($atts['filter_cat']) && $atts['filter_cat']) {
                $shortcode_config['categories'] = explode(',', $atts['filter_cat']);
            }


            ob_start();
            $this->enqueue_scripts($layout, $sc_disable_modernizr);

            $fat_event_setting = get_option('fat_event_setting');
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox' && $layout=='map'){
                $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/mapbox.php';
            }else{
                $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/' . $layout . '.php';
            }

            if (file_exists($layout_path)) {
                $locale = get_locale();
                if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                    $locale .= '.utf8';
                }
                setlocale(LC_TIME, $locale);
                include $layout_path;
            }
            add_action('wp_footer', array($this, 'include_tmpl'));

            $custom_css = isset($shortcode_config['custom_css']) && $shortcode_config['custom_css'] ? $shortcode_config['custom_css'] : '';
            if ($custom_css) {
                if (!isset($fat_event_custom_css) || !is_array($fat_event_custom_css)) {
                    $fat_event_custom_css = array();
                }
                $fat_event_custom_css[$id] = $custom_css;
                remove_action('wp_footer', 'FAT_Event_Utils::enqueue_custom_css');
                add_action('wp_footer', 'FAT_Event_Utils::enqueue_custom_css');
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;

        }

        function event_register_shortcode($atts)
        {
            $fat_event_setting = get_option('fat_event_setting');

            $fat_event_data = array(
                'ajax_url' => admin_url('admin-ajax.php'),
            );
            $dist = (defined('FAT_CORE_SCRIP_DEBUG') && FAT_CORE_SCRIP_DEBUG) ? '' : 'dist/';
            if (!isset($fat_event_setting['enable_create_event'][0]) || $fat_event_setting['enable_create_event'][0] !== '1') {
                return esc_html__('You don\'t have permission to create event', 'fat-event');
            }

            wp_enqueue_media();
            do_action('fat_event_register_begin_enqueue');
            wp_enqueue_style('font-awesome', FAT_EVENT_PLUGIN_URL . '/assets/fonts/fonts-awesome/css/font-awesome.min.css', array(), '4.7.0');
            wp_enqueue_style('fat-spinner', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/spinner.css', array(), false);
            wp_enqueue_style('fat-event-register', FAT_EVENT_ASSET_CSS_URL . 'frontend/register.css', array(), false);
            wp_enqueue_style('fat-event-admin', FAT_EVENT_ASSET_CSS_URL . 'admin/style.css', array(), false);
            wp_enqueue_style('fat-event', FAT_EVENT_ASSET_CSS_URL . 'frontend/style.css', array(), false);

            wp_register_script('fat-event-loading', FAT_EVENT_ASSET_JS_URL . 'frontend/' . $dist . 'fat-loading.js', array('jquery'), '1.0.0', true);
            wp_register_script('fat-event-register', FAT_EVENT_ASSET_JS_URL . 'frontend/' . $dist . 'fat-event-register.js', array('jquery', 'fat-event-loading'), '1.0.0', true);
            wp_localize_script('fat-event-register', 'fat_event_register_data', array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'require_field' => esc_html__('Please input value for this field', 'fat-event')
            ));
            wp_enqueue_script('fat-event-register');

            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
                wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
                wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
                wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
                wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);
                wp_register_script('fat-event', FAT_EVENT_ASSET_JS_URL . 'admin/main.js', array('jquery', 'wp-util'), '1.0.0', true);
                wp_localize_script('fat-event', 'fat_event_data', $fat_event_data);
                wp_enqueue_script('fat-event');
            }else{
                $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
                $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&libraries=places&callback=fat_event_google_map_callback', $api_key);
                wp_register_script('fat-event', FAT_EVENT_ASSET_JS_URL . 'admin/main.js', array('jquery', 'wp-util'), '1.0.0', true);
                wp_enqueue_script('google-map-api', $map_api, array('fat-event'), false, true);
                wp_localize_script('fat-event', 'fat_event_data', $fat_event_data);
                wp_enqueue_script('fat-event');
            }
            do_action('fat_event_register_end_enqueue');

            ob_start();
            $tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl.php';
            if (file_exists($tmpl_path)) {
                include $tmpl_path;
            }

            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/register/event-register.php';
            if (file_exists($layout_path)) {
                include $layout_path;
            }

            do_action('fat_event_register_include_template');
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        function event_dates_shortcode($atts)
        {
            if (!isset($atts['id']) || $atts['id'] < 0) {
                return;
            }
            $atts = array('id' => $atts['id']);
            ob_start();
            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/event_dates.php';
            if (file_exists($layout_path)) {
                $locale = get_locale();
                if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                    $locale .= '.utf8';
                }
                setlocale(LC_TIME, $locale);
                include $layout_path;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        function event_booking_shortcode($atts)
        {
            if (!isset($atts['id']) || $atts['id'] < 0) {
                return;
            }
            $atts = array('id' => $atts['id']);
            ob_start();
            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/event_booking.php';
            if (file_exists($layout_path)) {
                include $layout_path;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        function event_detail_page_title_shortcode($atts)
        {
            if (!isset($atts['id']) || $atts['id'] < 0) {
                return;
            }
            $atts = array('id' => $atts['id']);
            ob_start();
            $this->event_detail_enqueue_scripts();
            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/event_detail_page_title.php';
            if (file_exists($layout_path)) {
                include $layout_path;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        function event_detail_page_sidebar_shortcode($atts)
        {
            if (!isset($atts['id']) || $atts['id'] < 0) {
                return;
            }
            $atts = array('id' => $atts['id']);
            ob_start();
            $this->event_detail_enqueue_scripts();
            $layout_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/layouts/event_detail_page_sidebar.php';
            if (file_exists($layout_path)) {
                include $layout_path;
            }
            $ret = ob_get_contents();
            ob_end_clean();
            return $ret;
        }

        private function enqueue_scripts($layout, $sc_disable_modernizr)
        {
            $fat_event_setting = get_option('fat_event_setting');

            wp_enqueue_style('font-awesome', FAT_EVENT_PLUGIN_URL . '/assets/fonts/fonts-awesome/css/font-awesome.min.css', array(), '4.7.0');
            wp_enqueue_style('fat-event-simple-icon', FAT_EVENT_PLUGIN_URL . '/assets/fonts/simple-icon/css/simple-line-icons.css', array(), false);
            wp_enqueue_style('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/style.css', array(), FAT_EVENT_PLUGIN_VERSION);
            wp_enqueue_style('jquery-light-gallery', FAT_EVENT_PLUGIN_URL . '/assets/plugins/light-gallery/css/lightgallery.min.css', array(), false);
            wp_enqueue_style('jquery-light-gallery-transition', FAT_EVENT_PLUGIN_URL . '/assets/plugins/light-gallery/css/lg-transitions.min.css', array(), false);
            wp_enqueue_style('fat-spinner', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/spinner.css', array(), false);
            wp_enqueue_style('fat-animate', FAT_EVENT_PLUGIN_URL . '/assets/plugins/animate/animate.css', array(), false);
            wp_enqueue_style('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.css', array(), '1.4.0');
            FAT_Event_Utils::enqueue_google_font();

            wp_enqueue_script('jquery-cookie', FAT_EVENT_PLUGIN_URL . '/assets/plugins/jquery.cookie.js', array('jquery'), false, true);

            wp_enqueue_script('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js', array('jquery'), '1.4.0', true);
            wp_enqueue_script('jquery-light-gallery', FAT_EVENT_PLUGIN_URL . '/assets/plugins/light-gallery/js/lightgallery.min.js', array('jquery'), false, true);
            wp_enqueue_script('images-loaded', FAT_EVENT_PLUGIN_URL . '/assets/plugins/isotope/imagesloaded.pkgd.min.js', array('jquery'), false, true);


            wp_enqueue_style('selectize-default', FAT_EVENT_PLUGIN_URL . '/libs/fat-cmb/assets/js/selectize/css/selectize.default.css', array(), false, false);
            wp_enqueue_script('selectize', FAT_EVENT_PLUGIN_URL . '/libs/fat-cmb/assets/js/selectize/js/selectize.min.js', array('jquery', 'jquery-ui-sortable'), false, false);

            wp_enqueue_style('datetime-picker', FAT_EVENT_PLUGIN_URL . '/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.min.css', array(), false, false);
            wp_enqueue_script('datetime-picker', FAT_EVENT_PLUGIN_URL . '/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.full.min.js', array('jquery'), false, false);

            if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] == 'both' || $fat_event_setting['payment_method'] == 'stripe'
                    || $fat_event_setting['payment_method'] == 'offline_stripe' || $fat_event_setting['payment_method'] == 'paypal_stripe')) {
                wp_enqueue_script('stripe', 'https://js.stripe.com/v3/', array('jquery'), false, false);
            }

            $dist = (defined('FAT_CORE_SCRIP_DEBUG') && FAT_CORE_SCRIP_DEBUG) ? '' : 'dist/';
            $enqueue_modernizr = $sc_disable_modernizr!='disable';
            if($sc_disable_modernizr=='inherit'){
                $enqueue_modernizr = !isset($fat_event_setting['disable_modernizr'][0]) || $fat_event_setting['disable_modernizr'][0] != '1';
            }

            $auto_fill = isset($fat_event_setting['remember_latest_booking'][0]) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0;
            $auto_fill_info = array();
            if($auto_fill){
                $auto_fill_info  = FAT_Event_Utils::get_auto_fill_info();
            }

            switch ($layout) {
                case 'grid':
                case 'masonry':
                case 'metro-01':
                case 'metro-02':
                case 'metro-03':
                    {
                        if (!isset($fat_event_setting['disable_modernizr'][0]) || $fat_event_setting['disable_modernizr'][0] != '1')
                        wp_enqueue_script('fat-isotope', FAT_EVENT_PLUGIN_URL . '/assets/plugins/isotope/isotope.pkgd.min.js', array('jquery'), '3.0.5', true);
                        wp_enqueue_script('fat-masonry', FAT_EVENT_PLUGIN_URL . '/assets/plugins/isotope/masonry.pkgd.min.js', array('jquery'), false, true);
                        if($enqueue_modernizr){
                            wp_enqueue_script('modernizr', FAT_EVENT_PLUGIN_URL . '/assets/plugins/modernizr-custom.js', array('jquery'), false, true);
                        }
                        break;
                    }
                case 'slide':
                case 'carousel':
                    {
                        wp_enqueue_style('carousel', FAT_EVENT_PLUGIN_URL . '/assets/plugins/owl-carousel/assets/owl.carousel.min.css', array(), false);
                        wp_enqueue_script('carousel', FAT_EVENT_PLUGIN_URL . '/assets/plugins/owl-carousel/owl.carousel.min.js', array('jquery'), false, true);
                        break;
                    }
                case 'countdown':
                    {
                        wp_enqueue_script('jquery-countdown', FAT_EVENT_PLUGIN_URL . '/assets/plugins/countdown/jquery.countdown.min.js', array('jquery'), '2.2.0', true);
                        break;
                    }
                case 'timetable':
                    {
                        wp_enqueue_style('full-calendar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/fullcalendar/fullcalendar.min.css', array(), '3.9.0');
                        wp_enqueue_style('full-calendar-print', FAT_EVENT_PLUGIN_URL . '/assets/plugins/fullcalendar/fullcalendar.print.min.css', array(), '3.9.0', 'print');
                        wp_enqueue_script('moment', FAT_EVENT_PLUGIN_URL . '/assets/plugins/fullcalendar/moment.min.js', array('jquery'), false, true);
                        wp_enqueue_script('full-calendar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/fullcalendar/fullcalendar.min.js', array('jquery'), '3.9.0', true);
                        wp_enqueue_script('full-calendar-locale', 'https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.9.0/locale-all.js', array('jquery', 'moment', 'full-calendar'), false, true);
                        break;
                    }
                case 'calendar-widget':
                    {
                        wp_enqueue_style('calendar-widget', FAT_EVENT_PLUGIN_URL . '/assets/plugins/calendar-widget/calendar-widget.css', array(), '1.0.2');
                        wp_enqueue_script('moment', FAT_EVENT_PLUGIN_URL . '/assets/plugins/fullcalendar/moment.min.js', array('jquery'), false, true);
                        wp_enqueue_script('fat-loading', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/' . $dist . 'fat-loading.js', array('jquery'), '1.0.0', true);
                        wp_enqueue_script('calendar-widget', FAT_EVENT_PLUGIN_URL . '/assets/plugins/calendar-widget/calendar-widget.js', array('jquery', 'moment', 'fat-loading'), '1.4.1', true);
                        wp_localize_script('calendar-widget', 'fat_event_ajax',
                            array(
                                'ajaxurl' => admin_url('admin-ajax.php'),
                                'woocommerce_intergrated' => isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0] == '1' ? 1 : 0,
                                'no_event' => esc_html__('No event','fat-event'),
                                'auto_fill' => isset($fat_event_setting['remember_latest_booking'][0]) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0,
                                'auto_fill_info' => $auto_fill_info
                            )
                        );
                        break;
                    }
                case 'timeline':
                    {
                        wp_enqueue_style('time-line', FAT_EVENT_PLUGIN_URL . '/assets/plugins/timeline/css/style.css', array(), '1.0.0');
                        if($enqueue_modernizr){
                            wp_enqueue_script('modernizr', FAT_EVENT_PLUGIN_URL . '/assets/plugins/timeline/js/modernizr.js', array('jquery'), false, true);
                        }
                        wp_enqueue_script('time-line', FAT_EVENT_PLUGIN_URL . '/assets/plugins/timeline/js/main.js', array('jquery'), '1.0.0', true);
                        break;
                    }
            }

            wp_enqueue_script('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/fat-event.js', array('jquery', 'wp-util', 'datetime-picker'), FAT_EVENT_PLUGIN_VERSION, true);
            wp_localize_script('fat-event', 'fat_event_ajax', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'woocommerce_intergrated' => isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0] == '1' ? 1 : 0,
                'no_event' => esc_html__('No event','fat-event'),
                'auto_fill' => isset($fat_event_setting['remember_latest_booking'][0]) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0,
                'auto_fill_info' => $auto_fill_info
            ));

            if ($layout == 'map') {
                if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                    $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
                    wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
                    wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
                    wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
                    wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);
                    wp_enqueue_script('fat-event-map', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/' . $dist . 'fat-event-map.js', array('fat-event'), FAT_EVENT_PLUGIN_VERSION, true);
                }else{
                    $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
                    $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&libraries=places&callback=fat_event_google_map_callback', $api_key);
                    wp_enqueue_script('fat-event-map', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/' . $dist . 'fat-event-map.js', array('fat-event'), FAT_EVENT_PLUGIN_VERSION, true);
                    wp_enqueue_script('google-map-api', $map_api, array('fat-event-map'), false, true);
                    wp_enqueue_script('fat-event-marker', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/' . $dist . 'fat-event-marker.js', array('google-map-api'), FAT_EVENT_PLUGIN_VERSION, true);
                }
            }
        }

        public function event_detail_enqueue_scripts()
        {
            wp_enqueue_style('fat-event-font-awesome', FAT_EVENT_PLUGIN_URL . '/assets/fonts/fonts-awesome/css/font-awesome.min.css', array(), '4.7.0');
            wp_enqueue_style('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.css', array(), '1.4.0');
            wp_enqueue_style('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/style.css', array(), FAT_EVENT_PLUGIN_VERSION);
            wp_enqueue_style('fat-spinner', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/spinner.css', array(), false);
            FAT_Event_Utils::enqueue_google_font();

            $fat_event_setting = get_option('fat_event_setting');
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
            }else{
                $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
            }
            $dist = (defined('FAT_CORE_SCRIP_DEBUG') && FAT_CORE_SCRIP_DEBUG) ? '' : 'dist/';

            wp_enqueue_script('jquery-cookie', FAT_EVENT_PLUGIN_URL . '/assets/plugins/jquery.cookie.js', array('jquery'), false, true);

            wp_enqueue_style('selectize-default', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/css/selectize.default.css', array(), false, false);
            wp_enqueue_script('selectize', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/js/selectize.min.js',  array('jquery', 'jquery-ui-sortable'), false, false);

            wp_enqueue_style('datetime-picker', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.min.css', array(), false, false);
            wp_enqueue_script('datetime-picker', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.full.min.js',  array('jquery'), false, false);

            wp_enqueue_script('stripe', 'https://js.stripe.com/v3/', array('jquery'), false, false);
            wp_enqueue_script('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js', array('jquery'), '1.4.0', true);
            wp_enqueue_script('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/fat-event.js', array('jquery', 'wp-util'), FAT_EVENT_PLUGIN_VERSION, false);


            $auto_fill = isset($fat_event_setting['remember_latest_booking']) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0;
            $auto_fill_info = array();
            if($auto_fill){
                $auto_fill_info  = FAT_Event_Utils::get_auto_fill_info();
            }

            wp_localize_script('fat-event', 'fat_event_ajax', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'woocommerce_intergrated' => isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0]=='1' ? 1 : 0,
                'fully_booked' => esc_html__('Fully booked','fat-event'),
                'auto_fill' => isset($fat_event_setting['remember_latest_booking']) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0,
                'auto_fill_info' => $auto_fill_info
            ));

            $ver = uniqid();
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
                wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
                wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
                wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);
                wp_enqueue_script('turf', FAT_EVENT_PLUGIN_URL . '/assets/plugins/turf/turf.min.js', array('jquery'), FAT_EVENT_PLUGIN_VERSION, false);
                wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
            }else{
                if(isset($fat_event_setting['disable_google_API'][0]) && $fat_event_setting['disable_google_API'][0]=='1'){
                    wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
                }else{
                    $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&callback=fat_event_single_map', $api_key);
                    wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
                    wp_enqueue_script('fat-google-map', $map_api, array('fat-event-single'), false, false);
                }

            }
        }

        private function includes()
        {
            if (file_exists(untrailingslashit(FAT_EVENT_DIR_PATH) . '/utils/resize.php')) {
                require_once(untrailingslashit(FAT_EVENT_DIR_PATH) . '/utils/resize.php');
            }
            if (file_exists(untrailingslashit(FAT_EVENT_DIR_PATH) . '/utils/fe-ajax.php')) {
                require_once(untrailingslashit(FAT_EVENT_DIR_PATH) . '/utils/fe-ajax.php');
            }
        }

        public function include_tmpl()
        {
            $tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl_popup_detail.php';
            if (file_exists($tmpl_path)) {
                include_once $tmpl_path;
            }
            $tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl_popup_booking.php';
            if (file_exists($tmpl_path)) {
                include_once $tmpl_path;
            }
        }
    }
}