<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 9:25 AM
 */
if (!defined('ABSPATH')) die('-1');
if (!class_exists('FAT_Event_Menu')) {
    class FAT_Event_Menu
    {
        function __construct()
        {
            add_action( 'admin_enqueue_scripts', array($this,'admin_enqueue_script'));
            add_action('admin_menu', array($this, 'addMenuPage'));
            add_action('admin_menu', array($this, 'register_event_option_page'));
        }

        function addMenuPage()
        {
            add_submenu_page(
                'edit.php?post_type=' . FAT_EVENT_POST_TYPE,
                esc_html__('Shortcodes', 'fat-event'),
                esc_html__('Shortcodes', 'fat-event'),
                'edit_posts',
                'edit.php?post_type=' . FAT_EVENT_SHORTCODE_POST_TYPE,
                array()
            );

            add_submenu_page(
                'edit.php?post_type=' . FAT_EVENT_POST_TYPE,
                esc_html__('Coupon', 'fat-event'),
                esc_html__('Coupon', 'fat-event'),
                'edit_posts',
                'edit.php?post_type=' . FAT_EVENT_COUPON_POST_TYPE,
                array()
            );

            add_submenu_page(
                'edit.php?post_type=' . FAT_EVENT_POST_TYPE,
                esc_html__('Booking', 'fat-event'),
                esc_html__('Booking', 'fat-event'),
                'edit_posts',
                'edit.php?post_type=' . FAT_EVENT_BOOKING_POST_TYPE,
                array()
            );

            $fat_event_setting = get_option('fat_event_setting', array());
            if(isset($fat_event_setting['enable_form_builder'][0]) && $fat_event_setting['enable_form_builder'][0]=='1'){
                add_submenu_page(
                    'edit.php?post_type=' . FAT_EVENT_POST_TYPE,
                    esc_html__('Booking form builder', 'fat-event'),
                    esc_html__('Booking form builder', 'fat-event'),
                    'edit_posts',
                    'fat-event-booking-builder',
                    array($this,'fat_event_booking_builder_callback')
                );
            }
        }

        function register_event_option_page()
        {
            add_filter('fat_cmb_register_option_page', array($this, 'callback_event_setting'));
        }

        function callback_event_setting($options)
        {
            $allow_users = array();
            $users = get_users(array());
            foreach ($users as $u){
                $allow_users[$u->ID] = $u->user_login;
            }

            $currency = array(
                'USD' => esc_html__('U.S. Dollar', 'fat-event'),
                'AUD' => esc_html__('Australian Dollar', 'fat-event'),
                'BRL' => esc_html__('Brazilian Real', 'fat-event'),
                'CAD' => esc_html__('Canadian Dollar', 'fat-event'),
                'CZK' => esc_html__('Czech Koruna', 'fat-event'),
                'DKK' => esc_html__('Danish Krone', 'fat-event'),
                'EUR' => esc_html__('Euro', 'fat-event'),
                'HKD' => esc_html__('Hong Kong Dollar', 'fat-event'),
                'HUF' => esc_html__('Hungarian Forint', 'fat-event'),
                'INR' => esc_html__('Indian Rupee', 'fat-event'),
                'ILS' => esc_html__('Israeli New Sheqel', 'fat-event'),
                'JPY' => esc_html__('Japanese Yen', 'fat-event'),
                'MYR' => esc_html__('Malaysian Ringgit', 'fat-event'),
                'MXN' => esc_html__('Mexican Peso', 'fat-event'),
                'NOK' => esc_html__('Norwegian Krone', 'fat-event'),
                'NZD' => esc_html__('New Zealand Dollar', 'fat-event'),
                'PHP' => esc_html__('Philippine Peso', 'fat-event'),
                'PLN' => esc_html__('Polish Zloty', 'fat-event'),
                'GBP' => esc_html__('Pound Sterling', 'fat-event'),
                'RUB' => esc_html__('Russian Ruble', 'fat-event'),
                'SGD' => esc_html__('Singapore Dollar', 'fat-event'),
                'SEK' => esc_html__('Swedish Krona', 'fat-event'),
                'CHF' => esc_html__('Swiss Franc', 'fat-event'),
                'TWD' => esc_html__('Taiwan New Dollar', 'fat-event'),
                'THB' => esc_html__('Thai Baht', 'fat-event'),
                'DOP' => esc_html__('Dominican Peso', 'fat-event'),
                'ZAR' => esc_html__('Rand', 'fat-event'),
                'MNT' => esc_html__('Tugrik', 'fat-event'),
                'ARS' => esc_html__('Argentine Peso', 'fat-event'),
                'BGN' => esc_html__('Bulgarian Lev', 'fat-event'),
            );
            $currency = apply_filters('fat_event_currency',$currency);

            $options[] = array(
                'menu_type' => 'sub-menu',
                'parent_slug' => 'edit.php?post_type=' . FAT_EVENT_POST_TYPE,
                'page_title' => esc_html__('FAT Event Settings','fat-event'),
                'menu_title' => esc_html__('Settings','fat-event'),
                'capability' => 'edit_posts',
                'menu_slug' => 'fat-event-setting',
                'icon_url' => '',
                'position' => null,
                'page_id' => 'fat_event_setting',
                'tabs' => array(
                    'tab_type' => 'vertical',
                    'tab_width' => 'auto',
                    'tab' => array(
                        'tab-general' => array(
                            'id' => 'tab_general',
                            'icon' => 'fa fa-cogs',
                            'title' => esc_html__('General', 'fat-event'),
                        ),
                        'tab-day-off' => array(
                            'id' => 'tab_day_off',
                            'icon' => 'fa fa-calendar',
                            'title' => esc_html__('Day off', 'fat-event'),
                        ),
                        'tab-amenities' => array(
                            'id' => 'tab_amenities',
                            'icon' => 'fa fa-building-o',
                            'title' => esc_html__('Amenities', 'fat-event'),
                        ),
                        'tab-google-map' => array(
                            'id' => 'tab_google_map',
                            'icon' => 'fa fa-globe',
                            'title' => esc_html__('Map', 'fat-event'),
                        ),
                        'tab-social' => array(
                            'id' => 'tab_social',
                            'icon' => 'fa fa-share-alt',
                            'title' => esc_html__('Social network', 'fat-event'),
                        ),
                        'tab-email' => array(
                            'id' => 'tab_email',
                            'icon' => 'fa fa-envelope-o',
                            'title' => esc_html__('Email notification', 'fat-event')
                        ),
                        'tab-email-reminder' => array(
                            'id' => 'tab_email_reminder',
                            'icon' => 'fa fa-bell-o',
                            'title' => esc_html__('Email reminder', 'fat-event')
                        ),
                        'tab-payment' => array(
                            'id' => 'tab_payment',
                            'icon' => 'fa fa-paypal',
                            'title' => esc_html__('Payment', 'fat-event')
                        ),
                        'tab-booking' => array(
                            'id' => 'tab_booking',
                            'icon' => 'fa fa-calendar-check-o',
                            'title' => esc_html__('Booking', 'fat-event')
                        ),
                        'tab-color' => array(
                            'id' => 'tab_color',
                            'icon' => 'fa fa-paint-brush',
                            'title' => 'Font'
                        ),
                        'tab-css' => array(
                            'id' => 'tab_css',
                            'icon' => 'fa fa-css3',
                            'title' => 'Custom Css'
                        )
                    )
                ),
                'fields' => array(
                    /** tab general **/
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Label', 'fat-event'),
                        'id' => 'section_label',
                        'type' => 'section',
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Ticket detail label', 'fat-event'),
                        'id' => 'ticket_detail_label',
                        'type' => 'text',
                        'std' => esc_html__('Ticket detail','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Fees label', 'fat-event'),
                        'id' => 'fees_label',
                        'type' => 'text',
                        'std' => esc_html__('Fees','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Seats label', 'fat-event'),
                        'id' => 'seats_label',
                        'type' => 'text',
                        'std' => esc_html__('Seats','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Seats available label', 'fat-event'),
                        'id' => 'seats_available_label',
                        'type' => 'text',
                        'std' => esc_html__('Seats available','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Booking form label', 'fat-event'),
                        'id' => 'booking_form_label',
                        'type' => 'text',
                        'std' => esc_html__('Booking form','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Booking button label', 'fat-event'),
                        'id' => 'booking_button_label',
                        'type' => 'text',
                        'std' => esc_html__('Book Now','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('API', 'fat-event'),
                        'id' => 'section_api',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Enable API', 'fat-event'),
                        'id' => 'enable_api',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'description' => esc_html__('Please check at here if you want publish your event via API','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Key for import', 'fat-event'),
                        'id' => 'import_key',
                        'type' => 'text',
                        'std' => '0',
                    ),

                    array(
                        'tab_id' => 'tab_day_off',
                        'label' => esc_html__('Day off', 'fat-event'),
                        'id' => 'section_day_off',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_day_off',
                        'label' => esc_html__('Block specific days', 'fat-event'),
                        'id' => 'day_off',
                        'type' => 'repeat',
                        'fields' => array(
                            array(
                                'label' => esc_html__('Start', 'fat-event'),
                                'id' => 'repeat_on_date',
                                'type' => 'datetime',
                                'std' => '',
                                'time_picker' => 1
                            ),
                            array(
                                'label' => esc_html__('To', 'fat-event'),
                                'id' => 'repeat_to_date',
                                'type' => 'datetime',
                                'std' => '',
                                'time_picker' => 1
                            ),
                        ),
                        'description' => esc_html__('Select a date that you do not allow reservations','fat-event')
                    ),

                    /**  Amenities */
                    array(
                        'tab_id' => 'tab_amenities',
                        'label' => esc_html__('Amenities', 'fat-event'),
                        'id' => 'section_amenities',
                        'type' => 'section'
                    ),
                    array(
                        'tab_id' => 'tab_amenities',
                        'label' => esc_html__('Amenities heading', 'fat-event'),
                        'id' => 'amenities_heading',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'tab_id' => 'tab_amenities',
                        'label' => esc_html__('Display amenities in single event page', 'fat-event'),
                        'id' => 'amenities_position',
                        'type' => 'select',
                        'options' => array(
                            'sidebar' => esc_html__('At sidebar','fat-event'),
                            'top_content' => esc_html__('Above content','fat-event'),
                            'bottom_content' => esc_html__('Below content','fat-event')
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_amenities',
                        'label' => esc_html__('Show amenities in popup booking', 'fat-event'),
                        'id' => 'show_amenities_in_booking',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'description' => esc_html__('If check this, the list amenities will be display in popup booking','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_amenities',
                        'id' => 'amenities',
                        'type' => 'repeat',
                        'fields' => array(
                            array(
                                'label' => esc_html__('Amenities icon', 'fat-event'),
                                'id' => 'amenities_icon',
                                'type' => 'text',
                                'std' => '',
                                'col_width' => 'fat-cmb-col-6',
                                'description' => esc_html__('Please access here https://fontawesome.com/v4.7.0/icons/ click icon that you want and copy icon. Ex: https://fontawesome.com/v4.7.0/icon/address-book-o', 'fat-event')
                            ),
                            array(
                                'label' => esc_html__('Amenities name', 'fat-event'),
                                'id' => 'amenities_name',
                                'type' => 'text',
                                'std' => '',
                                'col_width' => 'fat-cmb-col-6',
                                'description' => esc_html__('Ex: picnic tables, grills, music, ...', 'fat-event')
                            )
                        )
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Archives', 'fat-event'),
                        'id' => 'section_archive',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Archive page', 'fat-event'),
                        'id' => 'archive_page',
                        'type' => 'select',
                        'data_source' => 'page',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Single', 'fat-event'),
                        'id' => 'section_single',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Single layout', 'fat-event'),
                        'id' => 'single_layout',
                        'type' => 'select',
                        'options' => array(
                            'single-style-01' => esc_html__('Feature at top, content at col left, sidebar at col right','fat-event'),
                            'single-style-02' => esc_html__('Feature and content at col left, sidebar at col right','fat-event'),
                            'single-style-03' => esc_html__('Feature and content, hide sidebar','fat-event'),
                            'single-style-04' => esc_html__('Feature, content and sidebar at center','fat-event')
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Date time order', 'fat-event'),
                        'id' => 'single_date_time_order',
                        'type' => 'select',
                        'options' => array(
                            'time-date' => esc_html__('Time - Date', 'fat-event'),
                            'date-time' => esc_html__('Date - Time', 'fat-event'),
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Time format', 'fat-event'),
                        'id' => 'single_time_format',
                        'type' => 'select',
                        'options' => array(
                            'H:i' => esc_html__('24:00', 'fat-event'),
                            'h:ia' => esc_html__('12:00am - 12:00pm', 'fat-event'),
                            'h:iA' => esc_html__('12:00AM - 12:00PM', 'fat-event'),
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Hide event end time', 'fat-event'),
                        'id' => 'hide_event_end_time',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'description' => esc_html__('If this checked, plugin will be hide event end time in single event page','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Disable crop single image', 'fat-event'),
                        'id' => 'disable_single_crop',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'description' => esc_html__('If this checked, plugin will be display origin image in single event page','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Slug & Permalinks', 'fat-event'),
                        'id' => 'section_slug',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Event slug', 'fat-event'),
                        'id' => 'event_slug',
                        'type' => 'text',
                        'std' => 'fat-event'
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Event title', 'fat-event'),
                        'id' => 'event_singular_name',
                        'type' => 'text',
                        'std' => 'Fat Event'
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Event category slug', 'fat-event'),
                        'id' => 'event_category_slug',
                        'type' => 'text',
                        'std' => 'fat-event-category'
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Create event from frontend', 'fat-event'),
                        'id' => 'section_create',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Enable create from frontend', 'fat-event'),
                        'id' => 'enable_create_event',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0'
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Enable status', 'fat-event'),
                        'id' => 'enable_status',
                        'type' => 'check',
                        'options' => array(
                            'draft' => esc_html__('Draft','fat-event'),
                            'publish' => esc_html__('Publish','fat-event'),
                        ),
                        'std' => 'draft',
                        'description' => esc_html__('If you select \'Draft\', you will need to approve events created at the frontend','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Notification', 'fat-event'),
                        'id' => 'event_create_notification',
                        'type' => 'select',
                        'std' => 'both',
                        'options' => array(
                            'popup' => esc_html__('Popup message', 'fat-event'),
                            'page' => esc_html__('Redirect to success page', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'enable_create_event',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Allow select location', 'fat-event'),
                        'id' => 'allow_select_location',
                        'type' => 'select',
                        'std' => 'all',
                        'options' => array(
                            'all' => esc_html__('All location', 'fat-event'),
                            'owner' => esc_html__('Only the locations they have created', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'enable_create_event',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Allow select organizer', 'fat-event'),
                        'id' => 'allow_select_organizer',
                        'type' => 'select',
                        'std' => 'all',
                        'options' => array(
                            'all' => esc_html__('All organizer', 'fat-event'),
                            'owner' => esc_html__('Only the organizers they have created', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'enable_create_event',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Allow user create event', 'fat-event'),
                        'id' => 'allow_user_create',
                        'type' => 'select',
                        'multiple' => true,
                        'std' => '',
                        'options' => $allow_users,
                        'depend_field' => array(
                            'field' => 'enable_create_event',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'description' => esc_html__('Set empty to allow any user create event','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Success message', 'fat-event'),
                        'id' => 'event_create_success_message',
                        'type' => 'text',
                        'std' => esc_html__('Thank you for your event. Please wait for approve!', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'event_create_notification',
                            'value' => 'popup',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Require login message', 'fat-event'),
                        'id' => 'register_notice_message',
                        'type' => 'ace',
                        'mode' => 'html',
                        'description' => esc_html__('Use tag: [login_link], [register_link] in content to add login link and resigter link ','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Page success', 'fat-event'),
                        'id' => 'event_create_page_success',
                        'type' => 'select',
                        'std' => '',
                        'data_source' => 'page',
                        'depend_field' => array(
                            'field' => 'event_create_notification',
                            'value' => 'page',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Library', 'fat-event'),
                        'id' => 'section_library',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_general',
                        'label' => esc_html__('Disable modernizr library', 'fat-event'),
                        'id' => 'disable_modernizr',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'description' => esc_html__('If both FAT Events plugin and your theme use modernizr library, you may see an error when init grid, masonry or metro layouts are used. Check here to disable the modernizr library in FAT Events plugin', 'fat-event'),
                    ),


                    /** tab google map */
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Map', 'fat-event'),
                        'id' => 'section_google_map',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Select map', 'fat-event'),
                        'id' => 'map_source',
                        'type' => 'select',
                        'options' => array(
                            'google' => esc_html__('Google map','fat-event'),
                            'mapbox' => esc_html__('Mapbox','fat-event')
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('API Key', 'fat-event'),
                        'id' => 'google_map_api_key',
                        'type' => 'text',
                        'std' => 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts',
                        'description' => esc_html__('Please go to here: https://developers.google.com/maps/documentation/javascript/get-api-key and create your api key', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'map_source',
                            'value' => 'mapbox',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Zoom level', 'fat-event'),
                        'id' => 'zoom_level',
                        'type' => 'number',
                        'min' => 5,
                        'max' => 20,
                        'step' => 1,
                        'std' => 13,
                        'depend_field' => array(
                            'field' => 'map_source',
                            'value' => 'mapbox',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Access token', 'fat-event'),
                        'id' => 'mapbox_access_token',
                        'type' => 'text',
                        'std' => '',
                        'description' => esc_html__('Please go to here: https://docs.mapbox.com/help/how-mapbox-works/access-tokens/ and create your access token', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'map_source',
                            'value' => 'mapbox',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Show map in single event page', 'fat-event'),
                        'id' => 'show_google_map',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1'
                    ),

                    array(
                        'tab_id' => 'tab_google_map',
                        'label' => esc_html__('Disable Google Map API', 'fat-event'),
                        'id' => 'disable_google_API',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '0',
                        'depend_field' => array(
                            'field' => 'map_source',
                            'value' => 'mapbox',
                            'compare' => '!='
                        ),
                    ),

                    /** tab social network */
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Social network', 'fat-event'),
                        'id' => 'section_social',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Show social share in single event page', 'fat-event'),
                        'id' => 'enable_social',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1'
                    ),
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Facebook', 'fat-event'),
                        'id' => 'enable_facebook',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'enable_social',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Twitter', 'fat-event'),
                        'id' => 'enable_twitter',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'enable_social',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Google plus', 'fat-event'),
                        'id' => 'enable_google_plus',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'enable_social',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_social',
                        'label' => esc_html__('Email', 'fat-event'),
                        'id' => 'enable_email',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'enable_social',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    /** tab email */
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Email Notification', 'fat-event'),
                        'id' => 'section_email_notification',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Send email notification after booking', 'fat-event'),
                        'id' => 'enable_email_notification',
                        'type' => 'radio',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                            '0' => esc_html__('No','fat-event'),
                        ),
                        'std' => '0',

                    ),

                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Attach QRCode in email', 'fat-event'),
                        'id' => 'enable_qrcode',
                        'type' => 'radio',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                            '0' => esc_html__('No','fat-event'),
                        ),
                        'std' => '0',
                    ),

                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Email Config', 'fat-event'),
                        'id' => 'section_email',
                        'type' => 'section',
                    ),

                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Mailer', 'fat-event'),
                        'id' => 'mailer',
                        'type' => 'select',
                        'std' => 'smtp',
                        'options' => array(
                            'default' => esc_html__('Default', 'fat-event'),
                            'smtp' => esc_html__('SMTP', 'fat-event'),
                            'postSMTP' => esc_html__('Use Post SMTP plugin', 'fat-event'),
                        ),
                        'description' => esc_html__('If choose Post SMTP, please download plugin at here: https://wordpress.org/plugins/post-smtp','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('From name', 'fat-event'),
                        'id' => 'from_name',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('From email', 'fat-event'),
                        'id' => 'from_email',
                        'type' => 'text',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'default',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('CC to', 'fat-event'),
                        'id' => 'cc_email',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('BCC to', 'fat-event'),
                        'id' => 'bcc_email',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('SMTP Host', 'fat-event'),
                        'id' => 'smtp_host',
                        'type' => 'text',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'smtp',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Encryption', 'fat-event'),
                        'id' => 'encryption',
                        'type' => 'radio',
                        'options' => array(
                            'none' => esc_html__('None','fat-event'),
                            'ssl' => esc_html__('SSL','fat-event'),
                            'tls' => esc_html__('TLS','fat-event')
                        ),
                        'std' => 'ssl',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'smtp',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('SMTP Port', 'fat-event'),
                        'id' => 'smtp_port',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                        'std' => '465',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'smtp',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('SMTP Username', 'fat-event'),
                        'id' => 'smtp_username',
                        'type' => 'text',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'smtp',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('SMTP Password', 'fat-event'),
                        'id' => 'smtp_password',
                        'type' => 'password',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'mailer',
                            'value' => 'smtp',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Email Content For Client', 'fat-event'),
                        'id' => 'section_email_content',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Subject', 'fat-event'),
                        'id' => 'email_subject',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Content', 'fat-event'),
                        'id' => 'email_content',
                        'type' => 'ace',
                        'mode' => 'html',
                        'description' => esc_html__('Use tag: [qrcode], [first_name], [last_name], [phone], [company], [department], [address], [country], [note], [quantity], [total_price], [link_confirm], [event_name], [start_date], [end_date], [location], [location_address], [quantity], [note], [order_detail] (for woocommerce integrated) in email subject or content','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Email Content For Admin', 'fat-event'),
                        'id' => 'section_admin_email_content',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Send notification to organizer', 'fat-event'),
                        'id' => 'notifier_to_organizer',
                        'type' => 'radio',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                            '0' => esc_html__('No','fat-event'),
                        ),
                        'std' => '0',

                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Admin\'s name', 'fat-event'),
                        'id' => 'admin_name',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Admin\'s email', 'fat-event'),
                        'id' => 'admin_email',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Subject', 'fat-event'),
                        'id' => 'admin_email_subject',
                        'type' => 'text',
                        'std' => '',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Content', 'fat-event'),
                        'id' => 'admin_email_content',
                        'type' => 'ace',
                        'mode' => 'html',
                        'description' => esc_html__('Use tag:  [email], [qrcode], [first_name], [last_name], [phone], [company], [department], [address], [country], [note], [quantity], [total_price], [link_confirm], [event_name], [start_date], [end_date], [location], [location_address], [quantity], [note], [order_detail] (for woocommerce integrated) in email subject or content','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Participation Confirm', 'fat-event'),
                        'id' => 'section_attention_confirm',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_email',
                        'label' => esc_html__('Page participation confirm success', 'fat-event'),
                        'id' => 'attention_confirm_success',
                        'type' => 'select',
                        'std' => '',
                        'data_source' => 'page',
                        'description' => esc_html__('This is a confirmation page for successful participation when the user clicks the confirmation link in the email','fat-event')
                    ),

                    /** tab email reminder */
                    array(
                        'tab_id' => 'tab_email_reminder',
                        'label' => esc_html__('Email Reminder', 'fat-event'),
                        'id' => 'section_email_reminder',
                        'type' => 'section',
                    ),

                    array(
                        'tab_id' => 'tab_email_reminder',
                        'label' => esc_html__('Send email reminder', 'fat-event'),
                        'id' => 'enable_email_reminder',
                        'type' => 'radio',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                            '0' => esc_html__('No','fat-event'),
                        ),
                        'std' => '0',
                    ),

                    array(
                        'tab_id' => 'tab_email_reminder',
                        'label' => esc_html__('Reminder before  (hours)', 'fat-event'),
                        'id' => 'email_reminder_before',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 1000,
                        'step' => 1,
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'enable_email_reminder',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'description' => esc_html__('The number of hour what reminders before the event starts. Example: you can input 1 for reminder 1 hour before the event starts','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_email_reminder',
                        'label' => esc_html__('Subject', 'fat-event'),
                        'id' => 'email_reminder_subject',
                        'type' => 'text',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'enable_email_reminder',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_email_reminder',
                        'label' => esc_html__('Content', 'fat-event'),
                        'id' => 'email_reminder_content',
                        'type' => 'ace',
                        'mode' => 'html',
                        'depend_field' => array(
                            'field' => 'enable_email_reminder',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'description' => esc_html__('Use tag: [qrcode], [first_name], [last_name], [phone], [company], [department], [address], [country], [note], [quantity], [total_price], [link_confirm], [event_name], [start_date], [end_date], [quantity], [note], [order_detail] (for woocommerce integrated) in email subject or content','fat-event')
                    ),


                    /** tab payment */
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Currency', 'fat-event'),
                        'id' => 'section_payment',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Currency', 'fat-event'),
                        'id' => 'currency',
                        'type' => 'select',
                        'std' => 'USD',
                        'options' => $currency,
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Currency symbol', 'fat-event'),
                        'id' => 'currency_symbol',
                        'type' => 'text',
                        'std' => '$',
                        'description' => esc_html__('If set to empty, the currency code will be displayed. Ex: If Currency is Australian Dollar then the currency symbol AUD will be displayed', 'fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Symbol position', 'fat-event'),
                        'id' => 'symbol_position',
                        'type' => 'select',
                        'std' => 'suffix',
                        'options' => array(
                            'suffix' => esc_html__('Behind price (Ex: 500$)', 'fat-event'),
                            'prefix' => esc_html__('In front of price (Ex: $500)', 'fat-event'),
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Currency decimal', 'fat-event'),
                        'id' => 'currency_decimal',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 5,
                        'step' => 1,
                        'std' => 0,
                        'description' => esc_html__('Specify the number of decimals. Ex: if price is 510 and currency decimal is 2, the price displayed will be 510.00','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Currency separator', 'fat-event'),
                        'id' => 'currency_separator',
                        'type' => 'text',
                        'std' => ',',
                        'description' => esc_html__('Specifies what string to use for thousands separator. Only the first character of separator is used. Ex: if price is 5100 and separator is , then the price displayed will be: 5,100','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Country limit', 'fat-event'),
                        'id' => 'section_country',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Enable country limit', 'fat-event'),
                        'id' => 'enable_country_limit',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                        'description' => esc_html__('Limit country in booking form','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Allow country', 'fat-event'),
                        'id' => 'allow_country',
                        'type' => 'select',
                        'multiple' => true,
                        'std' => '',
                        'options' => array(
                            'Afghanistan' => esc_html__('Afghanistan','fat-event'),
                            'Albania' => esc_html__('Albania','fat-event'),
                            'Algeria' => esc_html__('Algeria','fat-event'),
                            'Andorra' => esc_html__('Andorra','fat-event'),
                            'Angola' => esc_html__('Angola','fat-event'),
                            'Antigua and Barbuda' => esc_html__('Antigua and Barbuda','fat-event'),
                            'Argentina' => esc_html__('Argentina','fat-event'),
                            'Armenia' => esc_html__('Armenia','fat-event'),
                            'Australia' => esc_html__('Australia','fat-event'),
                            'Austria' => esc_html__('Austria','fat-event'),
                            'Azerbaijan' => esc_html__('Azerbaijan','fat-event'),
                            'The Bahamas' => esc_html__('The Bahamas','fat-event'),
                            'Bahrain' => esc_html__('Bahrain','fat-event'),
                            'Bangladesh' => esc_html__('Bangladesh','fat-event'),
                            'Barbados' => esc_html__('Barbados','fat-event'),
                            'Belarus' => esc_html__('Belarus','fat-event'),
                            'Belgium' => esc_html__('Belgium','fat-event'),
                            'Belize' => esc_html__('Belize','fat-event'),
                            'Benin' => esc_html__('Benin','fat-event'),
                            'Bhutan' => esc_html__('Bhutan','fat-event'),
                            'Bolivia' => esc_html__('Bolivia','fat-event'),
                            'Bosnia and Herzegovina' => esc_html__('Bosnia and Herzegovina','fat-event'),
                            'Botswana' => esc_html__('Botswana','fat-event'),
                            'Brazil' => esc_html__('Brazil','fat-event'),
                            'Brunei' => esc_html__('Brunei','fat-event'),
                            'Bulgaria' => esc_html__('Bulgaria','fat-event'),
                            'Burkina Faso' => esc_html__('Burkina Faso','fat-event'),
                            'Burundi' => esc_html__('Burundi','fat-event'),
                            'Cabo Verde' => esc_html__('Cabo Verde','fat-event'),
                            'Cambodia' => esc_html__('Cambodia','fat-event'),
                            'Cameroon' => esc_html__('Cameroon','fat-event'),
                            'Canada' => esc_html__('Canada','fat-event'),
                            'Central African Republic' => esc_html__('Central African Republic','fat-event'),
                            'Chad' => esc_html__('Chad','fat-event'),
                            'Chile' => esc_html__('Chile','fat-event'),
                            'China' => esc_html__('China','fat-event'),
                            'Colombia' => esc_html__('Colombia','fat-event'),
                            'Comoros' => esc_html__('Comoros','fat-event'),
                            'Congo, Democratic  Republic of the' => 'Congo, Democratic  Republic of the',
                            'Congo, Republic of the' => 'Congo, Republic of the',
                            'Costa Rica' => esc_html__('Costa Rica','fat-event'),
                            'Côte d’Ivoire' => 'Côte d’Ivoire',
                            'Croatia' => esc_html__('Croatia','fat-event'),
                            'Cuba' => esc_html__('Cuba','fat-event'),
                            'Cyprus' => esc_html__('Cyprus','fat-event'),
                            'Czech Republic' => esc_html__('Czech Republic','fat-event'),
                            'Denmark' => esc_html__('Denmark','fat-event'),
                            'Djibouti' => esc_html__('Djibouti','fat-event'),
                            'Dominica' => esc_html__('Dominica','fat-event'),
                            'Dominican Republic' => esc_html__('Dominican Republic','fat-event'),
                            'East Timor' => esc_html__('East Timor','fat-event'),
                            'Ecuador' => esc_html__('Ecuador','fat-event'),
                            'Egypt' => esc_html__('Egypt','fat-event'),
                            'El Salvador' => esc_html__('El Salvador','fat-event'),
                            'Equatorial Guinea' => esc_html__('Equatorial Guinea','fat-event'),
                            'Eritrea' => esc_html__('Eritrea','fat-event'),
                            'Estonia' => esc_html__('Estonia','fat-event'),
                            'Ethiopia' => esc_html__('Ethiopia','fat-event'),
                            'Fiji' => esc_html__('Fiji','fat-event'),
                            'Finland' => esc_html__('Finland','fat-event'),
                            'France' => esc_html__('France','fat-event'),
                            'Gabon' => esc_html__('Gabon','fat-event'),
                            'The Gambia' => esc_html__('The Gambia','fat-event'),
                            'Georgia' => esc_html__('Georgia','fat-event'),
                            'Germany' => esc_html__('Germany','fat-event'),
                            'Ghana' => esc_html__('Ghana','fat-event'),
                            'Greece' => esc_html__('Greece','fat-event'),
                            'Grenada' => esc_html__('Grenada','fat-event'),
                            'Guatemala' => esc_html__('Guatemala','fat-event'),
                            'Guinea' => esc_html__('Guinea','fat-event'),
                            'Guinea-Bissau' => 'Guinea-Bissau',
                            'Guyana' => esc_html__('Guyana','fat-event'),
                            'Haiti' => esc_html__('Haiti','fat-event'),
                            'Honduras' => esc_html__('Honduras','fat-event'),
                            'Hungary' => esc_html__('Hungary','fat-event'),
                            'Iceland' => esc_html__('Iceland','fat-event'),
                            'India' => esc_html__('India','fat-event'),
                            'Indonesia' => esc_html__('Indonesia','fat-event'),
                            'Iran' => esc_html__('Iran','fat-event'),
                            'Iraq' => esc_html__('Iraq','fat-event'),
                            'Ireland' => esc_html__('Ireland','fat-event'),
                            'Israel' => esc_html__('Israel','fat-event'),
                            'Italy' => esc_html__('Italy','fat-event'),
                            'Jamaica' => esc_html__('Jamaica','fat-event'),
                            'Japan' => esc_html__('Japan','fat-event'),
                            'Jordan' => esc_html__('Jordan','fat-event'),
                            'Kazakhstan' => esc_html__('Kazakhstan','fat-event'),
                            'Kenya' => esc_html__('Kenya','fat-event'),
                            'Kiribati' => esc_html__('Kiribati','fat-event'),
                            'Korea, North' => 'Korea, North',
                            'Korea, South' => 'Korea, South',
                            'Kosovo' => esc_html__('Kosovo','fat-event'),
                            'Kuwait' => esc_html__('Kuwait','fat-event'),
                            'Kyrgyzstan' => esc_html__('Kyrgyzstan','fat-event'),
                            'Laos' => esc_html__('Laos','fat-event'),
                            'Latvia' => esc_html__('Latvia','fat-event'),
                            'Lebanon' => esc_html__('Lebanon','fat-event'),
                            'Lesotho' => esc_html__('Lesotho','fat-event'),
                            'Liberia' => esc_html__('Liberia','fat-event'),
                            'Libya' => esc_html__('Libya','fat-event'),
                            'Liechtenstein' => esc_html__('Liechtenstein','fat-event'),
                            'Lithuania' => esc_html__('Lithuania','fat-event'),
                            'Luxembourg' => esc_html__('Luxembourg','fat-event'),
                            'Macedonia' => esc_html__('Macedonia','fat-event'),
                            'Madagascar' => esc_html__('Madagascar','fat-event'),
                            'Malawi' => esc_html__('Malawi','fat-event'),
                            'Malaysia' => esc_html__('Malaysia','fat-event'),
                            'Maldives' => esc_html__('Maldives','fat-event'),
                            'Mali' => esc_html__('Mali','fat-event'),
                            'Malta' => esc_html__('Malta','fat-event'),
                            'Marshall Islands' => esc_html__('Marshall Islands','fat-event'),
                            'Mauritania' => esc_html__('Mauritania','fat-event'),
                            'Mauritius' => esc_html__('Mauritius','fat-event'),
                            'Mexico' => esc_html__('Mexico','fat-event'),
                            'Micronesia,  Federated States of' => 'Micronesia,  Federated States of',
                            'Moldova' => esc_html__('Moldova','fat-event'),
                            'Monaco' => esc_html__('Monaco','fat-event'),
                            'Mongolia' => esc_html__('Mongolia','fat-event'),
                            'Montenegro' => esc_html__('Montenegro','fat-event'),
                            'Morocco' => esc_html__('Morocco','fat-event'),
                            'Mozambique' => esc_html__('Mozambique','fat-event'),
                            'Myanmar' => esc_html__('Myanmar','fat-event'),
                            'Namibia' => esc_html__('Namibia','fat-event'),
                            'Nauru' => esc_html__('Nauru','fat-event'),
                            'Nepal' => esc_html__('Nepal','fat-event'),
                            'Netherlands' => esc_html__('Netherlands','fat-event'),
                            'New Zealand' => esc_html__('New Zealand','fat-event'),
                            'Nicaragua' => esc_html__('Nicaragua','fat-event'),
                            'Niger' => esc_html__('Niger','fat-event'),
                            'Nigeria' => esc_html__('Nigeria','fat-event'),
                            'Norway' => esc_html__('Norway','fat-event'),
                            'Oman' => esc_html__('Oman','fat-event'),
                            'Pakistan' => esc_html__('Pakistan','fat-event'),
                            'Palau' => esc_html__('Palau','fat-event'),
                            'Panama' => esc_html__('Panama','fat-event'),
                            'Papua New Guinea' => esc_html__('Papua New Guinea','fat-event'),
                            'Paraguay' => esc_html__('Paraguay','fat-event'),
                            'Peru' => esc_html__('Peru','fat-event'),
                            'Philippines' => esc_html__('Philippines','fat-event'),
                            'Poland' => esc_html__('Poland','fat-event'),
                            'Portugal' => esc_html__('Portugal','fat-event'),
                            'Qatar' => esc_html__('Qatar','fat-event'),
                            'Romania' => esc_html__('Romania','fat-event'),
                            'Russia' => esc_html__('Russia','fat-event'),
                            'Rwanda' => esc_html__('Rwanda','fat-event'),
                            'Saint Kitts and Nevis' => esc_html__('Saint Kitts and Nevis','fat-event'),
                            'Saint Lucia' => esc_html__('Saint Lucia','fat-event'),
                            'Saint Vincent and  the Grenadines' => esc_html__('Saint Vincent and  the Grenadines','fat-event'),
                            'Samoa' => esc_html__('Samoa','fat-event'),
                            'San Marino' => esc_html__('San Marino','fat-event'),
                            'Sao Tome and Principe' => esc_html__('Sao Tome and Principe','fat-event'),
                            'Saudi Arabia' => esc_html__('Saudi Arabia','fat-event'),
                            'Senegal' => esc_html__('Senegal','fat-event'),
                            'Serbia' => esc_html__('Serbia','fat-event'),
                            'Seychelles' => esc_html__('Seychelles','fat-event'),
                            'Sierra Leone' => esc_html__('Sierra Leone','fat-event'),
                            'Singapore' => esc_html__('Singapore','fat-event'),
                            'Slovakia' => esc_html__('Slovakia','fat-event'),
                            'Slovenia' => esc_html__('Slovenia','fat-event'),
                            'Solomon Islands' => esc_html__('Solomon Islands','fat-event'),
                            'Somalia' => esc_html__('Somalia','fat-event'),
                            'South Africa' => esc_html__('South Africa','fat-event'),
                            'Spain' => esc_html__('Spain','fat-event'),
                            'Sri Lanka' => esc_html__('Sri Lanka','fat-event'),
                            'Sudan' => esc_html__('Sudan','fat-event'),
                            'Sudan, South' => 'Sudan, South',
                            'Suriname' => esc_html__('Suriname','fat-event'),
                            'Swaziland' => esc_html__('Swaziland','fat-event'),
                            'Sweden' => esc_html__('Sweden','fat-event'),
                            'Switzerland' => esc_html__('Switzerland','fat-event'),
                            'Syria' => esc_html__('Syria','fat-event'),
                            'Taiwan' => esc_html__('Taiwan','fat-event'),
                            'Tajikistan' => esc_html__('Tajikistan','fat-event'),
                            'Tanzania' => esc_html__('Tanzania','fat-event'),
                            'Thailand' => esc_html__('Thailand','fat-event'),
                            'Togo' => esc_html__('Togo','fat-event'),
                            'Tonga' => esc_html__('Tonga','fat-event'),
                            'Trinidad and Tobago' => esc_html__('Trinidad and Tobago','fat-event'),
                            'Tunisia' => esc_html__('Tunisia','fat-event'),
                            'Turkey' => esc_html__('Turkey','fat-event'),
                            'Turkmenistan' => esc_html__('Turkmenistan','fat-event'),
                            'Tuvalu' => esc_html__('Tuvalu','fat-event'),
                            'Uganda' => esc_html__('Uganda','fat-event'),
                            'Ukraine' => esc_html__('Ukraine','fat-event'),
                            'United Arab Emirates' => esc_html__('United Arab Emirates','fat-event'),
                            'United Kingdom' => esc_html__('United Kingdom','fat-event'),
                            'United States' => esc_html__('United States','fat-event'),
                            'Uruguay' => esc_html__('Uruguay','fat-event'),
                            'Uzbekistan' => esc_html__('Uzbekistan','fat-event'),
                            'Vanuatu' => esc_html__('Vanuatu','fat-event'),
                            'Vatican City' => esc_html__('Vatican City','fat-event'),
                            'Venezuela' => esc_html__('Venezuela','fat-event'),
                            'Vietnam' => esc_html__('Vietnam','fat-event'),
                            'Yemen' => esc_html__('Yemen','fat-event'),
                            'Zambia' => esc_html__('Zambia','fat-event'),
                            'Zimbabwe' => esc_html__('Zimbabwe','fat-event')
                        ),
                        'depend_field' => array(
                            'field' => 'enable_country_limit',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'description' => esc_html__('If you pickup country at here, the list country in booking form only show up as same as at here','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Payment', 'fat-event'),
                        'id' => 'section_payment',
                        'type' => 'section',
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Enable Woocomerce Integrated', 'fat-event'),
                        'id' => 'enable_woocommerce',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                        'description' => esc_html__(' If checked, the payment will be executed via Woocommerce','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Use booking form builder', 'fat-event'),
                        'id' => 'enable_form_builder',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                        'depend_field' => array(
                            'field' => 'enable_woocommerce',
                            'value' => '1',
                            'compare' => '!='
                        ),
                        'description' => esc_html__('If checked, booking form will be displayed via the booking form builder','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Enable coupon', 'fat-event'),
                        'id' => 'enable_coupon',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0'
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Payment method', 'fat-event'),
                        'id' => 'payment_method',
                        'type' => 'select',
                        'std' => 'offline_paypal',
                        'options' => array(
                            'both' => esc_html__('Offline, Paypal and Stripe', 'fat-event'),
                            'offline' => esc_html__('Offline', 'fat-event'),
                            'paypal' => esc_html__('Paypal', 'fat-event'),
                            'stripe' => esc_html__('Stripe', 'fat-event'),
                            'myPOS' => esc_html__('myPOS', 'fat-event'),
                            'offline_paypal' => esc_html__('Offline and Paypal', 'fat-event'),
                            'offline_stripe' => esc_html__('Offline and Stripe', 'fat-event'),
                            'paypal_stripe' => esc_html__('Paypal and Stripe', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'enable_woocommerce',
                            'value' => '1',
                            'compare' => '!='
                        ),
                    ),

                    /** paypal */
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Payment API', 'fat-event'),
                        'id' => 'payment_api',
                        'type' => 'select',
                        'std' => 'sandbox',
                        'options' => array(
                            'sandbox' => esc_html__('Sandbox for test', 'fat-event'),
                            'live' => esc_html__('Live', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'both,paypal,paypal_stripe,offline_paypal,myPOS',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Paypal Client ID', 'fat-event'),
                        'id' => 'paypal_client_id',
                        'type' => 'text',
                        'std' => 'AcjVqTSABlK2AYj4VruT1f7LH4WgpkXHjaUoYH7UwdIzDplzVfrFDifrzRVXw_YGgAZyKtKZaW0IO6ek',
                        'description' => esc_html__('Please go to here: https://developer.paypal.com and create your paypal app', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'both,paypal,paypal_stripe,offline_paypal',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Paypal Secret', 'fat-event'),
                        'id' => 'paypal_secret',
                        'type' => 'text',
                        'std' => 'ECZLRZe7Bi4z4yljhB0lsifnkjTn4Q3rhRJreHQQCUou3anY5NWwrWubZT2HvhOIqqpMPGwd2a8sXbf1',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'both,paypal,paypal_stripe,offline_paypal',
                            'compare' => 'in'
                        ),
                    ),
                    /** end paypal */

                    /** stripe */
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Stripe Publish Key', 'fat-event'),
                        'id' => 'stripe_publish_key',
                        'type' => 'text',
                        'std' => 'pk_test_9q3BpuszZDNlnc8uppYQYQH7',
                        'description' => esc_html__('Please go to here: https://stripe.com and create your api key', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'both,paypal_stripe,offline_stripe,stripe',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Stripe Secret Key', 'fat-event'),
                        'id' => 'stripe_secret_key',
                        'type' => 'text',
                        'std' => 'sk_test_4z295yRYaiEBneY29hOzzMF5',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'both,paypal_stripe,offline_stripe,stripe',
                            'compare' => 'in'
                        ),
                    ),
                    /** end stripe */

                    /** myPOS */
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Store ID', 'fat-event'),
                        'id' => 'myPOS_storeID',
                        'type' => 'text',
                        'std' => '000000000000010',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'myPOS',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Client number', 'fat-event'),
                        'id' => 'myPOS_client_number',
                        'type' => 'text',
                        'std' => '61938166610',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'myPOS',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Key index', 'fat-event'),
                        'id' => 'myPOS_key_index',
                        'type' => 'text',
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'myPOS',
                            'compare' => 'in'
                        ),
                        'description' => esc_html__('The Key Index assigned to the certificate could be reviewed in your online banking at www.mypos.eu > menu Online > Online stores > Keys.','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('myPOS private key', 'fat-event'),
                        'id' => 'myPOS_private_key',
                        'type' => 'textarea',
                        'std' => '',
                        'description' => esc_html__('Please go to here: https://developers.mypos.eu and create your prirate key', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'myPOS',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('myPOS public certificate', 'fat-event'),
                        'id' => 'myPOS_public_certificate',
                        'type' => 'textarea',
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'payment_method',
                            'value' => 'myPOS',
                            'compare' => 'in'
                        ),
                    ),
                    /** end myPOS */

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Payment Notification', 'fat-event'),
                        'id' => 'section_payment_notification',
                        'type' => 'section',
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Payment notification', 'fat-event'),
                        'id' => 'payment_notification',
                        'type' => 'select',
                        'std' => 'popup',
                        'options' => array(
                            'popup' => esc_html__('Popup message', 'fat-event'),
                            'page' => esc_html__('Redirect to success (error) page', 'fat-event'),
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Success message', 'fat-event'),
                        'id' => 'payment_success_message',
                        'type' => 'text',
                        'std' => esc_html__('Thank you for your booking. See you soon in our event!', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'payment_notification',
                            'value' => 'popup',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Error message', 'fat-event'),
                        'id' => 'payment_error_message',
                        'type' => 'text',
                        'std' => esc_html__('Sorry for the inconvenience. Please contact our staff by send mail to : info@roninwp.com !', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'payment_notification',
                            'value' => 'popup',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Page success', 'fat-event'),
                        'id' => 'payment_page_success',
                        'type' => 'select',
                        'std' => '',
                        'data_source' => 'page',
                        'depend_field' => array(
                            'field' => 'payment_notification',
                            'value' => 'page',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab_payment',
                        'label' => esc_html__('Page error', 'fat-event'),
                        'id' => 'payment_page_error',
                        'type' => 'select',
                        'std' => '',
                        'data_source' => 'page',
                        'depend_field' => array(
                            'field' => 'payment_notification',
                            'value' => 'page',
                            'compare' => '='
                        ),
                    ),

                    /** tab booking */
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Email blacklist', 'fat-event'),
                        'id' => 'section_email_blacklist',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Email blacklist', 'fat-event'),
                        'id' => 'email_blacklist',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Use commas to separate emails. Example: a@gmail.com,b@gmail.com','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Customer information', 'fat-event'),
                        'id' => 'section_customer_information',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Remember latest booking', 'fat-event'),
                        'id' => 'remember_latest_booking',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                        'description' => esc_html__('Remember latest booking and auto fill for the next booking','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Booking filter', 'fat-event'),
                        'id' => 'section_booking',
                        'type' => 'section',

                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by event', 'fat-event'),
                        'id' => 'filter_by_event',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by customer', 'fat-event'),
                        'id' => 'filter_by_customer',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by payment type', 'fat-event'),
                        'id' => 'filter_by_payment_type',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by booking status', 'fat-event'),
                        'id' => 'filter_by_booking_status',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by category', 'fat-event'),
                        'id' => 'filter_by_category',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by location', 'fat-event'),
                        'id' => 'filter_by_location',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display filter by organizer', 'fat-event'),
                        'id' => 'filter_by_organizer',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display Columns', 'fat-event'),
                        'id' => 'section_display_columns',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display start date', 'fat-event'),
                        'id' => 'display_start_date',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display end date', 'fat-event'),
                        'id' => 'display_end_date',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display create date', 'fat-event'),
                        'id' => 'display_create_date',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display customer', 'fat-event'),
                        'id' => 'display_customer',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display email', 'fat-event'),
                        'id' => 'display_email',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display payment type', 'fat-event'),
                        'id' => 'display_payment_type',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display confirm participation', 'fat-event'),
                        'id' => 'display_confirm',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display booking status', 'fat-event'),
                        'id' => 'display_booking_status',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '1',
                    ),
                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display category', 'fat-event'),
                        'id' => 'display_category',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display location', 'fat-event'),
                        'id' => 'display_location',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),

                    array(
                        'tab_id' => 'tab_booking',
                        'label' => esc_html__('Display organizer', 'fat-event'),
                        'id' => 'display_organizer',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes','fat-event'),
                        ),
                        'std' => '0',
                    ),

                    /** tab color */
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Font', 'fat-event'),
                        'id' => 'section_font_color',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Use google front', 'fat-event'),
                        'id' => 'use_google_font',
                        'type' => 'check',
                        'options' => array(
                            '1' => 'Yes'
                        ),
                        'std' => ''
                    ),
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Event title font', 'fat-event'),
                        'id' => 'event_title_font',
                        'type' => 'google_font',
                        'std' => array(
                            'font_family' => 'Montserrat',
                            'font_weight' => 400,
                            'font_size' => 16
                        ),
                        'depend_field' => array(
                            'field' => 'use_google_font',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Location font', 'fat-event'),
                        'id' => 'location_font',
                        'type' => 'google_font',
                        'std' => array(
                            'font_family' => 'Montserrat',
                            'font_weight' => 400,
                            'font_size' => 14
                        ),
                        'depend_field' => array(
                            'field' => 'use_google_font',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Date time font', 'fat-event'),
                        'id' => 'date_time_font',
                        'type' => 'google_font',
                        'std' => array(
                            'font_family' => 'Montserrat',
                            'font_weight' => 400,
                            'font_size' => 16
                        ),
                        'depend_field' => array(
                            'field' => 'use_google_font',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab_color',
                        'label' => esc_html__('Description font', 'fat-event'),
                        'id' => 'description_font',
                        'type' => 'google_font',
                        'std' => array(
                            'font_family' => 'Montserrat',
                            'font_weight' => 400,
                            'font_size' => 14
                        ),
                        'depend_field' => array(
                            'field' => 'use_google_font',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    /** Tab Custom CSS */
                    array(
                        'tab_id' => 'tab_css',
                        'label' => esc_html__('Custom Css', 'fat-event'),
                        'id' => 'section_custom_css',
                        'type' => 'section',
                    ),
                    array(
                        'tab_id' => 'tab_css',
                        'label' => esc_html__('Single custom css', 'fat-event'),
                        'id' => 'single_custom_css',
                        'type' => 'ace',
                        'mode' => 'css',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This css will apply to the single event page', 'fat-event')
                    ),
                )
            );

            $options = apply_filters('fat_event_setting_panel', $options);

            return $options;
        }

        function fat_event_booking_builder_callback(){
            if(file_exists(FAT_EVENT_DIR_PATH.'/templates/booking/booking-builder.php')){
                include_once (FAT_EVENT_DIR_PATH.'/templates/booking/booking-builder.php');
            }
        }

        function admin_enqueue_script(){
            $screen = get_current_screen();
            if(isset($screen->id) && $screen->id==='fat-event_page_fat-event-booking-builder'){
                wp_enqueue_style('form-builder',FAT_EVENT_PLUGIN_URL.'/assets/plugins/form-builder/form-builder.css',array(),'1.0.0');

                wp_enqueue_script('form-builder', FAT_EVENT_PLUGIN_URL.'/assets/plugins/form-builder/form-builder.min.js', array('jquery'), '3.1.2', false);
                wp_enqueue_script('fat-form-builder', FAT_EVENT_ASSET_JS_URL.'/admin/form-builder.js', array('jquery'), '1.0.0', false);
                wp_localize_script('fat-form-builder', 'fat_event_ajax', array('ajaxurl' => admin_url('admin-ajax.php')));
            }
        }

    }
}