<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 6/11/2018
 * Time: 9:02 AM
 */
if (!defined('ABSPATH')) die('-1');
if (!class_exists('FAT_Event_CPT')) {
    class FAT_Event_CPT
    {
        function __construct()
        {
            add_action('init', array($this, 'register_post_types'), 5);
            add_action('init', array($this, 'register_coupon_post_types'), 5);
            add_action('init', array($this, 'register_shortcode_post_types'), 5);
            add_action('init', array($this, 'register_booking_post_types'), 5);
            add_action('init', array($this, 'register_taxonomies'), 6);
            add_action('init', array($this, 'register_tag_taxonomies'), 7);
            add_action('init', array($this, 'register_location_taxonomies'), 8);
            add_action('init', array($this, 'register_organizer_taxonomies'), 8);

            add_action('admin_head', array($this, 'include_tmpl'), 8);
            add_action('send_headers', array($this, 'attention_confirm'),5);
            add_action('send_headers', array($this, 'payment_update_status'),10);
            add_action('parse_request', array($this, 'myPOS_update_status'),15);

            add_action('init', array($this, 'register_export_calendar'), 100);

            add_filter('fat_cmb_register_metabox', array($this, 'register_meta_boxes'));
            add_filter('fat_cmb_register_metabox', array($this, 'register_booking_meta_boxes'));
            add_filter('fat_cmb_register_metabox', array($this, 'register_shortcode_meta_boxes'));
            add_filter('fat_cmb_register_metabox', array($this, 'register_coupon_meta_boxes'));

            add_filter('fat_cmb_register_taxonomy_metabox', array($this, 'register_taxonomy_meta_boxes'));

            add_filter('posts_where', array($this, 'title_like_posts_where'), 10, 2);

            add_filter('single_template', array($this, 'get_event_single_template'));
            add_filter('archive_template', array($this, 'get_event_archive_template'));

            add_filter('fat_cpt_single_page_template', array($this, 'fat_cpt_single_page_template_callback'));
            add_filter('porto_page_title', array($this,'singe_event_page_title'));

            add_action('created_'.FAT_EVENT_LOCATION_TAXONOMY, array($this,'event_create_location_term'),10,2);
            add_action('created_'.FAT_EVENT_ORGANIZER_TAXONOMY, array($this,'event_create_organizer_term'),10,2);

            add_action('in_admin_footer', array($this,'include_tmpl_booking'));
            if (is_admin()) {
                add_action('save_post_'.FAT_EVENT_POST_TYPE, array($this, 'event_save_post'));
                add_action('save_post_'.FAT_EVENT_BOOKING_POST_TYPE, array($this, 'booking_save_post'));
                add_action('before_delete_post', array($this, 'booking_delete_post'));
                add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'), 0);

                add_action('fat-cmb-after-update-fat_event_setting', array($this, 'flush_rewrite'), 10, 1);

                add_filter('fat_cmd_field_value', array($this, 'fat_booking_field_value'), 10, 3);
                add_filter('fat_cmd_field_description', array($this, 'fat_booking_field_description'), 10, 3);

                // add duplicate event
                add_filter('page_row_actions',array($this,'add_duplicate_link'), 10, 2);
            }

            /** add columns to admin listing */
            if (is_admin()) {
                add_filter('manage_edit-' . FAT_EVENT_SHORTCODE_POST_TYPE . '_columns', array($this, 'add_admin_listing_shortcode_columns'));
                add_action('manage_' . FAT_EVENT_SHORTCODE_POST_TYPE . '_posts_custom_column', array($this, 'set_admin_listing_shortcode_columns_value'), 10, 2);

                add_filter('manage_edit-' . FAT_EVENT_POST_TYPE . '_columns', array($this, 'add_admin_listing_event_columns'));
                add_action('manage_' . FAT_EVENT_POST_TYPE . '_posts_custom_column', array($this, 'set_admin_listing_event_columns_value'), 10, 2);

                add_action('restrict_manage_posts', array($this, 'admin_listing_event_manage_posts'));
                add_filter('parse_query', array($this, 'admin_convert_category_taxonomy_in_query'));

                add_action('restrict_manage_posts', array($this, 'admin_listing_event_location_manage_posts'));
                add_filter('parse_query', array($this, 'admin_convert_location_taxonomy_in_query'));

                add_action('restrict_manage_posts', array($this, 'admin_listing_event_organizer_manage_posts'));
                add_filter('parse_query', array($this, 'admin_convert_organizer_taxonomy_in_query'));

                add_filter('manage_edit-' . FAT_EVENT_POST_TYPE . '_sortable_columns', array($this, 'set_fat_event_sortable_columns'));
                add_action('pre_get_posts', array($this, 'columns_custom_orderby'));

                // add column for booking listing
                add_filter('manage_edit-' . FAT_EVENT_BOOKING_POST_TYPE . '_columns', array($this, 'add_admin_listing_booking_columns'));
                add_action('manage_' . FAT_EVENT_BOOKING_POST_TYPE . '_posts_custom_column', array($this, 'set_admin_listing_booking_columns_value'), 10, 2);
                add_action('restrict_manage_posts', array($this, 'admin_listing_booking_manage_posts'));
                add_filter('parse_query', array($this, 'admin_convert_booking_in_query'), 900, 1);
                add_action('pre_get_posts', array($this, 'booking_custom_orderby'));

                // making column sortable for booking listing
                add_filter( 'manage_edit-' . FAT_EVENT_BOOKING_POST_TYPE . '_sortable_columns', array($this,'make_booking_column_sortable'));

                // add column for coupon listing
                add_action('save_post_'.FAT_EVENT_COUPON_POST_TYPE, array($this, 'save_coupon_post'));
                add_filter('manage_edit-' . FAT_EVENT_COUPON_POST_TYPE . '_columns', array($this, 'add_admin_listing_coupon_columns'));
                add_action('manage_' . FAT_EVENT_COUPON_POST_TYPE . '_posts_custom_column', array($this, 'set_admin_listing_coupon_columns_value'), 10, 2);


                $ajax_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/utils/be-ajax.php';
                if (file_exists($ajax_path)) {
                    include_once($ajax_path);
                }
            }

        }

        public function add_duplicate_link($actions, $post){
            if($post->post_type===FAT_EVENT_POST_TYPE){
                $actions['fat_event_duplicate'] = '<a href="javascript:;" data-id="'.$post->ID.'" class="fat-event-duplicate">' . esc_html__('Duplicate','fat-event') . '</a>';
            }
            return $actions;
        }

        public function title_like_posts_where($where, $wp_query)
        {
            global $wpdb;
            if ($wp_query->get('post_type') === FAT_EVENT_POST_TYPE && $post_title_like = $wp_query->get('post_title_like')) {
                $where .= ' AND (' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql($wpdb->esc_like($post_title_like)) . '%\' OR ' . $wpdb->posts . '.ID=\'' . $post_title_like . '\')';
            }
            return $where;
        }

        public function fat_cpt_single_page_template_callback($cpt)
        {
            $cpt[] = array(
                'title' => esc_html__('Event single page template', 'fat-event'),
                'slug' => FAT_EVENT_POST_TYPE,
            );
            return $cpt;
        }

        /** start event post type */
        function register_post_types()
        {

            $post_type = FAT_EVENT_POST_TYPE;
            $slug = 'fat-event';
            $name = $singular_name = esc_html__('FAT Event','fat-event');

            if (post_type_exists($post_type)) {
                return;
            }
            $fat_event_setting = get_option('fat_event_setting');
            $slug = isset($fat_event_setting['event_slug']) && $fat_event_setting['event_slug'] ? $fat_event_setting['event_slug'] : $slug;
            $name = $singular_name =isset($fat_event_setting['event_singular_name']) && $fat_event_setting['event_singular_name'] ? $fat_event_setting['event_singular_name'] : $name;

            register_post_type($post_type,
                array(
                    'label' => esc_html__('FAT Event', 'fat-event'),
                    'description' => esc_html__('FAT Event Description', 'fat-event'),
                    'labels' => array(
                        'name' => $name,
                        'singular_name' => $singular_name,
                        'menu_name' => ucfirst($name),
                        'parent_item_colon' => esc_html__('Parent Item:', 'fat-event'),
                        'all_items' => sprintf(esc_html__('All %s', 'fat-event'), $name),
                        'view_item' => esc_html__('View Event', 'fat-event'),
                        'add_new_item' => sprintf(esc_html__('Add New  %s', 'fat-event'), $name),
                        'add_new' => esc_html__('Add Event', 'fat-event'),
                        'edit_item' => esc_html__('Edit Event', 'fat-event'),
                        'update_item' => esc_html__('Update Event', 'fat-event'),
                        'search_items' => esc_html__('Search Event', 'fat-event'),
                        'not_found' => esc_html__('Not found', 'fat-event'),
                        'not_found_in_trash' => esc_html__('Not found in Trash', 'fat-event'),
                    ),
                    'supports' => array('title', 'thumbnail', 'editor', 'excerpt', 'comments'),
                    'public' => true,
                    'show_ui' => true,
                    '_builtin' => false,
                    'has_archive' => true,
                    'exclude_from_search' => true,
                    'menu_icon' => 'dashicons-calendar-alt',
                    'hierarchical' => true,
                    'rewrite' => array('slug' => $slug, 'with_front' => true),
                )
            );

            $flush_rewrite = get_option('fat_event_flush_rewrite',0);
            if($flush_rewrite!=1){
                flush_rewrite_rules();
                update_option('fat_event_flush_rewrite',1);
            }
        }

        function register_meta_boxes($meta_boxes)
        {
            $fat_event_setting = get_option('fat_event_setting');
            $current_user_id = get_current_user_id();
            $utils = new FAT_Event_Utils();

            $args = array(
                'include' => ''
            );
            if (isset($fat_event_setting['enable_create_event'][0]) && $fat_event_setting['enable_create_event'][0]=='1'){
                if ($current_user_id && isset($fat_event_setting['allow_select_location']) && $fat_event_setting['allow_select_location'] == 'owner') {
                    $term_owner = get_user_meta($current_user_id, 'location_term_owner', true);
                    if (is_array($term_owner) && count($term_owner) > 0) {
                        $args['include'] = $term_owner;
                        $location = $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY, $args);
                    }else{
                        $location = array();
                    }
                }else{
                    $location = $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY);
                }
            }else{
                $location = $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY);
            }

            $location = array(
                    'hide' => esc_html__('Hide location', 'fat-event'),
                    'add_new' => esc_html__('Add new location', 'fat-event'),
                ) + $location;


            $args = array(
                'include' => ''
            );
            if (isset($fat_event_setting['enable_create_event'][0]) && $fat_event_setting['enable_create_event'][0]=='1'){
                if ($current_user_id && isset($fat_event_setting['allow_select_organizer']) && $fat_event_setting['allow_select_organizer'] == 'owner') {
                    $term_owner = get_user_meta($current_user_id, 'organizer_term_owner', true);
                    if (is_array($term_owner)  && count($term_owner) > 0) {
                        $args['include'] = $term_owner;
                        $other_organizer = $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY, $args);
                    }else{
                        $other_organizer = array();
                    }
                }else{
                    $other_organizer = $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY);
                }
            }else{
                $other_organizer = $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY);
            }

            $main_organizer = array(
                    'hide' => esc_html__('Hide organizer', 'fat-event'),
                    'add_new' => esc_html__('Add new organizer', 'fat-event'),
                ) + $other_organizer;

            $gateways = array();

            if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'both'){
                $gateways['both'] = esc_html__('Offline, Paypal and Stripe', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'offline_paypal'){
                $gateways['offline_paypal'] = esc_html__('Offline and Paypal', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'offline_stripe'){
                $gateways['offline_stripe'] = esc_html__('Offline and Stripe', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'paypal_stripe'){
                $gateways['offline_stripe'] = esc_html__('Paypal and Stripe', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && $fat_event_setting['payment_method'] == 'myPOS'){
                $gateways['myPOS'] = esc_html__('myPOS', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method']=='offline' || $fat_event_setting['payment_method'] == 'both'
                    || $fat_event_setting['payment_method'] == 'offline_paypal' || $fat_event_setting['payment_method'] == 'offline_stripe')){
                $gateways['offline'] = esc_html__('Payment offline', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] === 'both' || $fat_event_setting['payment_method'] === 'paypal'
                    || $fat_event_setting['payment_method'] === 'paypal_stripe' || $fat_event_setting['payment_method'] === 'offline_paypal')) {
                $gateways['paypal'] = esc_html__('Payment by Paypal', 'fat-event');
            }

            if (isset($fat_event_setting['payment_method']) && ($fat_event_setting['payment_method'] === 'both' || $fat_event_setting['payment_method'] === 'stripe'
                    || $fat_event_setting['payment_method'] === 'paypal_stripe' || $fat_event_setting['payment_method'] === 'offline_stripe')) {
                $gateways['stripe'] = esc_html__('Payment by Stripe', 'fat-event');
            }

            $gateways['external_link'] = esc_html__('External link','fat-event');

            $step = 0.01;
            $step = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal']==0 ? 1 : $step;
            $step = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal']==1 ? 0.1 : $step;
            $step = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal']==2 ? 0.01 : $step;
            $step = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal']==3 ? 0.001 : $step;
            $step = isset($fat_event_setting['currency_decimal']) && $fat_event_setting['currency_decimal']==4 ? 0.0001 : $step;

            $meta_boxes[] = array(
                'title' => esc_html__('Event Details', 'fat-event'),
                'id' => 'fat-mb-event-detail',
                'priority' => 'high',
                'pages' => array(FAT_EVENT_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('Start Date', 'fat-event'),
                        'id' => 'start_date',
                        'type' => 'datetime',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Format: Year/Month/Day Hour:Minute', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('End Date', 'fat-event'),
                        'id' => 'end_date',
                        'type' => 'datetime',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Format: Year/Month/Day Hour:Minute', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('All Day Event', 'fat-event'),
                        'id' => 'all_day_event',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),


                    /** Repeating */
                    array(
                        'label' => esc_html__('Event Repeating', 'fat-event'),
                        'id' => 'event_repeating',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'col_width' => 'fat-cmb-col-12',
                        'value' => ''
                    ),
                    array(
                        'label' => esc_html__('Repeat', 'fat-event'),
                        'id' => 'repeat',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'daily' => esc_html__('Daily', 'fat-event'),
                            'monthly' => esc_html__('Monthly', 'fat-event'),
                            'weekly' => esc_html__('Weekly', 'fat-event'),
                            'yearly' => esc_html__('Yearly', 'fat-event'),
                            'custom' => esc_html__('Custom days', 'fat-event')
                        ),
                        'std' => 'daily',
                        'depend_field' => array(
                            'field' => 'event_repeating',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Repeat interval', 'fat-event'),
                        'id' => 'daily_interval',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'repeat',
                            'value' => 'daily',
                            'compare' => '='
                        ),
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Repeat event display', 'fat-event'),
                        'id' => 'repeat_event_display',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 365,
                        'step' => 1,
                        'std' => '1',
                        'depend_field' => array(
                            'field' => 'repeat',
                            'value' => 'custom',
                            'compare' => '!='
                        ),
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Number of event will be repeat on frontend','fat-event')
                    ),
                    array(
                        'label' => esc_html__('Custom days', 'fat-event'),
                        'id' => 'custom_days',
                        'type' => 'repeat',
                        'fields' => array(
                            array(
                                'label' => esc_html__('Start', 'fat-event'),
                                'id' => 'repeat_on_date',
                                'type' => 'datetime',
                                'std' => '',
                                'time_picker' => 1
                            ),
                            array(
                                'label' => esc_html__('To', 'fat-event'),
                                'id' => 'repeat_to_date',
                                'type' => 'datetime',
                                'std' => '',
                                'time_picker' => 1
                            ),
                        ),
                        'depend_field' => array(
                            'field' => 'repeat',
                            'value' => 'custom',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Multiple location', 'fat-event'),
                        'id' => 'multiple_location',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'no' => esc_html__('No. The event takes place at one location', 'fat-event'),
                            'yes' => esc_html__('Yes. Events taking place in many locations', 'fat-event'),
                        ),
                        'std' => 'no',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('If choices Yes. Please select locations and organizer in \'Hourly Schedule\' section','fat-event')
                    ),

                    /** Day off */
                    array(
                        'label' => esc_html__('Day off', 'fat-event'),
                        'id' => 'section_day_off',
                        'type' => 'section',
                        'description' => esc_html__('Select a date that you do not allow reservations','fat-event')
                    ),
                    array(
                        'id' => 'day_off',
                        'type' => 'repeat',
                        'fields' => array(
                            array(
                                'label' => esc_html__('Day off', 'fat-event'),
                                'id' => 'dof',
                                'type' => 'dateranger',
                                'std' => '',
                                'date_format' => 'Y/m/d',
                                'col_width' => 'fat-cmb-col-12',
                            )
                        )
                    ),

                    /** Hour schedule */
                    array(
                        'label' => esc_html__('Hourly Schedule', 'fat-event'),
                        'id' => 'section_schedule',
                        'type' => 'section',
                    ),
                    array(
                        'id' => 'schedule',
                        'type' => 'repeat',
                        'fields' => array(
                            array(
                                'label' => esc_html__('From', 'fat-event'),
                                'id' => 'from',
                                'type' => 'text',
                                'std' => '',
                                'description' => esc_html__('Ex: 8:30', 'fat-event')
                            ),
                            array(
                                'label' => esc_html__('To', 'fat-event'),
                                'id' => 'to',
                                'type' => 'text',
                                'std' => '',
                                'description' => esc_html__('Ex: 9:30', 'fat-event')
                            ),
                            array(
                                'label' => esc_html__('Title', 'fat-event'),
                                'id' => 'title',
                                'type' => 'text',
                                'std' => '',
                            ),
                            array(
                                'label' => esc_html__('Description', 'fat-event'),
                                'id' => 'description',
                                'type' => 'text',
                                'std' => ''
                            ),
                            array(
                                'label' => esc_html__('Choose location', 'fat-event'),
                                'id' => 'location',
                                'type' => 'select',
                                'multiple' => false,
                                'options' => $location,
                                'std' => '',
                                'col_width' => 'fat-cmb-col-6',
                                'depend_field' => array(
                                    'field' => 'multiple_location',
                                    'value' => 'yes',
                                    'compare' => '='
                                ),
                            ),
                            array(
                                'label' => esc_html__('Organizer', 'fat-event'),
                                'id' => 'organizer',
                                'type' => 'select',
                                'multiple' => false,
                                'options' => $main_organizer,
                                'std' => 'hide',
                                'col_width' => 'fat-cmb-col-6',
                                'css_class' => '',
                                'depend_field' => array(
                                    'field' => 'multiple_location',
                                    'value' => 'yes',
                                    'compare' => '='
                                ),
                            ),

                        )
                    ),

                    /** Location & Organizer */
                    array(
                        'label' => esc_html__('Event location & organizer', 'fat-event'),
                        'id' => 'section_location',
                        'type' => 'section',
                        'depend_field' => array(
                            'field' => 'multiple_location',
                            'value' => 'yes',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Choose location', 'fat-event'),
                        'id' => 'location',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => $location,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'multiple_location',
                            'value' => 'yes',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Main organizer', 'fat-event'),
                        'id' => 'main_organizer',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => $main_organizer,
                        'std' => 'hide',
                        'col_width' => 'fat-cmb-col-12',
                        'css_class' => 'clear-both',
                        'depend_field' => array(
                            'field' => 'multiple_location',
                            'value' => 'yes',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Other organizer', 'fat-event'),
                        'id' => 'other_organizer',
                        'type' => 'select',
                        'multiple' => true,
                        'options' => $other_organizer,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'css_class' => 'clear-both',
                        'depend_field' => array(
                            'field' => 'multiple_location',
                            'value' => 'yes',
                            'compare' => '!='
                        ),
                    ),

                    /** Links */
                    array(
                        'label' => esc_html__('Links', 'fat-event'),
                        'id' => 'section_link',
                        'type' => 'section',
                    ),
                    array(
                        'label' => esc_html__('Link type', 'fat-event'),
                        'id' => 'link_detail_type',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'custom' => esc_html__('Custom', 'fat-event'),
                            'post' => esc_html__('Get from post', 'fat-event'),
                            'page' => esc_html__('Get from page', 'fat-event'),
                        ),
                        'std' => 'custom',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('If you want redirect to another page(external link, post or page on your site) when click event. Please select link at here','fat-event')
                    ),
                    array(
                        'label' => esc_html__('Link to detail', 'fat-event'),
                        'id' => 'link_detail',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'link_detail_type',
                            'value' => 'custom',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Link from post', 'fat-event'),
                        'id' => 'link_detail_post',
                        'type' => 'select',
                        'data_source' => 'post',
                        'depend_field' => array(
                            'field' => 'link_detail_type',
                            'value' => 'post',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Link from page', 'fat-event'),
                        'id' => 'link_detail_page',
                        'type' => 'select',
                        'data_source' => 'page',
                        'depend_field' => array(
                            'field' => 'link_detail_type',
                            'value' => 'page',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Link more info', 'fat-event'),
                        'id' => 'link_more_info',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('More info label', 'fat-event'),
                        'id' => 'label_more_info',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Open type', 'fat-event'),
                        'id' => 'link_open_type',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            '_self' => esc_html__('Current Window', 'fat-event'),
                            '_blank' => esc_html__('New Window', 'fat-event'),
                        ),
                        'std' => '_target',
                        'col_width' => 'fat-cmb-col-12',
                    ),

                    /** Booking */
                    array(
                        'label' => esc_html__('Booking', 'fat-event'),
                        'id' => 'section_booking',
                        'type' => 'section',
                    ),
                    array(
                        'label' => esc_html__('Enable booking', 'fat-event'),
                        'id' => 'enable_booking',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Fees type', 'fat-event'),
                        'id' => 'fees_type',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'fixed' => esc_html__('Fixed fees','fat-event'),
                            'package' => esc_html__('Fees base on quantity (Ex: 1 ticket : 10$, 2 ticket : 15$, 3 ticket: 22$, .. )','fat-event'),
                            'ticket_class' => esc_html__('Ticket classification (Ex: Economy class - 10$, Premium class -> 30$, ..)','fat-event'),
                        ),
                        'std' => 'fixed',
                        'col_width' => 'fat-cmb-col-12',
                        'css_class' => 'full-width',
                        'depend_field' => array(
                            'field' => 'enable_booking',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Fees', 'fat-event'),
                        'id' => 'fees',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 10000000,
                        'step' => $step,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Set empty or 0 if event is free','fat-event'),
                        'depend_field' => array(
                            'field' => 'fees_type',
                            'value' => 'fixed',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'id' => 'fees_package',
                        'type' => 'repeat',
                        'add_field_label' => esc_html__('Add package','fat-event'),
                        'fields' => array(
                            array(
                                'label' => esc_html__('Quantity', 'fat-event'),
                                'id' => 'quantity',
                                'type' => 'number',
                                'min' => 1,
                                'max' => 10000,
                                'step' => 1,
                                'std' => 1
                            ),
                            array(
                                'label' => esc_html__('Fees', 'fat-event'),
                                'id' => 'fees',
                                'type' => 'number',
                                'min' => 0,
                                'max' => 10000000,
                                'step' => $step,
                                'std' => 0,
                            ),
                        ),
                        'depend_field' => array(
                            'field' => 'fees_type',
                            'value' => 'package',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'id' => 'ticket_class',
                        'type' => 'repeat',
                        'add_field_label' => esc_html__('Add class','fat-event'),
                        'fields' => array(

                            array(
                                'label' => esc_html__('Class', 'fat-event'),
                                'id' => 'class',
                                'type' => 'text',
                                'std' => '',
                                'col_width' => 'fat-cmb-col-4',
                                'description' => esc_html__('Ticket class name','fat-event')
                            ),
                            array(
                                'label' => esc_html__('Seats available', 'fat-event'),
                                'id' => 'seats',
                                'type' => 'number',
                                'min' => 0,
                                'max' => 10000,
                                'step' => 1,
                                'std' => 1,
                                'col_width' => 'fat-cmb-col-4',
                                'description' => esc_html__('Seat of this ticket class. Set empty or 0 to unlimited','fat-event')
                            ),
                            array(
                                'label' => esc_html__('Fees', 'fat-event'),
                                'id' => 'fees',
                                'type' => 'number',
                                'min' => 0,
                                'max' => 10000000,
                                'step' => $step,
                                'std' => 0,
                                'col_width' => 'fat-cmb-col-4',
                                'description' => esc_html__('Fees of this ticket class','fat-event')
                            ),
                            array(
                                'id' => 'class_id',
                                'type' => 'hidden',
                                'guid' => 1,
                                'std' => uniqid()
                            ),
                        ),
                        'depend_field' => array(
                            'field' => 'fees_type',
                            'value' => 'ticket_class',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Seats', 'fat-event'),
                        'id' => 'seats',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100000000,
                        'step' => 1,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Set empty or 0 to remove limit seat'),
                        'depend_field' => array(
                            'field' => 'fees_type',
                            'value' => 'ticket_class',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Enable seat available', 'fat-event'),
                        'id' => 'enable_seat_available',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',

                    ),
                    array(
                        'label' => esc_html__('Payment', 'fat-event'),
                        'id' => 'payment',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => $gateways,
                        'std' => 'offline',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_booking',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('External link booking', 'fat-event'),
                        'id' => 'external_link_booking',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'payment',
                            'value' => 'external_link',
                            'compare' => '='
                        ),
                        'description' => esc_html__('Please input external link booking. The website will be redirect to this link when user click register button', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Second external link booking', 'fat-event'),
                        'id' => 'second_external_link_booking',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'payment',
                            'value' => 'external_link',
                            'compare' => '='
                        ),
                        'description' => esc_html__('Please input second external link booking. The website will be redirect to this link when user click register button', 'fat-event')
                    ),

                    array(
                        'label' => esc_html__('Disable booking before (hours)', 'fat-event'),
                        'id' => 'disable_booking_before',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Hide the \'Book Now\' button before the event happens before. Set empty or 0 to ignore this feature','fat-event'),
                        'depend_field' => array(
                            'field' => 'enable_booking',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'label' => esc_html__('Reservations allowed after the event has started (hours)', 'fat-event'),
                        'id' => 'allow_booking_after_event_started',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Set empty or 0 to ignore this feature. If you want use this feature, you need set Disable booking before (hours) = 0','fat-event'),
                        'depend_field' => array(
                            'field' => 'enable_booking',
                            'value' => '1',
                            'compare' => '='
                        ),
                    ),

                    /** Media  */
                    array(
                        'label' => esc_html__('Media', 'fat-event'),
                        'id' => 'section_media',
                        'type' => 'section',
                    ),
                    array(
                        'label' => esc_html__('Media type', 'fat-event'),
                        'id' => 'media_type',
                        'type' => 'radio',
                        'options' => array(
                            'none' => esc_html__('None', 'fat-event'),
                            'image' => esc_html__('Image', 'fat-event'),
                            'video' => 'Video'
                        ),
                        'col_width' => 'fat-cmb-col-12',
                        'std' => 'none'
                    ),
                    array(
                        'label' => esc_html__('Choose images', 'fat-event'),
                        'id' => 'images',
                        'type' => 'images',
                        'depend_field' => array(
                            'field' => 'media_type',
                            'value' => 'image',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'label' => esc_html__('Link video', 'fat-event'),
                        'id' => 'link_video',
                        'type' => 'text',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'media_type',
                            'value' => 'video',
                            'compare' => '='
                        ),
                    ),

                )
            );

            $meta_boxes[] = array(
                'title' => esc_html__('Event Color', 'fat-event'),
                'id' => 'fat-mb-event-color',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('Default Color', 'fat-event'),
                        'id' => 'color',
                        'type' => 'color',
                        'std' => '#25be45',
                        'col_width' => 'fat_cmb_col_12'
                    ),
                    array(
                        'label' => esc_html__('Seat available warning color', 'fat-event'),
                        'id' => 'warning_color',
                        'type' => 'color',
                        'std' => '#ede435',
                        'col_width' => 'fat_cmb_col_12'
                    ),
                    array(
                        'label' => esc_html__('Number of seat warning', 'fat-event'),
                        'id' => 'number_seat_warning',
                        'type' => 'number',
                        'std' =>  3,
                        'step' => 1,
                        'max' => 999999,
                        'min' => 0,
                        'col_width' => 'fat_cmb_col_12'
                    ),
                    array(
                        'label' => esc_html__('Seat not available color', 'fat-event'),
                        'id' => 'disable_color',
                        'type' => 'color',
                        'std' => '#ef1d20',
                        'col_width' => 'fat_cmb_col_12'
                    ),
                )
            );

             $meta_boxes[] = array(
                'title' => esc_html__('Background Image', 'fat-event'),
                'id' => 'fat-mb-event-bg-image',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_POST_TYPE),
                'fields' => array(
                    array(
                        'id' => 'bg_image',
                        'type' => 'single_image',
                        'col_width' => 'fat_cmb_col_12',
                        'css_class' => 'no-label'
                    ),
                )
            );

            $meta_boxes[] = array(
                'title' => esc_html__('Single image size', 'fat-event'),
                'id' => 'fat-mb-event-single-image-size',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('Image width(pixel)', 'fat-event'),
                        'id' => 'single_image_width',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 5000,
                        'step' => 5,
                        'std' => '1170',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Image height(pixel)', 'fat-event'),
                        'id' => 'single_image_height',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 5000,
                        'step' => 5,
                        'std' => '500',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                )
            );

            $amenities = isset($fat_event_setting['amenities']) ? $fat_event_setting['amenities'] : '';
            if(is_array($amenities) &&  isset($amenities['amenities_name'])){
                $amenities_field = array();
                $field_id ='';
                foreach($amenities['amenities_name'] as $a){
                    $field_id = strtolower($a);
                    $field_id = str_replace(' ','_',$field_id);
                    $field_id = str_replace(',','',$field_id);
                    $field_id = str_replace(';','',$field_id);
                    $field_id = str_replace('.','',$field_id);
                    $field_id = str_replace('#','',$field_id);
                    $amenities_field[] = array(
                        'label' => '',
                        'id' => $field_id,
                        'type' => 'check',
                        'options' => array(
                            $a => $a
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-6'
                    );
                }
                $meta_boxes[] = array(
                    'title' => esc_html__('Amenities', 'fat-event'),
                    'id' => 'fat-mb-event-single-amenities',
                    'pages' => array(FAT_EVENT_POST_TYPE),
                    'fields' => $amenities_field
                );
            }

            $meta_boxes[] = array(
                'title' => esc_html__('Attendees', 'fat-event'),
                'id' => 'fat-mb-event-attendees',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('View Attendees', 'fat-event'),
                        'id' => 'view_attendees',
                        'type' => 'button',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                )
            );

            return $meta_boxes;
        }
         /** end event post type */

         /** start booking post type */
        function register_booking_post_types()
        {

            $post_type = FAT_EVENT_BOOKING_POST_TYPE;
            $slug = 'fat-event-booking';
            $name = $singular_name = 'FAT Event Booking';

            if (post_type_exists($post_type)) {
                return;
            }

            register_post_type($post_type,
                array(
                    'label' => esc_html__('FAT Event Booking', 'fat-event'),
                    'description' => esc_html__('FAT Event Booking Description', 'fat-event'),
                    'labels' => array(
                        'name' => $name,
                        'singular_name' => $singular_name,
                        'menu_name' => ucfirst($name),
                        'parent_item_colon' => esc_html__('Parent Item:', 'fat-event'),
                        'all_items' => sprintf(esc_html__('All %s', 'fat-event'), $name),
                        'view_item' => esc_html__('View Event', 'fat-event'),
                        'edit_item' => esc_html__('Edit Event', 'fat-event'),
                        'update_item' => esc_html__('Update Event', 'fat-event'),
                        'search_items' => esc_html__('Search Event', 'fat-event'),
                        'not_found' => esc_html__('Not found', 'fat-event'),
                        'not_found_in_trash' => esc_html__('Not found in Trash', 'fat-event'),
                    ),
                    /*'capabilities' => array('create_posts' => false),*/
                    'map_meta_cap' => true,
                    'supports' => array('title',),
                    'public' => false,
                    'show_ui' => true,
                    '_builtin' => false,
                    'has_archive' => false,
                    'exclude_from_search' => true,
                    'menu_icon' => 'dashicons-calendar-alt',
                    'hierarchical' => true,
                    'rewrite' => array('slug' => $slug, 'with_front' => true),
                )
            );
            // flush_rewrite_rules();
        }

        function register_booking_meta_boxes($meta_boxes)
        {
            global $post;
            $fat_event_setting = get_option('fat_event_setting');
            $currency = isset($fat_event_setting['currency']) ? $fat_event_setting['currency'] : 'USD';
            $currency_symbol = isset($fat_event_setting['currency_symbol']) ? $fat_event_setting['currency_symbol'] : '$';
            $currency_symbol = $currency_symbol ? $currency_symbol : $currency;

            $fields = array();
            if (isset($fat_event_setting['enable_form_builder'][0]) && $fat_event_setting['enable_form_builder'][0] == '1') {
                $booking_form = get_option('fat_event_booking_form', '');
                $booking_form = stripslashes($booking_form);

                $fields = array(
                    array(
                        'label' => esc_html__('Event ID', 'fat-event'),
                        'id' => 'event_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event Title', 'fat-event'),
                        'id' => 'event_title',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event start date ', 'fat-event'),
                        'id' => 'event_start_date',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event end date ', 'fat-event'),
                        'id' => 'event_end_date',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Quantity', 'fat-event'),
                        'id' => 'quantity',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Fees type', 'fat-event'),
                        'id' => 'fees_type',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Fees', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'price',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100000000,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Subtotal', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'subtotal',
                        'type' => 'text',
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Discount ', 'fat-event'). ' (' . $currency_symbol . ')',
                        'id' => 'discount',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-6'
                    ),
                    array(
                        'label' => esc_html__('Coupon', 'fat-event'),
                        'id' => 'coupon',
                        'type' => 'text',
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-6'
                    ),
                    array(
                        'label' => esc_html__('Total', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'total_price',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000000000,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Payment type ', 'fat-event'),
                        'id' => 'payment_type',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('myPOS Status', 'fat-event'),
                        'id' => 'myPOS_status',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is status what return from myPOS gateway. It only for myPOS', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Paypal ID', 'fat-event'),
                        'id' => 'paypal_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is paypal id what return from Paypal gateway. It only for paypal', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Paypal Payer ID', 'fat-event'),
                        'id' => 'paypal_payer_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is paypal payer id what return from Paypal gateway. It only for paypal', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Paypal payment state', 'fat-event'),
                        'id' => 'paypal_state',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Stripe Transaction ID', 'fat-event'),
                        'id' => 'stripe_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is strip transaction id what return from Stripe gateway.', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Stripe Balance ID', 'fat-event'),
                        'id' => 'stripe_balance_transaction',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is strip balance id what return from Stripe gateway.', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Stripe error message', 'fat-event'),
                        'id' => 'stripe_error',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Confirmation of participation', 'fat-event'),
                        'id' => 'attention_status',
                        'type' => 'select',
                        'std' => 'No',
                        'options' => array(
                            'No' => esc_html__('No','fat-event'),
                            'Yes' => esc_html__('Yes','fat-event'),
                        ),
                        'read_only' => false,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Process status', 'fat-event'),
                        'id' => 'process_status',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'no_process' => esc_html__('No Process', 'fat-event'),
                            'processed' => esc_html__('Processed', 'fat-event'),
                            'cancel' => esc_html__('Cancel', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    )
                );

                if ($booking_form !== '' && $booking_form !== '[]'){
                    $booking_form = json_decode($booking_form);
                    if(is_array($booking_form)){
                        foreach ($booking_form as $field) {
                            if(isset($field->label) && isset($field->name)){
                                $fields[] = array(
                                    'label' => $field->label,
                                    'id' => isset($field->mapField) && $field->mapField!='none' && $field->mapField ? $field->mapField : $field->name,
                                    'type' => 'text',
                                    'std' => '',
                                    'read_only' => true,
                                    'col_width' => 'fat-cmb-col-12'
                                );
                            }
                        }
                    }
                }
            }else{
                $fields = array(
                    array(
                        'label' => esc_html__('Event ID', 'fat-event'),
                        'id' => 'event_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event Title', 'fat-event'),
                        'id' => 'event_title',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event start date ', 'fat-event'),
                        'id' => 'event_start_date',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Event end date ', 'fat-event'),
                        'id' => 'event_end_date',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('First name', 'fat-event'),
                        'id' => 'first_name',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Last name', 'fat-event'),
                        'id' => 'last_name',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Gender', 'fat-event'),
                        'id' => 'gender',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Email', 'fat-event'),
                        'id' => 'email',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Phone', 'fat-event'),
                        'id' => 'phone',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Department', 'fat-event'),
                        'id' => 'department',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Company', 'fat-event'),
                        'id' => 'company',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Address', 'fat-event'),
                        'id' => 'address',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Country', 'fat-event'),
                        'id' => 'country',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Quantity', 'fat-event'),
                        'id' => 'quantity',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Fees type', 'fat-event'),
                        'id' => 'fees_type',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Ticket name', 'fat-event'),
                        'id' => 'ticket_name',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Ticket name', 'fat-event'),
                        'id' => 'ticket_name',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Fees', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'price',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 100000000,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Subtotal', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'subtotal',
                        'type' => 'text',
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Discount ', 'fat-event'). ' (' . $currency_symbol . ')',
                        'id' => 'discount',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-6'
                    ),
                    array(
                        'label' => esc_html__('Coupon', 'fat-event'),
                        'id' => 'coupon',
                        'type' => 'text',
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-6'
                    ),
                    array(
                        'label' => esc_html__('Total', 'fat-event') . ' (' . $currency_symbol . ')',
                        'id' => 'total_price',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000000000,
                        'step' => 1,
                        'read_only' => true,
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Note', 'fat-event'),
                        'id' => 'note',
                        'type' => 'textarea',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Payment type ', 'fat-event'),
                        'id' => 'payment_type',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Paypal ID', 'fat-event'),
                        'id' => 'paypal_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is paypal id what return from Paypal gateway. It only for paypal', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Paypal Payer ID', 'fat-event'),
                        'id' => 'paypal_payer_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is paypal payer id what return from Paypal gateway. It only for paypal', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Paypal payment state', 'fat-event'),
                        'id' => 'paypal_state',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Stripe Transaction ID', 'fat-event'),
                        'id' => 'stripe_id',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is strip transaction id what return from Stripe gateway.', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Stripe Balance ID', 'fat-event'),
                        'id' => 'stripe_balance_transaction',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('This is strip balance id what return from Stripe gateway.', 'fat-event')
                    ),
                    array(
                        'label' => esc_html__('Stripe error message', 'fat-event'),
                        'id' => 'stripe_error',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Confirmation of participation', 'fat-event'),
                        'id' => 'attention_status',
                        'type' => 'text',
                        'std' => '',
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Process status', 'fat-event'),
                        'id' => 'process_status',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'no_process' => esc_html__('No Process', 'fat-event'),
                            'processed' => esc_html__('Processed', 'fat-event'),
                            'cancel' => esc_html__('Cancel', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                );
            }

            if($post->ID){
               $location_name = get_post_meta($post->ID,'location_name',true);
               if($location_name){
                   $fields[] =  array(
                       'label' => esc_html__('Event\'s location', 'fat-event'),
                       'id' => 'location_name',
                       'type' => 'text',
                       'std' => $location_name,
                       'read_only' => true,
                       'col_width' => 'fat-cmb-col-12'
                   );
               }

                $amenities = get_post_meta($post->ID,'amenities',true);
                if($amenities){
                    $fields[] =  array(
                        'label' => esc_html__('Amenities', 'fat-event'),
                        'id' => 'location_name',
                        'type' => 'text',
                        'std' => $amenities,
                        'read_only' => true,
                        'col_width' => 'fat-cmb-col-12'
                    );
                }
            }
            $meta_boxes[] = array(
                'title' => esc_html__('Booking detail', 'fat-event'),
                'id' => 'fat-mb-event-booking-detail',
                'priority' => 'high',
                'pages' => array(FAT_EVENT_BOOKING_POST_TYPE),
                'fields' => $fields
            );
            return $meta_boxes;
        }

        public function booking_save_post($post_id)
        {
            $post_type = get_post_type($post_id);
            if ($post_type === FAT_EVENT_BOOKING_POST_TYPE && isset($_REQUEST['process_status']) && $_REQUEST['process_status']) {
                update_post_meta($post_id, 'process_status', $_REQUEST['process_status']);
                update_post_meta($post_id, 'attention_status', $_REQUEST['attention_status']);

                if ($_REQUEST['process_status'] === 'cancel') {
                    $booking = get_post_meta($post_id, 'fat-mb-event-booking-detail', true);
                    $s_date = get_post_meta($post_id,'start_date',true);
                    $e_date = get_post_meta($post_id,'end_date',true);
                    if (isset($booking['event_id']) && $booking['event_id']) {
                        $num_of_book_key = 'num_of_book_'.$s_date->format('U').'_'.$e_date->format('U');
                        $event_detail = get_post_meta($booking['event_id'], 'fat-mb-event-detail', true);
                        if(isset($event_detail['fees_type']) && $event_detail['fees_type']=='ticket_class'){
                            $num_of_book_key.= '_'. get_post_meta($post_id,'ticket_class_id',true);
                        }
                        $num_book = get_post_meta($booking['event_id'], $num_of_book_key, true);
                        $num_book = isset($num_book) && $num_book ? $num_book : 0;
                        $num_book--;
                        update_post_meta($booking['event_id'], $num_of_book_key, $num_book);
                    }
                }
            }
        }

        public function booking_delete_post($post_id)
        {
            $post_type = get_post_type($post_id);
            if ($post_type === FAT_EVENT_BOOKING_POST_TYPE) {
                $booking = get_post_meta($post_id, 'fat-mb-event-booking-detail', true);
                $s_date = get_post_meta($post_id,'start_date',true);
                $e_date = get_post_meta($post_id,'end_date',true);
                $quantity = isset($booking['quantity']) ? $booking['quantity'] : 1;
                if (isset($booking['event_id']) && $booking['event_id']) {
                    $num_of_book_key = 'num_of_book_'.$s_date->format('U').'_'.$e_date->format('U');
                    $event_detail = get_post_meta($booking['event_id'], 'fat-mb-event-detail', true);
                    if(isset($event_detail['fees_type']) && $event_detail['fees_type']=='ticket_class'){
                        $num_of_book_key.= '_'. get_post_meta($post_id,'ticket_class_id',true);
                    }
                    $num_book = get_post_meta($booking['event_id'], $num_of_book_key, true);
                    $num_book = isset($num_book) && $num_book ? $num_book : 0;
                    $num_book = $num_book - $quantity;
                    if ($num_book > 0) {
                        update_post_meta($booking['event_id'], $num_of_book_key, $num_book);
                    } else {
                        update_post_meta($booking['event_id'], $num_of_book_key, 0);
                    }
                }
            }
        }

        function admin_listing_booking_manage_posts()
        {
            global $typenow;
            if ($typenow == FAT_EVENT_BOOKING_POST_TYPE) {
                global $wpdb;
                $bookings = $wpdb->get_results('SELECT ID FROM ' . $wpdb->prefix . 'posts WHERE post_type="' . FAT_EVENT_BOOKING_POST_TYPE . '"');
                $customers = array();
                $events = array();
                $booking_detail = '';
                if ($bookings) {
                    $fat_event_setting = get_option('fat_event_setting');

                    //customer

                    $sql = "SELECT DISTINCT meta_value FROM  {$wpdb->prefix}posts as P
                            INNER JOIN  {$wpdb->prefix}postmeta as PM
                            ON P.ID = PM.post_id
                            WHERE P.post_type=%s AND P.post_status=%s
                            AND PM.meta_key=%s";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_BOOKING_POST_TYPE, 'publish', 'customer');
                    $posts = $wpdb->get_results($sql);
                    $nof = array();
                    foreach($posts as $p){
                        $customers[$p->meta_value] = $p->meta_value;
                    }

                    $sql = "SELECT ID,post_title FROM {$wpdb->prefix}posts WHERE post_type = %s and post_status='publish'";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_POST_TYPE);
                    $posts = $wpdb->get_results($sql);
                    foreach($posts as $p){
                        $events[$p->ID] = $p->post_title;
                    }

                    //name of child
                    $sql = "SELECT DISTINCT meta_value FROM  {$wpdb->prefix}posts as P
                            INNER JOIN  {$wpdb->prefix}postmeta as PM
                            ON P.ID = PM.post_id
                            WHERE P.post_type=%s AND P.post_status=%s
                            AND PM.meta_key=%s";
                    $sql = $wpdb->prepare($sql, FAT_EVENT_BOOKING_POST_TYPE, 'publish', 'name_of_child');
                    $posts = $wpdb->get_results($sql);
                    $nof = array();
                    foreach($posts as $p){
                        $nof[$p->meta_value] = $p->meta_value;
                    }

                    $utils = new FAT_Event_Utils();

                    $dates = array();
                    $now = current_time('mysql', 0);
                    $now = DateTime::createFromFormat('Y-m-d H:i:s', $now);
                    $now = $now->modify('- 5 day');
                    $day = '';
                    for($i=0; $i < 25; $i++){
                        $now = $now->modify('+ 1 day');
                        $day = $now->format('Y-m-d');
                        $dates[$day] = $day;
                    }
                    $args = array(
                        'show_option_all' => esc_html__('Show all date', 'fat-event'),
                        'name' => 'booking_date',
                        'data' => $dates,
                        'class' => 'fat-selectize',
                        'selected' => isset($_REQUEST['booking_date']) ? $_REQUEST['booking_date'] : '',

                    );
                    $utils->fat_dropdown_post_meta($args);

                    // event title
                    if(!isset($fat_event_setting['filter_by_event']) || ( isset($fat_event_setting['filter_by_event'][0]) && $fat_event_setting['filter_by_event'][0]=='1')){
                        asort($events, 2);
                        $args = array(
                            'show_option_all' => esc_html__('Show all event', 'fat-event'),
                            'name' => 'event',
                            'data' => $events,
                            'class' => 'fat-selectize',
                            'selected' => isset($_REQUEST['event']) ? $_REQUEST['event'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    // customer
                    if(!isset($fat_event_setting['filter_by_customer']) || ( isset($fat_event_setting['filter_by_customer'][0]) && $fat_event_setting['filter_by_customer'][0]=='1')) {
                        asort($customers, 2);
                        $args = array(
                            'show_option_all' => esc_html__('Show all customer', 'fat-event'),
                            'name' => 'customer',
                            'data' => $customers,
                            'class' => 'fat-selectize',
                            'selected' => isset($_REQUEST['customer']) ? $_REQUEST['customer'] : ''
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    //name of child
                    asort($nof, 2);
                    $args = array(
                        'show_option_all' => esc_html__('Show all children', 'fat-event'),
                        'name' => 'name_of_child',
                        'data' => $nof,
                        'class' => 'fat-selectize',
                        'selected' => isset($_REQUEST['name_of_child']) ? $_REQUEST['name_of_child'] : ''
                    );
                    $utils->fat_dropdown_post_meta($args);

                    //ticket type
                    $ticket_type = FAT_Event_Utils::get_ticket_type();
                    $args = array(
                        'show_option_all' => esc_html__('Show all ticket', 'fat-event'),
                        'name' => 'ticket_type',
                        'data' => $ticket_type,
                        'class' => 'fat-selectize',
                        'selected' => isset($_REQUEST['ticket_type']) ? $_REQUEST['ticket_type'] : ''
                    );
                    $utils->fat_dropdown_post_meta($args);

                    $terms = array();
                    $term_ids = array();
                    // category
                    if(isset($fat_event_setting['filter_by_category']) && ( isset($fat_event_setting['filter_by_category'][0]) && $fat_event_setting['filter_by_category'][0]=='1')) {
                        $terms =  get_terms(array(
                            'taxonomy' => FAT_EVENT_CATEGORY_TAXONOMY,
                            'hide_empty' => false
                        ));
                        foreach($terms as $term){
                            $term_ids[$term->term_id] = $term->name ;
                        }

                        $args = array(
                            'show_option_all' => esc_html__('Show all category', 'fat-event'),
                            'name' => 'category',
                            'data' => $term_ids,
                            'class' => 'fat-selectize',
                            'selected' => isset($_REQUEST['category']) ? $_REQUEST['category'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    // location
                    $term_ids = array();
                    if(isset($fat_event_setting['filter_by_location']) && ( isset($fat_event_setting['filter_by_location'][0]) && $fat_event_setting['filter_by_location'][0]=='1')) {
                        $terms =  get_terms(array(
                            'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                            'hide_empty' => false
                        ));
                        foreach($terms as $term){
                            $term_ids[$term->term_id] = $term->name ;
                        }
                        $args = array(
                            'show_option_all' => esc_html__('Show all location', 'fat-event'),
                            'name' => 'location',
                            'data' => $term_ids,
                            'class' => 'fat-selectize',
                            'selected' => isset($_REQUEST['location']) ? $_REQUEST['location'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    // organizer
                    $term_ids = array();
                    if(isset($fat_event_setting['filter_by_organizer']) && ( isset($fat_event_setting['filter_by_organizer'][0]) && $fat_event_setting['filter_by_organizer'][0]=='1')) {
                        $terms =  get_terms(array(
                            'taxonomy' => FAT_EVENT_ORGANIZER_TAXONOMY,
                            'hide_empty' => false
                        ));
                        foreach($terms as $term){
                            $term_ids[$term->term_id] = $term->name ;
                        }
                        $args = array(
                            'show_option_all' => esc_html__('Show all organizer', 'fat-event'),
                            'name' => 'organizer',
                            'data' => $term_ids,
                            'class' => 'fat-selectize',
                            'selected' => isset($_REQUEST['organizer']) ? $_REQUEST['organizer'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    // payment type
                    if(!isset($fat_event_setting['filter_by_payment_type']) || (isset($fat_event_setting['filter_by_payment_type'][0]) && $fat_event_setting['filter_by_payment_type'][0]=='1')) {
                        $args = array(
                            'show_option_all' => esc_html__('Show all payment type', 'fat-event'),
                            'name' => 'payment_type',
                            'data' => array(
                                'offline' => esc_html__('Offline', 'fat-event'),
                                'paypal' => esc_html__('Paypal', 'fat-event'),
                                'stripe' => esc_html__('Stripe', 'fat-event'),
                                'woocommerce' => esc_html__('Woocommerce', 'fat-event'),
                                'myPOS' => esc_html__('myPOS', 'fat-event')
                            ),
                            'selected' => isset($_REQUEST['payment_type']) ? $_REQUEST['payment_type'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                    // booking status
                    if(!isset($fat_event_setting['filter_by_booking_status']) || ( isset($fat_event_setting['filter_by_payment_type'][0]) &&  $fat_event_setting['filter_by_booking_status'][0]=='1')) {
                        $args = array(
                            'show_option_all' => esc_html__('Show all booking status', 'fat-event'),
                            'name' => 'booking_status',
                            'data' => array(
                                'no_process' => esc_html__('No Process', 'fat-event'),
                                'cancel' => esc_html__('Cancel', 'fat-event'),
                                'processed' => esc_html__('Processed', 'fat-event')
                            ),
                            'selected' => isset($_REQUEST['booking_status']) ? $_REQUEST['booking_status'] : '',
                        );
                        $utils->fat_dropdown_post_meta($args);
                    }

                }

            }
        }

        function admin_convert_booking_in_query($query)
        {
            global $pagenow, $wpdb, $typenow;
            $qv = &$query->query_vars;

            if ($pagenow == 'edit.php' && $typenow==FAT_EVENT_BOOKING_POST_TYPE) {
                $meta_query = array();

                $booking_ids = array();
                $ids = array();
                if (isset($_REQUEST['customer']) && $_REQUEST['customer'] !== '0') {
                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='customer' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['customer']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }

                }

                if (isset($_REQUEST['name_of_child']) && $_REQUEST['name_of_child'] !== ''  && $_REQUEST['name_of_child'] !== '0') {
                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='name_of_child' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['name_of_child']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['event']) && $_REQUEST['event']!='' && $_REQUEST['event'] !== '0') {

                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='event_id' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['event']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['payment_type']) && $_REQUEST['payment_type']!='' && $_REQUEST['payment_type'] !== '0') {

                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='payment_type' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['payment_type']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['booking_status']) && $_REQUEST['booking_status']!='' && $_REQUEST['booking_status'] !== '0') {
                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='process_status' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['booking_status']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['booking_date']) && $_REQUEST['booking_date'] !== '' && $_REQUEST['booking_date'] !== '0') {

                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='start_date_str' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['booking_date']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['category']) && $_REQUEST['category'] !== '' && $_REQUEST['category'] !== '0') {
                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='category' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['category']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['organizer']) && $_REQUEST['organizer'] !== '' && $_REQUEST['organizer'] !== '0') {
                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='organizer' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['organizer']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['location']) && $_REQUEST['location'] !== '' && $_REQUEST['location'] !== '0') {

                    $sql = "SELECT post_id FROM {$wpdb->prefix}postmeta 
                            WHERE post_id IN (SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='event_id')
                            AND meta_key='location' AND meta_value=%s";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  $_REQUEST['location']);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    foreach($ids as $id){
                        $booking_ids[] = $id->post_id;
                    }
                }

                if (isset($_REQUEST['ticket_type']) && $_REQUEST['ticket_type'] !== '' && $_REQUEST['ticket_type'] !== '0') {

                    $sql = "SELECT ID FROM {$wpdb->prefix}posts
                            WHERE post_type= %s AND post_status='publish'";
                    if(count($booking_ids) > 0){
                        $sql .= " AND post_id IN (" .implode(',', $booking_ids).")";
                    }
                    $sql = $wpdb->prepare($sql,  FAT_EVENT_BOOKING_POST_TYPE);
                    $ids = $wpdb->get_results($sql);
                    if(count($booking_ids)>0){
                        $booking_ids = array();
                    }
                    $bk_detail = array();
                    $ticket_name = '';
                    foreach($ids as $id){
                        $bk_detail = get_post_meta($id->ID, 'fat-mb-event-booking-detail', true);
                        $ticket_name = isset($bk_detail['ticket_name']) ? trim($bk_detail['ticket_name']) : '';
                        $ticket_name = strtolower($ticket_name);
                        if($_REQUEST['ticket_type'] == $ticket_name){
                            $booking_ids[] = $id->ID;
                        }
                    }
                }

                $query->set( 'post__in', $booking_ids);

            }
        }

        function booking_custom_orderby($query)
        {
            if (is_admin() && !isset($_GET['orderby']) && isset($query->query['post_type']) && $query->query['post_type'] === FAT_EVENT_BOOKING_POST_TYPE) {
                $query->set('orderby', 'date');
                $query->set('order', 'DESC');

            }
            if( is_admin() && isset($query->query['post_type']) && $query->query['post_type'] === FAT_EVENT_BOOKING_POST_TYPE){
                $orderby = isset($_GET['orderby']) ? $_GET['orderby'] : '';
                if( 'start_date' == $orderby ) {
                    $query->set('meta_key','start_date');
                    $query->set('orderby','meta_value');
                }
                if( 'end_date' == $orderby ) {
                    $query->set('meta_key','end_date');
                    $query->set('orderby','meta_value');
                }
                if( 'name_of_child' == $orderby ) {
                    $query->set('meta_key','name_of_child');
                    $query->set('orderby','meta_value');
                }
                if( 'customer' == $orderby ) {
                    $query->set('meta_key','customer');
                    $query->set('orderby','meta_value');
                }
                if( 'email' == $orderby ) {
                    $query->set('meta_key','email');
                    $query->set('orderby','meta_value');
                }
                if( 'category' == $orderby ) {
                    $query->set('meta_key','category');
                    $query->set('orderby','meta_value');
                }
                if( 'location' == $orderby ) {
                    $query->set('meta_key','location');
                    $query->set('orderby','meta_value');
                }
                if( 'organizer' == $orderby ) {
                    $query->set('meta_key','organizer');
                    $query->set('orderby','meta_value');
                }
                if( 'attention_status' == $orderby ) {
                    $query->set('meta_key','attention_status');
                    $query->set('orderby','meta_value');
                }
            }

        }

        public function add_admin_listing_booking_columns($columns)
        {

            unset(
                $columns['comments'],
                $columns['title'],
                $columns['date'],
                $columns['author']
            );
            $fat_event_setting = get_option('fat_event_setting');
            $enable_woocommerce =  isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0]=='1' ? 1 : 0;

            $customer_column = array(
                'title' =>  esc_html__('Title', 'fat-event')
            );

            if($enable_woocommerce){
                $customer_column['order_id'] = esc_html__('WC Order','fat-event');
            }

            if(!isset($fat_event_setting['display_start_date']) || (isset($fat_event_setting['display_start_date'][0]) && $fat_event_setting['display_start_date'][0]=='1')){
                $customer_column['start_date'] =  esc_html__('Start Date', 'fat-event');
            }

            if(!isset($fat_event_setting['display_end_date']) || ( isset($fat_event_setting['display_end_date'][0]) && $fat_event_setting['display_end_date']=='1')){
                $customer_column['end_date'] =  esc_html__('End Date', 'fat-event');
            }
            if(!isset($fat_event_setting['display_customer']) || (isset($fat_event_setting['display_customer'][0]) && $fat_event_setting['display_customer'][0]=='1') ){
                $customer_column['customer'] =  esc_html__('Customer', 'fat-event');
            }

            $customer_column['name_of_child'] =  esc_html__('Name of child', 'fat-event');

            if(!isset($fat_event_setting['display_email']) || ( isset($fat_event_setting['display_email'][0]) && $fat_event_setting['display_email'][0]=='1')){
                $customer_column['email'] =  esc_html__('Email', 'fat-event');
            }
            if(!isset($fat_event_setting['display_payment_type']) || ( isset($fat_event_setting['display_payment_type'][0]) && $fat_event_setting['display_payment_type'][0]=='1')){
                $customer_column['payment_type'] =  esc_html__('Payment Type', 'fat-event');
            }
            if(!isset($fat_event_setting['display_confirm']) || ( isset($fat_event_setting['display_confirm'][0]) && $fat_event_setting['display_confirm'][0]=='1')){
                $customer_column['attention_status'] =  esc_html__('Confirm participation', 'fat-event');
            }
            if(!isset($fat_event_setting['display_booking_status']) || (isset($fat_event_setting['display_booking_status'][0]) && $fat_event_setting['display_booking_status'][0]=='1')){
                $customer_column['process_status'] =  esc_html__('Booking Status', 'fat-event');
            }

            if(isset($fat_event_setting['display_category'][0]) &&  $fat_event_setting['display_category'][0]=='1'){
                $customer_column['category'] =  esc_html__('Category', 'fat-event');
            }
            if(isset($fat_event_setting['display_location'][0]) && $fat_event_setting['display_location'][0]=='1'){
                $customer_column['location'] =  esc_html__('Location', 'fat-event');
            }
            if(isset($fat_event_setting['display_organizer'][0]) && $fat_event_setting['display_organizer'][0]=='1'){
                $customer_column['organizer'] =  esc_html__('Organizer', 'fat-event');
            }

            $customer_column['ticket_type'] =  esc_html__('Ticket Type', 'fat-event');

            $customer_column['quantity'] =  esc_html__('Quantity', 'fat-event');

            $columns = array_merge($columns, $customer_column);

            return $columns;
        }

        public function set_admin_listing_booking_columns_value($column, $post_id)
        {
            $booking_detail = get_post_meta($post_id, 'fat-mb-event-booking-detail', true);
            $date_format = get_option('date_format');
            $date_format = strpos($date_format, 'H:i:s') === FALSE ? $date_format . ' H:i:s' : $date_format;
            $email = get_post_meta($post_id, 'email', true);

            if($column=='order_id'){
                $order_id = get_post_meta($post_id,'order_id', true);
                echo $order_id ? ('<a href="'.get_edit_post_link($order_id).'">'.$order_id.'</a>') :  '';
            }

            if ($column == 'customer' ) {
               /* if(isset($booking_detail['first_name']) && isset($booking_detail['last_name'])){
                    echo $booking_detail['first_name'] . ' ' . $booking_detail['last_name'];
                }*/
                echo get_post_meta($post_id,'customer', true);
            }

            if ($column == 'name_of_child' ) {
                echo get_post_meta($post_id,'name_of_child', true);
            }

            if ($column == 'email' && isset($email)) {
                echo sprintf('<a href="mailto:%s">%s</a>', $email, $email);
            }

            if ($column == 'start_date') {
                $event_date = get_post_meta($post_id, 'start_date', true);
                echo $event_date ? date_i18n($date_format, $event_date->format('U'))  : $event_date;
            }

            if ($column == 'end_date') {
                $event_date = get_post_meta($post_id, 'end_date', true);
                echo $event_date ? date_i18n($date_format, $event_date->format('U')) : $event_date;
            }

            if ($column == 'payment_type' && isset($booking_detail['payment_type'])) {
                echo ucfirst($booking_detail['payment_type']);
            }

            if ($column == 'ticket_name' && isset($booking_detail['ticket_name'])) {
                echo ucfirst($booking_detail['ticket_name']);
            }

            if ($column == 'process_status' && isset($booking_detail['process_status'])) {
                if ($booking_detail['process_status'] === 'no_process') {
                    echo '<span class="booking-status no-process"></span> ' . esc_html__('No Process', 'fat-event');
                }

                if ($booking_detail['process_status'] === 'cancel') {
                    echo '<span class="booking-status cancel"></span> ' . esc_html__('Cancel', 'fat-event');
                }

                if ($booking_detail['process_status'] === 'processed') {
                    echo '<span class="booking-status processed"></span> ' . esc_html__('Processed', 'fat-event');
                }
            }

            if ($column == 'attention_status') {
                $attention_status = get_post_meta($post_id,'attention_status',true);
                if ($attention_status == '1' || $attention_status == 'Yes') {
                    echo '<span class="attention-status confirmed"></span> ' . esc_html__('Confirmed', 'fat-event');
                }else{
                    echo '<span class="attention-status not-yet"></span> ' . esc_html__('Not yet', 'fat-event');
                }
            }

            $col_val = array();
            if ($column == 'category') {
                $event_id = isset($booking_detail['event_id']) ? $booking_detail['event_id'] : '';
                if($event_id){
                    $cat_list = get_the_terms( $event_id, FAT_EVENT_CATEGORY_TAXONOMY );
                    echo join(', ', wp_list_pluck($cat_list, 'name'));
                }
            }
            if ($column == 'location') {
                $locations = get_post_meta($post_id,'location', true);
                $locations = explode(',', $locations);
                foreach($locations as $loc){
                    $loc =  get_term_by('id', $loc, FAT_EVENT_LOCATION_TAXONOMY);
                    $col_val[] =   $loc->name;
                }
                echo implode(', ',$col_val);
            }

            if ($column == 'organizer') {
                $organizer = get_post_meta($post_id,'organizer', true);
                $organizer = explode(',', $organizer);
                foreach($organizer as $org){
                    $org =  get_term_by('id', $org, FAT_EVENT_ORGANIZER_TAXONOMY);
                    $col_val[] =   $org->name;
                }
                echo implode(', ',$col_val);
            }

            if ($column == 'ticket_type') {
                $bk_detail = get_post_meta($post_id, 'fat-mb-event-booking-detail', true);
                echo isset($bk_detail['ticket_name']) ? $bk_detail['ticket_name'] : '';
            }

            if ($column == 'quantity') {
                $bk_detail = get_post_meta($post_id, 'fat-mb-event-booking-detail', true);
                echo isset($bk_detail['quantity']) ? $bk_detail['quantity'] : '';
            }
        }

        function make_booking_column_sortable($columns ){
            $columns['start_date'] = 'start_date';
            $columns['name_of_child'] = 'name_of_child';
            $columns['customer'] = 'customer';
            $columns['email'] = 'email';
            $columns['category'] = 'category';
            $columns['location'] = 'location';
            $columns['organizer'] = 'organizer';
            $columns['attention_status'] = 'attention_status';
            return $columns;
        }

        /** end booking post type */

        /** start shortcode post type */
        function register_shortcode_post_types()
        {
            $post_type = FAT_EVENT_SHORTCODE_POST_TYPE;
            $slug = 'fat-calendar';
            $name = $singular_name = esc_html__('Shortcode', 'fat-event');

            if (post_type_exists($post_type)) {
                return;
            }

            register_post_type($post_type,
                array(
                    'label' => esc_html__('Shortcode', 'fat-event'),
                    'labels' => array(
                        'name' => $name,
                        'singular_name' => $singular_name,
                        'menu_name' => ucfirst($name),
                        'parent_item_colon' => esc_html__('Parent Item:', 'fat-event'),
                        'all_items' => sprintf(esc_html__('All %s', 'fat-event'), $name),
                        'view_item' => esc_html__('View Shortcode', 'fat-event'),
                        'add_new_item' => sprintf(esc_html__('Add New  %s', 'fat-event'), $name),
                        'add_new' => esc_html__('Add Shortcode', 'fat-event'),
                        'edit_item' => esc_html__('Edit Shortcode', 'fat-event'),
                        'update_item' => esc_html__('Update Shortcode', 'fat-event'),
                        'search_items' => esc_html__('Search Shortcode', 'fat-event'),
                        'not_found' => esc_html__('Not found', 'fat-event'),
                        'not_found_in_trash' => esc_html__('Not found in Trash', 'fat-event'),
                    ),
                    'supports' => array('title'),
                    'public' => false,
                    'show_ui' => true,
                    '_builtin' => false,
                    'has_archive' => false,
                    'exclude_from_search' => true,
                    'menu_icon' => 'dashicons-calendar-alt',
                    'hierarchical' => true,
                    'rewrite' => array('slug' => $slug, 'with_front' => false),
                )
            );
            //flush_rewrite_rules();
        }

        function register_shortcode_meta_boxes($meta_boxes)
        {
            global $post, $wpdb;
            $utils = new FAT_Event_Utils();

            $events = $wpdb->get_results($wpdb->prepare("SELECT id, post_title FROM $wpdb->posts WHERE post_status='publish' AND post_type=%s", FAT_EVENT_POST_TYPE));
            $fat_events = array();
            foreach ($events as $event) {
                $fat_events[$event->id] = $event->post_title;
            }

            $meta_boxes[] = array(
                'title' => esc_html__('Shortcode Config', 'fat-event'),
                'id' => 'fat-mb-event-shortcode-config',
                'priority' => 'high',
                'tabs' => array(
                    array(
                        'id' => 'tab-layout',
                        'icon' => '',
                        'title' => esc_html__('Layout', 'fat-event')
                    ),
                    array(
                        'id' => 'tab-filter',
                        'icon' => '',
                        'title' => esc_html__('Filter', 'fat-event')
                    ),
                    array(
                        'id' => 'tab-css',
                        'icon' => '',
                        'title' => esc_html__('Custom CSS', 'fat-event')
                    ),
                ),
                'pages' => array(FAT_EVENT_SHORTCODE_POST_TYPE),
                'fields' => array(
                    /** Tab layout */
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Layout', 'fat-event'),
                        'id' => 'layout',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'list' => esc_html__('List view', 'fat-event'),
                            'grid' => esc_html__('Grid view', 'fat-event'),
                            'masonry' => esc_html__('Masonry view', 'fat-event'),
                            /*'conference' => esc_html__('Conference view', 'fat-event'),*/
                            'countdown' => esc_html__('Countdown view', 'fat-event'),
                            'slide' => esc_html__('Carousel view', 'fat-event'),
                            'metro-01' => esc_html__('Metro 01', 'fat-event'),
                            'metro-02' => esc_html__('Metro 02', 'fat-event'),
                            'metro-03' => esc_html__('Metro 03', 'fat-event'),
                            'timetable' => esc_html__('Timetable view', 'fat-event'),
                            'calendar-widget' => esc_html__('Calendar Widget', 'fat-event'),
                            'timeline' => esc_html__('Timeline view', 'fat-event'),
                            'map' => esc_html__('Map', 'fat-event'),
                            'table' => esc_html__('Table view','fat-event'),
                        ),
                        'std' => 'list',
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Color skin', 'fat-event'),
                        'id' => 'calendar_color_skin',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'skin-gray' => esc_html__('Gray', 'fat-event'),
                            'skin-blue' => esc_html__('Blue', 'fat-event'),
                            'skin-white' => esc_html__('White', 'fat-event'),
                        ),
                        'std' => 'skin-gray',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'calendar-widget',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Calendar default month', 'fat-event'),
                        'id' => 'calendar_default_month',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            '-1' => esc_html__('Current month', 'fat-event'),
                            '0' => esc_html__('January', 'fat-event'),
                            '1' => esc_html__('February', 'fat-event'),
                            '2' => esc_html__('March', 'fat-event'),
                            '3' => esc_html__('April', 'fat-event'),
                            '4' => esc_html__('May', 'fat-event'),
                            '5' => esc_html__('June', 'fat-event'),
                            '6' => esc_html__('July', 'fat-event'),
                            '7' => esc_html__('August', 'fat-event'),
                            '8' => esc_html__('September', 'fat-event'),
                            '9' => esc_html__('October', 'fat-event'),
                            '10' => esc_html__('November', 'fat-event'),
                            '11' => esc_html__('Devember', 'fat-event'),
                        ),
                        'std' => 'skin-gray',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'calendar-widget',
                            'compare' => '='
                        ),
                        'description' => esc_html__('At default, calendar will be display event in current month. If you want display event in next month at default, please select month at here','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Default view', 'fat-event'),
                        'id' => 'timetable_view',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'month' => esc_html__('Month', 'fat-event'),
                            'listWeek' => esc_html__('Week', 'fat-event'),
                            'listDay' => esc_html__('Day', 'fat-event'),
                        ),
                        'std' => 'month',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Locale', 'fat-event'),
                        'id' => 'locale',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'en' => esc_html__('English', 'fat-event'),
                            'af' => esc_html__('Afrikaans', 'fat-event'),
                            'ar-dz' => esc_html__('Arabic (Algeria)', 'fat-event'),
                            'ar-kw' => esc_html__('Arabic (Kuwait)', 'fat-event'),
                            'ar-ly' => esc_html__('Arabic (Libya)', 'fat-event'),
                            'ar-ma' => esc_html__('Arabic (Morocco)', 'fat-event'),
                            'ar-dz' => esc_html__('Arabic (Algeria)', 'fat-event'),
                            'ar-sa' => esc_html__('Arabic (Saudi Arabia)', 'fat-event'),
                            'ar-tn' => esc_html__('Arabic (Tunisia)', 'fat-event'),
                            'ar' => esc_html__('Arabic', 'fat-event'),
                            'bg' => esc_html__('Bulgarian', 'fat-event'),
                            'bs' => esc_html__('Bosnian', 'fat-event'),
                            'ca' => esc_html__('Catalan', 'fat-event'),
                            'cs' => esc_html__('Czech', 'fat-event'),
                            'da' => esc_html__('Danish', 'fat-event'),
                            'de-at' => esc_html__('German (Austria)', 'fat-event'),
                            'de-ch' => esc_html__('German (Switzerland)', 'fat-event'),
                            'de' => esc_html__('German', 'fat-event'),
                            'el' => esc_html__('Greek', 'fat-event'),
                            'en-au' => esc_html__('English (Australia)', 'fat-event'),
                            'en-ca' => esc_html__('English (Canada)', 'fat-event'),
                            'en-gb' => esc_html__('English (United Kingdom) ', 'fat-event'),
                            'en-ie' => esc_html__('English (Ireland)', 'fat-event'),
                            'en-nz' => esc_html__('English (New Zealand)', 'fat-event'),
                            'es-do' => esc_html__('Spanish (Dominican Republic)', 'fat-event'),
                            'es-us' => esc_html__('Spanish (United States)', 'fat-event'),
                            'es' => esc_html__('Spanisht', 'fat-event'),
                            'et' => esc_html__('Estonian', 'fat-event'),
                            'eu' => esc_html__('Basque', 'fat-event'),
                            'fa' => esc_html__('Persian', 'fat-event'),
                            'fi' => esc_html__('Finnish', 'fat-event'),
                            'fr-ca' => esc_html__('French (Canada)', 'fat-event'),
                            'fr-ch' => esc_html__('French (Switzerland)', 'fat-event'),
                            'fr' => esc_html__('French', 'fat-event'),
                            'gl' => esc_html__('Galician', 'fat-event'),
                            'he' => esc_html__('Hebrew', 'fat-event'),
                            'hi' => esc_html__('Hindi', 'fat-event'),
                            'hr' => esc_html__('Croatian', 'fat-event'),
                            'hu' => esc_html__('Hungarian', 'fat-event'),
                            'id' => esc_html__('Indonesian', 'fat-event'),
                            'is' => esc_html__('Icelandic', 'fat-event'),
                            'it' => esc_html__('Italian', 'fat-event'),
                            'ja' => esc_html__('Japanese', 'fat-event'),
                            'ka' => esc_html__('Georgian', 'fat-event'),
                            'kk' => esc_html__('Kazakh', 'fat-event'),
                            'lb' => esc_html__('Luxembourgish', 'fat-event'),
                            'lt' => esc_html__('Lithuanian', 'fat-event'),
                            'lv' => esc_html__('Latvian', 'fat-event'),
                            'mk' => esc_html__('Macedonian', 'fat-event'),
                            'ms-my' => esc_html__('Malay (Malaysia)', 'fat-event'),
                            'ms' => esc_html__('Malay', 'fat-event'),
                            'nb' => esc_html__('Norwegian Bokmål', 'fat-event'),
                            'nl-be' => esc_html__('Dutch (Belgium)', 'fat-event'),
                            'nl' => esc_html__('Dutch', 'fat-event'),
                            'nn' => esc_html__('Norwegian Nynorsk ', 'fat-event'),
                            'pl' => esc_html__('Polish', 'fat-event'),
                            'pt' => esc_html__('Portuguese', 'fat-event'),
                            'ro' => esc_html__('Romanian', 'fat-event'),
                            'ru' => esc_html__('Russian', 'fat-event'),
                            'sk' => esc_html__('Slovak', 'fat-event'),
                            'sl' => esc_html__('Slovenian', 'fat-event'),
                            'sq' => esc_html__('Albanian', 'fat-event'),
                            'sr' => esc_html__('Serbian', 'fat-event'),
                            'sv' => esc_html__('Swedish', 'fat-event'),
                            'th' => esc_html__('Thailand', 'fat-event'),
                            'tr' => esc_html__('Turkish', 'fat-event'),
                            'uk' => esc_html__('Ukrainian', 'fat-event'),
                            'vi' => esc_html__('VietName', 'fat-event'),
                            'zh' => esc_html__('Chinese', 'fat-event'),
                        ),
                        'std' => 'en',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('List day label', 'fat-event'),
                        'id' => 'list_day_label',
                        'type' => 'text',
                        'std' => '',
                        'description' => esc_html__('Set empty for use default label', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('List week label', 'fat-event'),
                        'id' => 'list_week_label',
                        'type' => 'text',
                        'std' => '',
                        'description' => esc_html__('Set empty for use default label', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Month label', 'fat-event'),
                        'id' => 'list_month_label',
                        'type' => 'text',
                        'std' => '',
                        'description' => esc_html__('Set empty for use default label', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Select event', 'fat-event'),
                        'id' => 'event_id',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => $fat_events,
                        'std' => '',
                        'description' => esc_html__('Please use backspace to clear and input event name to filter', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'countdown',
                            'compare' => 'in'
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Skin', 'fat-event'),
                        'id' => 'skin',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            /*  'skin-01' => esc_html__('Skin 01', 'fat-event'),*/
                            'skin-02' => esc_html__('Skin 01', 'fat-event'),
                            'skin-03' => esc_html__('Skin 02', 'fat-event'),
                            'skin-04' => esc_html__('Skin 03', 'fat-event'),
                            'skin-05' => esc_html__('Skin 04', 'fat-event'),
                            'skin-06' => esc_html__('Skin 05', 'fat-event'),
                            'skin-07' => esc_html__('Skin 06', 'fat-event'),
                            'skin-08' => esc_html__('Skin 07', 'fat-event'),
                            'skin-09' => esc_html__('Skin 05 extra', 'fat-event'),
                        ),
                        'std' => 'skin-01',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry,slide,metro',
                            'compare' => 'in'
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Skin', 'fat-event'),
                        'id' => 'list_skin',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'list-skin-01' => esc_html__('Skin 01', 'fat-event'),
                            'list-skin-02' => esc_html__('Skin 02', 'fat-event'),
                        ),
                        'std' => 'skin-01',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'list',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Background', 'fat-event'),
                        'id' => 'background',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'color' => esc_html__('Black color', 'fat-event'),
                            'image' => esc_html__('Feature image', 'fat-event'),
                        ),
                        'std' => 'color',
                        'depend_field' => array(
                            'field' => 'list_skin',
                            'value' => 'list-skin-01',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Image width', 'fat-event'),
                        'id' => 'bg_image_width',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                        'std' => '100',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'list',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Image height', 'fat-event'),
                        'id' => 'bg_image_height',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                        'std' => '100',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'list',
                            'compare' => '='
                        ),
                    ),



                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Skin', 'fat-event'),
                        'id' => 'countdown_skin',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'cd-skin-01' => esc_html__('Skin 01', 'fat-event'),
                            'cd-skin-02' => esc_html__('Skin 02', 'fat-event'),
                            'cd-skin-03' => esc_html__('Skin 03', 'fat-event'),
                        ),
                        'std' => 'cd-skin-01',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'countdown',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Skin', 'fat-event'),
                        'id' => 'timeline_skin',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'timeline-skin-01' => esc_html__('Skin 01', 'fat-event'),
                            'timeline-skin-02' => esc_html__('Skin 02', 'fat-event'),
                            'timeline-skin-03' => esc_html__('Skin 03', 'fat-event'),
                        ),
                        'std' => 'timeline-skin-01',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timeline',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Column', 'fat-event'),
                        'id' => 'column',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            '1' => esc_html__('1 column', 'fat-event'),
                            '2' => esc_html__('2 columns', 'fat-event'),
                            '3' => esc_html__('3 columns', 'fat-event'),
                            '4' => esc_html__('4 columns', 'fat-event'),
                            '6' => esc_html__('6 columns', 'fat-event')
                        ),
                        'std' => '3',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Gutter', 'fat-event'),
                        'id' => 'gutter',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'fat-no-padding' => esc_html__('None', 'fat-event'),
                            'fat-padding-5' => esc_html__('Padding 5px', 'fat-event'),
                            'fat-padding-10' => esc_html__('Padding 10px', 'fat-event'),
                            'fat-padding-15' => esc_html__('Padding 15px', 'fat-event'),
                            'fat-padding-20' => esc_html__('Padding 20px', 'fat-event'),
                        ),
                        'std' => 'fat-padding-10',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry',
                            'compare' => 'in'
                        ),
                    ),

                    /** start slider option */
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Desktop large columns', 'fat-event'),
                        'id' => 'slider_desktop_large_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 4,
                        'description' => esc_html__('Set column for screen >= 1600 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Desktop medium columns', 'fat-event'),
                        'id' => 'slider_desktop_medium_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 4,
                        'description' => esc_html__('Set column for screen > 1200 pixel and < 1600 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Desktop small columns', 'fat-event'),
                        'id' => 'slider_desktop_small_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 4,
                        'description' => esc_html__('Set column for screen >= 980 pixel and < 1200 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Tablet columns', 'fat-event'),
                        'id' => 'slider_tablet_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 3,
                        'description' => esc_html__('Set column for screen >= 768 pixel and < 980 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Tablet small columns', 'fat-event'),
                        'id' => 'slider_tablet_small_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 2,
                        'description' => esc_html__('Set column for screen >= 480 pixel and < 768 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Mobile columns', 'fat-event'),
                        'id' => 'slider_mobile_column',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                        'std' => 1,
                        'description' => esc_html__('Set column for screen <= 480 pixel', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Gutter', 'fat-event'),
                        'id' => 'slide_gutter',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 30,
                        'step' => 1,
                        'std' => 10,
                        'description' => esc_html__('Space between events', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Display dot navigation', 'fat-event'),
                        'id' => 'slider_show_dot',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Display prev & next navigation', 'fat-event'),
                        'id' => 'slider_show_nav_text',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Auto play', 'fat-event'),
                        'id' => 'slider_auto_play',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Right to left', 'fat-event'),
                        'id' => 'slider_rtl',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'slide',
                            'compare' => 'in'
                        ),
                    ),
                    /** end slider option */

                    /** start map option */
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Map height', 'fat-event'),
                        'id' => 'map_height',
                        'type' => 'number',
                        'min' => 200,
                        'max' => 1000,
                        'step' => 10,
                        'std' => '500',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'map',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Map color schema', 'fat-event'),
                        'id' => 'map_color_schema',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'default' => esc_html__('Default', 'fat-event'),
                            'roadmap_black' => esc_html__('Black', 'fat-event'),
                            'roadmap_gray' => esc_html__('Gray', 'fat-event'),
                        ),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'map',
                            'compare' => '='
                        ),
                        'std' => 'default',
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Map zoom', 'fat-event'),
                        'id' => 'map_zoom',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                        'std' => '10',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'map',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Marker background color', 'fat-event'),
                        'id' => 'marker_color',
                        'type' => 'color',
                        'std' => '#4d94ff',
                        'col_width' => 'fat_cmb_col_12',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'map',
                            'compare' => '='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Show list event on marker', 'fat-event'),
                        'id' => 'enable_marker_info',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '0',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'map',
                            'compare' => '='
                        ),
                    ),
                    /** end map option */

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Start Date', 'fat-event'),
                        'id' => 'start_date',
                        'type' => 'datetime',
                        'std' => '',
                        'description' => esc_html__('Only choose event what have start date >= this field value. Set empty to get start date is today', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('End Date', 'fat-event'),
                        'id' => 'end_date',
                        'type' => 'datetime',
                        'std' => '',
                        'description' => esc_html__('Only choose event what have end date <= this field value. Set empty to ignore end date', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '!='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Hide Event End Time', 'fat-event'),
                        'id' => 'hide_event_end_time',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry,list',
                            'compare' => 'in'
                        ),
                        'description' => esc_html__('Only show start date and hidden end date','fat-event')
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Date format', 'fat-event'),
                        'id' => 'date_format',
                        'type' => 'text',
                        'std' => get_option('date_format'),
                        'description' => __('Please read more date time format <a target="_blank" href="https://codex.wordpress.org/Formatting_Date_and_Time">at here</a>','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Time format', 'fat-event'),
                        'id' => 'time_format',
                        'type' => 'text',
                        'std' => 'H:i',
                        'description' => __('Please read more date time format <a target="_blank" href="https://codex.wordpress.org/Formatting_Date_and_Time">at here</a>. Set empty if you want hide time','fat-event')
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Limit event', 'fat-event'),
                        'id' => 'limit',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 10000,
                        'step' => 1,
                        'std' => '',
                        'description' => esc_html__('Set empty to ignore limit', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '!='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Repeat event', 'fat-event'),
                        'id' => 'repeat_event',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 10000,
                        'step' => 1,
                        'std' => '',
                        'description' => esc_html__('Set empty to ignore limit', 'fat-event'),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Pagination', 'fat-event'),
                        'id' => 'pagination',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'pagination' => esc_html__('Page number', 'fat-event'),
                            'load-more' => esc_html__('Load more', 'fat-event'),
                            'infinite-scroll' => esc_html__('Infinite scroll', 'fat-event'),
                            'none' => esc_html__('None', 'fat-event'),
                        ),
                        'std' => 'none',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry,list,metro-01,metro-02,metro-03',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Order by', 'fat-event'),
                        'id' => 'order_by',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'start_date' => esc_html__('Start date', 'fat-event'),
                            'none' => esc_html__('None', 'fat-event'),
                            'date' => esc_html__('Create date', 'fat-event'),
                            'title' => esc_html__('Event title', 'fat-event'),
                            'name' => esc_html__('Event slug', 'fat-event'),
                            'ID' => esc_html__('Event ID', 'fat-event')
                        ),
                        'std' => 'start_date',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry,list,metro-01,metro-02,metro-03',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Order Start Date', 'fat-event'),
                        'id' => 'order',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'ASC' => esc_html__('Ascending', 'fat-event'),
                            'DESC' => esc_html__('Descending', 'fat-event')
                        ),
                        'std' => 'ASC',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,masonry,list,metro-01,metro-02,metro-03',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Number of item per page', 'fat-event'),
                        'id' => 'item_per_page',
                        'type' => 'number',
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                        'std' => '12',
                        'depend_field' => array(
                            'field' => 'pagination',
                            'value' => 'pagination,load-more,infinite-scroll',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Loading spinner', 'fat-event'),
                        'id' => 'loading_spinner',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'atom' => esc_html__('Atom spinner', 'fat-event'),
                            'finger' => esc_html__('Finger print spinner', 'fat-event'),
                            'flower' => esc_html__('Flower spinner', 'fat-event'),
                            'half_circle' => esc_html__('Half circle spinner', 'fat-event'),
                            'orbit' => esc_html__('Orbit spinner', 'fat-event'),
                            'self_building' => esc_html__('Self building square spinner', 'fat-event'),
                            'hollow_dots' => esc_html__('Hollow dots spinner', 'fat-event'),
                        ),
                        'std' => 'hollow_dots',
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Enable item animation', 'fat-event'),
                        'id' => 'enable_animation',
                        'type' => 'check',
                        'options' => array(
                            'has-animation' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => 'has-animation',
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'timetable',
                            'compare' => '!='
                        ),
                    ),

                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Only display for user logged', 'fat-event'),
                        'id' => 'only_for_logged',
                        'type' => 'check',
                        'options' => array(
                            'yes' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => 'no',
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Disable modernizr library', 'fat-event'),
                        'id' => 'disable_modernizr',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'inherit' => esc_html__('Inherit from setting', 'fat-event'),
                            'disable' => esc_html__('Disable', 'fat-event'),
                            'enable' => esc_html__('Enable', 'fat-event'),
                        ),
                        'std' => 'single_window',
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Open event detail', 'fat-event'),
                        'id' => 'open_detail_type',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'single_window' => esc_html__('Separate window', 'fat-event'),
                            'popup_modal' => esc_html__('Popup modal', 'fat-event'),
                            'current_window' => esc_html__('Current Window', 'fat-event'),
                        ),
                        'std' => 'single_window',
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Thumbnail image width', 'fat-event'),
                        'id' => 'image_width',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                        'std' => 375,
                        'description' => esc_html__('You can change thumbnail image size by set width at here and height bellow', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,slide,timeline',
                            'compare' => 'in'
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-layout',
                        'label' => esc_html__('Thumbnail image height', 'fat-event'),
                        'id' => 'image_height',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                        'std' => 275,
                        'depend_field' => array(
                            'field' => 'layout',
                            'value' => 'grid,slide,timeline',
                            'compare' => 'in'
                        ),
                    ),

                    /** Tab filter */
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('From', 'fat-event'),
                        'id' => 'data_from',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'category' => esc_html__('Pickup event belong categories','fat-event'),
                            'event_id' => esc_html__('Pickup event from list event','fat-event')
                        ),
                        'std' => 'category'
                    ),
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('Choose Categories', 'fat-event'),
                        'id' => 'categories',
                        'type' => 'select',
                        'multiple' => true,
                        'options' => $utils->get_event_taxonomy(FAT_EVENT_CATEGORY_TAXONOMY),
                        'std' => 'single_window',
                        'description' => esc_html__('Set empty if you want display event all of categories', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'data_from',
                            'value' => 'category',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('Choose event', 'fat-event'),
                        'id' => 'event_ids',
                        'type' => 'select',
                        'multiple' => true,
                        'options' => $fat_events,
                        'std' => '',
                        'description' => esc_html__('Please select event from list', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'data_from',
                            'value' => 'event_id',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('Choose Locations', 'fat-event'),
                        'id' => 'locations',
                        'type' => 'select',
                        'multiple' => true,
                        'options' => $utils->get_event_taxonomy(FAT_EVENT_LOCATION_TAXONOMY),
                        'std' => '',
                        'description' => esc_html__('Set empty if you want display event all of locations', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'data_from',
                            'value' => 'category',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('Choose Organizers', 'fat-event'),
                        'id' => 'organizers',
                        'type' => 'select',
                        'multiple' => true,
                        'options' => $utils->get_event_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY),
                        'std' => '',
                        'description' => esc_html__('Set empty if you want display event all of organizers', 'fat-event'),
                        'depend_field' => array(
                            'field' => 'data_from',
                            'value' => 'category',
                            'compare' => '='
                        ),
                    ),
                    array(
                        'tab_id' => 'tab-filter',
                        'label' => esc_html__('Include expired events', 'fat-event'),
                        'id' => 'include_expired_event',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        //'description' => esc_html__('This option isn\'t avaiable for Timetable view', 'fat-event')
                    ),

                    /** Tab custom css */
                    array(
                        'tab_id' => 'tab-css',
                        'label' => esc_html__('Custom Css', 'fat-event'),
                        'id' => 'custom_css',
                        'type' => 'ace',
                        'mode' => 'css',
                        'std' => '',
                    ),
                )

            );

            $meta_boxes[] = array(
                'title' => esc_html__('Shortcode', 'fat-event'),
                'id' => 'fat-mb-shortcode',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_SHORTCODE_POST_TYPE),
                'fields' => array(
                    array(
                        'id' => 'shortcode',
                        'type' => 'heading',
                        'css_class' => 'no-label',
                        'std' => isset($post->ID) ? '[fat_event id="' . $post->ID . '"]' : '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => isset($_GET['post']) ? esc_html__('To use shortcode, please select and copy this shortcode and paste to page, post or anywhere', 'fat-event') : '',
                    ),
                )
            );

            $meta_boxes[] = array(
                'title' => esc_html__('Search Form', 'fat-event'),
                'id' => 'fat-mb-shortcode-search',
                'priority' => 'low',
                'context' => 'side',
                'pages' => array(FAT_EVENT_SHORTCODE_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('Enable search', 'fat-event'),
                        'id' => 'enable_search',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Search style', 'fat-event'),
                        'id' => 'search_style',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'dropdown' => esc_html__('Drop down', 'fat-event'),
                            'listing' => esc_html__('Listing', 'fat-event'),
                        ),
                        'std' => 'dropdown',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        ),
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Enable search event name (or ID)', 'fat-event'),
                        'id' => 'enable_search_name',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                    array(
                        'label' => esc_html__('Enable search start date', 'fat-event'),
                        'id' => 'enable_search_start_date',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                    array(
                        'label' => esc_html__('Enable search event tag', 'fat-event'),
                        'id' => 'enable_search_tag',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                    array(
                        'label' => esc_html__('Enable search category', 'fat-event'),
                        'id' => 'enable_search_category',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                    array(
                        'label' => esc_html__('Enable search location', 'fat-event'),
                        'id' => 'enable_search_location',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                    array(
                        'label' => esc_html__('Enable search organizer', 'fat-event'),
                        'id' => 'enable_search_organizer',
                        'type' => 'check',
                        'options' => array(
                            '1' => esc_html__('Yes', 'fat-event')
                        ),
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'depend_field' => array(
                            'field' => 'enable_search',
                            'value' => '1',
                            'compare' => '='
                        )
                    ),
                )
            );

            return $meta_boxes;
        }

        public function add_admin_listing_shortcode_columns($columns)
        {
            $columns = array_merge($columns, array('shortcode' => esc_html__('Shortcodes', 'fat-event')));
            return $columns;
        }

        public function set_admin_listing_shortcode_columns_value($column, $post_id)
        {
            if ($column == 'shortcode') {
                echo '[fat_event id="' . $post_id . '"]';
            }
        }
        /** end shortcode post type */

        function register_taxonomies()
        {
            if (taxonomy_exists(FAT_EVENT_CATEGORY_TAXONOMY)) {
                return;
            }

            $taxonomy_slug = FAT_EVENT_CATEGORY_TAXONOMY;
            $taxonomy_name = esc_html__('Categories', 'fat-event');
            $fat_event_setting = get_option('fat_event_setting');
            $taxonomy_slug = isset($fat_event_setting['event_category_slug']) && $fat_event_setting['event_category_slug'] ? $fat_event_setting['event_category_slug'] : $taxonomy_slug;

            register_taxonomy(FAT_EVENT_CATEGORY_TAXONOMY, FAT_EVENT_POST_TYPE,
                array('hierarchical' => true,
                    'label' => $taxonomy_name,
                    'query_var' => true,
                    'rewrite' => array('slug' => $taxonomy_slug))
            );
            //$this->flush_rewrite();
        }

        function register_tag_taxonomies()
        {
            if (taxonomy_exists(FAT_EVENT_TAG_TAXONOMY)) {
                return;
            }

            $taxonomy_slug = FAT_EVENT_TAG_TAXONOMY;
            $taxonomy_name = esc_html__('Tags', 'fat-event');

            $labels = array(
                'name' => $taxonomy_name,
                'singular_name' => $taxonomy_name,
                'search_items' => esc_html__('Search Tags', 'fat-event'),
                'popular_items' => esc_html__('Popular Tags', 'fat-event'),
                'all_items' => esc_html__('All Tags', 'fat-event'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => esc_html__('Edit Tag', 'fat-event'),
                'update_item' => esc_html__('Update Tag', 'fat-event'),
                'add_new_item' => esc_html__('Add New Tag', 'fat-event'),
                'new_item_name' => esc_html__('New Tag Name', 'fat-event'),
                'separate_items_with_commas' => esc_html__('Separate tags with commas', 'fat-event'),
                'add_or_remove_items' => esc_html__('Add or remove tags', 'fat-event'),
                'choose_from_most_used' => esc_html__('Choose from the most used tags', 'fat-event'),
                'menu_name' => $taxonomy_name,
            );

            register_taxonomy(FAT_EVENT_TAG_TAXONOMY, FAT_EVENT_POST_TYPE, array(
                'hierarchical' => false,
                'labels' => $labels,
                'show_ui' => true,
                'update_count_callback' => '_update_post_term_count',
                'query_var' => true,
                'rewrite' => array('slug' => $taxonomy_slug),
            ));

            //$this->flush_rewrite();
        }

        function register_location_taxonomies()
        {
            if (taxonomy_exists(FAT_EVENT_LOCATION_TAXONOMY)) {
                return;
            }

            $taxonomy_slug = FAT_EVENT_LOCATION_TAXONOMY;
            $taxonomy_name = esc_html__('Locations', 'fat-event');

            $labels = array(
                'name' => $taxonomy_name,
                'singular_name' => $taxonomy_name,
                'search_items' => esc_html__('Search Location', 'fat-event'),
                'popular_items' => esc_html__('Popular Location', 'fat-event'),
                'all_items' => esc_html__('All Location', 'fat-event'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => esc_html__('Edit Location', 'fat-event'),
                'update_item' => esc_html__('Update Location', 'fat-event'),
                'add_new_item' => esc_html__('Add New Location', 'fat-event'),
                'new_item_name' => esc_html__('New Location Name', 'fat-event'),
                'separate_items_with_commas' => esc_html__('Separate location with commas', 'fat-event'),
                'add_or_remove_items' => esc_html__('Add or remove location', 'fat-event'),
                'choose_from_most_used' => esc_html__('Choose from the most used location', 'fat-event'),
                'menu_name' => $taxonomy_name,
            );

            register_taxonomy(FAT_EVENT_LOCATION_TAXONOMY, FAT_EVENT_POST_TYPE, array(
                'hierarchical' => false,
                'labels' => $labels,
                'show_ui' => true,
                'update_count_callback' => '_update_post_term_count',
                'query_var' => true,
                'rewrite' => array('slug' => $taxonomy_slug),
            ));

            //$this->flush_rewrite();
        }

        function register_organizer_taxonomies()
        {
            if (taxonomy_exists(FAT_EVENT_ORGANIZER_TAXONOMY)) {
                return;
            }

            $taxonomy_slug = FAT_EVENT_ORGANIZER_TAXONOMY;
            $taxonomy_name = esc_html__('Organizers', 'fat-event');

            $labels = array(
                'name' => $taxonomy_name,
                'singular_name' => $taxonomy_name,
                'search_items' => esc_html__('Search Organizer', 'fat-event'),
                'popular_items' => esc_html__('Popular Organizer', 'fat-event'),
                'all_items' => esc_html__('All Organizer', 'fat-event'),
                'parent_item' => null,
                'parent_item_colon' => null,
                'edit_item' => esc_html__('Edit Organizer', 'fat-event'),
                'update_item' => esc_html__('Update Organizer', 'fat-event'),
                'add_new_item' => esc_html__('Add New Organizer', 'fat-event'),
                'new_item_name' => esc_html__('New Organizer Name', 'fat-event'),
                'separate_items_with_commas' => esc_html__('Separate organizer with commas', 'fat-event'),
                'add_or_remove_items' => esc_html__('Add or remove organizer', 'fat-event'),
                'choose_from_most_used' => esc_html__('Choose from the most used organizer', 'fat-event'),
                'menu_name' => $taxonomy_name,
            );

            register_taxonomy(FAT_EVENT_ORGANIZER_TAXONOMY, FAT_EVENT_POST_TYPE, array(
                'hierarchical' => false,
                'labels' => $labels,
                'show_ui' => true,
                'update_count_callback' => '_update_post_term_count',
                'query_var' => true,
                'rewrite' => array('slug' => $taxonomy_slug),
            ));

            //$this->flush_rewrite();
        }

        function register_taxonomy_meta_boxes($meta_boxes)
        {
            $fat_event_setting = get_option('fat_event_setting');
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
            }else{
                $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
            }

            /** Location meta box */
            $meta_boxes[] = array(
                'title' => esc_html__('Location detail', 'fat-event'),
                'id' => 'fat-mb-location-detail',
                'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                'fields' => array(
                    array(
                        'label' => esc_html__('Address', 'fat-event'),
                        'id' => 'address',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Map', 'fat-event'),
                        'id' => 'map',
                        'type' => isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox' ? 'mapbox' : 'google_map',
                        'api_key' => $api_key,
                        'std' => ''
                    ),
                    array(
                        'label' => esc_html__('Thumbnail', 'fat-event'),
                        'id' => 'thumbnail',
                        'type' => 'single_image',
                        'std' => '',
                    ),

                )
            );

            /** Organizer meta box */
            $meta_boxes[] = array(
                'title' => esc_html__('Organizer detail', 'fat-event'),
                'id' => 'fat-mb-organizer-detail',
                'taxonomy' => FAT_EVENT_ORGANIZER_TAXONOMY,
                'fields' => array(
                    array(
                        'label' => esc_html__('Telephone', 'fat-event'),
                        'id' => 'telephone',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Website', 'fat-event'),
                        'id' => 'website',
                        'type' => 'text',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12'
                    ),
                    array(
                        'label' => esc_html__('Email', 'fat-event'),
                        'id' => 'email',
                        'type' => 'text',
                        'std' => ''
                    ),
                    array(
                        'label' => esc_html__('Facebook', 'fat-event'),
                        'id' => 'facebook',
                        'type' => 'text',
                        'std' => ''
                    ),
                    array(
                        'label' => esc_html__('Twitter', 'fat-event'),
                        'id' => 'twitter',
                        'type' => 'text',
                        'std' => ''
                    ),
                    array(
                        'label' => esc_html__('Linkedin', 'fat-event'),
                        'id' => 'linkedin',
                        'type' => 'text',
                        'std' => ''
                    ),
                    array(
                        'label' => esc_html__('Thumbnail', 'fat-event'),
                        'id' => 'thumbnail',
                        'type' => 'single_image',
                        'std' => '',
                    ),

                )
            );

            return $meta_boxes;
        }

        /** coupon post type */
        function register_coupon_post_types()
        {
            $post_type = FAT_EVENT_COUPON_POST_TYPE;
            $slug = 'fat-coupon';
            $name = $singular_name = esc_html__('Coupons', 'fat-event');

            if (post_type_exists($post_type)) {
                return;
            }

            register_post_type($post_type,
                array(
                    'label' => esc_html__('Coupon', 'fat-event'),
                    'labels' => array(
                        'name' => $name,
                        'singular_name' => $singular_name,
                        'menu_name' => ucfirst($name),
                        'parent_item_colon' => esc_html__('Parent Item:', 'fat-event'),
                        'all_items' => sprintf(esc_html__('All %s', 'fat-event'), $name),
                        'view_item' => esc_html__('View Coupon', 'fat-event'),
                        'add_new_item' => sprintf(esc_html__('Add New  %s', 'fat-event'), $name),
                        'add_new' => esc_html__('Add Coupon', 'fat-event'),
                        'edit_item' => esc_html__('Edit Coupon', 'fat-event'),
                        'update_item' => esc_html__('Update Coupon', 'fat-event'),
                        'search_items' => esc_html__('Search Coupon', 'fat-event'),
                        'not_found' => esc_html__('Not found', 'fat-event'),
                        'not_found_in_trash' => esc_html__('Not found in Trash', 'fat-event'),
                    ),
                    'supports' => array('title'),
                    'public' => false,
                    'show_ui' => true,
                    '_builtin' => false,
                    'has_archive' => false,
                    'exclude_from_search' => true,
                    'menu_icon' => 'dashicons-calendar-alt',
                    'hierarchical' => true,
                    'rewrite' => array('slug' => $slug, 'with_front' => false),
                )
            );
        }

        function register_coupon_meta_boxes($meta_boxes)
        {
            $meta_boxes[] = array(
                'title' => esc_html__('Coupon config', 'fat-event'),
                'id' => 'fat-mb-event-coupon-detail',
                'priority' => 'high',
                'pages' => array(FAT_EVENT_COUPON_POST_TYPE),
                'fields' => array(
                    array(
                        'label' => esc_html__('General', 'fat-event'),
                        'id' => 'section_general',
                        'type' => 'section',
                    ),
                    array(
                        'label' => esc_html__('Discount type', 'fat-event'),
                        'id' => 'discount_type',
                        'type' => 'select',
                        'multiple' => false,
                        'options' => array(
                            'percentage' => esc_html__('Percentage discount'),
                            'fixed' => esc_html__('Fixed discount'),
                        ),
                        'std' => 'offline',
                        'col_width' => 'fat-cmb-col-12',
                    ),
                    array(
                        'label' => esc_html__('Coupon amount', 'fat-event'),
                        'id' => 'amount',
                        'type' => 'number',
                        'min' => 0.5,
                        'max' => 100000,
                        'step' => 0.5,
                        'std' => 1,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Discount value of coupon','fat-event'),
                    ),
                    array(
                        'label' => esc_html__('Expiry Date', 'fat-event'),
                        'id' => 'expiry_date',
                        'type' => 'datetime',
                        'std' => '',
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Format: Year/Month/Day Hour:Minute', 'fat-event')
                    ),

                    array(
                        'label' => esc_html__('Usage limits', 'fat-event'),
                        'id' => 'section_limits',
                        'type' => 'section',
                    ),

                    array(
                        'label' => esc_html__('Minimum spend', 'fat-event'),
                        'id' => 'minimum_spend',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000000,
                        'step' => 0.5,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-6',
                        'description' => esc_html__('Set 0 or empty to ignore minimum spend','fat-event'),
                    ),
                    array(
                        'label' => esc_html__('Maximum spend', 'fat-event'),
                        'id' => 'maximum_spend',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000000,
                        'step' => 0.5,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-6',
                        'description' => esc_html__('Set 0 or empty to ignore maximum spend','fat-event'),
                    ),
                    array(
                        'label' => esc_html__('Apply for events', 'fat-event'),
                        'id' => 'apply_events',
                        'type' => 'select',
                        'multiple' => true,
                        'data_source' => FAT_EVENT_POST_TYPE,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Fill event name and enter to search. Set empty to apply for all event','fat-event'),
                    ),
                    array(
                        'label' => esc_html__('Exclude events', 'fat-event'),
                        'id' => 'exclude_events',
                        'multiple' => true,
                        'type' => 'select',
                        'data_source' => FAT_EVENT_POST_TYPE,
                        'col_width' => 'fat-cmb-col-12',
                        'description' => esc_html__('Fill event name and enter to search. Set empty to ignore exclude','fat-event'),
                    ),
                    array(
                        'label' => esc_html__('Times to use', 'fat-event'),
                        'id' => 'times_use',
                        'type' => 'number',
                        'min' => 0,
                        'max' => 1000000,
                        'step' => 0.5,
                        'std' => 0,
                        'col_width' => 'fat-cmb-col-6',
                        'description' => esc_html__('How many times this coupon can be used before it is void','fat-event'),
                    ),
                )
            );
            return $meta_boxes;
        }

        public function add_admin_listing_coupon_columns($columns)
        {
            unset(
                $columns['comments'],
                $columns['title'],
                $columns['date'],
                $columns['author']
            );

            $columns = array_merge($columns, array(
                'title' => esc_html__('Coupon Code', 'fat-event'),
                'coupon_type' => esc_html__('Coupon type', 'fat-event'),
                'coupon_amount' => esc_html__('Coupon amount', 'fat-event'),
                'expiry_date' => esc_html__('Expiry date', 'fat-event'),
                'times_to_used' => esc_html__('Times to used', 'fat-event'),
                'used' => esc_html__('Used', 'fat-event'),
            ));
            return $columns;
        }

        public function set_admin_listing_coupon_columns_value($column, $post_id)
        {
            $coupon_detail  = get_post_meta($post_id,'fat-mb-event-coupon-detail', true);
            if ($column === 'coupon_type') {
                echo isset($coupon_detail['discount_type']) && $coupon_detail['discount_type']==='percentage' ? esc_html__('Percentage discount') : esc_html__('Fixed discount');
            }

            if($column==='coupon_amount'){
                echo isset($coupon_detail['amount']) && $coupon_detail['amount'] ?  $coupon_detail['amount'] : 0;
            }

            if($column==='expiry_date'){
                $expiry_date = get_post_meta($post_id,'fat_event_expiry_date',true);
                if($expiry_date){
                    $expiry_date = DateTime::createFromFormat('U',$expiry_date);
                    $date_format = get_option('date_format'). ' '.get_option('time_format');
                    echo $expiry_date->format($date_format);
                }
            }

            if($column==='times_to_used'){
                echo isset($coupon_detail['times_use']) ? $coupon_detail['times_use'] : esc_html__('Unlimited','fat-event');
            }

            if($column==='used'){
                $used = get_post_meta($post_id,'fat_event_coupon_used',true);
                if(is_array($used)){
                    $used = isset($used[0][0]) ? $used[0][0] : 0;
                }
                echo $used ? $used : 0;
            }
        }

        public function save_coupon_post($post_id){
            $expiry_date = isset($_REQUEST['expiry_date']) ? $_REQUEST['expiry_date'] : '';
            if($expiry_date){
                $expiry_date  = DateTime::createFromFormat('Y/m/d H:i',$expiry_date);
                update_post_meta($post_id,'fat_event_expiry_date', $expiry_date->format('U'));
            }
        }
        /** end coupon post type */

        public function event_save_post($post_id)
        {
            $post_type = get_post_type($post_id);
            if ($post_type === FAT_EVENT_POST_TYPE) {
                $location_id = array();
                $main_organizer_id = array();
                $start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
                $end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
                $multiple_location = isset($_REQUEST['multiple_location']) ? $_REQUEST['multiple_location'] : '';

                if($multiple_location=='yes'){
                    $schedule_location = isset($_REQUEST['schedule_location']) ? $_REQUEST['schedule_location'] : '';
                    $schedule_organizer = isset($_REQUEST['schedule_organizer']) ? $_REQUEST['schedule_organizer'] : '';
                    if(is_array($schedule_location)){
                        foreach ($schedule_location as $loc){
                            if($loc!='hide'){
                                $location_id[] = intval($loc);
                            }
                        }
                    }
                    if(is_array($schedule_organizer)){
                        foreach ($schedule_organizer as $org){
                            if($org!='hide'){
                                $main_organizer_id[] = intval($org);
                            }
                        }
                    }
                }else{
                    if(isset($_REQUEST['location']) && $_REQUEST['location']!='hide'){
                        $location_id[] = intval($_REQUEST['location']);
                    }
                    if(isset($_REQUEST['main_organizer']) && $_REQUEST['main_organizer']!='hide'){
                        $main_organizer_id[] = intval($_REQUEST['main_organizer']);
                    }
                }
                // set location and organizer term for post
                wp_set_post_terms($post_id, $location_id, FAT_EVENT_LOCATION_TAXONOMY);
                wp_set_post_terms($post_id, $main_organizer_id, FAT_EVENT_ORGANIZER_TAXONOMY);

                //set category
                $term_obj_list = get_the_terms( $post_id, FAT_EVENT_CATEGORY_TAXONOMY);
                $terms_string = join(', ', wp_list_pluck($term_obj_list, 'name'));
                update_post_meta($post_id, 'category', $terms_string);

                update_post_meta($post_id, 'start_date', $start_date);
                update_post_meta($post_id, 'end_date', $end_date);
                update_post_meta($post_id, 'opt_date_format', FAT_EVENT_DATETIME_FORMAT); //get_option('date_format')

            }
        }

        public function include_tmpl()
        {
            global $pagenow;
            $post_type = isset($_GET['post_type']) ? $_GET['post_type'] : '';
            $taxonomy = isset($_GET['taxonomy']) ? $_GET['taxonomy'] : '';
            if ($post_type == '' && isset($_GET['post'])) {
                $post_type = get_post_type($_GET['post']);
            }
            if (in_array($pagenow, array('post.php', 'post-new.php')) && $taxonomy === '' && $post_type === FAT_EVENT_POST_TYPE) {

                $tmpl_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/tmpl/tmpl.php';
                ob_start();
                if (file_exists($tmpl_path)) {
                    include $tmpl_path;
                }
                $ret = ob_get_contents();
                ob_end_clean();
                echo $ret;
            }
        }

        public function add_admin_listing_event_columns($columns)
        {

            unset(
                $columns['comments'],
                $columns['title'],
                $columns['date'],
                $columns['author']
            );


            $columns = array_merge($columns, array(
                'title' => esc_html__('Title', 'fat-event'),
                'location' => esc_html__('Location', 'fat-event'),
                'organizer' => esc_html__('Organizer', 'fat-event'),
                'start_date' => esc_html__('Start Date', 'fat-event'),
                'end_date' => esc_html__('End Date', 'fat-event'),
                'repeat' => esc_html__('Repeat', 'fat-event'),
            ));
            $columns = array_merge($columns, array('date' => esc_html__('Date', 'fat-event')));
            $columns = array_merge($columns, array('category' => esc_html__('Category', 'fat-event')));
            return $columns;
        }

        public function set_admin_listing_event_columns_value($column, $post_id)
        {
            $event_detail = get_post_meta($post_id, 'fat-mb-event-detail', true);

            if ($column == 'location' && isset($event_detail['location'])) {
                $term = get_term($event_detail['location']);
                echo isset($term->name) ? $term->name : '';
            }

            if ($column == 'organizer' && isset($event_detail['main_organizer'])) {
                $term = get_term($event_detail['main_organizer']);
                echo isset($term->name) ? $term->name : '';
            }

            if ($column == 'start_date') {
                echo isset($event_detail['start_date']) ? $event_detail['start_date'] : '';
            }

            if ($column == 'end_date') {
                echo isset($event_detail['end_date']) ? $event_detail['end_date'] : '';
            }

            if ($column == 'repeat') {
                if (isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1') {
                    echo isset($event_detail['repeat']) ? ucfirst($event_detail['repeat']) : '';
                } else {
                    echo '';
                }

            }

            if ($column == 'category') {
                echo get_post_meta($post_id,'category', true);
            }

        }

        function admin_listing_event_manage_posts()
        {
            global $typenow;
            if ($typenow == FAT_EVENT_POST_TYPE) {
                $selected = isset($_GET[FAT_EVENT_CATEGORY_TAXONOMY]) ? $_GET[FAT_EVENT_CATEGORY_TAXONOMY] : '';
                $args = array(
                    'show_count' => true,
                    'show_option_all' => esc_html__('Show All Categories', 'fat-event'),
                    'taxonomy' => FAT_EVENT_CATEGORY_TAXONOMY,
                    'name' => FAT_EVENT_CATEGORY_TAXONOMY,
                    'selected' => $selected,
                );
                wp_dropdown_categories($args);
            }
        }

        function admin_convert_category_taxonomy_in_query($query)
        {
            global $pagenow;
            $qv = &$query->query_vars;
            if ($pagenow == 'edit.php' &&
                isset($qv[FAT_EVENT_CATEGORY_TAXONOMY]) &&
                is_numeric($qv[FAT_EVENT_CATEGORY_TAXONOMY])
            ) {
                $term = get_term_by('id', $qv[FAT_EVENT_CATEGORY_TAXONOMY], FAT_EVENT_CATEGORY_TAXONOMY);
                if (isset($term->slug)) {
                    $qv[FAT_EVENT_CATEGORY_TAXONOMY] = $term->slug;
                }
            }
        }

        function admin_listing_event_location_manage_posts()
        {
            global $typenow;
            if ($typenow == FAT_EVENT_POST_TYPE) {
                $selected = isset($_GET[FAT_EVENT_LOCATION_TAXONOMY]) ? $_GET[FAT_EVENT_LOCATION_TAXONOMY] : '';
                $args = array(
                    'show_count' => true,
                    'show_option_all' => esc_html__('Show All Location', 'fat-event'),
                    'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                    'name' => FAT_EVENT_LOCATION_TAXONOMY,
                    'selected' => $selected,
                );
                $utils = new FAT_Event_Utils();
                $utils->fat_dropdown_taxonomy($args);
            }
        }

        function admin_convert_location_taxonomy_in_query($query)
        {
            global $pagenow;
            $qv = &$query->query_vars;
            if ($pagenow == 'edit.php' &&
                isset($qv[FAT_EVENT_LOCATION_TAXONOMY]) &&
                is_numeric($qv[FAT_EVENT_LOCATION_TAXONOMY])
            ) {
                $term = get_term_by('id', $qv[FAT_EVENT_LOCATION_TAXONOMY], FAT_EVENT_LOCATION_TAXONOMY);
                if (isset($term->slug)) {
                    $qv[FAT_EVENT_LOCATION_TAXONOMY] = $term->slug;
                }
            }
        }

        function admin_listing_event_organizer_manage_posts()
        {
            global $typenow;
            if ($typenow == FAT_EVENT_POST_TYPE) {
                $selected = isset($_GET[FAT_EVENT_ORGANIZER_TAXONOMY]) ? $_GET[FAT_EVENT_ORGANIZER_TAXONOMY] : '';
                $args = array(
                    'show_count' => true,
                    'show_option_all' => esc_html__('Show All Organizer', 'fat-event'),
                    'taxonomy' => FAT_EVENT_ORGANIZER_TAXONOMY,
                    'name' => FAT_EVENT_ORGANIZER_TAXONOMY,
                    'selected' => $selected,
                );
                $utils = new FAT_Event_Utils();
                $utils->fat_dropdown_taxonomy($args);
            }
        }

        function admin_convert_organizer_taxonomy_in_query($query)
        {
            global $pagenow;
            $qv = &$query->query_vars;
            if ($pagenow == 'edit.php' &&
                isset($qv[FAT_EVENT_ORGANIZER_TAXONOMY]) &&
                is_numeric($qv[FAT_EVENT_ORGANIZER_TAXONOMY])
            ) {
                $term = get_term_by('id', $qv[FAT_EVENT_ORGANIZER_TAXONOMY], FAT_EVENT_ORGANIZER_TAXONOMY);
                if (isset($term->slug)) {
                    $qv[FAT_EVENT_ORGANIZER_TAXONOMY] = $term->slug;
                }
            }
        }

        public function set_fat_event_sortable_columns($columns)
        {
            $columns['start_date'] = 'start_date';
            $columns['end_date'] = 'end_date';
            $columns['category'] = 'category';
            return $columns;
        }

        public function columns_custom_orderby($query)
        {
            if (!is_admin())
                return;

            $orderby = $query->get('orderby');
            $order = $query->get('order');
            $order = strtoupper($order);
            if ('start_date' == $orderby) {
                $query->set('meta_key', 'start_date');
                $query->set('orderby', array('meta_value' => $order));
            }

            if ('end_date' == $orderby) {
                $query->set('meta_key', 'end_date');
                $query->set('orderby', array('meta_value' => $order));
            }

            if ('category' == $orderby) {
                $query->set('meta_key', 'category');
                $query->set('orderby',  array('meta_value' => $order));
            }
        }

        public function flush_rewrite($fat_cmb_section_value)
        {
            flush_rewrite_rules();
        }

        public function admin_enqueue_scripts()
        {
            global $typenow, $pagenow;

            $fat_event_data = array(
                'ajax_url' => admin_url('admin-ajax.php')
            );
            $fat_event_setting = get_option('fat_event_setting');

            $screen = get_current_screen();
            if(isset($screen->id) && $screen->id ==='edit-fat-event-booking'){
                $now = current_time('mysql',0);
                $now = DateTime::createFromFormat('Y-m-d H:i:s', $now)->format('Y-m-d');
                $shortcode_config = array(
                    'start_date' => $now,
                    'limit' => 100000,
                    'pagination' => 'none'

                );
                $total = 0;
                $events = FAT_Event_Utils::get_events($shortcode_config,$total);
                $list_events = array();
                $events_date = array();
                $ev_ids = array();
                foreach($events as $ev){
                    if(!in_array($ev['id'], $ev_ids)){
                        $list_events[] = array(
                            'id' => $ev['id'],
                            'title' => $ev['title'],
                            'fees' => $ev['fees'],
                            'fees_type' => $ev['fees_type'],
                            'fees_package' => isset($ev['fees_package']) ? $ev['fees_package'] : '',
                            'ticket_class' => isset($ev['ticket_class']) ? $ev['ticket_class'] : ''
                        );
                        $ev_ids[] = $ev['id'];
                    }
                    $events_date[$ev['id']][] = $ev['start_date']->format('Y-m-d H:i').';'.$ev['start_date']->format('U').';'.$ev['end_date']->format('U');

                }
                $fat_event_data['evs'] = $events;
                $fat_event_data['events'] = $list_events;
                $fat_event_data['events_date'] = $events_date;
            }

            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
            }else{
                $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
            }
            $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&libraries=places&callback=fat_event_init_google_map', $api_key);
            wp_enqueue_media();
            wp_enqueue_style('fat-event-admin', FAT_EVENT_ASSET_CSS_URL . 'admin/style.css', array(), false);

            wp_enqueue_style('selectize-default', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/css/selectize.default.css', array(), false, false);
            wp_enqueue_script('selectize', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/js/selectize.min.js',  array('jquery', 'jquery-ui-sortable'), false, false);

            if (in_array($pagenow, array('post.php', 'post-new.php')) && FAT_EVENT_POST_TYPE == $typenow) {
                wp_register_script('fat-event', FAT_EVENT_ASSET_JS_URL . 'admin/main.js', array('jquery', 'wp-util'), '1.0.0', true);
                if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                    wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
                    wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
                    wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
                    wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);
                }else{
                    wp_enqueue_script('fat-google-map-api', $map_api, array('fat-event'), false, true);
                }

            } else {
                wp_register_script('fat-event', FAT_EVENT_ASSET_JS_URL . 'admin/main.js', array('jquery', 'wp-util'), '1.0.0', true);
            }
            wp_localize_script('fat-event', 'fat_event_data', $fat_event_data);
            wp_enqueue_script('fat-event');
        }

        public function single_enqueue_scripts()
        {
            wp_enqueue_style('fat-event-font-awesome', FAT_EVENT_PLUGIN_URL . '/assets/fonts/fonts-awesome/css/font-awesome.min.css', array(), '4.7.0');
            wp_enqueue_style('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.css', array(), '1.4.0');
            wp_enqueue_style('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/style.css', array(), FAT_EVENT_PLUGIN_VERSION);
            wp_enqueue_style('fat-spinner', FAT_EVENT_PLUGIN_URL . '/assets/css/frontend/spinner.css', array(), false);
            FAT_Event_Utils::enqueue_google_font();

            $fat_event_setting = get_option('fat_event_setting');
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                $api_key = $fat_event_setting['mapbox_access_token'] && $fat_event_setting['mapbox_access_token'] ? $fat_event_setting['mapbox_access_token'] : '';
            }else{
                $api_key = $fat_event_setting['google_map_api_key'] && $fat_event_setting['google_map_api_key'] ? $fat_event_setting['google_map_api_key'] : 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts';
            }
            $dist = (defined('FAT_CORE_SCRIP_DEBUG') && FAT_CORE_SCRIP_DEBUG) ? '' : 'dist/';

            wp_enqueue_script('jquery-cookie', FAT_EVENT_PLUGIN_URL . '/assets/plugins/jquery.cookie.js', array('jquery'), false, true);

            wp_enqueue_style('selectize-default', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/css/selectize.default.css', array(), false, false);
            wp_enqueue_script('selectize', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/selectize/js/selectize.min.js',  array('jquery', 'jquery-ui-sortable'), false, false);

            wp_enqueue_style('datetime-picker', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.min.css', array(), false, false);
            wp_enqueue_script('datetime-picker', FAT_EVENT_PLUGIN_URL.'/libs/fat-cmb/assets/js/datetime-picker/jquery.datetimepicker.full.min.js',  array('jquery'), false, false);

            wp_enqueue_script('stripe', 'https://js.stripe.com/v3/', array('jquery'), false, false);
            wp_enqueue_script('fat-perfect-scrollbar', FAT_EVENT_PLUGIN_URL . '/assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js', array('jquery'), '1.4.0', true);
            wp_enqueue_script('fat-event', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/fat-event.js', array('jquery', 'wp-util'), FAT_EVENT_PLUGIN_VERSION, false);


            $auto_fill = isset($fat_event_setting['remember_latest_booking']) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0;
            $auto_fill_info = array();
            if($auto_fill){
                $auto_fill_info  = FAT_Event_Utils::get_auto_fill_info();
            }

            wp_localize_script('fat-event', 'fat_event_ajax', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'woocommerce_intergrated' => isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0]=='1' ? 1 : 0,
                'fully_booked' => esc_html__('Fully booked','fat-event'),
                'auto_fill' => isset($fat_event_setting['remember_latest_booking']) && $fat_event_setting['remember_latest_booking'][0]=='1' ? 1 : 0,
                'auto_fill_info' => $auto_fill_info
            ));

            $ver = uniqid();
            if(isset($fat_event_setting['map_source']) && $fat_event_setting['map_source']=='mapbox'){
                wp_enqueue_style('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.css', array(), '1.3.0');
                wp_enqueue_style('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.css', array(), '4.4.1');
                wp_enqueue_script('mapbox-gl', 'https://api.tiles.mapbox.com/mapbox-gl-js/v1.3.0/mapbox-gl.js', array(), '1.3.0', true);
                wp_enqueue_script('mapbox-gl-geocoder', 'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.4.1/mapbox-gl-geocoder.min.js', array('mapbox-gl'), '4.4.1', true);
                wp_enqueue_script('turf', FAT_EVENT_PLUGIN_URL . '/assets/plugins/turf/turf.min.js', array('jquery'), FAT_EVENT_PLUGIN_VERSION, false);
                wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
            }else{
                if(isset($fat_event_setting['disable_google_API'][0]) && $fat_event_setting['disable_google_API'][0]=='1'){
                    wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
                }else{
                    $map_api = sprintf('https://maps.googleapis.com/maps/api/js?key=%s&callback=fat_event_single_map', $api_key);
                    wp_enqueue_script('fat-event-single', FAT_EVENT_PLUGIN_URL . '/assets/js/frontend/'.$dist.'fat-event-single.js', array('jquery'), $ver, false);
                    wp_enqueue_script('fat-google-map', $map_api, array('fat-event-single'), false, false);
                }
            }
        }

        public function get_event_single_template($single)
        {
            /* Checks for single template by post type */
            if (is_singular(FAT_EVENT_POST_TYPE)) {
                $template_path = untrailingslashit(FAT_EVENT_DIR_PATH) . '/templates/single/single-event.php';
                $theme_path = get_stylesheet_directory().'/templates/fat-event/single/single-event.php';
                if(file_exists($theme_path)){
                    $template_path = $theme_path;
                }
                if (file_exists($template_path)) {
                    add_action('wp_enqueue_scripts', array($this, 'single_enqueue_scripts'), 0);
                    return $template_path;
                }
            }

            return $single;
        }

        public function get_event_archive_template($archive_template)
        {
            /* Checks for archive template by post type */
            if (is_post_type_archive(FAT_EVENT_POST_TYPE) || is_tax(FAT_EVENT_CATEGORY_TAXONOMY) || is_tax(FAT_EVENT_TAG_TAXONOMY)) {
                $fat_event_setting = get_option('fat_event_setting');
                $archive_page_id = isset($fat_event_setting['archive_page']) ? $fat_event_setting['archive_page'] : '';
                if (isset($archive_page_id) && $archive_page_id != '') {
                    $cat = get_queried_object();
                    $category = '';
                    if (isset($cat) && isset($cat->slug)) {
                        $category = $cat->slug;
                    }
                    $archive_url = get_permalink($archive_page_id);
                    wp_redirect($archive_url);

                } else {
                    $home_url = get_home_url();
                    wp_redirect($home_url);
                }
            }
            return $archive_template;
        }

        public function fat_booking_field_value($text, $field_id, $post_meta)
        {
            if($field_id==='firstName'){
                $text = $text=='' && isset($post_meta['first_name']) ? $post_meta['first_name'] : $text;
            }
            if($field_id==='lastName'){
                $text = $text=='' && isset($post_meta['last_name']) ? $post_meta['last_name'] : $text;
            }
            if($field_id==='fees_type'){
                if($text==='fees_type'){
                    $text = esc_html__('Fixed fees','fat-event');
                }
                if($text==='package'){
                    $text =  esc_html__('Fees base on quantity','fat-event');
                }
                if($text==='ticket_class'){
                    $text =  esc_html__('Ticket classification','fat-event');
                }
            }
            if($field_id==='ticket_name'){
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'ticket_name', true);
            }
            if ($field_id === 'payment_title') {
                $text = $text ? $text : $post_meta['payment_type'];
                $text = ucfirst($text);
            }
            if ($field_id === 'discount') {
                $text = $text ? '-'.$text : '';
            }
            if ($field_id === 'subtotal') {
                $quantity = isset($post_meta['quantity']) && $post_meta['quantity'] ? $post_meta['quantity'] : 0;
                $price = isset($post_meta['price']) && $post_meta['price'] ? $post_meta['price'] : 0;
                $text = $quantity * $price;
            }
            if ($field_id === 'event_title') {
                $text = isset($post_meta['event_id']) ? get_the_title($post_meta['event_id']) : get_the_title();
            }
            if ($field_id === 'paypal_id') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'paypal_id', true);
            }
            if ($field_id === 'myPOS_status') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'myPOS_status', true);
            }
            if ($field_id === 'paypal_payer_id') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'paypal_payer_id', true);
            }
            if ($field_id === 'paypal_status') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'paypal_status', true);
            }
            if ($field_id === 'paypal_state') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'paypal_state', true);
            }
            if ($field_id === 'stripe_id') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'stripe_id', true);
            }
            if ($field_id === 'stripe_balance_transaction') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'stripe_balance_transaction', true);
            }
            if ($field_id === 'stripe_error') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'stripe_error', true);
            }
            if ($field_id === 'attention_status') {
                $post_id = get_the_ID();
                $text = get_post_meta($post_id, 'attention_status', true);
                $text = $text=='1' ? esc_html__('Yes','fat-event'): esc_html__('No','fat-event');
            }
            if ($field_id === 'another_field') {
                $post_id = get_the_ID();
                $another_field = get_post_meta($post_id, 'another_field', true);
                $text = '';
                if(is_array($another_field)){
                    foreach ($another_field as $k=>$v){
                        $text .= $v['label']. ': ';
                        if(is_array($v['value'])){
                            foreach ($v['value'] as $val){
                                $text.= $val.',';
                            }
                            $text = rtrim($text,",") . '. ';
                        }else{
                            $text.= $v['value'].'. ';
                        }
                    }
                }
            }
            return $text;
        }

        public function fat_booking_field_description($description, $field_id, $post_meta)
        {
            if ($field_id === 'event_title' && isset($post_meta['event_id'])) {
                $description = '<a href="' . get_edit_post_link($post_meta['event_id']) . '">' . esc_html__('Click here to edit event', 'fat-event') . '</a>';
            }
            return $description;
        }

        public function payment_update_status()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'fat_event_booking' && isset($_GET['token']) && isset($_GET['PayerID']) && isset($_GET['paymentId'])) {
                $payment = new FAT_Event_Payment();
                $payment->payment_update_status();
            }
        }

        public function myPOS_update_status()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'fat_event_booking_myPOS'  ) {
                $payment = new FAT_Event_Payment();
                $payment->myPOS_update_status();
            }
        }

        public function attention_confirm()
        {
            if (isset($_GET['source']) && $_GET['source'] === 'fat_event_confirm' && isset($_GET['booking_id']) && isset($_GET['code'])) {
                $booking_id = $_GET['booking_id'] ? $_GET['booking_id'] : 0;
                error_log('attention_confirm booking id:'.$booking_id);
                if ($booking_id > 0) {
                    $confirm_code = get_post_meta($booking_id, 'attention_code', true);
                    error_log('confirm code:'.$confirm_code);
                    if ($confirm_code === $_GET['code']) {
                        update_post_meta($booking_id, 'attention_status', 1);
                        $fat_event_setting = get_option('fat_event_setting');
                        error_log(serialize($fat_event_setting['attention_confirm_success']));
                        if (isset($fat_event_setting['attention_confirm_success']) && $fat_event_setting['attention_confirm_success'] > 0) {
                            $url_redirect = get_permalink($fat_event_setting['attention_confirm_success']);
                            error_log('redirect :'.$url_redirect);
                            if (wp_redirect($url_redirect)) {
                                exit;
                            }
                        }
                    }
                }
            }
        }

        public function register_export_calendar(){
            //ical
            if (isset($_GET['action']) && $_GET['action'] === 'fat_event_export_ical' && isset($_GET['id']) && isset($_GET['s_date']) && isset($_GET['e_date'])) {
                $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
                $u_start_date = isset($_REQUEST['s_date']) ? $_REQUEST['s_date'] : '';
                $u_end_date = isset($_REQUEST['e_date']) ? $_REQUEST['e_date'] : '';
                if ($id > 0) {
                    require_once untrailingslashit(FAT_EVENT_DIR_PATH) . '/libs/ICS.php';
                    $mb_event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
                    $post = get_post($id);
                    $title = get_the_title($id);
                    if($post->post_excerpt){
                        $description =  $post->post_excerpt;
                    }else{
                        $description = wp_trim_words($post->post_content);
                    }

                    $organizer = isset($mb_event_detail['main_organizer']) ? get_term_by('id', $mb_event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                    $location = FAT_Event_Utils::get_location_title($mb_event_detail['location'], ', ');
                    $link_detail =  $mb_event_detail['link_detail'] ? $mb_event_detail['link_detail'] : (get_permalink($id). '?s_date='.$u_start_date.'&e_date='.$u_end_date);

                    $u_start_date = DateTime::createFromFormat('U',$u_start_date);
                    $u_end_date = DateTime::createFromFormat('U',$u_end_date);

                    $u_start_date = $u_start_date->format('Y-m-d H:i');
                    $u_end_date = $u_end_date->format('Y-m-d H:i');

                    $time_zone = get_option('timezone_string');
                    $properties = array(
                        'dtstart' => $u_start_date,
                        'dtend' => $u_end_date,
                        'description' => $description,
                        'location' => $location,
                        'summary' => $title,
                        'url' => $link_detail,
                        'organizer' => $organizer
                    );
                    $ics = new ICS($properties, $time_zone);

                    header('Content-type: text/calendar; charset=utf-8');
                    header('Content-Disposition: attachment; filename="'.str_replace(' ','-',$title) .'.ics"');
                    echo $ics->to_string();
                    exit;
                }
            }

            // google calendar
            if (isset($_GET['action']) && $_GET['action'] === 'fat_event_export_gg' && isset($_GET['id']) && isset($_GET['s_date']) && isset($_GET['e_date'])) {
                $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : 0;
                $u_start_date = isset($_REQUEST['s_date']) ? $_REQUEST['s_date'] : '';
                $u_end_date = isset($_REQUEST['e_date']) ? $_REQUEST['e_date'] : '';
                $access_token = isset($_REQUEST['access_token']) ? $_REQUEST['access_token'] : '';

                if ($id > 0 && $access_token && $u_start_date && $u_end_date) {
                    ob_start();
                    $mb_event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
                    $title = get_the_title($id);
                    $description = get_the_excerpt($id);
                    $organizer = isset($mb_event_detail['main_organizer']) ? get_term_by('id', $mb_event_detail['main_organizer'], FAT_EVENT_ORGANIZER_TAXONOMY) : '';
                    $location = FAT_Event_Utils::get_location_title($mb_event_detail['location'], ', ');
                    $link_detail =  $mb_event_detail['link_detail'] ? $mb_event_detail['link_detail'] : (get_permalink($id). '?s_date='.$u_start_date.'&e_date='.$u_end_date);

                    // get timezone
                    $ch = curl_init();
                    $url_settings = 'https://www.googleapis.com/calendar/v3/users/me/settings/timezone';
                    curl_setopt($ch, CURLOPT_URL, $url_settings);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer '. $access_token));
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                    $data = json_decode(curl_exec($ch), true);
                    $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
                    if($http_code != 200)
                        throw new Exception(esc_html__( 'Error : Failed to get timezone','fat-event'));

                    $event_timezone = $data['value'];

                    //create event calendar
                    $mb_event_detail = get_post_meta($id, 'fat-mb-event-detail', true);
                    $title = get_the_title($id);

                    $calendar_id = 'primary';

                    // Event starting & finishing at a specific time
                    $full_day_event = 0;
                    $event_time = [ 'start_time' => DateTime::createFromFormat('U',$u_start_date)->format('c'), 'end_time' => DateTime::createFromFormat('U',$u_end_date)->format('c') ];

                    $url_events = 'https://www.googleapis.com/calendar/v3/calendars/' . $calendar_id . '/events';

                    $curlPost = array('summary' => $title);
                    $curlPost['start'] = array('dateTime' => $event_time['start_time'], 'timeZone' => $event_timezone);
                    $curlPost['end'] = array('dateTime' => $event_time['end_time'], 'timeZone' => $event_timezone);

                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url_events);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Bearer '. $access_token, 'Content-Type: application/json'));
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($curlPost));
                    $data = json_decode(curl_exec($ch), true);
                    $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
                    if($http_code != 200)
                        throw new Exception('Error : Failed to create event');

                    exit;
                }
            }
        }

        public function register_get_google_access_token(){
            if (isset($_GET['action']) && $_GET['action'] === 'fat_event_google_get_token' && isset($_GET['id']) && isset($_GET['s_date']) && isset($_GET['e_date'])) {
                //get access token
                $url = 'https://accounts.google.com/o/oauth2/token';
                $client_id = '529010008389-ak5n8tleo4d2u090ufemdt62l4gtara0.apps.googleusercontent.com';
                $redirect_uri = '';
                $client_secret='Qmzy5A6GPsBSHT94yd6neToN';
                $code =  $_GET['code'];
                $curlPost = 'client_id=' . $client_id . '&redirect_uri=' . $redirect_uri . '&client_secret=' . $client_secret . '&code='. $code . '&grant_type=authorization_code';
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
                $data = json_decode(curl_exec($ch), true);
                $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);
                if($http_code != 200)
                    throw new Exception(esc_html__( 'Error : Failed to receive access token','fat-event'));

                $access_token = $data['access_token'];
                $url_redirect = home_url('/').'?action=fat_event_export_gg&access_token='.$access_token.'&id='.$_REQUEST['id'].'&s_date='.$_REQUEST['s_date'].'&e_date='.$_REQUEST['e_date'];
                if (wp_redirect($url_redirect)) {
                    exit;
                }
            }
        }

        public function singe_event_page_title($output){
            if (is_singular(FAT_EVENT_POST_TYPE)) {
                $output = get_the_title();
            }
            return $output;
        }

        public function event_create_location_term($term_id, $tt_id){
            $current_user_id = get_current_user_id();
            if($current_user_id){
                $term_owner = get_user_meta($current_user_id, 'location_term_owner',true);
                if(!is_array($term_owner)){
                    $term_owner = array();
                }
                $term_owner[] = $term_id;
                update_user_meta($current_user_id, 'location_term_owner', $term_owner);
            }
        }

        public function event_create_organizer_term($term_id, $tt_id){
            $current_user_id = get_current_user_id();
            if($current_user_id){
                $term_owner = get_user_meta($current_user_id, 'organizer_term_owner',true);
                if(!is_array($term_owner)){
                    $term_owner = array();
                }
                $term_owner[] = $term_id;
                update_user_meta($current_user_id, 'organizer_term_owner', $term_owner);
            }
        }

        public function include_tmpl_booking(){
            $screen = get_current_screen();
            if(isset($screen->id) && $screen->id ==='edit-fat-event-booking'){
                var_dump(FAT_EVENT_DIR_PATH.'tmpl/tmpl_admin_booking.php');
                include_once FAT_EVENT_DIR_PATH.'tmpl/tmpl_admin_booking.php';
            }
        }
    }
}