<?php
/*
Plugin Name: FAT Event
Plugin URI:  http://plugins.roninwp.com/event
Description: WordPress Event and Calendar Plugin
Version:     5.17
Author:      Roninwp
Author URI:  https://codecanyon.net/user/roninwp/portfolio?ref=roninwp
Domain Path: /languages
Text Domain: fat-event
*/

require_once(ABSPATH . 'wp-admin/includes/file.php');

if (!defined('ABSPATH')) die('-1');
if (!class_exists('FAT_Event')) {
    class FAT_Event
    {
        private static $instance = NULL;

        function __construct()
        {
            defined('FAT_EVENT_POST_TYPE') or define('FAT_EVENT_POST_TYPE', 'fat-event');
            defined('FAT_EVENT_CATEGORY_TAXONOMY') or define('FAT_EVENT_CATEGORY_TAXONOMY', 'fat-event-category');
            defined('FAT_EVENT_CATEGORY_TAXONOMY_NAME') or define('FAT_EVENT_CATEGORY_TAXONOMY_NAME', 'Categories');

            defined('FAT_EVENT_COUPON_POST_TYPE') or define('FAT_EVENT_COUPON_POST_TYPE', 'fat-coupon');
            defined('FAT_EVENT_SHORTCODE_POST_TYPE') or define('FAT_EVENT_SHORTCODE_POST_TYPE', 'fat-calendar');

            defined('FAT_EVENT_BOOKING_POST_TYPE') or define('FAT_EVENT_BOOKING_POST_TYPE', 'fat-event-booking');

            defined('FAT_EVENT_TAG_TAXONOMY') or define('FAT_EVENT_TAG_TAXONOMY', 'fat-event-tag');
            defined('FAT_EVENT_TAG_TAXONOMY_NAME') or define('FAT_EVENT_TAG_TAXONOMY_NAME', 'Tag');

            defined('FAT_EVENT_LOCATION_TAXONOMY') or define('FAT_EVENT_LOCATION_TAXONOMY', 'fat-event-location');
            defined('FAT_EVENT_LOCATION_TAXONOMY_NAME') or define('FAT_EVENT_LOCATION_TAXONOMY_NAME', 'Locations');

            defined('FAT_EVENT_ORGANIZER_TAXONOMY') or define('FAT_EVENT_ORGANIZER_TAXONOMY', 'fat-event-organizer');
            defined('FAT_EVENT_ORGANIZER_TAXONOMY_NAME') or define('FAT_EVENT_ORGANIZER_TAXONOMY_NAME', 'Organizers');

            defined('FAT_EVENT_DIR_PATH') or define('FAT_EVENT_DIR_PATH', plugin_dir_path(__FILE__));
            defined('FAT_EVENT_PLUGIN_URL') or define('FAT_EVENT_PLUGIN_URL', plugins_url('', __FILE__));
            defined('FAT_EVENT_ASSET_JS_URL') or define('FAT_EVENT_ASSET_JS_URL', plugins_url() . '/fat-event/assets/js/');
            defined('FAT_EVENT_ASSET_CSS_URL') or define('FAT_EVENT_ASSET_CSS_URL', plugins_url() . '/fat-event/assets/css/');

            defined('FAT_EVENT_FLUSH_REWRITE_KEY') or define('FAT_EVENT_FLUSH_REWRITE_KEY', 'fat_event_need_flush_rewrite_rules');

            defined('FAT_EVENT_PLUGIN_VERSION') or define('FAT_EVENT_PLUGIN_VERSION', '5.17');

            defined('FAT_EVENT_DATETIME_FORMAT') or define('FAT_EVENT_DATETIME_FORMAT', 'Y/m/d');

            add_action('plugins_loaded', array($this, 'load_textdomain'));
            add_filter('et_builder_post_types', array($this, 'my_et_builder_post_types'));

            $this->init_remainder_cron();

        }

        function fat_event_locale($locale)
        {
            if (strpos($locale, '.UTF8') === FALSE && strpos($locale, '.utf8') === FALSE) {
                $locale .= '.utf8';
            }
            return $locale;
        }

        function my_et_builder_post_types($post_types)
        {
            $post_types[] = FAT_EVENT_POST_TYPE;
            return $post_types;
        }

        public function plugin_activate()
        {
            $this->init_default_setting();
            global $wpdb;
            // update event_id meta for booking
            $args = array(
                'post_type' => FAT_EVENT_BOOKING_POST_TYPE,
                'post_status' => 'publish',
                'nopaging' => true,
                'post_per_page' => -1,
            );
            $posts = new WP_Query($args);
            $event_id = $booking_meta = $booking_id = $booking_date_string = '';

            $start_date = '';
            $sql = '';
            $nof= '';

            $customer = '';
            while ($posts->have_posts()) : $posts->the_post();
                $booking_id = get_the_ID();
                $booking_detail = get_post_meta($booking_id, 'fat-mb-event-booking-detail', true);
                $customer= '';
                if(isset($booking_detail['first_name']) && isset($booking_detail['last_name'])){
                    $customer = $booking_detail['first_name'] . ' ' . $booking_detail['last_name'];
                    $customer = trim($customer);
                }
                delete_post_meta($booking_id,'customer');
                update_post_meta($booking_id, 'customer', $customer);

                /*$nof = isset($booking_detail['text-1621845678578'])  ? $booking_detail['text-1621845678578'] : '';
                delete_post_meta($booking_id,'name_of_child');
                update_post_meta($booking_id, 'name_of_child', $nof);


                $event_id = get_post_meta($booking_id, 'event_id', true);
                $booking_meta = get_post_meta($booking_id, 'fat-mb-event-booking-detail', true);
                $booking_date_string = get_the_date('Y-m-d', $booking_id);
                if (isset($booking_meta['email'])) {
                    update_post_meta($booking_id, 'email', $booking_meta['email'], true);
                }
                $start_date = get_post_meta($booking_id, 'start_date', true);

                delete_post_meta($booking_id,'location');
                delete_post_meta($booking_id,'organizer');
                delete_post_meta($booking_id,'booking_date_string');
                delete_post_meta($booking_id,'start_date_str');

                update_post_meta($booking_id, 'booking_date_string', $booking_date_string, true);
                update_post_meta($booking_id, 'start_date_str', $start_date->format('Y-m-d'), true);

                /*$loc_orgs = FAT_Event_Utils::get_location_organizer($event_id);
                add_post_meta($booking_id, 'location', $loc_orgs['location'], true);
                add_post_meta($booking_id, 'organizer', $loc_orgs['organizer'], true);

                $sql = "SELECT TT.term_id FROM {$wpdb->prefix}posts AS P
                        LEFT JOIN {$wpdb->prefix}term_relationships AS TR
                        ON P.ID = TR.object_id
                        LEFT JOIN {$wpdb->prefix}term_taxonomy AS TT
                        ON TR.term_taxonomy_id = TT.term_taxonomy_id
                        WHERE TT.taxonomy='fat-event-category'
                        AND P.ID = ". $event_id;

                $cat_list = $wpdb->get_results($sql);
                foreach($cat_list as $cat){
                    add_post_meta($booking_id, 'category', $cat->term_id, false);
                }*/

                if (!$event_id || $event_id === '') {
                    if (isset($booking_meta['event_id'])) {
                        update_post_meta($booking_id, 'event_id', $booking_meta['event_id'], true);
                    }
                }
            endwhile;
            wp_reset_postdata();

            delete_option('fat_event_flush_rewrite');
        }

        public static function instance()
        {
            if (!self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        function init()
        {
            //$this->load_textdomain();
            $this->includes();
            if (class_exists('FAT_Event_CPT')) {
                new FAT_Event_CPT();
            }
            if (class_exists('FAT_Event_Menu')) {
                new FAT_Event_Menu();
            }
            if (class_exists('FAT_Event_Shortcode')) {
                new FAT_Event_Shortcode();
            }
            register_activation_hook(__FILE__, array($this, 'plugin_activate'));
            if(is_admin() && isset($_REQUEST['action']) && isset($_REQUEST['email']) && $_REQUEST['action']=='test_mail'){
                $result = FAT_Event_Utils::send_mail_test($_REQUEST['email']);
                echo 'result send mail:'.serialize($result);
            }
        }

        function load_textdomain()
        {
            $domain = dirname(plugin_basename(__FILE__));
            $locale = apply_filters('plugin_locale', get_locale(), $domain);
            load_textdomain('fat-event', trailingslashit(WP_LANG_DIR) . 'plugins' . '/' . $domain . '-' . $locale . '.mo');
            load_plugin_textdomain('fat-event', false, basename(dirname(__FILE__)) . '/languages/');
        }

        private function includes()
        {
            $fat_event_setting = get_option('fat_event_setting');

            if (!class_exists('FAT_Cmb')) {
                require_once('libs/fat-cmb/fat-cmb.php');
            }
            require_once('utils/payment.php');
            require_once('inc/cpt.php');
            require_once('inc/menu.php');
            require_once('inc/shortcodes.php');
            if (isset($fat_event_setting['enable_woocommerce'][0]) && $fat_event_setting['enable_woocommerce'][0] === '1') {
                require_once('inc/woocommerce-integrated.php');
            }
            require_once('utils/utils.php');


            if (isset($fat_event_setting['enable_api'][0]) && $fat_event_setting['enable_api'][0] === '1') {
                require_once('api/event_controller.php');
            }
        }

        private function init_default_setting()
        {
            $fat_setting = get_option('fat_event_setting', array());
            if (!isset($fat_setting) || !is_array($fat_setting) || count($fat_setting) == 0) {
                $fat_setting = array(
                    'archive_page' => '',
                    'event_slug' => FAT_EVENT_POST_TYPE,
                    'event_category_slug' => FAT_EVENT_CATEGORY_TAXONOMY,
                    'reCaptcha_key' => '6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI',
                    'reCaptcha_secret' => '6LeIxAcTAAAAAGG-vFI1TnRWxMZNFuojJ4WifJWe',
                    'google_map_api_key' => 'AIzaSyDnjdX5Zv3gPDvsYE2ZsbyQ-xl4TbSu8ts',
                    'zoom_level' => 13,
                    'show_google_map' => array('1'),
                    'enable_social' => array('1'),
                    'enable_facebook' => array('1'),
                    'enable_twitter' => array('1'),
                    'enable_google_plus' => array('1'),
                    'enable_linkedin' => array('1'),
                    'enable_email' => array('1'),
                    'currency' => 'USD',
                    'currency_symbol' => '$',
                    'symbol_position' => 'suffix',
                    'currency_decimal' => 0,
                    'currency_separator' => ',',
                    'payment_method' => 'both',
                    'payment_api' => 'sandbox',
                    'paypal_client_id' => 'AcjVqTSABlK2AYj4VruT1f7LH4WgpkXHjaUoYH7UwdIzDplzVfrFDifrzRVXw_YGgAZyKtKZaW0IO6ek',
                    'paypal_secret' => 'ECZLRZe7Bi4z4yljhB0lsifnkjTn4Q3rhRJreHQQCUou3anY5NWwrWubZT2HvhOIqqpMPGwd2a8sXbf1',
                    'stripe_publish_key' => 'pk_test_9q3BpuszZDNlnc8uppYQYQH7',
                    'stripe_secret_key' => 'sk_test_4z295yRYaiEBneY29hOzzMF5',
                    'payment_notification' => 'popup',
                    'payment_success_message' => esc_html__('Thank you for your booking. See you soon in our event!', 'fat-event'),
                    'payment_error_message' => esc_html__('Sorry for the inconvenience. Please contact our staff by send mail to : info@roninwp.com !', 'fat-event'),
                    'payment_page_success' => '',
                    'payment_page_error' => '',
                    'single_layout' => 'single-style-01',
                    'single_time_format' => 'H:i',

                );
                update_option('fat_event_setting', $fat_setting);
            }
        }

        /*
         * Reminder cron
         */
        function init_remainder_cron(){
            $fat_setting = get_option('fat_event_setting', array());
            if(isset($fat_setting['enable_email_reminder']) && $fat_setting['enable_email_reminder']=='1'){
                add_filter('cron_schedules', array($this, 'add_cron_interval'));
                add_action('init', array($this, 'cron_action'));
                add_action('fat_cron_event', array($this, 'job_cron'));
            }
        }

        public function add_cron_interval($schedules)
        {
            $fat_setting = get_option('fat_event_setting', array());
            $schedules['fat_event_in_hourly'] = array(
                'interval' => 60*2,
                'display' => esc_html__('Fat Event reminder before the event starts','fat-event'),
            );
            return $schedules;
        }

        function cron_action()
        {
            if (!wp_next_scheduled('fat_cron_event')) {
                wp_schedule_event(time(), 'fat_event_in_hourly', 'fat_cron_event');
            }
        }

        public function job_cron()
        {
            FAT_Event_Utils::send_email_reminder();
        }
    }

    $FAT_Event = FAT_Event::instance();
    $FAT_Event->init();
}
