var $fat_calendar_widget = {};
!function () {
    var today = moment();

    function Calendar(selector, events, month) {
        this.el = document.querySelector(selector);
        this.events = events;
        if(typeof month !='undefined' && month > -1 && month < 12 ){
            this.current = moment().set('month',month).date(1);
        }else{
            this.current = moment().date(1);
        }
        this.draw();
        var current = this.el.querySelector('.today');
        if (current) {
            var self = this;
            window.setTimeout(function () {
                self.openDay(current);
            }, 500);
        }
    }

    Calendar.prototype.draw = function () {
        //Create Header
        this.drawHeader();

        //Draw Month
        this.drawMonth();

        //this.drawLegend();
    };

    Calendar.prototype.drawHeader = function () {
        var self = this;
        if (!this.header) {
            //Create the header elements
            this.header = createElement('div', 'calendar-header');
            this.header.className = 'calendar-header';

            this.title = createElement('h1');

            var right = createElement('div', 'right');
            right.addEventListener('click', function () {
                self.nextMonth();
            });

            var left = createElement('div', 'left');
            left.addEventListener('click', function () {
                self.prevMonth();
            });

            //Append the Elements
            this.header.appendChild(this.title);
            this.header.appendChild(right);
            this.header.appendChild(left);
            this.el.appendChild(this.header);
        }

        this.title.innerHTML = this.current.format('MMMM YYYY');
    };

    Calendar.prototype.drawMonth = function () {
        var self = this;

        if (this.month) {
            this.oldMonth = this.month;
            this.oldMonth.className = 'month out ' + (self.next ? 'next' : 'prev');
            this.oldMonth.addEventListener('webkitAnimationEnd', function () {
                self.oldMonth.parentNode.removeChild(self.oldMonth);
                self.month = createElement('div', 'month');
                self.backFill();
                self.currentMonth();
                self.fowardFill();
                self.el.appendChild(self.month);
                window.setTimeout(function () {
                    self.month.className = 'month in ' + (self.next ? 'next' : 'prev');
                }, 16);
            });
        } else {
            this.month = createElement('div', 'month');
            this.el.appendChild(this.month);
            this.backFill();
            this.currentMonth();
            this.fowardFill();
            this.month.className = 'month new';
        }
    };

    Calendar.prototype.backFill = function () {
        var clone = this.current.clone();
        var dayOfWeek = clone.day();

        if (!dayOfWeek) {
            return;
        }

        clone.subtract('days', dayOfWeek + 1);

        for (var i = dayOfWeek; i > 0; i--) {
            this.drawDay(clone.add('days', 1));
        }
    };

    Calendar.prototype.fowardFill = function () {
        var clone = this.current.clone().add('months', 1).subtract('days', 1);
        var dayOfWeek = clone.day();

        if (dayOfWeek === 6) {
            return;
        }

        for (var i = dayOfWeek; i < 6; i++) {
            this.drawDay(clone.add('days', 1));
        }
    };

    Calendar.prototype.currentMonth = function () {
        var clone = this.current.clone();

        while (clone.month() === this.current.month()) {
            this.drawDay(clone);
            clone.add('days', 1);
        }
    };

    Calendar.prototype.getWeek = function (day) {
        if (!this.week || day.day() === 0) {
            this.week = createElement('div', 'week');
            this.month.appendChild(this.week);
        }
    };

    Calendar.prototype.drawDay = function (day) {
        var self = this;
        this.getWeek(day);

        //Outer Day
        var outer = createElement('div', this.getDayClass(day));
        outer.addEventListener('click', function () {
            self.openDay(this);
        });

        //Day Name
        var name = createElement('div', 'day-name', day.format('ddd'));

        //Day Number
        var number = createElement('div', 'day-number', day.format('DD'));


        //Events
        var events = createElement('div', 'day-events');
        this.drawEvents(day, events);

        outer.appendChild(name);
        outer.appendChild(number);
        outer.appendChild(events);
        this.week.appendChild(outer);

        var has_event = jQuery('.day-events > span',outer).length > 0;
        if(has_event){
            jQuery(outer).addClass('has-events');
        }
    };

    Calendar.prototype.drawEvents = function (day, element) {
        if (day.month() === this.current.month()) {
            var todaysEvents = this.events.reduce(function (memo, ev) {
                if (ev.day == day.date() && ev.month == (day.month()+1) && ev.year == day.year()) {
                    memo.push(ev);
                }
                return memo;
            }, []);

            todaysEvents.forEach(function (ev) {
                var evSpan = createElement('span', ev.color);
                evSpan.style.backgroundColor = ev.color;
                element.appendChild(evSpan);
            });
        }
    };

    Calendar.prototype.getDayClass = function (day) {
        classes = ['day'];
        if (day.month() !== this.current.month()) {
            classes.push('other');
        } else if (today.isSame(day, 'day')) {
            classes.push('today');
        }
        return classes.join(' ');
    };

    Calendar.prototype.openDay = function (el) {
        var details, arrow;
        var dayNumber = +el.querySelectorAll('.day-number')[0].innerText || +el.querySelectorAll('.day-number')[0].textContent;
        var day = this.current.clone().date(dayNumber);
        var currentOpened = jQuery(el).closest('.fat-event-sc.calendar-widget')[0].querySelector('.details');

        //Check to see if there is an open detais box on the current row
        if (currentOpened && currentOpened.parentNode === el.parentNode) {
            details = currentOpened;
            arrow = el.querySelector('.arrow');
            if(arrow==null){
                arrow = jQuery(el).closest('.fat-event-sc.calendar-widget')[0].querySelector('.arrow');
            }
        } else {
            //Close the open events on differnt week row
            //currentOpened && currentOpened.parentNode.removeChild(currentOpened);
            if (currentOpened) {
                currentOpened.addEventListener('webkitAnimationEnd', function () {
                    if(typeof currentOpened.parentNode!='undefined' && currentOpened.parentNode!=null) {
                        currentOpened.parentNode.removeChild(currentOpened);
                    }
                });
                currentOpened.addEventListener('oanimationend', function () {
                    if(typeof currentOpened.parentNode!='undefined' && currentOpened.parentNode!=null) {
                        currentOpened.parentNode.removeChild(currentOpened);
                    }
                });
                currentOpened.addEventListener('msAnimationEnd', function () {
                    if(typeof currentOpened.parentNode!='undefined' && currentOpened.parentNode!=null) {
                        currentOpened.parentNode.removeChild(currentOpened);
                    }
                });
                currentOpened.addEventListener('animationend', function () {
                    if(typeof currentOpened.parentNode!='undefined' && currentOpened.parentNode!=null) {
                        currentOpened.parentNode.removeChild(currentOpened);
                    }
                });
                currentOpened.className = 'details out';
            }

            //Create the Details Container
            details = createElement('div', 'details in');

            //Create the arrow
            var arrow = createElement('div', 'arrow');

            //Create the event wrapper

            details.appendChild(arrow);
            el.parentNode.appendChild(details);
        }

        var todaysEvents = this.events.reduce(function (memo, ev) {
            if (ev.day == day.date() && ev.month == (day.month()+1) && ev.year == day.year()) {
                memo.push(ev);
            }
            return memo;
        }, []);

        this.renderEvents(todaysEvents, details);

        arrow.style.left = el.offsetLeft - el.parentNode.offsetLeft + 27 + 'px';
        setTimeout(function(){
            var container = jQuery(el).closest('.fat-event-sc.calendar-widget');
            jQuery('.details.in', container).css('opacity', 1).css('height', jQuery('.details.in .events.in', container).outerHeight()+'px');
        },500)

    };

    Calendar.prototype.renderEvents = function (events, ele) {
        //Remove any events in the current details element
        var currentWrapper = ele.querySelector('.events');
        var wrapper = createElement('div', 'events in' + (currentWrapper ? ' new' : ''));
        events.forEach(function (ev) {
            var div = createElement('div', 'event');
            var square = createElement('div', 'event-category ');
            var span = createElement('span','','');
            var link = createElement('a','',ev.eventName);
            square.style.backgroundColor = ev.color;
            link.setAttribute('href',ev.link_detail);
            link.setAttribute('data-open-type',ev.open_type);
            link.setAttribute('data-event-id',ev.id);
            link.setAttribute('data-time',ev.time);
            link.setAttribute('data-single-time',ev.single_time);
            link.setAttribute('data-s',ev.data_start);
            link.setAttribute('data-e',ev.data_end);
            span.appendChild(link);
            div.appendChild(square);
            div.appendChild(span);
            wrapper.appendChild(div);
        });

        if (!events.length) {
            var div = createElement('div', 'event empty');
            var no_event = typeof fat_event_ajax.no_event !='undefined' ? fat_event_ajax.no_event : 'No Events';
            var span = createElement('span', '', no_event);

            div.appendChild(span);
            wrapper.appendChild(div);
        }
        if (currentWrapper) {
            currentWrapper.className = 'events out';
            currentWrapper.addEventListener('webkitAnimationEnd', function () {
                if(typeof currentWrapper.parentNode!='undefined' && currentWrapper.parentNode!=null) {
                    currentWrapper.parentNode.removeChild(currentWrapper);
                }
                ele.appendChild(wrapper);
            });
            currentWrapper.addEventListener('oanimationend', function () {
                if(typeof currentWrapper.parentNode!='undefined' && currentWrapper.parentNode!=null) {
                    currentWrapper.parentNode.removeChild(currentWrapper);
                }
                ele.appendChild(wrapper);
            });
            currentWrapper.addEventListener('msAnimationEnd', function () {
                if(typeof currentWrapper.parentNode!='undefined' && currentWrapper.parentNode!=null) {
                    currentWrapper.parentNode.removeChild(currentWrapper);
                }
                ele.appendChild(wrapper);
            });
            currentWrapper.addEventListener('animationend', function () {
                if(typeof currentWrapper.parentNode!='undefined' && currentWrapper.parentNode!=null){
                    currentWrapper.parentNode.removeChild(currentWrapper);
                }
                ele.appendChild(wrapper);
            });
        } else {
            ele.appendChild(wrapper);
        }

        setTimeout(function(){
            jQuery(document).trigger('tg_init_popup_detail');
        },800);
    };

    Calendar.prototype.drawLegend = function () {
        var legend = createElement('div', 'legend');
        var calendars = this.events.map(function (e) {
            return e.calendar + '|' + e.color;
        }).reduce(function (memo, e) {
            if (memo.indexOf(e) === -1) {
                memo.push(e);
            }
            return memo;
        }, []).forEach(function (e) {
            var parts = e.split('|');
            var entry = createElement('span', 'entry ' + parts[1], parts[0]);
            legend.appendChild(entry);
        });
        this.el.appendChild(legend);
    };

    Calendar.prototype.nextMonth = function () {
        this.current.add('months', 1);
        this.next = true;
        FatLoading.showLoading(this.el);
        var elm = this.el,
            calendar = $fat_calendar_widget[elm.getAttribute('id')],
            month = this.current.format('M');
        switch (month) {
            case '1': {
                month = 'Jan';
                break;
            }
            case '2': {
                month = 'Feb';
                break;
            }
            case '3': {
                month = 'Mar';
                break;
            }
            case '4': {
                month = 'Apr';
                break;
            }
            case '5': {
                month = 'May';
                break;
            }
            case '6': {
                month = 'Jun';
                break;
            }
            case '7': {
                month = 'Jul';
                break;
            }
            case '8': {
                month = 'Aug';
                break;
            }
            case '9': {
                month = 'Sep';
                break;
            }
            case '10': {
                month = 'Oct';
                break;
            }
            case '11': {
                month = 'Nov';
                break;
            }
            case '12': {
                month = 'Dec';
                break;
            }
        }
        jQuery.ajax({
            url: fat_event_ajax.ajaxurl,
            type: 'GET',
            data: ({
                action: 'fat_event_get_calendar',
                sc_id: this.el.getAttribute('data-sc-id'),
                month: month,
                year: this.current.format('Y')
            }),
            success: function (data) {
                FatLoading.closeLoading(elm);
                data = jQuery.parseJSON(data);
                for (var $i = 0; $i < data.length; $i++) {
                    data[$i].date =  moment(data[$i].date, "YYYY-MM-DD HH:mm");
                }
                calendar.events = data;
                calendar.draw();
                jQuery(document).trigger('fat_event_register_view_detail');
            },
            error: function () {
                FatLoading.closeLoading(elm);
            }
        });

    };

    Calendar.prototype.prevMonth = function () {
        this.current.subtract('months', 1);
        this.next = false;
        FatLoading.showLoading(this.el);
        var elm = this.el,
            calendar = $fat_calendar_widget[elm.getAttribute('id')],
            month = this.current.format('M');
        switch (month) {
            case '1': {
                month = 'Jan';
                break;
            }
            case '2': {
                month = 'Feb';
                break;
            }
            case '3': {
                month = 'Mar';
                break;
            }
            case '4': {
                month = 'Apr';
                break;
            }
            case '5': {
                month = 'May';
                break;
            }
            case '6': {
                month = 'Jun';
                break;
            }
            case '7': {
                month = 'Jul';
                break;
            }
            case '8': {
                month = 'Aug';
                break;
            }
            case '9': {
                month = 'Sep';
                break;
            }
            case '10': {
                month = 'Oct';
                break;
            }
            case '11': {
                month = 'Nov';
                break;
            }
            case '12': {
                month = 'Dec';
                break;
            }
        }
        jQuery.ajax({
            url: fat_event_ajax.ajaxurl,
            type: 'GET',
            data: ({
                action: 'fat_event_get_calendar',
                sc_id: this.el.getAttribute('data-sc-id'),
                month: month,
                year: this.current.format('Y')
            }),
            success: function (data) {
                FatLoading.closeLoading(elm);
                data = jQuery.parseJSON(data);
                for (var $i = 0; $i < data.length; $i++) {
                    data[$i].date =  moment(data[$i].date, "YYYY-MM-DD HH:mm");
                }
                calendar.events = data;
                calendar.draw();
                jQuery(document).trigger('fat_event_register_view_detail');
            },
            error: function () {
                FatLoading.closeLoading(elm);
            }
        });
    };

    window.Calendar = Calendar;

    function createElement(tagName, className, innerText) {
        var ele = document.createElement(tagName);
        if (className) {
            ele.className = className;
        }
        if (innerText) {
            ele.innderText = ele.textContent = innerText;
        }
        return ele;
    }
}();

!function () {
    jQuery('.fat-event-sc.calendar-widget').each(function () {
        var self = jQuery(this),
            events = self.attr('data-events'),
            id = self.attr('id'),
            now = self.attr('data-current'),
            month = self.attr('data-month');
        events = jQuery.parseJSON(events);
        for (var $i = 0; $i < events.length; $i++) {
            events[$i].date = moment(events[$i].date, "YYYY-MM-DD HH:mm");
        }
        if(typeof month!='undefined' && month!='' && !isNaN(month)){
            $fat_calendar_widget[id] = new Calendar('#' + jQuery(this).attr('id'), events, month);
        }else{
            $fat_calendar_widget[id] = new Calendar('#' + jQuery(this).attr('id'), events, now);
        }
    });
}();