"use strict";
var FatLoading = {};
(function ($) {
    FatLoading.showLoading = function ($el, $is_center_screen) {
        var $container = $('#' + $el.getAttribute('id')),
            spinner_type = $container.attr('data-spinner'),
            spinner = '';

        switch (spinner_type) {
            case 'atom': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="atom-spinner">\n' +
                    '        <div class="spinner-inner">\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <!--Chrome renders little circles malformed :(-->\n' +
                    '            <div class="spinner-circle">\n' +
                    '                &#9679;\n' +
                    '            </div>\n' +
                    '        </div>\n' +
                    '    </div></div></div>');
                break;
            }
            case 'finger': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="fingerprint-spinner">\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'flower': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="flower-spinner">\n' +
                    '  <div class="dots-container">\n' +
                    '    <div class="bigger-dot">\n' +
                    '      <div class="smaller-dot"></div>\n' +
                    '    </div>\n' +
                    '  </div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'half_circle': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="half-circle-spinner">\n' +
                    '  <div class="circle circle-1"></div>\n' +
                    '  <div class="circle circle-2"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'orbit': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="orbit-spinner">\n' +
                    '  <div class="orbit"></div>\n' +
                    '  <div class="orbit"></div>\n' +
                    '  <div class="orbit"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'self_building': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="self-building-square-spinner">\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square clear"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square clear"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'hollow_dots': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="hollow-dots-spinner" :style="spinnerStyle">\n' +
                    '  <div class="dot"></div>\n' +
                    '  <div class="dot"></div>\n' +
                    '  <div class="dot"></div>\n' +
                    '</div></div></div>');
                break;
            }
        }
        if (typeof $is_center_screen !== 'undefined' && $is_center_screen) {
            $container = $('body');
            $container.append(spinner);
            $('.epic-spinner-loading', $container).addClass('epic-center-screen');
        } else {
            $container.append(spinner);
        }
    };

    FatLoading.closeLoading = function ($el) {
        var $container = $('#' + $el.getAttribute('id'));
        $('.epic-spinner-loading', $container).remove();
        $('body .epic-spinner-loading').remove();
    };
})(jQuery);