"use strict";

function fat_event_single_map() {
    jQuery('document').ready(function () {
        jQuery('.fat-event-single .fat-event-location').each(function () {
            var map_wrap = jQuery(this),
                map = jQuery('.fat-google-map', map_wrap),
                latitudes = map_wrap.attr('data-latitude').split(';'),
                latitude_X = '',
                latitude_Y = '',
                map_type = 'roadmap',
                zoom = 15;
            if (map.length == 0 || typeof latitudes=='undefined') {
                return;
            }
            zoom = latitudes.length > 1 ? 12: zoom;
            if ( latitudes[0].split(',').length == 2) {
                latitude_X = latitudes[0].split(',')[0];
                latitude_Y = latitudes[0].split(',')[1];
                var mapCenter = new google.maps.LatLng(
                    latitude_X == '' ? 51.491676 : latitude_X,
                    latitude_Y == '' ? -0.167660 : latitude_Y
                );

                var google_map = new google.maps.Map(map[0], {
                    center: mapCenter,
                    zoom: zoom,
                    mapTypeId: map_type
                });

                google.maps.event.addDomListener(window, "resize", function () {
                    var center = google_map.getCenter();
                    google.maps.event.trigger(map, "resize");
                    google_map.setCenter(center);
                });

                for(var $i=0; $i< latitudes.length; $i++){
                    latitude_X = latitudes[$i].split(',')[0];
                    latitude_Y = latitudes[$i].split(',')[1];
                    if (latitude_X != '' && latitude_Y != '') {
                        new google.maps.Marker({
                            position: new google.maps.LatLng(latitude_X, latitude_Y),
                            draggable: false,
                            animation: google.maps.Animation.DROP,
                        }).setMap(google_map);
                    }
                }
            }

        })
    })
}

(function ($) {
    function fat_event_equal_height() {
        $('.fat-event-single.single-04 .fat-event-single-meta').each(function () {
            var max_height = 0,
                container = $(this);
            if ($(window).width() > 767) {
                $('.fat-event-meta:not(.exclude-height)', container).each(function () {
                    if ($('.fat-event-meta-wrap',this).height() > max_height) {
                        max_height =$('.fat-event-meta-wrap',this).height();
                    }
                });
                $('.fat-event-meta:not(.exclude-height)', container).css('height', max_height + 'px');
            } else {
                $('.fat-event-meta:not(.exclude-height)', container).css('height', 'auto');
            }
        })
    }

    $(document).ready(function () {
        $('.fat-event-location').each(function () {
            if (typeof mapboxgl != 'undefined') {
                var self = $(this),
                    elm_map = $('.fat-mapbox', self),
                    access_token = self.attr('data-access-token'),
                    latitudes = self.attr('data-latitude').split(';'),
                    latitude = '',
                    map,
                    options = {
                        container: elm_map.attr('id'),
                        style: 'mapbox://styles/mapbox/streets-v11',
                    };

                if(latitudes.length ==2){
                    latitude = latitudes[0].split(',');
                    if(latitudes.length==1){
                        options['center'] = [latitude[0], latitude[1]];
                        options['zoom'] = 15;
                    }else{
                        try{
                            var points=[];
                            for (var $i = 0; $i < latitudes.length; $i++) {
                                points.push(turf.point([ parseInt(latitudes[$i].split(',')[0]), parseInt(latitudes[$i].split(',')[1])] ));
                            }
                            var features = turf.featureCollection(points);
                            options['center'] = turf.center(features).geometry.coordinates;
                            options['zoom'] = 6.5;

                        }catch(err){console.log(err);}
                    }
                    mapboxgl.accessToken = access_token;
                    map = new mapboxgl.Map(options);
                    map.addControl(new mapboxgl.NavigationControl());
                    for (var $i = 0; $i < latitudes.length; $i++) {
                        latitude = latitudes[$i].split(',');
                        new mapboxgl.Marker({
                            draggable: false
                        }).setLngLat([latitude[0], latitude[1]]).addTo(map);
                    }
                }
            }
        });
        fat_event_equal_height();

        $('.fat-event-single').on('change',function(){
            setTimeout(function () {
                fat_event_equal_height();
            }, 300);
        })
    });


    $(window).on('load',function(){
        var map_lazy_load = $('.fat-event-location[data-lazy-load="1"]').length;
        if(map_lazy_load > 0){
            setTimeout(function(){
                fat_event_single_map();
            },1000)
        }
    });
    $(window).on('resize', function () {
        setTimeout(function () {
            fat_event_equal_height();
        }, 500);
    });

})(jQuery);