"use strict";
var FatEventRegister = {};
(function ($) {
    FatEventRegister.submit = function(container){
        var title = $('#title').val(),
            content = typeof tinymce!='undefined'  && typeof tinymce.activeEditor !='undefined' && tinymce.activeEditor !=null ? tinymce.activeEditor.getContent() : '',
            start_date = $('#start_date').val(),
            end_date = $('#end_date').val(),
            all_day_event = $('#all_day_event_1').is(':checked') ? $('#all_day_event_1').val() : '',
            hide_event_time = $('#hide_event_time_1').is(':checked') ? $('#hide_event_time_1').val() : '',
            hide_event_end_time = $('#hide_event_end_time_1').is(':checked') ? $('#hide_event_end_time_1').val() : '',
            event_repeating = $('#event_repeating_1').is(':checked') ? $('#event_repeating_1').val() : '',
            repeat = $('#repeat').val(),
            daily_interval = $('#daily_interval').val(),
            repeat_event_display = $('#repeat_event_display').val(),
            custom_day_repeat = [],
            multiple_location = $('#multiple_location').val(),
            hourly_schedule = [],
            location = $('#location').val(),
            main_organizer = $('#main_organizer').val(),
            other_organizer = $('select[name="other_organizer[]"]').val(),
            link_detail = $('#link_detail').val(),
            link_more_info = $('#link_more_info').val(),
            label_more_info = $('#label_more_info').val(),
            link_open_type = $('#link_open_type').val(),
            external_link_booking = $('#external_link_booking').val(),
            enable_booking = $('#enable_booking_1').is(':checked') ? $('#enable_booking_1').val() : '',
            enable_seat_available = $('#enable_seat_available_1').is(':checked') ? $('#enable_seat_available_1').val() : '',
            fees_type = $('#fees_type').val(),
            fees = $('#fees').val(),
            fees_package = [],
            ticket_class = [],
            seats = $('#seats').val(),
            payment = $('#payment').val(),
            media_type = $('#media_type_1').is(':checked') ? $('#media_type_1').val() : 'none',
            media_type = $('#media_type_2').is(':checked') ? $('#media_type_2').val() : media_type,
            media_type = $('#media_type_3').is(':checked') ? $('#media_type_3').val() : media_type,
            link_video = $('#link_video').val(),
            images = $('#images').val(),
            fat_mb_event_bg_image = $('#bg_images').val(),
            feature_image = $('#feature_image').val(),
            fat_mb_event_color = $('#color').val(),
            fat_mb_amenities = [],
            other_fields = {};


        var $repeat_on_date = [];
        $('input[id="custom_days_repeat_on_date"]').each(function(){
            if($(this).val()!=''){
                $repeat_on_date.push($(this).val());
            }
        });
        custom_day_repeat.push({repeat_on_date: $repeat_on_date});

        hourly_schedule.push({from: [], to: [], title: [], description: [], location: [], organizer: []});
        $('input[id="schedule_from"]').each(function(){
            hourly_schedule[0].from.push($(this).val());
        });

        $('input[id="schedule_to"]').each(function(){
            hourly_schedule[0].to.push($(this).val());

        });

        $('input[id="schedule_title"]').each(function(){
            hourly_schedule[0].title.push($(this).val());
        });

        $('input[id="schedule_description"]').each(function(){
            hourly_schedule[0].description.push($(this).val());
        });

        $('select[id="schedule_location"]').each(function(){
            hourly_schedule[0].location.push($(this).val());
        });

        $('select[id="schedule_organizer"]').each(function(){
            hourly_schedule[0].organizer.push($(this).val());
        });

        $('input[type="checkbox"]','.amenities-field').each(function(){
            if( $(this).is(':checked') ){
                fat_mb_amenities.push($(this).val())
            }
        });

        $('select').each(function(){
            var id = $(this).attr('id');
            id = id.replace('[','').replace(']','');
            if(id!='schedule_location' && id!='schedule_organizer' && id!='multiple_location' && id!='categories[]'
            && id!='link_open_type' ){
                other_fields[id] = typeof other_fields[id]!='undefined' ? other_fields[id] : [];
                other_fields[id].push($(this).val());
            }
        });

        if(fees_type=='package'){
            fees_package.push({quantity: [], fees: []});
            $('input[id="fees_package_quantity"]').each(function(){
                fees_package[0].quantity.push($(this).val());
            });
            $('input[id="fees_package_fees"]').each(function(){
                fees_package[0].fees.push($(this).val());
            });
        }else{
            fees_package = [];
        }

        if(fees_type=='ticket_class'){
            ticket_class.push({class: [], seats: [], fees: [], class_id: []});
            $('input[id="ticket_class_class"]').each(function(){
                ticket_class[0].class.push($(this).val());
            });
            $('input[id="ticket_class_seats"]').each(function(){
                ticket_class[0].seats.push($(this).val());
            });
            $('input[id="ticket_class_fees"]').each(function(){
                ticket_class[0].fees.push($(this).val());
            });
            $('input[id="ticket_class_class_id"]').each(function(){
                ticket_class[0].class_id.push($(this).val());
            });
        }else{
            ticket_class = [];
        }


        var $is_valid = true,
            scroll_to = '';
        if(title===''){
            $is_valid = false;
            $('#title').closest('.fat-cmb-field').append('<span class="error-message">' + fat_event_register_data.require_field + '</span>');
            $('#title').addClass('fat-error-field');
            scroll_to = $('#title');
        }
        if(start_date===''){
            $is_valid = false;
            $('#start_date').closest('.fat-cmb-field').append('<span class="error-message  has-description">' + fat_event_register_data.require_field + '</span>');
            $('#start_date').addClass('fat-error-field');
            if(scroll_to == ''){
                scroll_to = $('#start_date');
            }
        }
        if(end_date===''){
            $is_valid = false;
            $('#end_date').closest('.fat-cmb-field').append('<span class="error-message has-description">' + fat_event_register_data.require_field + '</span>');
            $('#end_date').addClass('fat-error-field');
            if(scroll_to == ''){
                scroll_to = $('#end_date');
            }
        }
        if(!$is_valid){
            $('html,body').stop(true, false).animate({
                scrollTop: (scroll_to.offset().top - 50)
            },500);
            return false;
        }
        var el = document.querySelector('.fat-event-register-container');
        FatLoading.showLoading(el, true);

        var fat_mb_event_detail = {
            start_date: start_date,
            end_date: end_date,
            all_day_event: [all_day_event],
            hide_event_time: [hide_event_time],
            hide_event_end_time: [hide_event_end_time],
            event_repeating: [event_repeating],
            repeat: repeat,
            daily_interval: daily_interval,
            repeat_event_display: repeat_event_display,
            custom_days: custom_day_repeat,
            multiple_location: multiple_location,
            schedule: hourly_schedule,
            location: location,
            main_organizer: main_organizer,
            other_organizer: other_organizer,
            link_detail: link_detail,
            link_more_info: link_more_info,
            label_more_info: label_more_info,
            link_open_type: link_open_type,
            enable_booking: [enable_booking],
            enable_seat_available: [enable_seat_available],
            fees_type: fees_type,
            fees_package: fees_package,
            ticket_class: ticket_class,
            fees: fees,
            seats: seats,
            payment: payment,
            external_link_booking: external_link_booking,
            media_type: media_type,
            link_video: link_video,
            images: images,
            other_fields: other_fields
        };

        $.ajax({
            url: fat_event_register_data.ajax_url,
            type: 'POST',
            data: ({
                action: 'fat_event_create',
                title: title,
                content: content,
                fat_mb_event_detail: fat_mb_event_detail,
                fat_mb_event_bg_image: fat_mb_event_bg_image,
                fat_mb_event_color: fat_mb_event_color,
                feature_image: feature_image,
                fat_mb_amenities: fat_mb_amenities,
                categories: $('select[name="categories[]"]').val(),
                tags: $('#tags').val(),
                recaptcha: ''//typeof grecaptcha !='undefined' ?  grecaptcha.getResponse() : ''
            }),
            success: function (data) {
                data = $.parseJSON(data);
                FatLoading.closeLoading(el);
                if(data.code >0){
                    if(data.notification=='popup'){
                        FatEventRegister.showPopupMessage(data.message, false);
                    }else{
                        if(data.page!=''){
                            window.location.href = data.page;
                        }
                    }
                }else{
                    if(data.code==-1){
                        $('.error-message','.g-recaptcha').remove();
                        $('.g-recaptcha').append($('<div class="error-message">' + data.message + '</div>'));
                    }
                }
            },
            error: function () {
                FatLoading.closeLoading(el);
            }
        });
    };

    FatEventRegister.showPopupMessage = function ($message, $reload) {
        var popup = $('<div class="fat-event-popup-modal"><div class="fat-event-popup-message"><a class="fat-close-popup"><i class="fa fa-times-circle"></i></a><div class="fat-event-message fe-message">' + $message + '</div></div></div>');
        $('body .fat-event-popup-modal').remove();
        $('body').append(popup);
        $('a.fat-close-popup', '.fat-event-popup-modal').on('click', function () {
            $('body .fat-event-popup-modal').remove();
            if($reload){
                window.location.reload();
            }
        })
    };

    $(document).ready(function () {
        $('.fat-event-register-container a.fat-event-register-submit').off('click').on('click',function(event){
            event.preventDefault();
            var container = $(this).closest('.fat-event-register-container');
            FatEventRegister.submit(container);
            return false;
        });

        $('input#title, input#start_date, input#end_date').focus(function(){
            var field = $(this).closest('.fat-cmb-field');
            $(this).removeClass('fat-error-field');
            $('.error-message',field).remove();
        });
    });
})(jQuery);