"use strict";
function Fat_Event_Custom_Marker(latlng, map, args) {
    this.latlng = latlng;
    this.args = args;
    this.setMap(map);
}
Fat_Event_Custom_Marker.prototype = new google.maps.OverlayView();
Fat_Event_Custom_Marker.prototype.draw = function() {
    var self = this;
    var div = this.div;
    if (!div) {
        div = this.div = document.createElement('div');
        div.className = 'fat-event-marker';

        var div_inner = document.createElement('div');
        div_inner.className = 'fat-event-marker-inner';
        div_inner.innerHTML = '<span class="fat-event-number">' + self.args.events + '</span>';
        div.appendChild(div_inner);


        if (typeof(self.args.marker_id) !== 'undefined') {
            div.dataset.marker_id = self.args.marker_id;
        }

        if(typeof self.args.marker_color != 'undefined' && self.args.marker_color!=''){
            div_inner.style.background = self.args.marker_color;
        }

        google.maps.event.addDomListener(div, "click", function(event) {
            google.maps.event.trigger(self, "click");
        });

        var panes = this.getPanes();
        panes.overlayImage.appendChild(div);
    }

    var point = this.getProjection().fromLatLngToDivPixel(this.latlng);

    if (point) {
        div.style.left = (point.x - 25) + 'px';
        div.style.top = (point.y - 30) + 'px';
    }
};
Fat_Event_Custom_Marker.prototype.remove = function() {
    if (this.div) {
        this.div.parentNode.removeChild(this.div);
        this.div = null;
    }
};
Fat_Event_Custom_Marker.prototype.getPosition = function() {
    return this.latlng;
};