"use strict";
function fat_event_google_map_callback() {
    jQuery(document).ready(function () {
        var mapStyle = [];

        mapStyle['roadmap_black'] = new google.maps.StyledMapType([
            {
                "featureType": "all",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "saturation": 36
                    },
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 40
                    }
                ]
            },
            {
                "featureType": "all",
                "elementType": "labels.text.stroke",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "featureType": "all",
                "elementType": "labels.icon",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 17
                    },
                    {
                        "weight": 1.2
                    }
                ]
            },
            {
                "featureType": "landscape",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 21
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 17
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 29
                    },
                    {
                        "weight": 0.2
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 18
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "featureType": "transit",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 19
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#000000"
                    },
                    {
                        "lightness": 17
                    }
                ]
            }
        ], {name: 'Map Black'});

        mapStyle['roadmap_gray'] = new google.maps.StyledMapType([
            {
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ebe8e0"
                    }
                ]
            },
            {
                "elementType": "labels.icon",
                "stylers": [
                    {
                        "visibility": "off",
                    }
                ]
            },
            {
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#616161"
                    }
                ]
            },
            {
                "elementType": "labels.text.stroke",
                "stylers": [
                    {
                        "color": "#ebe8e0"
                    }
                ]
            },
            {
                "featureType": "administrative.land_parcel",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#bdbdbd"
                    }
                ]
            },
            {
                featureType: 'landscape.natural',
                elementType: 'all',
                stylers: [
                    { color: '#f4f4f4' }

                ]
            },
            {
                "featureType": "poi",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#eeeeee"
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#757575"
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#f4f4f4"
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#9e9e9e"
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#757575"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#dadada"
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#616161"
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#f4f4f4"
                    }
                ]
            },
            {
                "featureType": "transit.line",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ebe8e0"
                    }
                ]
            },
            {
                "featureType": "transit.station",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#99b3cc"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#99b3cc"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "color": "#9e9e9e"
                    }
                ]
            }
        ], {name: 'Map Gray'});

        jQuery('.fat-event-google-map-container').each(function () {
            var $container = jQuery(this),
                $this = jQuery('.fat-event-google-map', $container),
                $lat = jQuery('.lk-google-map-marker-info:first-child',$container).attr('data-latitude'),
                $lat_x = $lat.split(',')[0],
                $lat_y = $lat.split(',').length>1 ? $lat.split(',')[1] : '',
                $zoom = $this.attr('data-zoom'),
                $marker = true,
                search = jQuery('input.search-box', $container),
                $marker_info_show_default = $this.attr('data-enable-marker-info')=='1',
                $map_type = $this.attr('data-map-type'); //satellite, roadmap, hybrid, terrain


            $zoom = typeof $zoom != 'undefined' ? $zoom : 10;
            $map_type = typeof $map_type != 'undefined' ? $map_type : 'ROADMAP';

            search = search[0];


            if (typeof  $lat_x != 'undefined' && typeof $lat_y != 'undefined') {
                var map = null,
                    mapCenter = new google.maps.LatLng($lat_x, $lat_y),
                    options = {
                        center: mapCenter,
                        zoom: parseInt($zoom, 10),
                        type: $map_type,
                        disableDefaultUI: true,
                        mapTypeControlOptions: {
                            mapTypeIds: ['roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map']
                        }
                    };

                map = new google.maps.Map($this[0], options);



                if ($marker) {
                    jQuery('.fat-event-google-map-marker .lk-google-map-marker-info', $container).each(function () {
                        var $lat = jQuery(this).attr('data-latitude'),
                            $marker_coords_x = $lat.split(',')[0],
                            $marker_coords_y = $lat.split(',').length>1 ? $lat.split(',')[1] : '';

                        var map_marker = new Fat_Event_Custom_Marker(
                            new google.maps.LatLng($marker_coords_x, $marker_coords_y),
                            map,
                            {
                                marker_id: Math.floor((Math.random() * 100) + 1),
                                events: jQuery(this).attr('data-events'),
                                marker_color:  $this.attr('data-marker-color')
                            }
                        );

                        map_marker.setMap(map);
                        var marker_info = new google.maps.InfoWindow({
                            content: jQuery(this).html(),
                            coords: [$marker_coords_x, $marker_coords_y]
                        });
                        google.maps.event.addListener(map_marker, 'click', function () {
                            marker_info.open(map, map_marker);
                            setTimeout(function(){
                                FatEvent.initPopupDetail();
                            },800);

                        });
                        if ($marker_info_show_default) {
                            marker_info.open(map, map_marker);
                        }

                        google.maps.event.addDomListener(window, "resize", function() {
                            var center = map.getCenter();
                            google.maps.event.trigger(map, "resize");
                            map.setCenter(center);
                        });

                    });
                }
                if($map_type=='roadmap_black' || $map_type=='roadmap_gray'){
                    map.mapTypes.set('styled_map', mapStyle[$map_type]);
                    map.setMapTypeId('styled_map');
                }

                /** init search box */
                var markers = [];
                var searchBox = new google.maps.places.SearchBox(search);
                map.controls[google.maps.ControlPosition.TOP_LEFT].push(search);
                map.addListener('bounds_changed', function() {
                    searchBox.setBounds(map.getBounds());
                });

                // Listen for the event fired when the user selects a prediction and retrieve
                // more details for that place.
                searchBox.addListener('places_changed', function() {
                    var places = searchBox.getPlaces();

                    if (places.length == 0) {
                        return;
                    }

                    // Clear out the old markers.
                    markers.forEach(function(marker) {
                        marker.setMap(null);
                    });
                    markers = [];

                    // For each place, get the icon, name and location.
                    var bounds = new google.maps.LatLngBounds();
                    places.forEach(function(place) {
                        if (!place.geometry) {
                            return;
                        }
                        var icon = {
                            size: new google.maps.Size(71, 71),
                            origin: new google.maps.Point(0, 0),
                            anchor: new google.maps.Point(17, 34),
                            scaledSize: new google.maps.Size(25, 25)
                        };

                        // Create a marker for each place.
                        var new_marker = new google.maps.Marker({
                            map: map,
                            icon: icon,
                            title: place.name,
                            draggable:true,
                            animation: google.maps.Animation.DROP,
                            position: place.geometry.location
                        });
                        markers.push(new_marker);

                        if (place.geometry.viewport) {
                            // Only geocodes have viewport.
                            bounds.union(place.geometry.viewport);
                        } else {
                            bounds.extend(place.geometry.location);
                        }
                    });
                    map.fitBounds(bounds);
                });

            } else {
                jQuery(this).append('Please set map coordinates !');
            }
        });
    })
}

(function ($) {
    $(document).ready(function () {
        $('.fat-event-mapbox-container .fat-event-mapbox').each(function(){
            if(typeof mapboxgl !='undefined'){
                var elm_map = $(this),
                    container = elm_map.closest('.fat-event-mapbox-container'),
                    access_token = elm_map.attr('data-access-token'),
                    latitude_x,
                    latitude_y,
                    zoom = typeof elm_map.attr('data-zoom')!='undefined' && elm_map.attr('data-zoom') ? elm_map.attr('data-zoom') : 15,
                    marker_color = elm_map.attr('data-marker-color');

                //create icon
                var size = 250;
                var pulsingDot = {
                    width: size,
                    height: size,
                    data: new Uint8Array(size * size * 4),

                    onAdd: function() {
                        var canvas = document.createElement('canvas');
                        canvas.width = this.width;
                        canvas.height = this.height;
                        this.context = canvas.getContext('2d');
                    },

                    render: function() {
                        var duration = 1000;
                        var t = (performance.now() % duration) / duration;

                        var radius = size / 2 * 0.3;
                        var outerRadius = size / 2 * 0.7 * t + radius;
                        var context = this.context;

                        // draw outer circle
                        context.clearRect(0, 0, this.width, this.height);
                        context.beginPath();
                        context.arc(this.width / 2, this.height / 2, outerRadius, 0, Math.PI * 2);
                        context.fillStyle = 'rgba(255, 255, 255,' + (1 - t) + ')';
                        context.fill();

                        // draw inner circle
                        context.beginPath();
                        context.arc(this.width / 2, this.height / 2, radius, 0, Math.PI * 2);
                        context.fillStyle = marker_color;//'rgba(255, 100, 100, 1)';
                        context.strokeStyle = 'white';
                        context.lineWidth = 2 + 4 * (1 - t);
                        context.fill();
                        context.stroke();

                        // update this image's data with data from the canvas
                        this.data = context.getImageData(0, 0, this.width, this.height).data;


                        // keep the map repainting
                        map.triggerRepaint();

                        // return `true` to let the map know that the image was updated
                        return true;
                    }
                };

                //features
                var features = [],
                    self,
                    latitude,
                    event_count;
                $('.fat-event-mapbox-marker .lk-google-map-marker-info',container).each(function(){
                    var self = $(this),
                        latitude = self.attr('data-latitude').split(','),
                        event_count = self.attr('data-events');

                    latitude_x = latitude[0];
                    latitude_y = latitude[1];

                    features.push({
                        "type": "Feature",
                        "geometry": {
                            "type": "Point",
                            "coordinates": [latitude[0], latitude[1]]
                        },
                        "properties": {
                            "title": event_count,
                            "description": self.html(),
                            "icon": "pulsing-dot"
                        }
                    })
                });

                mapboxgl.accessToken = access_token;
                var map = new mapboxgl.Map({
                    container: elm_map.attr('id'),
                    style: 'mapbox://styles/mapbox/streets-v11',
                    center: [latitude_x,latitude_y],
                    zoom: zoom
                });

                map.addControl(new MapboxGeocoder({
                    accessToken: mapboxgl.accessToken,
                    mapboxgl: mapboxgl,
                    marker: false
                }));

                map.addControl(new mapboxgl.NavigationControl());

                //add icon to map
                map.addImage('pulsing-dot', pulsingDot, { pixelRatio: 2 });
                map.on('load', function () {
                    map.addLayer({
                        "id": "points",
                        "type": "symbol",
                        "source": {
                            "type": "geojson",
                            "data": {
                                "type": "FeatureCollection",
                                "features": features
                            }
                        },
                        "layout": {
                            "icon-image": "pulsing-dot",
                            "text-field": "{title}",
                            "text-offset": [0, -0.6],
                            "text-anchor": "top"
                        }
                    });
                });

                // When a click event occurs on a feature in the places layer, open a popup at the
                // location of the feature, with description HTML from its properties.
                map.on('click', 'points', function (e) {
                    var coordinates = e.features[0].geometry.coordinates.slice();
                    var description = e.features[0].properties.description;

                    // Ensure that if the map is zoomed out such that multiple
                    // copies of the feature are visible, the popup appears
                    // over the copy being pointed to.
                    while (Math.abs(e.lngLat.lng - coordinates[0]) > 180) {
                        coordinates[0] += e.lngLat.lng > coordinates[0] ? 360 : -360;
                    }

                    new mapboxgl.Popup()
                        .setLngLat(coordinates)
                        .setHTML(description)
                        .addTo(map);

                    //init popup detail
                    $('.fat-event-mapbox-container.fat-event-sc a[data-open-type="popup_modal"]').off('click').on('click', function (event) {
                        event.preventDefault();
                        var self = $(this),
                            container = self.closest('.fat-event-mapbox-container'),
                            event_id = self.attr('data-event-id'),
                            time = self.attr('data-time'),
                            single_time = self.attr('data-single-time'),
                            start_date = self.attr('data-s'),
                            end_date = self.attr('data-e');

                        FatEvent.showLoading(container, true);
                        $.ajax({
                            url: fat_event_ajax.ajaxurl,
                            type: 'GET',
                            data: ({
                                action: 'fat_event_get_event_detail',
                                id: event_id,
                                s_date: start_date,
                                e_date: end_date
                            }),
                            success: function (data) {
                                data = $.parseJSON(data);
                                data.time = single_time;
                                data.start_date = start_date;
                                data.end_date = end_date;

                                FatEvent.showPopupDetail(data);
                                FatEvent.closeLoading(container);
                                FatEvent.isProcess = 0;

                            },
                            error: function () {
                                FatEvent.closeLoading(container);
                                FatEvent.isProcess = 0;
                            }
                        });

                        return false;
                    })
                });

                // Change the cursor to a pointer when the mouse is over the places layer.
                map.on('mouseenter', 'points', function (e) {
                    map.getCanvas().style.cursor = 'pointer';
                });

                // Change it back to a pointer when it leaves.
                map.on('mouseleave', 'points', function () {
                    map.getCanvas().style.cursor = '';
                });



            }
        });
    });
})(jQuery);