/**
 * Number.prototype.format(n, x, s)
 *
 * @param integer n: length of decimal
 * @param integer x: length of sections
 * @param string s:  separator
 */
Number.prototype.format = function (n, x, s) {
    var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
    return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&' + s);
};

"use strict";
var FatEvent = {};
(function ($) {
    FatEvent.init = function () {
        FatEvent.initIsotope();
        FatEvent.initPopupGallery();
        FatEvent.initFilter();
        FatEvent.initPaging();
        FatEvent.initCountdown();
        FatEvent.initTimetable();
        FatEvent.removeAutotop();
        FatEvent.initPopupDetail();
        FatEvent.initPopupShare();
        FatEvent.initPopupBooking();
        FatEvent.initTab();

        $('.fat-event-sc.event-slide').each(function () {
            FatEvent.initCarousel($(this));
        });

        $('.fat-event-sc:not(.event-masonry)').each(function () {
            var container = $(this).closest('.fat-event-container');
            if (container.hasClass('has-animation')) {
                FatEvent.initAppearScroll(container);
            }
        });

        if ($('body').hasClass('single-fat-event')) {
            FatEvent.initPopupBooking();
        }

        if ($.isFunction($.fn.fat_datetimepicker)) {
            $('.fat-event-date').each(function () {
                var locale = $(this).attr('data-locale');
                if (typeof locale != 'undefined' && locale != '') {
                    $.datetimepicker.setLocale(locale);
                }
                $(this).fat_datetimepicker({
                    datepicker: true,
                    timepicker: false,
                    format: 'Y/m/d'
                });
            })
        }
    };

    FatEvent.removeAutotop = function () {
        $('section.cd-container > p', '.fat-maika-sc.event-timeline').remove();
    };

    FatEvent.initIsotope = function () {
        if ($.isFunction($.fn.isotope)) {
            $('.fat-event-sc.event-masonry').each(function () {
                var sc = $(this),
                    container = $(this).closest('.fat-event-container'),
                    col_width = '.fat-col-md-' + sc.attr('data-event-col');

                if (sc.data('isotope')) {
                    sc.isotope('destroy');
                }
                container.on('arrangeComplete', function () {
                    try {
                        if (sc.data('isotope')) {
                            sc.isotope('layout');
                        }
                    } catch (ex) {
                    }
                    if ($(container).hasClass('has-animation')) {
                        FatEvent.initAppearScroll($(container));
                    }
                });
                var $iso = sc.isotope({
                    itemSelector: '.fat-event-item',
                    masonry: {
                        columnWidth: col_width
                    },
                    percentPosition: true,
                    hiddenStyle: {
                        opacity: 0,
                        transform: 'translate3d(0, 100px, 0)'
                    },
                    visibleStyle: {
                        opacity: 1,
                        transform: 'translate3d(0, 0, 0)'
                    },
                    transitionDuration: '0.6s'
                });
                var $i = 0, $time_out = 0;
                $iso.imagesLoaded().progress(function () {
                    $i++;
                    $time_out = $i * 150;
                    try {
                        setTimeout(function () {
                            $iso.isotope('layout');
                        }, $time_out);

                    } catch (ex) {
                    }
                });
            })
        }
    };

    FatEvent.initCarousel = function ($sc) {
        if ($.isFunction($.fn.owlCarousel)) {
            $sc.trigger('destroy.owl.carousel');
            $sc.each(function () {
                var $owl = $(this),
                    defaults = {
                        items: 4,
                        nav: false,
                        navText: ['<i class="fa fa-angle-left"></i> ', ' <i class="fa fa-angle-right"></i>'],
                        dots: false,
                        loop: true,
                        center: false,
                        mouseDrag: true,
                        touchDrag: true,
                        pullDrag: true,
                        freeDrag: false,
                        margin: 0,
                        stagePadding: 0,
                        merge: false,
                        mergeFit: true,
                        autoWidth: false,
                        startPosition: 0,
                        rtl: false,
                        smartSpeed: 250,
                        autoplay: false,
                        autoplayTimeout: 0,
                        fluidSpeed: false,
                        dragEndSpeed: false,
                        autoplayHoverPause: true
                    };
                var config = $.extend({}, defaults, $owl.data("owl-options"));
                // Initialize Slider
                $($owl).imagesLoaded(function () {
                    $owl.owlCarousel(config);

                    var container = $sc.closest('.fat-event-container');
                    if (container.hasClass('has-animation')) {
                        FatEvent.initAppearScroll(container);
                    }
                });
            });
        } else {
            FatEvent.showNotified('Owl Carousel library not found. Please do not check "Unload Owl-Carousel" in Fat Event -> Settings', 8000);
        }
    };

    FatEvent.initTimetable = function () {
        $('.fat-event-container.event-timetable').each(function () {
            if ($.isFunction($.fn.fullCalendar)) {
                var self = $(this),
                    events = self.attr('data-events'),
                    defaul_date = self.attr('data-default-date'),
                    view = self.attr('data-view'),
                    list_day_label = self.attr('data-list-day'),
                    list_week_label = self.attr('data-list-week'),
                    list_month_label = self.attr('data-list-month'),
                    locale = self.attr('data-locale'),
                    single_time_format = self.attr('data-single-time-format');

                single_time_format = single_time_format === 'h:ia' ? 'hh:mm a' : single_time_format;
                single_time_format = single_time_format === 'H:i' ? 'HH:mm' : single_time_format;
                single_time_format = single_time_format === 'h:iA' ? 'hh:mm A' : single_time_format;

                locale = typeof locale != 'undefined' || locale == '' ? locale : 'en';

                events = $.parseJSON(events);
                var opt_calendar = {
                    header: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'listDay,listWeek,month'
                    },
                    // customize the button names,
                    // otherwise they'd all just say "list",
                    locale: locale,
                    defaultView: view,
                    defaultDate: defaul_date,
                    navLinks: true, // can click day/week names to navigate views
                    editable: false,
                    eventLimit: true, // allow "more" link when too many events
                    events: events,
                    timeFormat: single_time_format,
                    eventClick: function (eventObj) {
                        if (eventObj.is_day_off == 1) {
                            return;
                        }
                        if (eventObj.url && eventObj.open_type == 'current_window') {
                            window.location.href = eventObj.url + '?sd=' + eventObj.start.format('X') + '&ed=' + eventObj.end.format('X');
                            return false;
                        }
                        if (eventObj.url && eventObj.open_type == 'single_window') {
                            window.open(eventObj.url + '?sd=' + eventObj.start.format('X') + '&ed=' + eventObj.end.format('X'));
                            return false;
                        } else {
                            if (typeof FatEvent.isProcess === 'undefined' || FatEvent.isProcess == 0) {
                                FatEvent.isProcess = 1;
                                FatEvent.showLoading(self, true);
                                $.ajax({
                                    url: fat_event_ajax.ajaxurl,
                                    type: 'GET',
                                    data: ({
                                        action: 'fat_event_get_event_detail',
                                        id: eventObj.id,
                                        s_date: eventObj.start.format('X'),
                                        e_date: eventObj.end != null ? eventObj.end.format('X') : null
                                    }),
                                    success: function (data) {
                                        data = $.parseJSON(data);
                                        if (typeof eventObj.time != 'undefined' && eventObj.time != null && eventObj.time != 'undefined' && eventObj.time != '') {
                                            data.time = eventObj.time;
                                        } else {
                                            if (typeof eventObj.end !== 'undefined' && eventObj.end != null) {
                                                if (eventObj.start.format('L') === eventObj.end.format('L')) {
                                                    data.time = eventObj.start.format(single_time_format) + ' - ' + eventObj.end.format(single_time_format) + ', ' + eventObj.start.format('MMM DD YYYY');
                                                } else {
                                                    data.time = eventObj.start.format(single_time_format + ' MMM DD YYYY') + ' - ' + eventObj.end.format(single_time_format + ' MMM DD YYYY');
                                                }
                                            } else {
                                                data.time = eventObj.start.format(single_time_format + ' MMM DD YYYY');
                                            }
                                        }
                                        data.start_date = eventObj.start.format('X');
                                        data.end_date = eventObj.end != null ? eventObj.end.format('X') : '';
                                        FatEvent.showPopupDetail(data);
                                        if (typeof data.thumb == 'undefined' || data.thumb == '') {
                                            $('.fat-event-popup-single').addClass('no-thumb');
                                            $('.fat-event-popup-single .fat-event-popup-thumb img').hide();
                                        }
                                        FatEvent.closeLoading(self);
                                        FatEvent.isProcess = 0;
                                    },
                                    error: function () {
                                        FatEvent.closeLoading(self);
                                        FatEvent.isProcess = 0;
                                    }
                                });
                                return false;
                            }
                        }
                        return false;
                    },
                    viewRender: function (view, element) {
                        $('.fc-next-button, .fc-prev-button', self).on('click', function () {
                            if (typeof FatEvent.isProcess === 'undefined' || FatEvent.isProcess == 0) {
                                FatEvent.isProcess = 1;
                                var date = self.fullCalendar('getDate'),
                                    button_state = $('.fc-button-group .fc-button.fc-state-active', self),
                                    month = date.format('M');

                                switch (month) {
                                    case '1': {
                                        month = 'Jan';
                                        break;
                                    }
                                    case '2': {
                                        month = 'Feb';
                                        break;
                                    }
                                    case '3': {
                                        month = 'Mar';
                                        break;
                                    }
                                    case '4': {
                                        month = 'Apr';
                                        break;
                                    }
                                    case '5': {
                                        month = 'May';
                                        break;
                                    }
                                    case '6': {
                                        month = 'Jun';
                                        break;
                                    }
                                    case '7': {
                                        month = 'Jul';
                                        break;
                                    }
                                    case '8': {
                                        month = 'Aug';
                                        break;
                                    }
                                    case '9': {
                                        month = 'Sep';
                                        break;
                                    }
                                    case '10': {
                                        month = 'Oct';
                                        break;
                                    }
                                    case '11': {
                                        month = 'Nov';
                                        break;
                                    }
                                    case '12': {
                                        month = 'Dec';
                                        break;
                                    }
                                }
                                view = button_state.hasClass('fc-listDay-button') ? 'day' : view;
                                view = button_state.hasClass('fc-listWeek-button') ? 'listWeek' : view;
                                view = button_state.hasClass('fc-month-button') ? 'listDay' : view;

                                FatEvent.showLoading(self);

                                $.ajax({
                                    url: fat_event_ajax.ajaxurl,
                                    type: 'GET',
                                    data: ({
                                        action: 'fat_event_get_timetable',
                                        sc_id: self.attr('data-sc-id'),
                                        sc_category: self.attr('data-sc-cat'),
                                        sc_organizer: self.attr('data-sc-organizer'),
                                        month: month,
                                        year: date.format('Y'),
                                        view: view
                                    }),
                                    success: function (data) {
                                        data = $.parseJSON(data);
                                        self.fullCalendar('removeEvents');
                                        self.fullCalendar('addEventSource', data);
                                        self.fullCalendar('rerenderEvents');
                                        FatEvent.closeLoading(self);
                                        FatEvent.isProcess = 0;

                                    },
                                    error: function () {
                                        FatEvent.closeLoading(self);
                                        FatEvent.isProcess = 0;
                                    }
                                });
                            }
                        });
                    },
                };
                opt_calendar['views'] = {};
                if (typeof list_day_label != 'undefined' && list_day_label != '') {
                    opt_calendar['views']['listDay'] = {buttonText: list_day_label};
                }
                if (typeof list_week_label != 'undefined' && list_week_label != '') {
                    opt_calendar['views']['listWeek'] = {buttonText: list_week_label};
                }
                if (typeof list_month_label != 'undefined' && list_month_label != '') {
                    opt_calendar['views']['month'] = {buttonText: list_month_label};
                }
                self.fullCalendar(opt_calendar);
            }
        })
    };

    FatEvent.initPopupGallery = function () {
        if ($.isFunction($.fn.lightGallery)) {
            $('a.fat-event-view-video').off('click').on('click', function () {
                var self = $(this),
                    galleries = [];

                galleries.push({
                    'src': self.attr('data-video'),
                    'subHtml': '<h4>' + self.attr('data-title') + '</h4>',
                    'w': 900,
                    'h': 600
                });

                self.lightGallery({
                    downloadUrl: false,
                    download: false,
                    share: false,
                    dynamic: true,
                    dynamicEl: galleries,
                    hash: false,
                }).on('onAfterOpen.lg', function (event, index) {
                    $('.lg-thumb-outer').css('opacity', '0');
                    setTimeout(function () {
                        $('.lg-has-thumb').removeClass('lg-thumb-open');
                        $('.lg-thumb-outer').css('opacity', '1');
                    }, 700);
                });
            });

            $('a.fat-event-view-gallery').off('click').on('click', function () {
                var self = $(this),
                    container = self.closest('.fat-event-container'),
                    id = self.attr('data-event-id');

                FatEvent.showLoading(container, true);
                $.ajax({
                    url: fat_event_ajax.ajaxurl,
                    type: 'GET',
                    data: ({
                        action: 'fat_event_get_gallery',
                        id: id
                    }),
                    success: function (data) {
                        FatEvent.closeLoading(container);
                        self.lightGallery({
                            downloadUrl: false,
                            download: false,
                            share: false,
                            dynamic: true,
                            dynamicEl: JSON.parse(data),
                            hash: false,
                        }).on('onAfterOpen.lg', function (event, index) {
                            $('.lg-thumb-outer').css('opacity', '0');
                            setTimeout(function () {
                                $('.lg-has-thumb').removeClass('lg-thumb-open');
                                $('.lg-thumb-outer').css('opacity', '1');
                            }, 700);
                        });
                    },
                    error: function () {
                        FatEvent.closeLoading(container);
                    }
                });

            });
        }
    };

    FatEvent.initFilter = function () {

        setTimeout(function () {
            $('#fat-event-filter-location').val(0);
            $('#fat-event-filter-organizer').val(0);
            $('#fat-event-filter-category').val(0);
        }, 500);

        $('.fat-event-filter-container select, .fat-event-filter-container input').on('change', function (event) {
            var self = $(this),
                container = self.closest('.fat-event-container');

            $('.fat-event-sc', container).css('opacity', 0);
            FatEvent.showLoading(container);

            $.ajax({
                url: fat_event_ajax.ajaxurl,
                type: 'GET',
                data: ({
                    action: 'fat_event_filter',
                    sc_id: container.attr('data-sc-id'),
                    date: typeof $('#fat-event-date', container).val() != 'undefined' ? $('#fat-event-date', container).val() : '',
                    name: $('#fat-event-filter-name', container).val(),
                    tag: $('#fat-event-filter-tag').val(),
                    category: $('#fat-event-filter-category', container).val(),
                    location: $('#fat-event-filter-location', container).val(),
                    organizer: $('#fat-event-filter-organizer', container).val(),
                    current_page: 1,
                    layout: container.attr('data-layout')
                }),
                success: function (data) {
                    FatEvent.closeLoading(container);
                    if (container.attr('data-layout') == 'table') {
                        FatEvent.bindTableItem(container, data);
                    } else {
                        FatEvent.bindItem(container, data);
                    }
                },
                error: function () {
                    FatEvent.closeLoading(container);
                    $('.fat-event-sc', container).css('opacity', 1);
                }
            });
        });

        $('.fat-event-filter-container ul.fat-event-filter a').off('click').on('click', function (event) {
            event.preventDefault();
            var container = $(this).closest('.fat-event-container'),
                ul = $(this).closest('.fat-event-filter');

            $('.fat-event-sc', container).css('opacity', 0);
            FatEvent.showLoading(container);

            $('a.active', ul).removeClass('active');
            $(this).addClass('active');

            $.ajax({
                url: fat_event_ajax.ajaxurl,
                type: 'GET',
                data: ({
                    action: 'fat_event_filter',
                    sc_id: container.attr('data-sc-id'),
                    date: typeof $('#fat-event-date', container).val() != 'undefined' ? $('#fat-event-date', container).val() : '',
                    name: '',
                    tag: '',
                    category: $('a.fat-event-filter-category.active', container).attr('data-value'),
                    location: $('a.fat-event-filter-location.active', container).attr('data-value'),
                    organizer: $('a.fat-event-filter-organizer.active', container).attr('data-value'),
                    current_page: 1,
                    layout: container.attr('data-layout')
                }),
                success: function (data) {
                    FatEvent.closeLoading(container);
                    if (container.attr('data-layout') == 'table') {
                        FatEvent.bindTableItem(container, data);
                    } else {
                        FatEvent.bindItem(container, data);
                    }

                },
                error: function () {
                    FatEvent.closeLoading(container);
                    $('.fat-event-sc', container).css('opacity', 1);
                }
            });

            return false;
        })
    };

    FatEvent.initCountdown = function () {
        $('.fat-event-sc.event-countdown .fat-event-cd-inner').each(function () {
            if ($.isFunction($.fn.countdown)) {
                var event_cd = $(this),
                    container = $(this).closest('.fat-event-sc'),
                    start_date = event_cd.attr('data-start');

                if (typeof start_date !== 'undefined' && start_date !== '') {
                    event_cd.countdown(start_date, function (event) {
                        FatEvent.countdown_callback(event, event_cd);
                    }).on('update.countdown', function (event) {
                        FatEvent.countdown_callback(event, event_cd);
                    }).on('finish.countdown', function (event) {
                        $('.countdown-seconds', event_cd).html('00');
                    });
                }
            } else {
                FatEvent.showNotified('Countdown library not found.', 8000);
            }
        });
    };

    FatEvent.countdown_callback = function (event, event_cd) {
        var seconds = parseInt(event.offset.seconds),
            minutes = parseInt(event.offset.minutes),
            hours = parseInt(event.offset.hours),
            days = parseInt(event.offset.totalDays);

        seconds = seconds > 9 ? seconds : '0' + seconds;
        minutes = minutes > 9 ? minutes : '0' + minutes;
        hours = hours > 9 ? hours : '0' + hours;
        days = days > 9 ? days : '0' + days;

        if ($('.fat-event-cd-second', event_cd).length > 0) {
            $('.fat-event-cd-second', event_cd).html(seconds);
        }
        if ($('.fat-event-cd-minute', event_cd).length > 0) {
            $('.fat-event-cd-minute', event_cd).html(minutes);
        }
        if ($('.fat-event-cd-hour', event_cd).length > 0) {
            $('.fat-event-cd-hour', event_cd).html(hours);
        }
        if ($('.fat-event-cd-day', event_cd).length > 0) {
            $('.fat-event-cd-day', event_cd).html(days);
        }

    };

    FatEvent.bindItem = function (container, data, is_append) {
        var sc = $('.fat-event-sc', container),
            items = $('.fat-event-item', data),
            paging = $('.fat-paging-navigation-wrap', data),
            a_paging = $('.fat-paging-navigation-wrap a', container),
            is_load_more = a_paging.hasClass('fat-event-load-more'),
            last_item = $('.fat-event-item:last-child', container);

        var $offset = is_load_more ? $('.fat-paging-navigation-wrap', container).offset().top : container.closest('.fat-event-container').offset().top;

        $('.fat-paging-navigation-wrap', container).remove();
        if (typeof is_append == 'undefined' || is_append == 0) {
            if (sc.data('isotope')) {
                $(sc).isotope('destroy');
            }
            $(sc).empty();
        }

        $(sc).css('opacity', 1);
        $(sc).append(items);

        if (sc.hasClass('event-slide')) {
            FatEvent.initCarousel(sc);
        }
        if (sc.hasClass('event-masonry')) {

            if (is_load_more) {
                $('html,body').animate({
                    scrollTop: ($offset - 150)
                }, 300);
            } else {
                //for header Avada
                $offset -= $('header').hasClass('fusion-is-sticky') ? $('header div.fusion-header').height() : 0;
                $offset -= $('#wpadminbar').length > 0 ? $('#wpadminbar').height() : 0;
                $('html,body').animate({
                    scrollTop: $offset
                }, 300);
            }

            FatEvent.initIsotope();
            FatEvent.initPopupGallery();
        } else {
            $('.fat-event-sc:not(.event-masonry)').each(function () {
                var container = $(this).closest('.fat-event-container');
                if (container.hasClass('has-animation')) {
                    FatEvent.initAppearScroll(container);
                }
            })
        }
        if (paging.length > 0) {
            $(container).append(paging);
            FatEvent.initPaging();
        }


        FatEvent.initPopupDetail();
    };

    FatEvent.bindTableItem = function (container, data) {
        $('table tbody tr', container).remove();
        $('table tbody', container).append($('tbody tr', data));
        $('.fat-event-sc', container).css('opacity', 1);
        FatEvent.initPopupDetail();
    };

    FatEvent.initPaging = function () {
        $('a.page-numbers, .fat-paging-navigation-wrap a.fat-event-load-more, .fat-paging-navigation-wrap a.fat-event-infinite-scroll', '.fat-event-container').off('click').on('click', function (event) {
            event.preventDefault();

            var $container = $(this).closest('.fat-event-container'),
                $paging_wrap = $('.fat-paging-navigation-wrap', $container),
                $current_page = 1,
                is_append = false;

            if ($(this).hasClass('page-numbers') && typeof $(this).attr('href') != 'undefined') {
                $current_page = FatEvent.getPageNumberFromHref($(this).attr('href'));
            }

            if ($(this).hasClass('fat-event-load-more') || $(this).hasClass('fat-event-infinite-scroll')) {
                $current_page = parseInt($(this).attr('data-next-page'));
                is_append = true;
            }
            $('.fat-paging-navigation-wrap .paging-navigation', $container).css('opacity', 0);
            FatEvent.showLoading($paging_wrap);
            $.ajax({
                url: fat_event_ajax.ajaxurl,
                type: 'GET',
                data: ({
                    action: 'fat_event_filter',
                    sc_id: $container.attr('data-sc-id'),
                    category: typeof $container.attr('data-sc-cat') != 'undefined' && $container.attr('data-sc-cat') != '' ? $container.attr('data-sc-cat') : $('#fat-event-filter-category', $container).val(),
                    location: $('#fat-event-filter-location', $container).val(),
                    organizer: typeof $container.attr('data-sc-organizer') != 'undefined' && $container.attr('data-sc-organizer') != '' ? $container.attr('data-sc-organizer') : $('#fat-event-filter-organizer', $container).val(),
                    current_page: $current_page,
                    layout: $container.attr('data-layout')
                }),
                success: function (data) {
                    FatEvent.closeLoading($paging_wrap);
                    FatEvent.bindItem($container, data, is_append);
                },
                error: function () {
                    FatEvent.closeLoading($paging_wrap);
                    $('.fat-paging-navigation-wrap .paging-navigation', $container).css('opacity', 1);
                }
            });

            return false;
        });
    };

    FatEvent.initPopupDetail = function () {
        $('.fat-event-sc a[data-open-type="popup_modal"]').off('click').on('click', function (event) {
            event.preventDefault();
            var self = $(this),
                container = self.closest('.fat-event-container'),
                item = self.closest('.fat-event-item'),
                event_id = item.attr('data-event-id'),
                time = item.attr('data-time'),
                single_time = item.attr('data-single-time'),
                start_date = self.attr('data-s'),
                end_date = self.attr('data-e');

            if (typeof single_time == 'undefined' || item.length == 0 || typeof time == 'undefined' || typeof event_id == 'undefined') {
                event_id = typeof self.attr('data-event-id') != 'undefined' ? self.attr('data-event-id') : event_id;
                time = typeof self.attr('data-time') != 'undefined' ? self.attr('data-time') : time;
                single_time = typeof self.attr('data-single-time') ? self.attr('data-single-time') : single_time;
                container = typeof self.closest('.fat-event-sc') ? self.closest('.fat-event-sc') : container;
            }
            FatEvent.showLoading(container, true);
            $.ajax({
                url: fat_event_ajax.ajaxurl,
                type: 'GET',
                data: ({
                    action: 'fat_event_get_event_detail',
                    id: event_id,
                    s_date: start_date,
                    e_date: end_date
                }),
                success: function (data) {
                    data = $.parseJSON(data);
                    data.time = single_time;
                    data.start_date = start_date;
                    data.end_date = end_date;
                    data.email_location = '';
                    data.main_organizer_name = typeof data.organizer != 'undefined' && data.organizer.length > 0 ? data.organizer[0].name : '';
                    for (var $i = 0; $i < data.location.length; $i++) {
                        data.email_location += data.email_location == '' ? data.location[$i].location : ('. ' + data.location[$i].location);
                    }

                    FatEvent.showPopupDetail(data);
                    if (typeof data.thumb == 'undefined' || data.thumb == '') {
                        $('.fat-event-popup-single').addClass('no-thumb');
                        $('.fat-event-popup-single .fat-event-popup-thumb img').hide();
                    }
                    FatEvent.closeLoading(container);
                    FatEvent.isProcess = 0;
                    $('.fat-event-popup-single .fat-event-popup-inner').off('click').on('click', function (event) {
                        event.preventDefault();
                        return false;
                    });

                    $('.fat-event-popup-single').off('click').on('click', function () {
                        $('.fat-event-popup-single').fadeOut(function () {
                            $('.fat-event-popup-single').remove();
                            $('.epic-spinner-loading').remove();
                            $('body .epic-spinner-loading').remove();
                            $('body').removeClass('no-scroll');
                        })
                    })


                },
                error: function () {
                    FatEvent.closeLoading(container);
                    FatEvent.isProcess = 0;
                }
            });

            return false;
        })
    };

    FatEvent.initPopupBooking = function () {
        $('a.fat-event-register').off('click').on('click', function (event) {
            var data_payment = $(this).attr('data-payment');
            if (typeof data_payment === 'undefined' || data_payment != 'external_link') {
                event.preventDefault();
                var self = $(this),
                    template = wp.template('fat-event-popup-booking-template'),
                    popup = '',
                    id = self.attr('data-id'),
                    start_date = self.attr('data-start'),
                    end_date = self.attr('data-end'),
                    fees_type = self.attr('data-fees-type'),
                    fees_package = self.attr('data-fees-package'),
                    ticket_class = self.attr('data-ticket-class'),
                    fees = $(this).attr('data-fees'),
                    decimal = 2,
                    separator = ',',
                    locations = self.attr('data-location'),
                    amenities = self.attr('data-amenities');

                separator = typeof separator == 'undefined' || separator == '' ? '.' : separator;

                var data = {locations: '', amenities: ''};
                if (typeof locations != 'undefined') {
                    data.locations = $.parseJSON(locations);
                    // hide if single location
                    data.locations = data.locations.length > 1 ? data.locations : '';
                }
                if (typeof amenities != 'undefined') {
                    data.amenities = $.parseJSON(amenities);
                }
                popup = $(template(data));
                decimal = $('.fat-event-fees-info', popup).attr('data-decimal');
                separator = $('.fat-event-fees-info', popup).attr('data-separator');

                fees = !isNaN(fees) ? parseFloat(fees) : 0;

                if (fat_event_ajax.woocommerce_intergrated == 1) {
                    if (fees_type == 'ticket_class' || fees_type == 'package') {
                        $('select#ticket_class').off('change').on('change', function () {
                            var opt = $('option:selected', this),
                                seats = parseInt(opt.attr('data-seat')),
                                seats_available = opt.attr('data-seat-available'),
                                elm_ticket_number = $('select#ticket_number');
                            elm_ticket_number.empty();

                            if (typeof seats_available != 'undefined' && seats_available != '' && !isNaN(seats_available)) {
                                seats = parseInt(seats_available);
                            }

                            for (var $i = 1; $i <= seats; $i++) {
                                elm_ticket_number.append('<option value="' + $i + '">' + $i + '</option>');
                            }
                            $('.fat-event-price-variable .ticket-number-wrap .fully-book').remove();
                            if (seats == 0) {
                                $('.fat-event-price-variable .ticket-number-wrap select#ticket_number,.fat-event-price-variable .ticket-number-wrap label').hide();
                                $('a.fat-bt-submit-to-WC').hide();
                                $('.fat-event-price-variable .ticket-number-wrap').append('<div class="fully-book" style="color: red">' + fat_event_ajax.fully_booked + '</div>');
                            } else {
                                $('.fat-event-price-variable .ticket-number-wrap select#ticket_number,.fat-event-price-variable .ticket-number-wrap label').show();
                                $('a.fat-bt-submit-to-WC').show();
                            }
                        });
                        $('select#ticket_class').trigger('change');

                        $('.fat-event-price-variable').slideDown();

                        $('a.fat-bt-submit-to-WC').off('click').on('click', function () {
                            // add to woo cart
                            var ticket_number = $('select#ticket_number').val(),
                                elm_ticket = $('select#ticket_class'),
                                class_id = elm_ticket.val(),
                                opt_select = $('option:selected', elm_ticket),
                                class_name = opt_select.attr('data-class'),
                                max_seat = fees_type == 'ticket_class' ? opt_select.attr('data-seat') : $('select#ticket_number option:selected').attr('data-seat');
                            FatEvent.addToWooCart(self, id, start_date, end_date, data, ticket_number, class_id, class_name, max_seat);
                        });

                    } else {
                        // add to woo cart
                        var elm_ticket_number = $('select#ticket_number'),
                            seats = parseInt(elm_ticket_number.attr('data-seat'));
                        elm_ticket_number.empty();
                        for (var $i = 1; $i <= seats; $i++) {
                            elm_ticket_number.append('<option value="' + $i + '">' + $i + '</option>');
                        }

                        if (seats == 0) {
                            $('.fat-event-price-variable .ticket-number-wrap select#ticket_number,.fat-event-price-variable .ticket-number-wrap label').hide();
                            $('a.fat-bt-submit-to-WC').hide();
                            $('.fat-event-price-variable .ticket-number-wrap').append('<div class="fully-book" style="color: red">' + fat_event_ajax.fully_booked + '</div>');
                        } else {
                            $('.fat-event-price-variable .ticket-number-wrap select#ticket_number,.fat-event-price-variable .ticket-number-wrap label').show();
                            $('a.fat-bt-submit-to-WC').show();
                        }

                        $('.fat-event-price-variable').slideDown();
                        $('a.fat-bt-submit-to-WC').off('click').on('click', function () {
                            // add to woo cart
                            var ticket_number = $('select#ticket_number').val(),
                                max_seat = $('select#ticket_number').attr('data-seat');
                            FatEvent.addToWooCart(self, id, start_date, end_date, data, ticket_number, '', '', max_seat);
                        });
                    }
                    $('.fat-event-single').trigger('change');

                } else {
                    if ($.isFunction($.fn.selectize)) {
                        $('#optCountry, #optLocation', popup).selectize({
                            plugins: ['remove_button', 'drag_drop'],
                            searchField: 'text',
                            delimiter: ',',
                            persist: false
                        });
                    }

                    if ($.isFunction($.fn.datetimepicker)) {
                        $('.fat-event-date-field', popup).each(function () {
                            $(this).datetimepicker({
                                datepicker: true,
                                formatDate: 'Y/m/d',
                                format: 'Y/m/d',
                                timepicker: false,
                            });
                        });
                    }

                    $('body .fat-event-popup-modal.booking-popup').remove();
                    $('body').append(popup);

                    if (fat_event_ajax.auto_fill == '1') {
                        FatEvent.autoFill();
                    }

                    $('.fat-event-popup-modal.booking-popup a.fat-close-popup,.fat-event-popup-modal.booking-popup a.fat-popup-bt-cancel').on('click', function () {
                        $('body .fat-event-popup-modal.booking-popup').remove();
                        $('body').removeClass('hide-overflow');
                    });

                    var container = $('.g-recaptcha', '.fat-event-popup-modal.booking-popup'),
                        parametes = {'sitekey': container.attr('data-sitekey'), 'theme': 'light'};

                    if (container.length > 0) {
                        grecaptcha.render(container[0], parametes);
                    }

                    /* init fees package */

                    if (fees_type != '' && fees_type == 'package' && fees_package != '' && JSON.parse(fees_package).length > 0) {
                        var $package = JSON.parse(fees_package),
                            labelQuantity = $('label[for="numQuantity"]', '.fat-event-popup-modal.booking-popup'),
                            bookingForm = $('.fat-event-popup-modal.booking-popup'),
                            ticketTitle = $(labelQuantity).attr('data-package-title'),
                            currency_symbol = bookingForm.attr('data-currency-symbol'),
                            symbol_position = bookingForm.attr('data-symbol-position');

                        $('#numQuantity', '.fat-event-popup-modal.booking-popup').val($package[0].quantity);
                        fees = parseFloat($package[0].fees);

                        $(labelQuantity).html($(labelQuantity).attr('data-package-title'));
                        $('.fat-event-fees-info', '.fat-event-popup-modal.booking-popup').addClass('fat-hidden-field');
                        $(labelQuantity).closest('.fat-popup-field').removeClass('fat-popup-field-half-size');

                        /** check limit quantity*/
                        var $optQuantity = '<select id="numQuantity">';
                        for (var $i = 0; $i < $package.length; $i++) {
                            if (symbol_position == 'prefix') {
                                $optQuantity += '<option value="' + $package[$i].quantity + '">' + $package[$i].quantity + ' ' + ticketTitle + ' - ' + currency_symbol + $package[$i].fees + '</option>';
                            } else {
                                $optQuantity += '<option value="' + $package[$i].quantity + '">' + $package[$i].quantity + ' ' + ticketTitle + ' - ' + $package[$i].fees + currency_symbol + '</option>';
                            }
                        }
                        $optQuantity += '</select>';

                        var quantityFieldWrap = $('#numQuantity', '.fat-event-popup-modal.booking-popup').closest('.fat-popup-field');
                        $('#numQuantity', '.fat-event-popup-modal.booking-popup').remove();
                        quantityFieldWrap.append($optQuantity);
                    }

                    /* init ticket classification */
                    if (fees_type != '' && fees_type == 'ticket_class' && JSON.parse(ticket_class).length > 0) {
                        $('.fat-popup-field.fat-event-quantity-info,.fat-popup-field.fat-event-fees-info', '.fat-event-popup-modal.booking-popup').removeClass('fat-popup-field-half-size').addClass('fat-popup-field-ticket-class-size');
                        $('.fat-popup-field.fat-event-ticket-class-info', '.fat-event-popup-modal.booking-popup').removeClass('fat-hidden-field');
                        var $optClass = '',
                            bookingForm = $('.fat-event-popup-modal.booking-popup'),
                            currency_symbol = bookingForm.attr('data-currency-symbol'),
                            symbol_position = bookingForm.attr('data-symbol-position'),
                            optTicketClass = $('select[name="optTicketClass"]', '.fat-popup-field.fat-event-ticket-class-info');

                        ticket_class = JSON.parse(ticket_class);
                        for (var $i = 0; $i < ticket_class.length; $i++) {
                            $optClass = '<option value="' + ticket_class[$i].class_id + '" data-seat="' + ticket_class[$i].seat + '" data-seat-avail="' + ticket_class[$i].seat_available + '" data-fees="' + ticket_class[$i].fees + '">' + ticket_class[$i].class + ' - ';
                            $optClass += symbol_position == 'prefix' ? (currency_symbol + ticket_class[$i].fees) : (ticket_class[$i].fees + currency_symbol);
                            if (ticket_class[$i].seat != '0' && ticket_class[$i].seat != '') {
                                $optClass += ' (' + ticket_class[$i].seat_label + ':' + ticket_class[$i].seat + ')';
                            }
                            optTicketClass.append($optClass);
                            if ($i == 0) {
                                fees = parseFloat(ticket_class[$i].fees);
                            }
                        }
                        optTicketClass.on('change', function () {
                            var opt = $('option:selected', this),
                                seats_avail = parseInt(opt.attr('data-seat-avail')),
                                seat = opt.attr('data-seat');

                            seat = typeof seat != 'undefined' ? seat : '';

                            if (seats_avail == 0 && seat != '') {
                                $('.fat-popup-error-message').html(fat_event_ajax.fully_booked);
                                $('a.fat-popup-bt-submit').attr('disabled', 'disabled');
                            } else {
                                $('.fat-popup-error-message').html('');
                                $('a.fat-popup-bt-submit').removeAttr('disabled');
                                FatEvent.calculatorPrice();
                            }
                        });

                        optTicketClass.trigger('change');
                    }

                    $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').attr('data-id', id);
                    $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').attr('data-start', start_date);
                    $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').attr('data-end', end_date);
                    $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').attr('data-fees', fees);
                    $('span.fat-event-fees', '.fat-event-popup-modal.booking-popup').html(fees.format(decimal, 3, separator));
                    $('span.fat-event-total-fees', '.fat-event-popup-modal.booking-popup').html(fees.format(decimal, 3, separator));

                    if (fees == 0) {
                        $('.fat-event-fees-info', '.fat-event-popup-modal.booking-popup').hide();
                        $('.fat-payment-method', '.fat-event-popup-modal.booking-popup').hide();
                    } else {
                        $('.fat-event-fees-info', '.fat-event-popup-modal.booking-popup').show();
                        $('.fat-payment-method', '.fat-event-popup-modal.booking-popup').show();
                    }

                    if (fees > 0) {
                        FatEvent.initStripeCardInput();
                    }

                    FatEvent.processBooking();
                    FatEvent.processApplyCoupon();
                    FatEvent.initPopupBookingScroll();
                    $(window).resize(function () {
                        FatEvent.initPopupBookingScroll();
                    });
                }
                return false;
            }
            return true;
        })
    };

    FatEvent.autoFill = function () {
        var id = '',
            val = '';

        $('.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="text"],.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="email"],.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="number"], .fat-event-popup-booking .fat-popup-fields .fat-popup-field select').each(function () {
            id = $(this).attr('id');
            val = typeof $.cookie(id) != 'undefined' && $.cookie(id) != '' ? $.cookie(id) : '';
            val = typeof fat_event_ajax.auto_fill_info[id] != 'undefined' ? fat_event_ajax.auto_fill_info[id] : val;
            $(this).val(val);

        })
        $('.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="checkbox"]').each(function () {
            id = $(this).attr('id');
            val = typeof $.cookie(id) != 'undefined' && $.cookie(id) != '' ? $.cookie(id) : '';
            val = typeof fat_event_ajax.auto_fill_info[id] != 'undefined' ? fat_event_ajax.auto_fill_info[id] : val;
            if (typeof id != 'undefined') {
                if (val != '') {
                    $(this).prop('checked', true);
                } else {
                    $(this).prop('checked', false);
                }
            }
        })
    }

    FatEvent.saveBookingFormCookie = function () {
        var $cookie_booking_form = {};
        $('.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="text"],.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="number"], .fat-event-popup-booking .fat-popup-fields .fat-popup-field select').each(function () {
            $.cookie($(this).attr('id'), $(this).val(), {expires: 30, path: '/'});
        })

        $('.fat-event-popup-booking .fat-popup-fields .fat-popup-field input[type="checkbox"]').each(function () {
            if (typeof $(this).attr('id') != 'undefined') {
                if ($(this).is(':checked')) {
                    $.cookie($(this).attr('id'), $(this).val(), {expires: 30, path: '/'});
                } else {
                    $.cookie($(this).attr('id'), '', {expires: 30, path: '/'});
                }
            }
        })
    }

    FatEvent.processBooking = function () {
        $('#numQuantity', '.fat-event-popup-modal.booking-popup').on('change', function () {
            FatEvent.calculatorPrice();
        });

        $('input[required], textarea[require], select[required]', '.fat-event-popup-modal.booking-popup').on('change', function () {
            if ($(this).val() != '') {
                $(this).removeClass('fat-error-field');
            }
        });

        $('input[type="email"]', '.fat-event-popup-modal.booking-popup').on('change', function () {
            if ($(this).val() != '') {
                var emailReg = /\S+@\S+\.\S+/;
                if (emailReg.test($(this).val())) {
                    $(this).removeClass('fat-error-field');
                }
            }
        });

        $('.fat-event-radio-group[required],.fat-event-checkbox-group[required]', '.fat-event-popup-modal.booking-popup').on('change', function () {
            if (typeof $('input:checked', this).val() == 'undefined') {
                $(this).addClass('fat-error-field');
            } else {
                $(this).removeClass('fat-error-field');
            }
        });


        $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').off('click').on('click', function () {
            var self = $(this),
                form = self.closest('.fat-event-popup-modal'),
                txtFirstName = $('input[data-map-field="first_name"]', form).val(),
                txtLastName = $('input[data-map-field="last_name"]', form).val(),
                txtEmail = $('input[data-map-field="email"]', form).val(),
                txtPhone = $('input[data-map-field="phone"]', form).val(),
                txtAddress = $('input[data-map-field="address"]', form).val(),
                numQuantity = $('#numQuantity', form).val(),
                txtNote = $('input[data-map-field="address"]', form).val(),
                optGender = $('select[data-map-field="gender"]').val(),
                txtDepartment = $('input[data-map-field="department"]').val(),
                txtCompany = $('input[data-map-field="company"]').val(),
                txtCountry = $('select[data-map-field="country"]').val(),
                payment_type = $('select[name="paymentType"]').val(),
                location = $('select#optLocation').val(),
                amenities = [],
                isValid = true,
                id = self.attr('data-id'),
                fees = self.attr('data-fees'),
                error_message = '';

            $('.fat-popup-error-message', form).empty();

            var emailReg = /\S+@\S+\.\S+/;
            $('input[type="email"]', '.fat-event-popup-modal.booking-popup').each(function () {
                if ($(this).val() != '') {
                    var emailReg = /\S+@\S+\.\S+/;
                    if (emailReg.test($(this).val())) {
                        $(this).removeClass('fat-error-field');
                    } else {
                        isValid = false;
                        $(this).addClass('fat-error-field');
                        if (typeof $(this).attr('data-error') != 'undefined' && $(this).attr('data-error') !== '') {
                            error_message += $(this).attr('data-error') + '<br/>';
                        }
                    }
                }
            });

            $('input[required], textarea[require], select[required]', '.fat-event-popup-modal.booking-popup').each(function () {
                if ($(this).val() != '') {
                    $(this).removeClass('fat-error-field');
                } else {
                    isValid = false;
                    $(this).addClass('fat-error-field');
                    if (typeof $(this).attr('data-error') != 'undefined' && $(this).attr('data-error') !== '') {
                        error_message += $(this).attr('data-error') + '<br/>';
                    }
                }
            });

            $('.fat-event-radio-group[required],.fat-event-checkbox-group[required]', '.fat-event-popup-modal.booking-popup').each(function () {
                if (typeof $('input:checked', this).val() == 'undefined') {
                    $(this).addClass('fat-error-field');
                    isValid = false;
                    if (typeof $(this).attr('data-error') != 'undefined' && $(this).attr('data-error') !== '') {
                        error_message += $(this).attr('data-error') + '<br/>';
                    }
                } else {
                    $(this).removeClass('fat-error-field');
                }
            });

            $('.fat-popup-field.amenities-field input[name="amenities"]', '.fat-event-popup-modal.booking-popup').each(function () {
                if ($(this).prop('checked')) {
                    amenities.push($(this).val());
                }
            });

            if (isValid) {
                FatEvent.saveBookingFormCookie();

                var $data = {},
                    ticket_class = $('select[name="optTicketClass"]').val() != null ? $('select[name="optTicketClass"]').val() : '';
                if (form.hasClass('booking-form-builder')) {
                    var $label,
                        $value,
                        $data_form = {};
                    $('.fat-event-field-builder').each(function () {
                        if (typeof $(this).attr('name') != 'undefined') {
                            if (typeof $(this).attr('data-map-field') != 'undefined' && $(this).attr('data-map-field') != '' && $(this).attr('data-map-field') != 'none') {
                                $data_form[$(this).attr('data-map-field')] = {
                                    'name': $(this).attr('name'),
                                    'label': $(this).attr('data-label'),
                                    'value': $(this).val()
                                };
                            } else {
                                $data_form[$(this).attr('name')] = {
                                    'name': $(this).attr('name'),
                                    'label': $(this).attr('data-label'),
                                    'value': $(this).val()
                                };
                            }
                        }
                    });
                    $('.fat-event-radio-group,.fat-event-checkbox-group').each(function () {
                        var field_wrap = $(this),
                            value = [];

                        if (typeof $('input:checked', field_wrap).val() != 'undefined') {
                            $('input', field_wrap).each(function () {
                                if ($(this).is(':checked')) {
                                    value.push($(this).val());
                                }
                            });
                            if (typeof $(this).attr('data-map-field') != 'undefined' && $(this).attr('data-map-field') != '' && $(this).attr('data-map-field') != 'none') {
                                $data_form[$(this).attr('data-map-field')] = {
                                    'name': $(this).attr('name'),
                                    'label': $(this).attr('data-label'),
                                    'value': value
                                };
                            } else {
                                $data_form[$(this).attr('name')] = {
                                    'name': $(this).attr('name'),
                                    'label': $(this).attr('data-label'),
                                    'value': value
                                };
                            }
                        }
                    });
                    $data = {
                        action: 'fat_event_booking',
                        id: id,
                        data_form: $data_form,
                        quantity: numQuantity,
                        paymentType: payment_type,
                        start_date: self.attr('data-start'),
                        end_date: self.attr('data-end'),
                        location: location,
                        amenities: amenities,
                        url: window.location.href,
                        coupon: typeof $('#txtCoupon', '.booking-popup').val() != 'undefined' ? $('#txtCoupon', '.booking-popup').val() : '',
                        ticket_class: ticket_class,
                    }
                } else {
                    $data = {
                        action: 'fat_event_booking',
                        id: id,
                        firstName: $('input#txtFirstName', form).val(),
                        lastName: $('input#txtLastName', form).val(),
                        phone: $('input#txtPhone', form).val(),
                        email: $('input#txtEmail', form).val(),
                        quantity: numQuantity,
                        note: $('#txtNote', form).val(),
                        address: $('#txtAddress', form).val(),
                        gender: $('#optGender', form).val(),
                        department: $('#txtDepartment', form).val(),
                        company: $('#txtCompany', form).val(),
                        country: $('#optCountry', form).val(),
                        paymentType: payment_type,
                        start_date: self.attr('data-start'),
                        end_date: self.attr('data-end'),
                        location: location,
                        amenities: amenities,
                        url: window.location.href,
                        coupon: typeof $('#txtCoupon', '.booking-popup').val() != 'undefined' ? $('#txtCoupon', '.booking-popup').val() : '',
                        ticket_class: ticket_class,
                    };
                }

                if (payment_type === 'stripe' && fees > 0) {
                    $('button', 'form#stripe-payment-form').trigger('click');
                } else {
                    FatEvent.showLoading(self, true);
                    $.ajax({
                        url: fat_event_ajax.ajaxurl,
                        type: 'POST',
                        data: $data,
                        success: function (data) {
                            data = $.parseJSON(data);
                            FatEvent.isProcess = 0;
                            if (data.code > 0) {
                                $('body').removeClass('no-scroll');
                                if (payment_type == 'myPOS') {
                                    form = $(data.form);
                                    form.hide();
                                    $('body').append(form);
                                    $('form#ipcForm').submit();
                                } else {
                                    if (payment_type == 'paypal' && typeof data.url != 'undefined' && data.url != '') {
                                        window.location.href = data.url;
                                    } else {

                                        $.ajax({
                                            url: fat_event_ajax.ajaxurl,
                                            type: 'POST',
                                            data: ({
                                                action: 'fat_event_booking_sendmail',
                                                id: data.code,
                                            })
                                        });

                                        FatEvent.closeLoading(self);
                                        $('body .fat-event-popup-modal').remove();
                                        if (typeof data.message != 'undefined') {
                                            FatEvent.showPopupMessage(data.message);
                                        }
                                        if (ticket_class == '') {
                                            var $elm_seats_available = $('.fat-event-seats-available strong'),
                                                $seats_available = $elm_seats_available.html();
                                            if (!isNaN($seats_available)) {
                                                $seats_available = parseInt($seats_available);
                                                if (($seats_available - numQuantity) >= 0) {
                                                    $elm_seats_available.html($seats_available - numQuantity);
                                                } else {
                                                    $elm_seats_available.html(0);
                                                }
                                            }
                                        } else {
                                            var $elm_seats_available = $('.fat-event-seats-available[data-ticket-id="' + ticket_class + '"]', '.fat-event-fees-package'),
                                                $seats_available = $elm_seats_available.attr('data-seats');
                                            if (!isNaN($seats_available)) {
                                                $seats_available = parseInt($seats_available);
                                                if (($seats_available - numQuantity) >= 0) {
                                                    $('span', $elm_seats_available).html($seats_available - numQuantity);
                                                    $elm_seats_available.attr('data-seats', ($seats_available - numQuantity));
                                                } else {
                                                    $('span', $elm_seats_available).html(0);
                                                    $elm_seats_available.attr('data-seats', 0);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else {
                                FatEvent.closeLoading(self);
                                $('.fat-popup-error-message', form).append(data.message + '</br>');
                                $('body').removeClass('no-scroll');
                            }
                        },
                        error: function () {
                            FatEvent.closeLoading(self);
                            FatEvent.isProcess = 0;
                            $('body').removeClass('no-scroll');
                        }
                    });
                }
            } else {
                $('.fat-popup-error-message', form).append(error_message);
                FatEvent.initPopupBookingScroll();
            }
        })
    };

    FatEvent.processApplyCoupon = function () {
        $('a.bt-apply-coupon', '.fat-event-popup-booking').off('click').on('click', function () {
            var self = $(this),
                coupon = $('#txtCoupon', '.fat-event-popup-booking').val(),
                btSubmit = $('.fat-popup-bt-submit', '.fat-event-popup-booking'),
                fees = btSubmit.attr('data-fees'),
                id = btSubmit.attr('data-id');
            if (FatEvent.isProcess == 1) {
                return;
            }
            if (coupon != '') {
                var total_spend = parseFloat(fees) * parseFloat($('#numQuantity', '.fat-event-popup-booking').val());
                FatEvent.showLoading(self, true);
                FatEvent.isProcess = 1;
                $.ajax({
                    url: fat_event_ajax.ajaxurl,
                    type: 'POST',
                    data: ({
                        action: 'fat_event_apply_coupon',
                        coupon: coupon,
                        event_id: id,
                        total_spend: total_spend,
                        currency: self.attr('data-currency'),
                        symbol_position: $('.fat-event-fees-info', '.fat-event-popup-booking').attr('data-symbol-position')
                    }),
                    success: function (data) {
                        data = $.parseJSON(data);
                        FatEvent.isProcess = 0;
                        FatEvent.closeLoading(self);
                        $('.fat-coupon-wrap .fat-coupon-error-message').remove();
                        $('.fat-coupon-wrap .fat-coupon-discount-message').remove();
                        if (data.code > 0) {
                            self.attr('data-discount-type', data.discount_type);
                            self.attr('data-discount-amount', data.amount);
                            $('.fat-coupon-wrap').append('<div class="fat-coupon-discount-message">' + data.discount_message + '</div>');
                            FatEvent.calculatorPrice();
                        } else {
                            $('.fat-coupon-wrap').append('<div class="fat-coupon-error-message">' + data.message + '</div>');
                        }
                    },
                    error: function () {
                        FatEvent.closeLoading(self);
                        FatEvent.isProcess = 0;
                    }
                });
            }
        });

        $('#txtCoupon', '.fat-event-popup-booking').on('change', function () {
            var bt_apply_coupon = $('a.bt-apply-coupon', '.fat-event-popup-booking');
            bt_apply_coupon.attr('data-discount-type', '');
            bt_apply_coupon.attr('data-discount-amount', 0);
            $('.fat-coupon-wrap .fat-coupon-error-message').remove();
            $('.fat-coupon-wrap .fat-coupon-discount-message').remove();
            $('.fat-event-discount', '.fat-event-popup-booking').html('');
            FatEvent.calculatorPrice();
        });
    };

    FatEvent.initPopupBookingScroll = function () {
        setTimeout(function () {
            if ($('.fat-event-popup-booking .fat-popup-fields').length > 0) {
                $('.fat-event-popup-booking .fat-popup-fields').css('height', 'auto');

                var formHeight = $('.fat-event-popup-booking .fat-popup-fields').outerHeight(true),
                    popupTitleHeight = $('.fat-popup-title h4').outerHeight(true),
                    popupFooterHeight = $('.fat-popup-footer').outerHeight(true),
                    popupHeight = $('.fat-event-popup-modal .fat-event-popup-inner').outerHeight(true),
                    buffer = 30;

                formHeight = parseFloat(formHeight);
                popupTitleHeight = parseFloat(popupTitleHeight);
                popupFooterHeight = parseFloat(popupFooterHeight);
                popupHeight = parseFloat(popupHeight);

                formHeight = (popupHeight - popupTitleHeight - popupFooterHeight - buffer) > formHeight ? formHeight : (popupHeight - popupTitleHeight - popupFooterHeight - buffer);
                $('.fat-event-popup-booking .fat-popup-fields').css('height', formHeight + 'px');
                new PerfectScrollbar($('.fat-event-popup-booking .fat-popup-fields')[0], {
                    wheelSpeed: 2,
                    wheelPropagation: true,
                    minScrollbarLength: 20
                });
            }
        }, 500);
    };

    FatEvent.showPopupDetail = function (data) {


        if (typeof data.latitude != 'undefined' && data.latitude.split(',').length == 2) {
            data.direction = 'https://www.google.com/maps/dir/?api=1&destination=' + data.latitude.split(',')[0] + ',' + data.latitude.split(',')[1]
        } else {
            data.direction = 'javascript:;';
        }

        var template = wp.template('fat-event-popup-template'),
            popup = $(template(data));
        popup.addClass('fat-event-popup-single');

        if (data.enable_booking == 0 && (data.organizer == '' &&
            (data.hourly_schedule.length > 0 && data.hourly_schedule[0].from == '')
            && $('.fat-event-share', popup).length == 0)) {
            popup.addClass('hide-col-right');
        }

        // init calendar export
        var export_url = $('.fat-event-export-ical', popup).attr('href');
        export_url += '&id=' + data.id + '&s_date=' + data.start_date + '&e_date=' + data.end_date;
        $('.fat-event-export-ical', popup).attr('href', export_url);

        $('body .fat-event-popup-modal').remove();
        $('body').append(popup);

        if (typeof data.fees_package == 'object') {
            var fees_package = JSON.stringify(data.fees_package);
            $('a.fat-event-register', '.fat-event-popup-modal').attr('data-fees-package', fees_package);
        }

        if (typeof data.amenities == 'object') {
            $('a.fat-event-register', '.fat-event-popup-modal').attr('data-amenities', JSON.stringify(data.amenities));
        }
        if (typeof data.location == 'object') {
            $('a.fat-event-register', '.fat-event-popup-modal').attr('data-location', JSON.stringify(data.location));
        }

        $('body .fat-event-popup-modal').imagesLoaded().progress(function () {
            FatEvent.initPopupScroll();
            $(window).resize(function () {
                setTimeout(function () {
                    FatEvent.initPopupScroll();
                }, 200);
            });
            FatEvent.initPopupShare();
        });

        //init max seat
        if ($('.fat-event-popup-single select#ticket_number').length > 0) {
            var max_seat = data.seats == '0' ? 15 : data.seats;
            $('.fat-event-popup-single select#ticket_number').attr('data-seat', max_seat);
        }

        FatEvent.initPopupBooking();

        $('.fat-event-popup-single').addClass('event-' + data.id);

        $('body').addClass('no-scroll');
        $('a.fat-close-popup', '.fat-event-popup-modal').on('click', function () {
            $('body').removeClass('no-scroll');
            $('body .fat-event-popup-modal').remove();
        })
    };

    FatEvent.initPopupScroll = function () {
        $('.fat-event-popup-content-wrap').css('height', 'auto');

        var popup_height = $('.fat-event-popup-single .fat-event-popup-inner', 'body').outerHeight(true),
            thumb_height = $('.fat-event-popup-single .fat-event-popup-thumb', 'body').outerHeight(true),
            content_wrap_height = popup_height - thumb_height - 30;

        $('.fat-event-popup-content-wrap').css('height', content_wrap_height + 'px');

        if ($('.fat-event-popup-content-wrap').length > 0 && ($('.fat-event-popup-content').height() > 380 || $('.fat-event-meta-wrap').height() > 380)) {
            new PerfectScrollbar($('.fat-event-popup-content-wrap')[0], {
                wheelSpeed: 2,
                wheelPropagation: true,
                minScrollbarLength: 20
            });
        }
    };

    FatEvent.initPopupShare = function () {
        $('.fat-event-share a').off('click').on('click', function () {
            var self = $(this),
                social = self.attr('data-social'),
                share_wrap = self.closest('.fat-event-share'),
                title = share_wrap.attr('data-title'),
                link = share_wrap.attr('data-link'),
                thumb = share_wrap.attr('data-thumb'),
                window_title = '',
                window_url = '';

            if (social === 'facebook') {
                window_url = 'https://www.facebook.com/sharer/sharer.php?u=' + link + '&t=TITLE';
                window_title = 'Facebook share';
            }
            if (social === 'twitter') {
                window_url = 'http://www.twitter.com/intent/tweet?url=' + link;// 'http://twitter.com/home?text=' + title + '&url=' + link;
                window_title = 'Twitter share';
            }
            if (social === 'google') {
                window_url = 'https://plus.google.com/share?url=' + link;
                window_title = 'Google+ share';
            }
            if (window_url != '') {
                var left = (screen.width / 2) - (500 / 2);
                var top = (screen.height / 2) - (450 / 2);
                window.open(window_url, window_title, 'width=500,height=450,resizable=0,top=' + top + ',left=' + left).focus();
            }
        })
    };

    FatEvent.initInfiniteScroll = function () {
        var windowTop = $(window).scrollTop(),
            windowBottom = windowTop + $(window).height(),
            elemTop, elemBottom;
        $('.fat-paging-navigation-wrap a.fat-event-infinite-scroll:not(.infinited)').each(function () {
            elemTop = $(this).offset().top;
            elemBottom = elemTop + $(this).height();
            if ((elemBottom <= windowBottom) && (elemTop >= windowTop)) {
                $(this).addClass('infinited');
                $(this).trigger('click');
            }
        });
    };

    FatEvent.getPageNumberFromHref = function ($href) {
        var $href_default = '',
            pattern = /paged=\d+/ig;
        if (new RegExp(pattern).test($href)) {
            $href_default = new RegExp(pattern).exec($href);
        } else {
            pattern = /page\/\d+/ig;
            $href_default = new RegExp(pattern).test($href) ? new RegExp(pattern).exec($href) : $href_default;
        }
        pattern = /\d+/g;
        return new RegExp(pattern).test($href_default) ? new RegExp(pattern).exec($href_default)[0] : 1;
    };

    FatEvent.initAppearScroll = function ($container) {
        var windowTop = $(window).scrollTop(),
            windowBottom = windowTop + $(window).height(),
            $animation_duration = 100,
            elemTop, elemBottom, $items, $animation = 'fadeInUp';
        $items = [];
        $('.fat-event-item.has-infinite:not(.infinited)', $container).each(function () {
            if (FatEvent.isAppear(this)) {
                $items.push($(this));
            }
        });

        for (var $i = 0; $i < $items.length; $i++) {
            (function ($index) {
                $animation_duration = $($items[$index]).closest('.fat-event-container').attr('data-animation-duration');
                $animation_duration = typeof $animation_duration != 'undefined' ? parseInt($animation_duration) : 200;
                var $delay = $animation_duration * $i;
                setTimeout(function () {
                    $animation = $($items[$index]).closest('.fat-event-container').attr('data-animation');
                    $($items[$index]).addClass('animated ' + $animation);
                    $($items[$index]).removeClass('has-infinite').removeClass('waiting-init');
                    $($items[$index]).addClass('infinited');
                    setTimeout(function () {
                        $($items[$index]).removeClass($animation);
                    }, 1500);
                }, $delay);
            })($i);
        }
    };

    FatEvent.isAppear = function (elm, percent_height) {
        var windowTop = $(window).scrollTop(),
            windowBottom = windowTop + $(window).height(),
            $height = $(elm).height(),
            elemTop = $(elm).offset().top,
            elemBottom = elemTop + $height,
            $height_appear = elemBottom - windowBottom;
        if (typeof percent_height == 'undefined' || isNaN(percent_height)) {
            percent_height = 0.9;
        }
        if (($height_appear <= 0 || $height_appear <= ($height * percent_height)) && (elemTop >= windowTop || windowBottom > elemBottom)) {
            return true;
        }
        return false;
    };

    FatEvent.initAnimation = function () {
        $('.fat-gallery-item', '.fat-maika-container.has-animation').addClass('has-infinite');
        $('.fat-maika-container.has-animation').each(function () {
            FatMaika.initAppearScroll($(this));
        })
    };

    FatEvent.showLoading = function ($container, $is_center_screen) {
        var spinner_type = $container.attr('data-spinner'),
            spinner = '';

        spinner_type = typeof spinner_type == 'undefined' ? 'atom' : spinner_type;

        switch (spinner_type) {
            case 'atom': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="atom-spinner">\n' +
                    '        <div class="spinner-inner">\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <div class="spinner-line"></div>\n' +
                    '            <!--Chrome renders little circles malformed :(-->\n' +
                    '            <div class="spinner-circle">\n' +
                    '                &#9679;\n' +
                    '            </div>\n' +
                    '        </div>\n' +
                    '    </div></div></div>');
                break;
            }
            case 'finger': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="fingerprint-spinner">\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '  <div class="spinner-ring"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'flower': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="flower-spinner">\n' +
                    '  <div class="dots-container">\n' +
                    '    <div class="bigger-dot">\n' +
                    '      <div class="smaller-dot"></div>\n' +
                    '    </div>\n' +
                    '  </div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'half_circle': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="half-circle-spinner">\n' +
                    '  <div class="circle circle-1"></div>\n' +
                    '  <div class="circle circle-2"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'orbit': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="orbit-spinner">\n' +
                    '  <div class="orbit"></div>\n' +
                    '  <div class="orbit"></div>\n' +
                    '  <div class="orbit"></div>\n' +
                    '</div></div></div>');
                break;
            }

            case 'self_building': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="self-building-square-spinner">\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square clear"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square clear"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '  <div class="square"></div>\n' +
                    '</div></div></div>');
                break;
            }
            case 'hollow_dots': {
                spinner = $('<div class="epic-spinner-loading"><div class="epic-spinner-loading-inner"><div class="hollow-dots-spinner" :style="spinnerStyle">\n' +
                    '  <div class="dot"></div>\n' +
                    '  <div class="dot"></div>\n' +
                    '  <div class="dot"></div>\n' +
                    '</div></div></div>');
                break;
            }
        }
        if (typeof $is_center_screen !== 'undefined' && $is_center_screen) {
            $container = $('body');
            $container.append(spinner);
            $('.epic-spinner-loading', $container).addClass('epic-center-screen');
        } else {
            $container.append(spinner);
        }
    };

    FatEvent.closeLoading = function ($container) {
        $('.epic-spinner-loading', $container).remove();
        $('body .epic-spinner-loading').remove();
    };

    FatEvent.showNotified = function ($message, $delay_time) {
        $('body').append('<div class="fat-event-notified">' + $message + '</div>');
        $delay_time = typeof $delay_time != 'undefined' && !isNaN($delay_time) ? $delay_time : 5000;
        setTimeout(function () {
            $('.fat-event-notified', 'body').fadeOut(function () {
                $('.fat-portfolio-notified', 'body').remove();
            })
        }, $delay_time);
    };

    FatEvent.showPopupMessage = function ($message) {
        var popup = $('<div class="fat-event-popup-modal"><div class="fat-event-popup-message"><a class="fat-close-popup"><i class="fa fa-times-circle"></i></a><div class="fat-event-message">' + $message + '</div></div></div>');
        $('body .fat-event-popup-modal').remove();
        $('body').append(popup);
        $('a.fat-close-popup', '.fat-event-popup-modal').on('click', function () {
            $('body .fat-event-popup-modal').remove();
        })
    };

    FatEvent.initTab = function () {
        $('.fat-event-tabs a').off('click').on('click', function () {
            var li = $(this).closest('li'),
                id = $(this).attr('data-id'),
                section = $(this).closest('.fat-event-sections');
            if (!li.hasClass('active')) {
                $('.fat-event-tabs li.active', section).removeClass('active');
                li.addClass('active');
                $('.fat-event-tab-content.active', section).fadeOut(function () {
                    $(this).removeClass('active');
                    $('.fat-event-tab-content[data-id="' + id + '"]', section).fadeIn(function () {
                        $(this).addClass('active');
                    })
                });
            }
        });
    };

    FatEvent.initStripeCardInput = function () {
        if ($('#stripe-payment-form').length == 0) {
            return;
        }
        try {
            var pk = $('form#stripe-payment-form').attr('data-pk'),
                stripe = Stripe(pk),
                elements = stripe.elements();

            var style = {
                base: {
                    color: '#32325d',
                    lineHeight: '18px',
                    fontSmoothing: 'antialiased',
                    fontSize: '16px',
                    '::placeholder': {
                        color: '#aab7c4'
                    }
                },
                invalid: {
                    color: 'red',
                    iconColor: 'red'
                }
            };

            // Create an instance of the card Element.
            var card = elements.create('card', {style: style, hidePostalCode: true});
            // Add an instance of the card Element into the `card-element` <div>.
            card.mount('#card-element');

            // Handle real-time validation errors from the card Element.
            card.addEventListener('change', function (event) {
                var displayError = document.getElementById('card-errors');
                if (event.error) {
                    displayError.textContent = event.error.message;
                } else {
                    displayError.textContent = '';
                }
            });

            // Handle form submission.
            var form = document.getElementById('stripe-payment-form');
            form.addEventListener('submit', function (event) {
                event.preventDefault();

                var self = $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup');
                FatEvent.showLoading(self, true);

                stripe.createToken(card).then(function (result) {
                    if (result.error) {
                        // Inform the user if there was an error.
                        var errorElement = document.getElementById('card-errors');
                        errorElement.textContent = result.error.message;
                        FatEvent.closeLoading($('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup'));
                    } else {
                        // Send the token to your server.
                        var self = $('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup'),
                            form = self.closest('.fat-event-popup-modal'),
                            numQuantity = $('#numQuantity', form).val(),
                            $data = {},
                            amenities = [],
                            location = $('select#optLocation').val();

                        $('.fat-popup-field.amenities-field input[name="amenities"]', '.fat-event-popup-modal.booking-popup').each(function () {
                            if ($(this).prop('checked')) {
                                amenities.push($(this).val());
                            }
                        });

                        if (form.hasClass('booking-form-builder')) {
                            var $label,
                                $value,
                                $data_form = {};
                            $('.fat-event-field-builder').each(function () {
                                if (typeof $(this).attr('name') != 'undefined') {
                                    if (typeof $(this).attr('data-map-field') != 'undefined' && $(this).attr('data-map-field') != '' && $(this).attr('data-map-field') != 'none') {
                                        $data_form[$(this).attr('data-map-field')] = {
                                            'name': $(this).attr('name'),
                                            'label': $(this).attr('data-label'),
                                            'value': $(this).val()
                                        };
                                    } else {
                                        $data_form[$(this).attr('name')] = {
                                            'name': $(this).attr('name'),
                                            'label': $(this).attr('data-label'),
                                            'value': $(this).val()
                                        };
                                    }
                                }
                            });
                            $('.fat-event-radio-group,.fat-event-checkbox-group').each(function () {
                                var field_wrap = $(this),
                                    value = [];

                                if (typeof $('input:checked', field_wrap).val() != 'undefined') {
                                    $('input', field_wrap).each(function () {
                                        if ($(this).is(':checked')) {
                                            value.push($(this).val());
                                        }
                                    });
                                    if (typeof $(this).attr('data-map-field') != 'undefined' && $(this).attr('data-map-field') != '' && $(this).attr('data-map-field') != 'none') {
                                        $data_form[$(this).attr('data-map-field')] = {
                                            'name': $(this).attr('name'),
                                            'label': $(this).attr('data-label'),
                                            'value': value
                                        };
                                    } else {
                                        $data_form[$(this).attr('name')] = {
                                            'name': $(this).attr('name'),
                                            'label': $(this).attr('data-label'),
                                            'value': value
                                        };
                                    }
                                }
                            });
                            $data = {
                                action: 'fat_event_booking',
                                id: self.attr('data-id'),
                                token: result.token.id,
                                data_form: $data_form,
                                quantity: numQuantity,
                                paymentType: $('select[name="paymentType"]').val(),
                                start_date: self.attr('data-start'),
                                end_date: self.attr('data-end'),
                                location: location,
                                amenities: amenities,
                                url: window.location.href,
                                coupon: typeof $('#txtCoupon', '.booking-popup').val() != 'undefined' ? $('#txtCoupon', '.booking-popup').val() : '',
                                ticket_class: $('select[name="optTicketClass"]').val() != null ? $('select[name="optTicketClass"]').val() : '',
                            }
                        } else {
                            $data = {
                                action: 'fat_event_booking',
                                id: self.attr('data-id'),
                                token: result.token.id,
                                firstName: $('input#txtFirstName', form).val(),
                                lastName: $('input#txtLastName', form).val(),
                                phone: $('input#txtPhone', form).val(),
                                email: $('input#txtEmail', form).val(),
                                quantity: numQuantity,
                                note: $('#txtNote', form).val(),
                                address: $('#txtAddress', form).val(),
                                gender: $('#optGender', form).val(),
                                department: $('#txtDepartment', form).val(),
                                company: $('#txtCompany', form).val(),
                                country: $('#optCountry', form).val(),
                                paymentType: $('select[name="paymentType"]').val(),
                                start_date: self.attr('data-start'),
                                end_date: self.attr('data-end'),
                                location: location,
                                amenities: amenities,
                                url: window.location.href,
                                coupon: typeof $('#txtCoupon', '.booking-popup').val() != 'undefined' ? $('#txtCoupon', '.booking-popup').val() : '',
                                ticket_class: $('select[name="optTicketClass"]').val() != null ? $('select[name="optTicketClass"]').val() : '',
                            };
                        }


                        $.ajax({
                            url: fat_event_ajax.ajaxurl,
                            type: 'POST',
                            data: $data,
                            success: function (data) {
                                data = $.parseJSON(data);

                                FatEvent.isProcess = 0;
                                if (data.code > 0) {

                                    $.ajax({
                                        url: fat_event_ajax.ajaxurl,
                                        type: 'POST',
                                        data: ({
                                            action: 'fat_event_booking_sendmail',
                                            id: data.code,
                                        })
                                    });

                                    FatEvent.closeLoading(self);
                                    $('body .fat-event-popup-modal').remove();
                                    if (typeof data.url != 'undefined' && data.url != '') {
                                        window.location.href = data.url;
                                    }
                                    if (typeof data.message != 'undefined') {
                                        FatEvent.showPopupMessage(data.message);
                                    }
                                    var $seats_available = $('.fat-event-seats-available strong').html();
                                    if (!isNaN($seats_available)) {
                                        $seats_available = parseInt($seats_available);
                                        if (($seats_available - numQuantity) >= 0) {
                                            $('.fat-event-seats-available strong').html($seats_available - numQuantity);
                                        } else {
                                            $('.fat-event-seats-available strong').html(0);
                                        }
                                    }

                                } else {
                                    FatEvent.closeLoading(self);
                                    $('.fat-popup-error-message', form).append(data.message + '</br>');
                                }
                            },
                            error: function () {
                                FatEvent.closeLoading(self);
                                FatEvent.isProcess = 0;
                            }
                        });
                    }
                });
            });

            var paymentType = $('select[name="paymentType"]').val();
            if (paymentType === 'stripe') {
                $('#stripe-payment-form').show();
                $('.g-recaptcha', '.fat-event-popup-booking').hide();
            } else {
                $('#stripe-payment-form').hide();
                $('.g-recaptcha', '.fat-event-popup-booking').show();
            }
            $('select[name="paymentType"]').on('change', function () {
                if ($(this).val() === 'stripe') {
                    $('#stripe-payment-form').show();
                    $('.g-recaptcha', '.fat-event-popup-booking').hide();
                } else {
                    $('#stripe-payment-form').hide();
                    $('.g-recaptcha', '.fat-event-popup-booking').show();
                }
            });
        } catch (err) {

        }

    };

    FatEvent.initPopupBookingSize = function () {
        var popupHeight = $('.fat-event-popup-inner').outerHeight();
        popupHeight = parseInt(popupHeight) - 200;
        popupHeight = popupHeight < 250 ? 250 : popupHeight;
        $('.fat-event-popup-modal.booking-popup .fat-event-popup-inner .fat-popup-fields').css('height', popupHeight + 'px');
        new PerfectScrollbar($('.fat-event-popup-modal.booking-popup .fat-event-popup-inner .fat-popup-fields')[0], {
            wheelSpeed: 2,
            wheelPropagation: true,
            minScrollbarLength: 20
        });
    };

    FatEvent.calculatorPrice = function () {
        var self = $('#numQuantity', '.fat-event-popup-modal.booking-popup');
        if (self.length > 0 && self.val() != '') {
            var quantity = $('#numQuantity', '.fat-event-popup-modal.booking-popup').val(),
                discount = 0,
                fees = parseFloat($('a.fat-popup-bt-submit', '.fat-event-popup-modal.booking-popup').attr('data-fees')),
                popup = $(self).closest('.booking-popup'),
                fee_info = $('.fat-event-fees-info', popup),
                decimal = fee_info.attr('data-decimal'),
                separator = fee_info.attr('data-separator'),
                symbol_position = fee_info.attr('data-symbol-position'),
                optTicketClass = $('.fat-event-ticket-class-info select[name="optTicketClass"] :selected', '.fat-event-popup-modal.booking-popup');

            separator = typeof separator == 'undefined' || separator == '' ? '.' : '';
            if (typeof optTicketClass.attr('data-fees') != 'undefined' && !isNaN(optTicketClass.attr('data-fees') != 'undefined')) {
                fees = parseFloat(optTicketClass.attr('data-fees'));
                $('.fat-event-fees', '.fat-event-popup-modal.booking-popup').html(fees.format(decimal, 3, separator));
            }
            quantity = parseFloat(quantity);
            if ($('.bt-apply-coupon', '.fat-event-popup-modal.booking-popup').length > 0) {
                var self = $('.bt-apply-coupon', '.fat-event-popup-modal.booking-popup'),
                    discount_amount = typeof self.attr('data-discount-amount') != 'undefined' ? self.attr('data-discount-amount') : 0,
                    discount_type = typeof self.attr('data-discount-type') != 'undefined' ? self.attr('data-discount-type') : 'fixed',
                    currency = self.attr('data-currency');

                if (discount_type == 'fixed') {
                    discount = parseFloat(discount_amount);
                } else {
                    discount = (fees * quantity) * parseFloat(discount_amount / 100);
                }
                if (discount > 0) {
                    if (symbol_position == 'prefix') {
                        $('span.fat-event-discount', '.fat-event-popup-modal.booking-popup').html('-' + currency + discount.format(decimal, 3, separator));
                    } else {
                        $('span.fat-event-discount', '.fat-event-popup-modal.booking-popup').html('-' + discount.format(decimal, 3, separator) + currency);
                    }
                }

            }

            var total = parseFloat(fees * quantity - discount);
            total = total > 0 ? total : 0;
            $('span.fat-event-total-fees', '.fat-event-popup-modal.booking-popup').html(total.format(decimal, 3, separator));
        }
    };

    FatEvent.addToWooCart = function (self, id, start_date, end_date, data, ticket_number, class_id, class_name, max_seat) {
        FatEvent.showLoading(self, true);
        FatEvent.isProcess = 1;
        $.ajax({
            url: fat_event_ajax.ajaxurl,
            type: 'POST',
            data: ({
                action: 'fat_event_wc_booking',
                id: id,
                start_date: start_date,
                end_date: end_date,
                ticket_number: ticket_number,
                max_seat: max_seat,
                class_id: class_id,
                class_name: class_name,
                location: data.locations,
                amenities: data.amenities,
            }),
            success: function (data) {
                data = $.parseJSON(data);
                FatEvent.isProcess = 0;
                if (data.code > 0) {
                    if (data.code === 1) {
                        if (typeof data.url != 'undefined') {
                            window.location.href = data.url;
                        } else {
                            FatEvent.closeLoading(self);
                            FatEvent.showPopupMessage(data.message);
                        }
                    }
                } else {
                    FatEvent.closeLoading(self);
                    if (typeof data.message != 'undefined') {
                        FatEvent.showPopupMessage(data.message);
                    }
                }
            },
            error: function () {
                FatEvent.closeLoading(self);
                FatEvent.isProcess = 0;
            }
        });
    };

    $(document).ready(function () {
        FatEvent.init();

        $(window).scroll(function () {
            $('.fat-event-container.has-animation').each(function () {
                FatEvent.initAppearScroll($(this));
            });
            FatEvent.initInfiniteScroll();
        });

        $('.vc_tta-tabs-list .vc_tta-tab > a').on('click', function () {
            setTimeout(function () {
                FatEvent.init();
            }, 500);
        });

        $(document).on('tg_init_popup_detail', function () {
            FatEvent.initPopupDetail();
        });

        $(document).on('fat_event_register_view_detail', function () {
            FatEvent.initPopupDetail();
        });

        if ($('div#hook_main_wrapper').length > 0) {
            $('div#hook_main_wrapper').addClass('hook_forced_menu');
        }

    });
})(jQuery);