function fat_event_init_google_map(){
    jQuery('.fat-event-popup-inner').each(function(){
        var map_wrap = jQuery(this),
            map = jQuery('.fat-google-map',map_wrap),
            latitude_X = 51.491676 ,
            latitude_Y = -0.167660,
            map_type = 'roadmap',
            zoom = 15,
            search = jQuery('input.search-box', map_wrap),
            input_location = jQuery('.fat-google-map-location',map_wrap);

        var mapCenter = new google.maps.LatLng(
            latitude_X =='' ? 51.491676 : latitude_X,
            latitude_Y=='' ? -0.167660 : latitude_Y
        );

        var google_map = new google.maps.Map(map[0], {
            center: mapCenter,
            zoom: zoom,
            mapTypeId: map_type
        });

        google.maps.event.addDomListener(window, "resize", function() {
            var center = google_map.getCenter();
            google.maps.event.trigger(map, "resize");
            google_map.setCenter(center);
        });

        if(latitude_X!='' && latitude_Y!=''){
            var map_marker = new google.maps.Marker({
                position: new google.maps.LatLng(latitude_X, latitude_Y),
                draggable:true,
                animation: google.maps.Animation.DROP,
            });
            map_marker.setMap(google_map);

            google.maps.event.addListener(map_marker, 'dragend', function(map_marker){
                var latLng = map_marker.latLng;
                input_location.val(latLng.lat() + ',' + latLng.lng());
            });
        }

        search = search[0];
        var searchBox = new google.maps.places.SearchBox(search);
        google_map.controls[google.maps.ControlPosition.TOP_LEFT].push(search);

        // Bias the SearchBox results towards current map's viewport.
        google_map.addListener('bounds_changed', function() {
            searchBox.setBounds(google_map.getBounds());
        });

        var markers = [];

        // Listen for the event fired when the user selects a prediction and retrieve
        // more details for that place.
        searchBox.addListener('places_changed', function() {
            var places = searchBox.getPlaces();

            if (places.length == 0) {
                return;
            }

            // Clear out the old markers.
            markers.forEach(function(marker) {
                marker.setMap(null);
            });
            markers = [];

            // For each place, get the icon, name and location.
            var bounds = new google.maps.LatLngBounds();
            places.forEach(function(place) {
                if (!place.geometry) {
                    return;
                }
                var icon = {
                    size: new google.maps.Size(71, 71),
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(17, 34),
                    scaledSize: new google.maps.Size(25, 25)
                };

                // Create a marker for each place.
                var new_marker = new google.maps.Marker({
                    map: google_map,
                    icon: icon,
                    title: place.name,
                    draggable:true,
                    animation: google.maps.Animation.DROP,
                    position: place.geometry.location
                });
                markers.push(new_marker);

                google.maps.event.addListener(new_marker, 'dragend', function(new_marker){
                    var latLng = new_marker.latLng;
                    input_location.val(latLng.lat() + ',' + latLng.lng());
                });

                if (place.geometry.viewport) {
                    // Only geocodes have viewport.
                    bounds.union(place.geometry.viewport);
                } else {
                    bounds.extend(place.geometry.location);
                }
                input_location.val(place.geometry.location.lat() + ',' + place.geometry.location.lng());
            });
            google_map.fitBounds(bounds);
        });
    })
}

function fat_event_init_mapbox(){
    jQuery('.fat-event-popup-inner .fat-mapbox-wrap').each(function(){
        var container = $(this);
        if(typeof mapboxgl !='undefined'){
            var elm_map = $('.fat-mapbox',container),
                access_token = elm_map.attr('data-access-token'),
                latitude_x = -79.4512,
                latitude_y = 43.6568,
                zoom = 13;
            mapboxgl.accessToken = access_token;
            var map = new mapboxgl.Map({
                container: elm_map.attr('id'),
                style: 'mapbox://styles/mapbox/streets-v11',
                center: [latitude_x, latitude_y],
                zoom: zoom
            });

            var marker = new mapboxgl.Marker({
                draggable: true
            }).setLngLat([latitude_x, latitude_y]).addTo(map);

            marker.on('dragend', function(){
                var lngLat = marker.getLngLat();
                $('input#location_map','.fat-event-location-popup').val(lngLat.lng+',' + lngLat.lat);
            });

            var geocoder = new MapboxGeocoder({
                accessToken: mapboxgl.accessToken,
                mapboxgl: mapboxgl,
                marker: false
            });

            map.addControl(geocoder);
            map.addControl(new mapboxgl.NavigationControl());
            map.on('load', function() {
                geocoder.on('result', function(ev) {
                    var coordinates = ev.result.geometry.coordinates;
                    if(coordinates.length ==2){
                        var marker = new mapboxgl.Marker({
                            draggable: true
                        }).setLngLat([coordinates[0], coordinates[1]]).addTo(map);

                        marker.on('dragend', function(){
                            var lngLat = marker.getLngLat();
                            $('input#location_map','.fat-event-location-popup').val(lngLat.lng+',' + lngLat.lat);
                        });

                        $('input#location_map','.fat-event-location-popup').val(coordinates[0] +',' + coordinates[1]);
                    }
                });
                /* geocoder.options.marker.on('dragend', function(){
                     var lngLat = marker.getLngLat();
                     console.log(lngLat);
                     $('input.fat-mapbox-location',container).val(lngLat.lng+',' + lngLat.lat);
                 });*/
            });

            /*map.on('click', function (e) {
                //clear current marker
                if (map_markers!==null) {
                    for (var i = map_markers.length - 1; i >= 0; i--) {
                        map_markers[i].remove();
                    }
                }
                var marker = new mapboxgl.Marker({
                    draggable: true
                }).setLngLat([e.lngLat.lng, e.lngLat.lat]).addTo(map);

                map_markers.push(marker);
            });*/
        }
    });
}

jQuery(function ($) {
    'use strict';
    var $fat_event_dropdown;
    function fat_event_register_close_popup(){
        $('a.fat-close-popup, a.fat-bt-cancel').off('click').on('click',function(event){
            event.preventDefault();
            $('body > .fat-event-popup-modal').remove();
            $('body').removeClass('fat-event-modal-open');
            if(typeof $fat_event_dropdown!='undefined'){
                $fat_event_dropdown[0].selectize.setValue('hide');
            }
            return false;
        })
    }

    function fat_event_delete_image(){
        var $image_id = 0,
            $container,
            input_id;
        $('.fat-add-single-image-wrap').each(function(){
            $('a.fat-delete-single-image', this).off('click').on('click',function(){
                $container = $(this).closest('.fat-add-single-image-wrap');
                $image_id = $(this).attr('data-id');
                input_id =  $(this).closest('.fat-list-image').attr('data-input-id');
                $('.fat-image-thumb[data-id="' + $image_id +'"]',$container).remove();
                $('#' + input_id, $container).val('');
            });
        });
    }

    function fat_event_choose_image(){
        $('a.fat-add-single-image', '.fat-event-popup-inner').off('click').on('click', function (event) {
            event.preventDefault();

            wp.media.frames.gk_frame = wp.media({
                title: 'Select Image',
                multiple: false,
                library: {
                    type: 'image'
                }
            });
            wp.media.frames.gk_frame.clicked_button = $(this);
            wp.media.frames.gk_frame.open().on('select', function (e) {
                var img_url,
                    img_full_url,
                    img_id,
                    parent,
                    image,
                    input_id,
                    selection_image = wp.media.frames.gk_frame.state().get('selection');

                input_id =  $(wp.media.frames.gk_frame.clicked_button).attr('data-input-id');
                selection_image.each(function (attachment) {
                    image = '<div class="fat-image-thumb" data-id="%id" ><img src="%thumbnail" /><div class="fat-overlay fat-transition-30"><span><a class="fat-delete-single-image" data-id="%id" href="javascript:;"><i class="dashicons dashicons-no-alt"></i></a></span></div></div>';
                    if(typeof attachment.attributes.sizes.thumbnail != 'undefined'){
                        img_url = attachment.attributes.sizes.thumbnail.url;
                    }else{
                        img_url = attachment.attributes.url;
                    }
                    img_id = attachment.attributes.id;
                    parent = $(wp.media.frames.gk_frame.clicked_button).closest('.fat-add-single-image-wrap');
                    image = image.replace("%thumbnail",img_url);
                    image = image.replace(/%id/g,img_id);

                    if($('[data-id="' + img_id + '"]', parent).length<=0){
                        $('.fat-list-image',parent).empty();
                        $('.fat-list-image',parent).append(image);
                    }

                });
                fat_event_delete_image();
                $('#' + input_id, parent).val(img_id);
            });
        })
    }

    function fat_event_show_loading(){
        $('body > .fat-event-loading').remove();
        var loading = $('<div class="fat-event-loading"><div class="fat-event-loading-inner"><i class="fa fa-spinner fa-spin"></i></div></div>');
        $('body').append(loading);
    }

    function fat_event_close_loading(){
        $('body > .fat-event-loading').remove();
    }

    function fat_event_add_location(){
        $('a.fat-bt-save','.fat-event-location-popup').off('click').on('click',function(event){
            event.preventDefault();
            var container = $(this).closest('.fat-event-location-popup'),
                name = $('#location_name',container).val(),
                address = $('#location_address',container).val(),
                location = $('#location_map',container).val(),
                thumbnail = $('#thumbnail',container).val();

            if(name=='' || address==''){
                alert('Please input Name and Address');
            }else{
                fat_event_show_loading();
                $.ajax({
                    url: fat_event_data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'fat_event_save_location',
                        name: name,
                        address: address,
                        location: location,
                        thumbnail: thumbnail
                    }),
                    success: function (data) {
                        fat_event_close_loading();
                        var $data = JSON.parse(data);
                        if($data.result > 0){
                            if(typeof $fat_event_dropdown!='undefined'){
                                $fat_event_dropdown[0].selectize.destroy();
                                $fat_event_dropdown.append('<option value="' + $data.result + '">' + name + '</option>');
                                $fat_event_dropdown.selectize({
                                    plugins: ['remove_button', 'drag_drop'],
                                    searchField: 'text',
                                    delimiter: ',',
                                    persist: false
                                });
                                $fat_event_dropdown[0].selectize.addOption({value:$data.result,text:name});
                                $fat_event_dropdown[0].selectize.setValue($data.result);
                                $('.fat-cmb-select',$fat_event_dropdown.closest('.fat-cmb-select-wrap')).css('opacity',1);
                            }
                            $('body > .fat-event-popup-modal').remove();
                        }else{
                            alert($data.message);
                        }
                    },
                    error: function () {
                        fat_event_close_loading();
                    }
                });
            }
            return false;
        })
    }

    function fat_event_add_organizer(){
        $('a.fat-bt-save','.fat-event-organizer-popup').off('click').on('click',function(event){
            event.preventDefault();
            var container = $(this).closest('.fat-event-organizer-popup'),
                name = $('#name',container).val(),
                telephone = $('#telephone',container).val(),
                website = $('#website',container).val(),
                email = $('#email',container).val(),
                facebook = $('#facebook',container).val(),
                twitter = $('#twitter',container).val(),
                linkedin = $('#linkedin',container).val(),
                thumbnail = $('#thumbnail',container).val();

            if(name==''){
                alert('Please input Name');
            }else{
                fat_event_show_loading();
                $.ajax({
                    url: fat_event_data.ajax_url,
                    type: 'POST',
                    data: ({
                        action: 'fat_event_save_organizer',
                        name: name,
                        telephone: telephone,
                        website: website,
                        email: email,
                        facebook: facebook,
                        twitter: twitter,
                        linkedin: linkedin,
                        thumbnail: thumbnail
                    }),
                    success: function (data) {
                        fat_event_close_loading();
                        var $data = JSON.parse(data);
                        if($data.result > 0){
                            if(typeof $fat_event_dropdown!='undefined'){
                                $fat_event_dropdown[0].selectize.destroy();
                                $fat_event_dropdown.append('<option value="' + $data.result + '">' + name + '</option>');
                                $fat_event_dropdown.selectize({
                                    plugins: ['remove_button', 'drag_drop'],
                                    searchField: 'text',
                                    delimiter: ',',
                                    persist: false
                                });
                                $fat_event_dropdown[0].selectize.addOption({value:$data.result,text:name});
                                $fat_event_dropdown[0].selectize.setValue($data.result);
                                $('.fat-cmb-select',$fat_event_dropdown.closest('.fat-cmb-select-wrap')).css('opacity',1);
                            }

                            $('select[data-field-id="other_organizer"]')[0].selectize.addOption({value:$data.result,text:name});
                            $('body > .fat-event-popup-modal').remove();
                        }else{
                            alert($data.message);
                        }

                    },
                    error: function () {
                        fat_event_close_loading();
                    }
                });
            }
            return false;
        })
    }

    function fat_event_depend_by_layout(){
        var $layout = $('select[data-field-id="layout"]').val(),
            $data_from = $('select[data-field-id="data_from"]').val();

        if($layout == 'countdown'){
            $('.fat-cmb-tab-settings-nav > li a[data-tab="tab-filter"]').closest('li').addClass('disable');
        }
        if($layout == 'countdown' || $layout == 'map'){
            $('#fat-mb-shortcode-search').hide();
        }
        if($data_from== 'event_id'){
            $('#fat-mb-shortcode-search').hide();
        }

        $('select[data-field-id="layout"]').on('change',function(){
            if($(this).val()== 'countdown'){
                $('.fat-cmb-tab-settings-nav > li a[data-tab="tab-filter"]').closest('li').addClass('disable');
                $('#fat-mb-shortcode-search').hide();
            }else{
                $('.fat-cmb-tab-settings-nav > li a[data-tab="tab-filter"]').closest('li').removeClass('disable');
                if($(this).val()== 'map'){
                    $('#fat-mb-shortcode-search').hide();
                }else{
                    $('#fat-mb-shortcode-search').show();
                }
            }
        });

        $('select[data-field-id="data_from"]').on('change',function(){
            if($(this).val()== 'event_id'){
                $('#fat-mb-shortcode-search').hide();
            }else{
                if($layout != 'countdown' && $layout != 'map'){
                    $('#fat-mb-shortcode-search').show();
                }
            }
        });
    }

    function fat_event_validate(){
        $('input[type="submit"]','body.post-type-fat-event #publishing-action').on('click',function(event){
            var start_date = $('input[data-field-id="start_date"]'),
                end_date = $('input[data-field-id="end_date"]'),
                event_repeating = $('input#event_repeating_1'),
                repeat = $('select[data-field-id="repeat"]'),
                repeat_interval = $('input[data-field-id="daily_interval"]'),
                is_valid = true,
                message = '';

            if(start_date.val()=='' || typeof start_date.val()=='undefined' || end_date.val()=='' || typeof  end_date.val()=='undefined'){
                if(start_date.val()=='' || typeof start_date.val()=='undefined'){
                    start_date.focus();
                }
                if(end_date.val()=='' || typeof end_date.val()=='undefined'){
                    end_date.focus();
                }
                is_valid  = false;
                message = 'Please select start date and end date for event';
            }
            if(event_repeating.is(':checked')){
                if(repeat.val()=='daily' && (typeof repeat_interval.val()=='undefined' || repeat_interval.val()=='')){
                    is_valid  = false;
                    message = 'Please select repeat interval for event';
                    repeat_interval.focus();
                }
            }

            if(!is_valid){
                alert(message);
                event.preventDefault();
                return false;
            }
            return true;
        });
    }

    function fat_view_attendees(){
        $('#view_attendees').off('click').on('click',function(event){
            event.preventDefault();
            var event_id = $(this).attr('data-post');
            fat_event_show_loading();
            $.ajax({
                url: fat_event_data.ajax_url,
                type: 'POST',
                data: ({
                    action: 'fat_event_get_attendees',
                    id: event_id
                }),
                success: function (data) {
                    fat_event_close_loading();
                        data = JSON.parse(data);
                        var template = wp.template('fat-event-attendees-template'),
                        slide = $(template(data));

                    $('body').append(slide);
                    setTimeout(function(){
                        slide.addClass('show-up');

                        $('a.fat-event-export-excel').off('click').on('click',function(event){
                            event.preventDefault();
                            var csv = [],
                                rows = document.querySelectorAll(".fat-event-slide-modal table tr"),
                                row = [],
                                cols = [],
                                csvFile,
                                downloadLink;

                            for (var i = 0; i < rows.length; i++) {
                                row = [], cols = rows[i].querySelectorAll("td, th");

                                for (var j = 0; j < cols.length; j++)
                                    row.push(cols[j].innerText.replace(/,/g,' '));

                                csv.push(row.join(","));
                            }
                            csv = csv.join("\n");
                            csvFile = new Blob([csv], {type: "text/csv"});

                            // Download link
                            downloadLink = document.createElement("a");

                            // File name
                            downloadLink.download = 'fat_event_attendees_' + event_id+'.csv';

                            // Create a link to the file
                            downloadLink.href = window.URL.createObjectURL(csvFile);

                            // Hide download link
                            downloadLink.style.display = "none";

                            // Add the link to DOM
                            document.body.appendChild(downloadLink);
                            downloadLink.click();
                            return false;
                        });
                    },200);

                    $('.fat-close-slide').off('click').on('click',function(e){
                        e.preventDefault();
                        $('.fat-event-slide-modal').removeClass('show-up');
                        setTimeout(function(){
                           $('.fat-event-slide-modal').remove();
                        },1000);
                        return false;
                    });


                },
                error: function () {
                    fat_event_close_loading();
                }
            });

            return false;
        });
    }

    function fat_event_create_booking(){
        $('body.post-type-fat-event-booking #wpbody-content a.page-title-action').off('click').on('click',function(event){
            event.preventDefault();
            var template = wp.template('fat-event-popup-booking-template'),
                popup = '',
                events = fat_event_data.events,
                e_id = 0;

            popup = $(template([]));

            for(let ev of events){
                $('select#optEvent', popup).append('<option value="' + ev.id +'">' + ev.title + '</option>');
            }

            $('select#optEvent', popup).on('change',function(){
                $('select#optEventDate option', popup).remove();
                var e_id = parseInt($('select#optEvent', popup).val()),
                    event_info = _.findWhere(fat_event_data.events, {id: e_id}),
                    dates = fat_event_data.events_date[e_id];

                for(let dt of dates){
                    dt = dt.split(';');
                    $('select#optEventDate', popup).append('<option value="' + dt[1] + ';' + dt[2] +'">' + dt[0] + '</option>');
                }

                if(event_info.fees_type=='ticket_class'){
                    $('.fat-event-ticket-class-info', popup).removeClass('fat-hidden-field');
                    $('.fat-event-quantity-info,.fat-event-fees-info',popup).addClass('fat-popup-field-ticket-class-size');
                    $('select#optTicketClass option', popup).remove();
                    for(var $i=0; $i< event_info.ticket_class.class.length; $i++){
                        $('select#optTicketClass', popup).append('<option value="' + event_info.ticket_class.class_id[$i] +'" data-fees="' + event_info.ticket_class.fees[$i] +'">' + event_info.ticket_class.class[$i] + ' ($' + event_info.ticket_class.fees[$i] + ')</option>');
                    }
                    $('select#optTicketClass', popup).trigger('change');
                }else{
                    $('.fat-event-ticket-class-info').addClass('fat-hidden-field');
                    $('.fat-event-quantity-info,.fat-event-fees-info',popup).removeClass('fat-popup-field-ticket-class-size');
                    fat_init_total_fees(popup);
                }

                if(event_info.fees_type=='package'){
                    $('.fat-event-package-quantity-info', popup).removeClass('fat-hidden-field');
                    $('.fat-event-quantity-info,.fat-event-fees-info', popup).addClass('fat-hidden-field');
                    for(var $i=0; $i < event_info.fees_package.fees.length; $i++){
                        $('select#optPackageQuantity', popup).append('<option value="' + event_info.fees_package.quantity[$i] +'">' + event_info.fees_package.quantity[$i] + ' ($' + event_info.fees_package.fees[$i] + ')</option>');
                    }
                }else{
                    $('.fat-event-package-quantity-info', popup).addClass('fat-hidden-field');
                    $('.fat-event-quantity-info,.fat-event-fees-info', popup).removeClass('fat-hidden-field');
                }

            });

            $('select#optTicketClass', popup).on('change',function(){
                fat_init_total_fees(popup);

            });

            $('#numQuantity', popup).on('change',function(){
                fat_init_total_fees(popup);
            });

            $('select#optEvent', popup).trigger('change');

            if ($.isFunction($.fn.selectize)) {
                $('#optCountry, #optLocation, #optEvent', popup).selectize({
                    plugins: ['remove_button', 'drag_drop'],
                    searchField: 'text',
                    delimiter: ',',
                    persist: false
                });
            }

            $('body .fat-event-popup-modal.booking-popup').remove();
            $('body').append(popup);

            $('.fat-event-popup-modal.booking-popup a.fat-close-popup,.fat-event-popup-modal.booking-popup a.fat-popup-bt-cancel').on('click', function () {
                $('body .fat-event-popup-modal.booking-popup').remove();
                $('body').removeClass('hide-overflow');
            });

            $('.fat-popup-bt-submit', popup).off('click').on('click',function(){
                fat_submit_booking(popup, this);
            });

            return false;
        })
    }

    function fat_init_total_fees(popup){
        var e_id = parseInt($('select#optEvent', popup).val()),
            fees = 0,
            quantity = $('#numQuantity', popup).val(),
            event_info = _.findWhere(fat_event_data.events, {id: e_id}),
            total_fees = 0;

        if(event_info.fees_type=='ticket_class'){
            var ticket_id =  $('select#optTicketClass', popup).val();
            fees = $('select#optTicketClass option[value="' + ticket_id +'"]', popup).attr('data-fees');
            total_fees = fees * quantity;
        }
        if(event_info.fees_type=='fixed'){
            fees = event_info.fees;
            total_fees = fees * quantity;
        }

        fees = parseFloat(fees);
        popup.attr('data-fees', fees);
        $('.fat-event-fees', popup).text(fees);
        $('.fat-event-total-fees', popup).text(total_fees);
    }

    function fat_submit_booking(popup, elm){
        var isValid = fat_validate_form(popup);
        if(isValid){
            var firstName = $('#txtFirstName',popup).val(),
                lastName = $('#txtLastName',popup).val(),
                gender = $('#optGender', popup).val(),
                phone = $('#txtPhone',popup).val(),
                email = $('#txtEmail', popup).val(),
                department = $('#txtDepartment', popup).val(),
                address = $('#txtAddress', popup).val(),
                company = $('#txtCompany', popup).val(),
                country = $('#optCountry', popup).val(),
                note = $('#txtNote', popup).val(),
                quantity = $('#numQuantity', popup).val(),
                fees = popup.attr('data-fees', fees),
                start_date = $('#optEventDate', popup).val().split(';')[0],
                end_date = $('#optEventDate', popup).val().split(';')[1],
                ticket_class = $('#optTicketClass', popup).length > 0 ? $('#optTicketClass', popup).val(): '',
                id = $('#optEvent').val()

            fat_show_loading($('body'), elm);
            $('.fat-popup-error-message', popup).addClass('fat-hidden-field');
            $.ajax({
                url: fat_event_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'fat_event_add_booking',
                    id: id,
                    firstName: firstName,
                    lastName: lastName,
                    phone: phone,
                    email: email,
                    quantity: quantity,
                    note: note,
                    address: address,
                    gender: gender,
                    department: department,
                    company: company,
                    country: country,
                    start_date: start_date,
                    end_date: end_date,
                    ticket_class: ticket_class,
                },
                success: function (data) {
                    data = $.parseJSON(data);
                    fat_close_loading($('body'), elm);
                    if (data.code > 0) {
                        $.ajax({
                            url: fat_event_data.ajax_url,
                            type: 'POST',
                            data: ({
                                action: 'fat_event_booking_sendmail',
                                id: data.code,
                            })
                        });

                        $('body .fat-event-popup-modal.booking-popup').remove();
                        $('body').removeClass('hide-overflow');
                        if(typeof data.message != 'undefined'){
                            fat_show_message(data.message);
                        }
                        window.location.reload();
                    } else {
                        $('.fat-popup-error-message', popup).empty().removeClass('fat-hidden-field').append(data.message + '</br>');
                    }
                },
                error: function () {
                    fat_close_loading($('body'), elm);
                }
            });

        }
    }

    function fat_validate_form(popup){
        var isValid = true;
        $('input[required]', popup).each(function () {
            var input = $(this),
                message = input.attr('data-error');
            if (input.val().trim() == '') {
                input.closest('.fat-popup-field').addClass('field-error');
                isValid = false;
            } else {
                input.closest('.fat-popup-field').removeClass('field-error');
            }
        });
        $('input[type="email"]', popup).each(function () {
            var input = $(this),
                pattern = new RegExp(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/),
                email = input.val().trim();
            if(email != '' && !pattern.test(email)){
                input.closest('.fat-popup-field').addClass('field-error');
                isValid = false;
            }else{
                input.closest('.fat-popup-field').removeClass('field-error');
            }
        });

        return isValid;
    }

    function fat_show_loading(container, elm){
        $('.fat-loading-container', container).remove();
        container.append('<div class="fat-loading-container"></div>');
        $(elm).addClass('loading');
    }

    function fat_close_loading(container, elm){
        $('.fat-loading-container', container).remove();
        $(elm).removeClass('loading');
    }

    function fat_show_message(message, type) {
        var css_class = typeof type == 'undefined' || type == '1' ? 'blue' : 'red',  //1:success message, 2: error message
            icon = typeof type == 'undefined' || type == '1' ? 'fa fa-info-circle' : 'fa fa-times-circle';

        css_class = type =='3' ? 'orange' : css_class;

        var elm_message = '<div class="fat-sb-message ' + css_class + '">';
        elm_message += typeof icon != 'undefined' && icon != '' ? '<i class="' + icon + '"></i> ' : ' ';
        elm_message += '<span>' + message + '</span>';
        elm_message += '</div>';
        elm_message = $(elm_message);
        var top = ($('body .fat-sb-message').length * 60 + 50) + 'px';
        $(elm_message).css('top', top);
        $('body').append(elm_message);
        setTimeout(function () {
            $(elm_message).addClass('show-up');
            setTimeout(function () {
                $(elm_message).removeClass('show-up');
                setTimeout(function () {
                    $(elm_message).remove();
                }, 300);
            }, 4000);
        }, 200);

    }

    function fat_init_duplicate_event(){
        $('body.post-type-fat-event a.fat-event-duplicate').off('click').on('click',function(event){
            var self = $(this),
                event_id = self.attr('data-id');

            event.preventDefault();

            fat_show_loading($('body'), self);
            $.ajax({
                url: fat_event_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'fat_event_duplicate',
                    id: event_id,
                },
                success: function (data) {
                    data = $.parseJSON(data);
                    fat_close_loading($('body'), self);
                    if (data.code > 0) {
                        if(typeof data.message != 'undefined'){
                            fat_show_message(data.message);
                        }
                        window.location.reload();
                    } else {
                        if(typeof data.message != 'undefined'){
                            fat_show_message(data.message, 3);
                        }
                    }
                },
                error: function () {
                    fat_close_loading($('body'), self);
                }
            });

            return false;
        })
    }
    
    $(document).ready(function () {
        $('select[data-field-id="location"]').on('change',function(){
           if($(this).val()== 'add_new'){
               var popup_template = wp.template('fat-event-location-template'),
                   popup = $(popup_template({}));

               $fat_event_dropdown = $(this);
               $('body > .fat-event-popup-modal').remove();
               $('body').append(popup);
               $('body').addClass('fat-event-modal-open');
               setTimeout(function(){
                   if($('.fat-event-popup-modal .fat-google-map').length > 0){
                       fat_event_init_google_map();
                   }
                   if($('.fat-event-popup-modal .fat-mapbox').length > 0){
                       fat_event_init_mapbox();
                   }

                   fat_event_choose_image();
               },500);
               fat_event_register_close_popup();
               fat_event_add_location();
           }
        });

        $('select[data-field-id="main_organizer"],select[data-field-id="organizer"]').on('change',function(){
            if($(this).val()== 'add_new'){
                var popup_template = wp.template('fat-event-organizer-template'),
                    popup = $(popup_template({}));

                $fat_event_dropdown = $(this);
                $('body > .fat-event-popup-modal').remove();
                $('body').append(popup);
                $('body').addClass('fat-event-modal-open');
                setTimeout(function(){
                    fat_event_choose_image();
                },500);
                fat_event_register_close_popup();
                fat_event_add_organizer();
            }
        });

        fat_event_depend_by_layout();
        $(document).on('extra_depend_field',function(){
            fat_event_depend_by_layout();
        });

        fat_event_validate();

        fat_view_attendees();

        fat_event_create_booking();

        fat_init_duplicate_event();

        setTimeout(function(){
            $('#fat-mb-event-detail .ui-sortable-handle').off('click');
        },1000);

        /** change place holder in coupon page */
        $('#postexcerpt .inside p','body.post-type-fat-coupon #poststuff').hide();
        $('label#title-prompt-text','body.post-type-fat-coupon #poststuff').html('Enter coupon code');

        /** init selectize in list booking screen */
        if ($.isFunction($.fn.selectize)){
            $('.fat-selectize').selectize({
                plugins: ['remove_button', 'drag_drop'],
                searchField: 'text',
                delimiter: ',',
                persist: false
            });
        }
    });
});