"use strict";
(function ($) {
    var FatFormBuilder = new function () {
        this.init = function () {
            var formData = $('.fat-form-builder').attr('data-form');
            console.log(formData);
            var options = {
                typeUserAttrs: {
                    text: {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        mapField: {
                            label: 'Map field',
                            options: {
                                'none': 'No map',
                                'first_name': 'First name',
                                'last_name': 'Last name',
                                'phone': 'Phone',
                                'email': 'Email',
                                'department': 'Department',
                                'company': 'Company',
                                'note': 'Note',
                                'address': 'Address',
                                'house_number': 'House number',
                                'postal_code': 'Postal code'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please input value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    textarea: {
                        mapField: {
                            label: 'Map field',
                            options: {
                                'none': 'No map',
                                'note': 'Note',
                                'special': 'Special',
                                'expectations': 'Expectations',
                                'previous_knowledge': 'Previous Knowledge'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please input value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    date: {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        dataLocale: {
                            label: 'Locale',
                            options: {
                                'en': 'English',
                                'ar': 'Arabic',
                                'ro': 'Romanian',
                                'id': 'Indonesian',
                                'is': 'Icelandic',
                                'bg': 'Bulgarian',
                                'fa': 'Persian, Farsi',
                                'ru': 'Russian',
                                'uk': 'Ukrainian',
                                'el': 'Ελληνικά',
                                'de': 'German',
                                'nl': 'Dutch',
                                'tr': 'Turkish',
                                'fr': 'French',
                                'es': 'Spanish',
                                'th': 'Thailand',
                                'pl': 'Polish',
                                'pt': 'Portuguese',
                                'ch': 'Chinese',
                                'se': 'Swedish',
                                'kr': 'Korean',
                                'it': 'Italian',
                                'da': 'Dansk',
                                'no': 'Norwegian',
                                'ja': 'Japanese',
                                'vi': 'Vietnamese',
                                'sl': 'Slovenščina',
                                'cs': 'Čeština',
                                'pt-BR': 'Português(Brasil)'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please input value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    paragraph: {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    number: {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please input value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    select: {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        mapField: {
                            label: 'Map field',
                            options: {
                                'none': 'No map',
                                'gender': 'Gender',
                                'country': 'Country',
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please input value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    'radio-group': {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please select value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    },
                    'checkbox-group': {
                        dataWidth: {
                            label: 'Width',
                            options: {
                                'full-size': 'Full size',
                                'fat-popup-field-half-size': 'Half size'
                            }
                        },
                        dataErrorMessage: {
                            label: 'Error message',
                            value: 'Please select value for this field'
                        },
                        dataPosition: {
                            label: 'Position',
                            options: {
                                'default': 'Default',
                                'bottom': 'Bottom of form'
                            }
                        }
                    }
                },
                controlOrder: [
                    'text',
                    'textarea',
                    'select',
                    'radio-group',
                    'checkbox-group',
                    'number',
                    'date'
                ],
                dataType: 'json'
            };
            if (formData != '[]') {
                try{
                   var data =   $.parseJSON(formData);
                    options['formData'] = formData;
                }catch(ex){}
            }
            var formBuilder = $('.fat-form-builder').formBuilder(options);
            formBuilder.promise.then(function (fb) {
                $('.fat-form-builder .btn-group .btn.save-template').on('click', function () {
                    //if(formBuilder.formData!='[]'){

                    var isMapFistName = false,
                        isMapLastName = false,
                        isMapEmail = false,
                        fields = JSON.parse(formBuilder.formData);

                    for (var $i = 0; $i < fields.length; $i++) {
                        if (fields[$i].mapField == 'first_name') {
                            isMapFistName = true;
                        }
                        if (fields[$i].mapField == 'last_name') {
                            isMapLastName = true;
                        }
                        if (fields[$i].mapField == 'email') {
                            isMapEmail = true;
                        }
                    }

                    if (!isMapFistName || !isMapLastName || !isMapEmail) {
                        FatFormBuilder.showMessage('Please map field for first name, last name and email before save form', 'error-message');
                        return;
                    }

                    FatFormBuilder.showLoading();
                    $.ajax({
                        url: fat_event_data.ajax_url,
                        type: 'POST',
                        data: ({
                            action: 'fat_event_save_booking_form',
                            form: formBuilder.formData,
                        }),
                        success: function (data) {
                            FatFormBuilder.closeLoading();
                            var $data = JSON.parse(data);
                            FatFormBuilder.showMessage($data.message);
                        },
                        error: function () {
                            FatFormBuilder.closeLoading();
                            FatFormBuilder.showMessage($data.message, 'error-message');
                        }
                    });
                    /* }else{
                         FatFormBuilder.showMessage('Please add field before save form');
                     }*/
                });
            });
        };
        this.showLoading = function () {
            $('body > .fat-event-loading').remove();
            var loading = $('<div class="fat-event-loading"><div class="fat-event-loading-inner"><i class="fa fa-spinner fa-spin"></i></div></div>');
            $('body').append(loading);
        };

        this.showMessage = function (message, $css_class) {
            $css_class = typeof $css_class != 'undefined' ? $css_class : '';

            var elm_message = $('<div class="fat-event-message ' + $css_class + '">' + message + '</div>');
            $('body').append(elm_message);
            setTimeout(function () {
                $(elm_message).addClass('show-up');
                setTimeout(function () {
                    $(elm_message).removeClass('show-up');
                    setTimeout(function () {
                        $(elm_message).remove();
                    }, 300);
                }, 4000);
            }, 200);
        };

        this.closeLoading = function () {
            $('body > .fat-event-loading').remove();
        }
    };

    $(document).ready(function () {
        FatFormBuilder.init();
    });
})(jQuery);