<?php
/**
 * Created by PhpStorm.
 * User: PhuongTH
 * Date: 10/15/2018
 * Time: 8:39 AM
 */
if (!class_exists('FAT_Event_REST_Controller')) {
    class FAT_Event_REST_Controller{
        public function __construct()
        {
            //wp-json/fat-event/v1
            $this->namespace     = '/fat-event/v1';
            $this->resource_name = 'get_all_location';
        }

        // Register our routes.
        public function register_routes() {
            register_rest_route( $this->namespace, '/' . $this->resource_name, array(
                // Here we register the readable endpoint for collections.
                array(
                    'methods'   => 'GET',
                    'callback'  => array( $this, 'get_all_location' ),
                ),
            ) );

            register_rest_route( $this->namespace, '/get_all_events', array(
                // Notice how we are registering multiple endpoints the 'schema' equates to an OPTIONS request.
                array(
                    'methods'   => 'GET',
                    'callback'  => array( $this, 'get_all_events' ),
                ),
            ) );
        }

        /**
         * Grabs the five most recent posts and outputs them as a rest response.
         *
         * @param WP_REST_Request $request Current request.
         */
        public function get_all_location( $request ) {
            $terms = get_terms(array(
                'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                'hide_empty' => false
            ));
            $locations = array();
            $loc = $lat = '';
            foreach ($terms as $term) {
                $loc = get_term_meta($term->term_id, 'fat-mb-location-detail', true);
                $lat = isset($loc['map']) ? explode(',',$loc['map']) : array();
                $locations[] = array(
                    'Id' => $term->term_id,
                    'CreateDate' => '',
                    'Name' =>  $term->name,
                    'Latitude' => isset($lat[0]) ? $lat[0] : '',
                    'Longitude' => isset($lat[0]) ? $lat[0] : '',
                    'Location' => isset($loc['map']) ? $loc['map'] : '',
                    'DefaultMapZoomInKilometres' => 30
                );
            }

            // Return all of our comment response data.
            return $locations;
        }

        /**
         * Grabs the five most recent posts and outputs them as a rest response.
         *
         * @param WP_REST_Request $request Current request.
         */
        public function get_all_events( $request ) {
            $terms = get_terms(array(
                'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                'hide_empty' => false
            ));
            $locations = array();



            foreach ($terms as $term) {
                $locations[$term->term_id] = $term->name;
            }

            $start_date = '';
            $shortcode_end_date = '';
            $shortcode_end_date = '';
            $date_format = get_option('date_format');
            $offset = isset($request['offset']) ? $request['offset'] : 0;
            $limit = isset($request['limit']) ? $request['limit'] : 100;
            $sc_open_detail = 'single_window';
            $name = '';
            $tag = '';
            $event_ids = '';
            $categories ='';
            $location_id = isset($request['locationId']) ? $request['locationId'] : '';
            $organizers = '';
            $include_expired_event = 0;

            $args = array(
                'post_type' => FAT_EVENT_POST_TYPE,
                'post_status' => 'publish',
                'nopaging' => true,
                'post_per_page' => -1,
            );


            $args['tax_query'] = array('relation' => 'AND');

            if ($location_id !== '') {
                $args['tax_query'][] = array(
                    'taxonomy' => FAT_EVENT_LOCATION_TAXONOMY,
                    'field' => 'id',
                    'terms' => array($location_id)
                );
            }

            $posts = new WP_Query($args);

            $events = array();
            $opt_date_format = FAT_EVENT_DATETIME_FORMAT;
            $event_start_date = $event_end_date = $repeat = $custom_days = $now = '';
            $post_id = $event_repeat = $repeat_interval = $date_diff = 0;
            $event_detail = array();

            $index = 1;
            $hours_start = $minutes_start = 0;
            $link_detail = '';

            $repeat_number = 1;
            $now = new DateTime($start_date);

            while ($posts->have_posts()) : $posts->the_post();
                $post_id = get_the_ID();
                $event_detail = get_post_meta($post_id, 'fat-mb-event-detail', true);
                $opt_date_format = get_post_meta($post_id, 'opt_date_format', true);

                $event_start_date = get_post_meta($post_id, 'start_date', true);
                $event_start_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_start_date);
                $event_end_date = get_post_meta($post_id, 'end_date', true);
                $event_end_date = DateTime::createFromFormat($opt_date_format . ' H:i', $event_end_date);
                $event_repeat = isset($event_detail['event_repeating'][0]) && $event_detail['event_repeating'][0] == '1' ? true : false;
                $repeat = $event_repeat && isset($event_detail['repeat']) ? $event_detail['repeat'] : '';
                $repeat_interval = isset($event_detail['daily_interval']) && $event_detail['daily_interval'] ? $event_detail['daily_interval'] : 1;
                $repeat_number = isset($event_detail['repeat_event_display']) && $event_detail['repeat_event_display'] ? $event_detail['repeat_event_display'] : $repeat_number;
                $count_repeat_number = 0;
                $start_date_string = '';
                $attachment_id = 0;
                $address= '';

                if (($event_end_date instanceof DateTime) && ($event_start_date instanceof DateTime)) {
                    $date_diff = $event_end_date->diff($event_start_date)->days;

                    if ($repeat === 'custom') {
                        $custom_days = $event_detail['custom_days'];
                        $hours_start = $event_start_date->format('H');
                        $minutes_start = $event_start_date->format('i');

                        if (count($custom_days) > 0) {
                            for ($i = 0; $i < count($custom_days['repeat_on_date']); $i++) {
                                $repeat_on_date = $custom_days['repeat_on_date'][$i];
                                if ($repeat_on_date) {
                                    $repeat_on_date = DateTime::createFromFormat($opt_date_format, $repeat_on_date);
                                    if (!($repeat_on_date instanceof DateTime)) {
                                        break;
                                    }
                                    $repeat_on_date->setTime(0, 0, 0);

                                    if ($repeat_on_date >= $now || $include_expired_event) {
                                        $date_diff = $event_start_date->diff($event_end_date);
                                        $event_start_date = $repeat_on_date->setTime($hours_start, $minutes_start, 0);

                                        $event_end_date = (clone $event_start_date);
                                        $event_end_date = $event_end_date->modify('+' . $date_diff->y . ' year');
                                        $event_end_date = $event_end_date->modify('+' . $date_diff->m . ' month');
                                        $event_end_date = $event_end_date->modify('+' . $date_diff->d . ' day');
                                        $event_end_date = $event_end_date->modify('+' . $date_diff->h . ' hours');
                                        $event_end_date = $event_end_date->modify('+' . $date_diff->i . ' minutes');

                                        $attachment_id = get_post_thumbnail_id( $post_id );
                                        $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                                        $events[] = array(
                                            'Id' => $post_id,
                                            'LocationName' => $locations[$location_id],
                                            'LocationId' => $location_id,
                                            'EventName' => get_the_title($post_id),
                                            'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                            'EventDetail' => get_the_excerpt($post_id),
                                            'StartTime' => $event_start_date->format('U'),
                                            'EndTime' => $event_end_date->format('U'),
                                            'PostDate' => get_the_date('U',$post_id),
                                            'Address' => $address,
                                            'AuthorId' =>  get_the_author_meta('ID')
                                        );
                                        if ($limit !== '' && $limit <= $index) {
                                            break;
                                        }
                                        $index++;
                                    }
                                }
                            }
                        }
                    }

                    $repeat_interval++;
                    $count_repeat_number = 0;
                    if($repeat!=='daily' && $repeat!=='weekly' && $repeat!=='monthly' && $repeat!=='yearly'){
                        if($include_expired_event || $now <= $event_start_date || ($now >= $event_start_date && $now <= $event_end_date)){
                            $attachment_id = get_post_thumbnail_id( $post_id );
                            $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                            $events[] = array(
                                'Id' => $post_id,
                                'LocationName' => $locations[$location_id],
                                'LocationId' => $location_id,
                                'EventName' => get_the_title($post_id),
                                'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                'EventDetail' => get_the_excerpt($post_id),
                                'StartTime' => $event_start_date->format('U'),
                                'EndTime' => $event_end_date->format('U'),
                                'PostDate' => get_the_date('U',$post_id),
                                'Address' => $address,
                                'AuthorId' =>  get_the_author_meta('ID')
                            );
                        }
                    }

                    if ($repeat === 'daily') {
                        do{
                            if($include_expired_event || $now < $event_start_date || $now < $event_end_date ){
                                $attachment_id = get_post_thumbnail_id( $post_id );
                                $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                                $events[] = array(
                                    'Id' => $post_id,
                                    'LocationName' => $locations[$location_id],
                                    'LocationId' => $location_id,
                                    'EventName' => get_the_title($post_id),
                                    'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                    'EventDetail' => get_the_excerpt($post_id),
                                    'StartTime' => $event_start_date->format('U'),
                                    'EndTime' => $event_end_date->format('U'),
                                    'PostDate' => get_the_date('U',$post_id),
                                    'Address' => $address,
                                    'AuthorId' =>  get_the_author_meta('ID')
                                );
                                if( $now < $event_start_date || $now < $event_end_date){
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y '). $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+' . $repeat_interval . ' day');
                            $event_end_date = $event_end_date->modify('+' . ($repeat_interval + $date_diff) . ' day');

                        }while($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }
                    if ($repeat === 'weekly') {
                        do{
                            if($include_expired_event || $now < $event_start_date || $now < $event_end_date ){
                                $attachment_id = get_post_thumbnail_id( $post_id );
                                $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                                $events[] = array(
                                    'Id' => $post_id,
                                    'LocationName' => $locations[$location_id],
                                    'LocationId' => $location_id,
                                    'EventName' => get_the_title($post_id),
                                    'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                    'EventDetail' => get_the_excerpt($post_id),
                                    'StartTime' => $event_start_date->format('U'),
                                    'EndTime' => $event_end_date->format('U'),
                                    'PostDate' => get_the_date('U',$post_id),
                                    'Address' => $address,
                                    'AuthorId' =>  get_the_author_meta('ID')
                                );
                                if( $now < $event_start_date || $now < $event_end_date){
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y '). $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+7 day');
                            $event_end_date = $event_end_date->modify('+7 day');

                        }while($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }
                    if ($repeat === 'monthly') {
                        do{
                            if($include_expired_event || $now < $event_start_date || $now < $event_end_date ){
                                $attachment_id = get_post_thumbnail_id( $post_id );
                                $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                                $events[] = array(
                                    'Id' => $post_id,
                                    'LocationName' => $locations[$location_id],
                                    'LocationId' => $location_id,
                                    'EventName' => get_the_title($post_id),
                                    'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                    'EventDetail' => get_the_excerpt($post_id),
                                    'StartTime' => $event_start_date->format('U'),
                                    'EndTime' => $event_end_date->format('U'),
                                    'PostDate' => get_the_date('U',$post_id),
                                    'Address' => $address,
                                    'AuthorId' =>  get_the_author_meta('ID')
                                );
                                if( $now < $event_start_date || $now < $event_end_date){
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y '). $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+1 month');
                            $event_end_date = $event_end_date->modify('+1 month');

                        }while($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }

                    if ($repeat === 'yearly') {
                        do{
                            if($include_expired_event || $now < $event_start_date || $now < $event_end_date ){
                                $attachment_id = get_post_thumbnail_id( $post_id );
                                $address = get_term_meta($location_id, 'fat-mb-location-detail', true)['address'];
                                $events[] = array(
                                    'Id' => $post_id,
                                    'LocationName' => $locations[$location_id],
                                    'LocationId' => $location_id,
                                    'EventName' => get_the_title($post_id),
                                    'ImageUrl' => $attachment_id > 0 ? wp_get_attachment_image_src($attachment_id) : '',
                                    'EventDetail' => get_the_excerpt($post_id),
                                    'StartTime' => $event_start_date->format('U'),
                                    'EndTime' => $event_end_date->format('U'),
                                    'PostDate' => get_the_date('U',$post_id),
                                    'Address' => $address,
                                    'AuthorId' =>  get_the_author_meta('ID')
                                );
                                if( $now < $event_start_date || $now < $event_end_date){
                                    $count_repeat_number++;
                                }
                            }
                            $start_date_string = $event_end_date->format('d/m/Y '). $event_start_date->format('H:i');
                            $event_start_date = DateTime::createFromFormat('d/m/Y H:i', $start_date_string);
                            $event_end_date = (clone $event_end_date);
                            $event_start_date = $event_start_date->modify('+1 year');
                            $event_end_date = $event_end_date->modify('+1 year');

                        }while($event_end_date < $now || $count_repeat_number < $repeat_number);
                    }
                }
            endwhile;
            wp_reset_postdata();

            $events = array_slice($events, $offset, $limit);

            // Return all of our comment response data.
            return $events;
        }
    }

    function fat_event_register_rest_routes() {
        $controller = new FAT_Event_REST_Controller();
        $controller->register_routes();
    }
    add_action( 'rest_api_init', 'fat_event_register_rest_routes' );
}